/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.codegenerate.projectmigrate.GenerateProjectFile;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.ui.AbstractKeilIARImportWizard;
import com.gigadevice.ui.GetMDKProjPage;
import com.gigadevice.ui.baseinfo.FilesStruct;
import com.gigadevice.ui.baseinfo.GroupStruct;
import com.gigadevice.ui.baseinfo.TargetInfoStruct;
import com.gigadevice.ui.tool.MDKProjParse;
import com.gigadevice.ui.tool.Messages;
import com.gigadevice.ui.tool.UniqueNumericStringGenerator;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportWizardMDK2GD
extends AbstractKeilIARImportWizard {
    private GetMDKProjPage getMDKProjPage;
    private Set<String> lstStartFilesMDK = new HashSet<String>();
    private String[] lstGroupNoFolder = new String[]{"::CMSIS"};

    public ImportWizardMDK2GD() {
        this.setWindowTitle(Messages.SwitchLanguageHandler_ImportWindowTitle);
    }

    public void addPages() {
        this.getMDKProjPage = new GetMDKProjPage(Messages.SwitchLanguageHandler_ImportMDKProjectTitle);
        this.addPage((IWizardPage)this.getMDKProjPage);
    }

    @Override
    public boolean performFinish() {
        Shell shell;
        this.myConsole = this.findConsole(Messages.SwitchLanguageHandler_MDKConvertConsole);
        this.out = this.myConsole.newMessageStream();
        final String MDKProjPath = this.getMDKProjPage.GetMDKPath();
        final String ProjectName = this.getMDKProjPage.GetProjName();
        final String UvoptxPath = MDKProjPath.replace(".uvprojx", ".uvoptx");
        File fileMDK = new File(MDKProjPath);
        if (fileMDK.exists()) {
            shell = Display.getCurrent().getActiveShell();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            progressMonitorDialog.setCancelable(false);
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.SwitchLanguageHandler_MDKConvertBeginTask, -1);
                    monitor.setCanceled(false);
                    MDKProjParse mdkProjParse = new MDKProjParse();
                    ImportWizardMDK2GD.this.out.println(Messages.SwitchLanguageHandler_ParseMDKProjectInfo);
                    mdkProjParse.parseMDKProj(MDKProjPath);
                    String DefaultTargetName = mdkProjParse.getDefaultTargetName(UvoptxPath);
                    LinkedHashMap<String, TargetInfoStruct> mapTarget = mdkProjParse.getMapTarget();
                    ImportWizardMDK2GD.this.MapTarget = ImportWizardMDK2GD.this.moveKeyToFront(mapTarget, DefaultTargetName);
                    ImportWizardMDK2GD.this.out.println(Messages.SwitchLanguageHandler_MDKProjectConverting);
                    String cConfigContent = "";
                    TargetInfoStruct gTargetInfoStruct = new TargetInfoStruct();
                    if (ImportWizardMDK2GD.this.lstStartFilesMDK.size() > 0) {
                        ImportWizardMDK2GD.this.lstStartFilesMDK.clear();
                    }
                    for (String targetName : ImportWizardMDK2GD.this.MapTarget.keySet()) {
                        TargetInfoStruct targetInfoStruct;
                        gTargetInfoStruct = targetInfoStruct = (TargetInfoStruct)ImportWizardMDK2GD.this.MapTarget.get(targetName);
                        String fileContent = "";
                        String ProSettingFolderPath = String.valueOf(GeneralPathUtil.ResourcePath) + "ProjectSetting";
                        String filePath = String.valueOf(ProSettingFolderPath) + File.separator + "unit.xml";
                        try {
                            fileContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
                            String idString = UniqueNumericStringGenerator.generateRandomNumericString();
                            fileContent = fileContent.replace("${id}", idString);
                            fileContent = fileContent.replace("${config.name}", targetName);
                            String symbols = ImportWizardMDK2GD.convertToListOptionValues(gTargetInfoStruct.getStrDefine());
                            fileContent = fileContent.replace("${assembler.symbols}", symbols);
                            fileContent = fileContent.replace("${CCompiler.symbols}", symbols);
                            fileContent = ImportWizardMDK2GD.this.processSecure(fileContent, gTargetInfoStruct);
                            String entry = "";
                            List<GroupStruct> groupFiles = targetInfoStruct.getLstGroups();
                            for (GroupStruct groupStruct : groupFiles) {
                                List<FilesStruct> lstFiles = groupStruct.getLstFiles();
                                for (FilesStruct filesStruct : lstFiles) {
                                    String excludingStr;
                                    String fileName = filesStruct.getFileName();
                                    if (fileName.toUpperCase().endsWith(".S")) {
                                        ImportWizardMDK2GD.this.lstStartFilesMDK.add(ImportWizardMDK2GD.capitalizeLastCharacter(fileName));
                                    }
                                    if (!filesStruct.getFileOption()) continue;
                                    if (fileName.toUpperCase().endsWith(".S")) {
                                        excludingStr = "gcc_startup" + File.separator + fileName;
                                        excludingStr = ImportWizardMDK2GD.capitalizeLastCharacter(excludingStr);
                                    } else {
                                        excludingStr = String.valueOf(groupStruct.getGroupName()) + File.separator + fileName;
                                    }
                                    if (excludingStr == null) continue;
                                    entry = String.valueOf(entry) + excludingStr + "|";
                                }
                            }
                            if (!entry.isEmpty()) {
                                String allButLast = entry.substring(0, entry.length() - 1);
                                fileContent = fileContent.replace("${sourceEntries.entry}", allButLast);
                            }
                            cConfigContent = String.valueOf(cConfigContent) + fileContent;
                        }
                        catch (NoSuchFileException e) {
                            System.err.println("\u93c2\u56e6\u6b22\u93c8\ue045\u58d8\u9352\ufffd: " + e.getFile());
                        }
                        catch (AccessDeniedException e) {
                            System.err.println("\u7481\u5757\u68f6\u741a\ue0a3\u5ac6\u7f01\ufffd: " + e.getFile());
                        }
                        catch (FileSystemException e) {
                            System.err.println("\u93c2\u56e6\u6b22\u7eef\u8364\u7cba\u5bee\u509a\u7236: " + e.getFile() + " - " + e.getReason());
                        }
                        catch (IOException e) {
                            System.err.println("I/O\u5bee\u509a\u7236: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    ImportWizardMDK2GD.this.convertProj(ProjectName, MDKProjPath, gTargetInfoStruct, cConfigContent);
                    monitor.done();
                }
            };
            try {
                progressMonitorDialog.run(true, false, iRunnableWithProgress);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogManager.getInstance().logThrowable((Throwable)e);
                String errorMsg = Messages.SwitchLanguageHandler_MDKConvertFailedGeneric;
                this.out.println(errorMsg);
                this.showResultDialog(Messages.SwitchLanguageHandler_MDKConvertFailedDialogTitle, errorMsg, true);
            }
        } else {
            Object[] options = new Object[]{"OK"};
            JOptionPane.showOptionDialog(null, Messages.SwitchLanguageHandler_MDKFileNotExistMessage, Messages.SwitchLanguageHandler_MDKFileNotExistDialogTitle, -1, -1, null, options, options[0]);
            return false;
        }
        shell.dispose();
        return true;
    }

    @Override
    protected boolean convertProj(String projectName, String projectPath, TargetInfoStruct targetInfoStruct, String cConfigContent) {
        String projRootFolder = this.getFolder(projectPath);
        if (projRootFolder == "") {
            String errorMsg = Messages.SwitchLanguageHandler_MDKRootFolderFailed;
            this.out.println(errorMsg);
            this.showResultDialog(Messages.SwitchLanguageHandler_MDKConvertFailedDialogTitle, errorMsg, true);
            return false;
        }
        String projFolder = String.valueOf(projRootFolder) + File.separator + "GD32EBuilder_project";
        this.eclipseProjectDir = new File(projFolder);
        File folder = new File(projFolder);
        if (folder.exists()) {
            String errorMsg = MessageFormat.format(Messages.SwitchLanguageHandler_MDKProjectExists, projFolder);
            this.out.println(errorMsg);
            this.showResultDialog(Messages.SwitchLanguageHandler_MDKConvertFailedDialogTitle, errorMsg, true);
            this.out.println("");
            return false;
        }
        this.folderProcess.createFolder(projFolder);
        this.out.println(Messages.SwitchLanguageHandler_MDKCreateProjectFolder);
        Path projctLocation = new Path(projFolder);
        this.projectCreator.createProject(projectName, (IPath)projctLocation);
        this.out.println(Messages.SwitchLanguageHandler_MDKInitializeMCUInfo);
        String targetMCUPartNo = targetInfoStruct.getStrDevice();
        MCUSeletorInfo tmpGDMcuSeletorInfo = GlobalVariables.McuSeletorInfo;
        GlobalVariables.McuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)2, (String)targetMCUPartNo);
        String targetName = GlobalVariables.McuSeletorInfo.getMCUGroup().toLowerCase();
        String pathFWLib = McuFactory.getFirmwarePath((String)"ARM", (String)targetName);
        String entry = "";
        String srcStartFolder = String.valueOf(pathFWLib) + File.separator + "gcc_startup";
        List<String> lstStartFliesSrc = this.folderProcess.listFiles(srcStartFolder, ".S");
        for (String fileName : lstStartFliesSrc) {
            String str;
            if (this.lstStartFilesMDK.contains(fileName) || (str = "gcc_startup" + File.separator + fileName) == null) continue;
            entry = String.valueOf(entry) + str + "|";
        }
        if (!entry.equals("")) {
            String allButLast = entry.substring(0, entry.length() - 1);
            cConfigContent = cConfigContent.replace("${sourceEntries.entry}", allButLast);
        }
        this.out.println(Messages.SwitchLanguageHandler_MDKModifyProjConfig);
        GenerateProjectFile generateProjectFile = new GenerateProjectFile(projFolder, projectName);
        generateProjectFile.CopyProjectFolder();
        if (!this.processCProjectFile(projFolder, cConfigContent)) {
            return false;
        }
        generateProjectFile.UpdateProjectFile();
        generateProjectFile.UpdateCProjectFile();
        boolean isCopyMode = this.getMDKProjPage.GetCopyMode();
        ArrayList<FilesStruct> virtualFolders = new ArrayList<FilesStruct>();
        ArrayList<FilesStruct> lstLinkedResource = new ArrayList<FilesStruct>();
        this.out.println(Messages.SwitchLanguageHandler_MDKCreateStructure);
        for (GroupStruct group : targetInfoStruct.getLstGroups()) {
            String groupName = group.getGroupName();
            if (groupName == null || groupName.isEmpty() || Arrays.asList(this.lstGroupNoFolder).contains(groupName.toUpperCase())) continue;
            List<FilesStruct> lstFiles = group.getLstFiles();
            if (isCopyMode) {
                String folderPath = String.valueOf(projFolder) + File.separator + groupName;
                this.folderProcess.createFolder(folderPath);
                for (FilesStruct filesStruct : lstFiles) {
                    if (filesStruct.getFileName().toUpperCase().endsWith(".S")) continue;
                    this.folderProcess.copyFolderAndFiles(filesStruct.getFilePath(), folderPath);
                }
                continue;
            }
            FilesStruct virFolder = new FilesStruct();
            virFolder.setFileName(groupName);
            virFolder.setFileType("2");
            virFolder.setFilePath("virtual:/virtual");
            virtualFolders.add(virFolder);
            for (FilesStruct filesStruct : lstFiles) {
                if (filesStruct.getFileName().toUpperCase().endsWith(".S")) continue;
                FilesStruct linkedFile = new FilesStruct();
                Object name = String.valueOf(groupName) + File.separator + filesStruct.getFileName();
                name = ((String)name).replace("\\", "/");
                String type = "1";
                String locationURI = this.convertFilePath(filesStruct.getFilePath(), projectPath, projFolder);
                linkedFile.setFileName((String)name);
                linkedFile.setFileType(type);
                linkedFile.setFilePath(locationURI);
                lstLinkedResource.add(linkedFile);
            }
        }
        if (!isCopyMode) {
            this.out.println(Messages.SwitchLanguageHandler_MDKAddVirtualAndLinks);
            this.projectCreator.linkResources(projectName, virtualFolders, lstLinkedResource);
        }
        this.out.println(Messages.SwitchLanguageHandler_MDKCopyFirmware);
        String desStartFolder = String.valueOf(projFolder) + File.separator + "gcc_startup";
        this.folderProcess.createFolder(desStartFolder);
        this.folderProcess.copyFolderAndFiles(srcStartFolder, desStartFolder);
        String srcCMSISPath = String.valueOf(pathFWLib) + File.separator + "Firmware" + File.separator + "CMSIS";
        String desCMSISPath = String.valueOf(projFolder) + File.separator + "CMSIS";
        try {
            this.folderProcess.copyTargetFile(srcCMSISPath, desCMSISPath, ".h");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> includePath = new ArrayList<String>();
        List<java.nio.file.Path> MDKInclude = targetInfoStruct.getLstIncludePath();
        String projCompilerFolder = String.valueOf(projRootFolder) + File.separator + "GD32EBuilder_project" + File.separator + "CompilerTarget";
        File eclipseProjectCompilerDir = new File(projCompilerFolder);
        for (java.nio.file.Path inc : MDKInclude) {
            java.nio.file.Path relativePath = eclipseProjectCompilerDir.toPath().relativize(inc);
            includePath.add(relativePath.toString());
        }
        java.nio.file.Path CMSISPath = Paths.get(desCMSISPath, new String[0]);
        includePath.add(eclipseProjectCompilerDir.toPath().relativize(CMSISPath).toString());
        String includeNode = this.projectCreator.getIncludeNode(includePath);
        this.out.println(Messages.SwitchLanguageHandler_MDKAddIncludePath);
        this.projectCreator.updateIncludePath(projectName, includeNode);
        this.projectCreator.refreshProject(projectName);
        GlobalVariables.McuSeletorInfo = tmpGDMcuSeletorInfo;
        this.out.println("");
        String successMsg = MessageFormat.format(Messages.SwitchLanguageHandler_MDKConvertSuccess, projFolder);
        this.out.println(successMsg);
        this.showResultDialog(Messages.SwitchLanguageHandler_MDKConvertCompleteDialogTitle, successMsg, false);
        this.out.println("");
        this.updatePartNoByDifferentConfig(projectName, 2);
        return true;
    }
}

