/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IRenameResourceWizard
extends RefactoringWizard {
    public static String newProjectName = "";

    public IRenameResourceWizard(IResource resource) {
        super((Refactoring)new RenameRefactoring((RenameProcessor)new RenameResourceProcessor(resource)), 4);
        this.setDefaultPageTitle(RefactoringUIMessages.RenameResourceWizard_page_title);
        this.setWindowTitle(RefactoringUIMessages.RenameResourceWizard_window_title);
    }

    protected void addUserInputPages() {
        RenameResourceProcessor processor = (RenameResourceProcessor)this.getRefactoring().getAdapter(RenameResourceProcessor.class);
        RenameResourceRefactoringConfigurationPage renameResourceRefactoringConfigurationPage = new RenameResourceRefactoringConfigurationPage(processor);
        this.addPage((IWizardPage)renameResourceRefactoringConfigurationPage);
    }

    public static String getNewProjectName() {
        return newProjectName;
    }

    private static class RenameResourceRefactoringConfigurationPage
    extends UserInputWizardPage {
        private final RenameResourceProcessor fRefactoringProcessor;
        private static Text fNameField;

        public RenameResourceRefactoringConfigurationPage(RenameResourceProcessor processor) {
            super("RenameResourceRefactoringInputPage");
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(RefactoringUIMessages.RenameResourceWizard_name_field_label);
            label.setLayoutData((Object)new GridData());
            fNameField = new Text(composite, 2048);
            String resourceName = this.fRefactoringProcessor.getNewResourceName();
            fNameField.setText(resourceName);
            fNameField.setFont(composite.getFont());
            fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
            fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.validatePage();
                }
            });
            int lastIndexOfDot = resourceName.lastIndexOf(46);
            if (this.fRefactoringProcessor.getResource().getType() == 1 && lastIndexOfDot > 0) {
                fNameField.setSelection(0, lastIndexOfDot);
            } else {
                fNameField.selectAll();
            }
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                fNameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text;
            newProjectName = text = fNameField.getText();
            RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(text);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            this.fRefactoringProcessor.setNewResourceName(fNameField.getText());
        }
    }
}

