/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.ui.IRenameResourceWizard;
import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.actions.AbstractResourcesHandler;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.Workbench;

public class IRenameResourceHandler
extends AbstractResourcesHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource;
        File oldFile = null;
        boolean ranameFlag = false;
        IProject project = IRenameResourceHandler.getCurrentProject();
        if (project != null) {
            oldFile = new File(project.getLocation().toString());
            ranameFlag = true;
        }
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && (resource = this.getCurrentResource((IStructuredSelection)sel)) != null) {
            IRenameResourceWizard refactoringWizard = new IRenameResourceWizard(resource);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
            try {
                op.run(activeShell, RefactoringUIMessages.RenameResourceHandler_title);
                if (ranameFlag) {
                    IRenameResourceHandler.closeGdcFile();
                    String newGdcFileName = IRenameResourceWizard.getNewProjectName();
                    System.out.println(newGdcFileName);
                    int index = oldFile.toString().lastIndexOf("\\");
                    String newGdcFilePath = String.valueOf(oldFile.toString().substring(0, index + 1)) + newGdcFileName;
                    File newfile = new File(newGdcFilePath);
                    IRenameResourceHandler.renameGdcFile(newfile, newGdcFileName);
                    IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newGdcFileName);
                    try {
                        newProject.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    private IResource getCurrentResource(IStructuredSelection sel) {
        IResource[] resources = this.getSelectedResources(sel);
        if (resources.length == 1) {
            return resources[0];
        }
        return null;
    }

    public static void closeGdcFile() {
        IEditorPart[] iEditParts = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditors();
        int i = 0;
        while (i < iEditParts.length) {
            String strEditorTitle = iEditParts[i].getTitle();
            if (strEditorTitle != null && strEditorTitle.contains(".gdc")) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(iEditParts[i], true);
            }
            ++i;
        }
    }

    public static void renameGdcFile(File file, String newGdcFileName) {
        File[] fsFiles = file.listFiles();
        if (fsFiles != null) {
            int i = 0;
            while (i < fsFiles.length) {
                System.out.println("AbsolutePath()" + fsFiles[i].getAbsolutePath());
                if (fsFiles[i].getAbsolutePath().contains(".gdc")) {
                    fsFiles[i].renameTo(new File(String.valueOf(file.toString()) + "\\" + newGdcFileName + ".gdc"));
                    break;
                }
                if (fsFiles[i].isDirectory()) {
                    IRenameResourceHandler.renameGdcFile(fsFiles[i], newGdcFileName);
                }
                ++i;
            }
        }
    }

    public static IProject getCurrentProject() {
        ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        IProject project = null;
        Object element = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            project = ((IResource)element).getProject();
        }
        return project;
    }
}

