/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.ui.tool.Messages;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GetMDKProjPage
extends WizardPage {
    private Text textfolder;
    private Text textProject;
    private Label labelMessage;
    private boolean isCopyMode;

    protected GetMDKProjPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.SwitchLanguageHandler_ImportMDKProjectTitle);
        this.setDescription(Messages.SwitchLanguageHandler_MDKWizardDescription);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout(null);
        Group grpProjectInfo = new Group(container, 0);
        grpProjectInfo.setBounds(10, 10, 554, 78);
        Label lblNewLabel_1 = new Label((Composite)grpProjectInfo, 0);
        lblNewLabel_1.setBounds(10, 45, 82, 17);
        lblNewLabel_1.setText(Messages.SwitchLanguageHandler_ProjectNameLabel);
        Label lblNewLabel = new Label((Composite)grpProjectInfo, 0);
        lblNewLabel.setBounds(10, 17, 97, 17);
        lblNewLabel.setText(Messages.SwitchLanguageHandler_ImportProjectLabel);
        this.textfolder = new Text((Composite)grpProjectInfo, 2048);
        this.textfolder.setBounds(111, 14, 365, 23);
        this.textProject = new Text((Composite)grpProjectInfo, 2048);
        this.textProject.setBounds(111, 42, 365, 23);
        Button btnBrowse = new Button((Composite)grpProjectInfo, 0);
        btnBrowse.setBounds(482, 12, 64, 27);
        btnBrowse.setText(Messages.SwitchLanguageHandler_BrowseButton);
        Group grpGeneratingMode = new Group(container, 0);
        grpGeneratingMode.setBounds(10, 87, 554, 100);
        grpGeneratingMode.setVisible(false);
        final Label lbTips = new Label((Composite)grpGeneratingMode, 64);
        lbTips.setBounds(112, 51, 367, 39);
        lbTips.setText(Messages.SwitchLanguageHandler_LinkModeTip);
        Button btnLink = new Button((Composite)grpGeneratingMode, 16);
        btnLink.setBounds(112, 20, 162, 17);
        btnLink.setSelection(true);
        btnLink.setText(Messages.SwitchLanguageHandler_LinkSourceFile);
        btnLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetMDKProjPage.this.isCopyMode = false;
                lbTips.setText(Messages.SwitchLanguageHandler_LinkModeTip);
            }
        });
        Button btnCopy = new Button((Composite)grpGeneratingMode, 16);
        btnCopy.setBounds(299, 20, 184, 17);
        btnCopy.setText(Messages.SwitchLanguageHandler_CopySourceFile);
        btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetMDKProjPage.this.isCopyMode = true;
                lbTips.setText(Messages.SwitchLanguageHandler_CopyModeTip);
            }
        });
        Label lblGeneratingMode = new Label((Composite)grpGeneratingMode, 0);
        lblGeneratingMode.setBounds(10, 20, 94, 17);
        lblGeneratingMode.setText(Messages.SwitchLanguageHandler_ModeLabel);
        this.labelMessage = new Label(container, 0);
        this.labelMessage.setBounds(10, 87, 554, 30);
        this.labelMessage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 6, 1));
        this.labelMessage.setText("                                                          ");
        this.labelMessage.setForeground(new Color(null, 255, 0, 0));
        this.labelMessage.setVisible(true);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetMDKProjPage.this.handleBrowse();
            }
        });
        this.textProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GetMDKProjPage.this.textfolder.getText().isEmpty() && !GetMDKProjPage.this.textProject.getText().isEmpty()) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    IProject project = root.getProject(GetMDKProjPage.this.textProject.getText());
                    if (project.exists()) {
                        GetMDKProjPage.this.setPageComplete(false);
                        GetMDKProjPage.this.labelMessage.setText(Messages.SwitchLanguageHandler_ProjectExistsRenamePrompt);
                        GetMDKProjPage.this.labelMessage.setVisible(true);
                    } else {
                        GetMDKProjPage.this.labelMessage.setVisible(false);
                        GetMDKProjPage.this.setPageComplete(true);
                    }
                } else {
                    GetMDKProjPage.this.setPageComplete(false);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return !this.textfolder.getText().isEmpty() && !this.textProject.getText().isEmpty() && !this.labelMessage.isVisible();
    }

    private void handleBrowse() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.SwitchLanguageHandler_SelectUvprojxDialogTitle);
        dialog.setFilterExtensions(new String[]{"*.uvprojx"});
        String selectDirectory = dialog.open();
        if (selectDirectory != null) {
            this.textfolder.setText(selectDirectory);
            this.textProject.setText(this.getProjName(selectDirectory));
        }
    }

    private String getProjName(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            String fileName = file.getName();
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex > 0) {
                fileName = fileName.substring(0, dotIndex);
            }
            return fileName;
        }
        return "";
    }

    public boolean GetCopyMode() {
        return this.isCopyMode;
    }

    public String GetMDKPath() {
        return this.textfolder.getText();
    }

    public String GetProjName() {
        return this.textProject.getText();
    }
}

