/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.ui.CleanActiveConfigurationHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.BuildConfigurationsJob;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BuildChangeListener
implements IStartup {
    private static List<ICConfigurationDescription> FinishedCConfigList = new ArrayList<ICConfigurationDescription>();
    private static IProject CurProject = null;
    private static boolean MultiCoreBuildBegin = false;
    private static IConfiguration curConfig = null;
    private static LinkedHashMap<IConfiguration, Boolean> FinishedCConfigMap = new LinkedHashMap();

    private IConfiguration getCurConfiguration(IProject project, IResourceDelta resourceDelta) {
        IConfiguration curConfig = null;
        IManagedBuildInfo managedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (managedBuildInfo == null) {
            return null;
        }
        IConfiguration[] configs = managedBuildInfo.getManagedProject().getConfigurations();
        IResourceDelta[] affectedChildrens = resourceDelta.getAffectedChildren();
        if (affectedChildrens.length > 0) {
            IResourceDelta[] iResourceDeltaArray = affectedChildrens;
            int n = affectedChildrens.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDeltaIndex = iResourceDeltaArray[n2];
                String projectRelativePath = resourceDeltaIndex.getProjectRelativePath().toOSString();
                IConfiguration[] iConfigurationArray = configs;
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfiguration config = iConfigurationArray[n4];
                    if (config.getName().equals(projectRelativePath)) {
                        curConfig = config;
                        return curConfig;
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            IConfiguration ActiveConfig = buildInfo.getDefaultConfiguration();
            return ActiveConfig;
        }
        return curConfig;
    }

    private ICConfigurationDescription[] getOtherCConfigToBuildOrClean11(IProject project, IConfiguration config) {
        ICConfigurationDescription[] cconfigs = this.getDebugOrReleaseCConfigList(project, config);
        return cconfigs;
    }

    private IConfiguration getCurConfiguration(IProject project) {
        IConfiguration[] configs;
        IConfiguration curConfig = null;
        IManagedBuildInfo managedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (managedBuildInfo == null) {
            return null;
        }
        curConfig = managedBuildInfo.getDefaultConfiguration();
        if (FinishedCConfigList.isEmpty()) {
            return curConfig;
        }
        IConfiguration[] iConfigurationArray = configs = managedBuildInfo.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (!config.getName().equals(curConfig.getName())) {
                curConfig = config;
                return curConfig;
            }
            ++n2;
        }
        return curConfig;
    }

    private ICConfigurationDescription[] getDebugOrReleaseCConfigList(IProject project, IConfiguration activeConfig) {
        ICConfigurationDescription[] cconfigs;
        IConfiguration[] configs;
        IManagedBuildInfo managedbuildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        ICProjectDescription projectDescription = CCorePlugin.getDefault().getProjectDescription(project);
        ArrayList<IConfiguration> configsList = new ArrayList<IConfiguration>();
        IConfiguration[] iConfigurationArray = configs = managedbuildInfo.getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (config.getParent().getName().equals(activeConfig.getParent().getName()) && !config.getId().equals(activeConfig.getId())) {
                configsList.add(config);
            }
            ++n2;
        }
        ArrayList<ICConfigurationDescription> cconfigsList = new ArrayList<ICConfigurationDescription>();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cconfigs = projectDescription.getConfigurations();
        int n3 = cconfigs.length;
        int n4 = 0;
        while (n4 < n3) {
            ICConfigurationDescription cconfig = iCConfigurationDescriptionArray[n4];
            for (IConfiguration config : configsList) {
                if (!config.getId().equals(cconfig.getId())) continue;
                cconfigsList.add(cconfig);
            }
            ++n4;
        }
        if (cconfigsList.isEmpty()) {
            return null;
        }
        return cconfigsList.toArray(new ICConfigurationDescription[cconfigsList.size()]);
    }

    private boolean CConfigisBuildOrCleanFinished(String configID) {
        for (ICConfigurationDescription CConfig : FinishedCConfigList) {
            if (!CConfig.getId().equals(configID)) continue;
            return true;
        }
        return false;
    }

    private ICConfigurationDescription getOtherCConfigToBuildOrClean(IProject project, IConfiguration config) {
        ICConfigurationDescription cconfigToBuild = null;
        ICConfigurationDescription[] cconfigs = this.getDebugOrReleaseCConfigList(project, config);
        if (cconfigs != null) {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cconfigs;
            int n = cconfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cconfig = iCConfigurationDescriptionArray[n2];
                if (!this.CConfigisBuildOrCleanFinished(cconfig.getId())) {
                    cconfigToBuild = cconfig;
                }
                ++n2;
            }
        }
        return cconfigToBuild;
    }

    private boolean addFinishedCConfigList(IProject project, String configID) {
        ICConfigurationDescription[] cconfigs;
        ICProjectDescription projectDescription = CCorePlugin.getDefault().getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cconfigs = projectDescription.getConfigurations();
        int n = cconfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cconfig = iCConfigurationDescriptionArray[n2];
            if (cconfig.getId().equals(configID)) {
                if (FinishedCConfigList.isEmpty()) {
                    FinishedCConfigList.add(cconfig);
                    return true;
                }
                if (!this.CConfigisBuildOrCleanFinished(cconfig.getId())) {
                    FinishedCConfigList.add(cconfig);
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public void earlyStartup() {
        CUIPlugin.getDefault().getPreferenceStore().setToDefault("clearConsole");
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ISelectionService iSelection;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (iSelection = window.getSelectionService()) != null) {
                    iSelection.addSelectionListener(new ISelectionListener(){

                        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                            Object element = null;
                            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                                CurProject = ((IResource)element).getProject();
                                if (CurProject != null) {
                                    CUIPlugin.getDefault().getPreferenceStore().setToDefault("clearConsole");
                                }
                            }
                        }
                    });
                }
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (CleanActiveConfigurationHandler.ExecuteFlag) {
                    return;
                }
                boolean allCConfigBuildOrCleanFinished = true;
                IResourceDelta delta = event.getDelta();
                IResourceDelta[] childrens = delta.getAffectedChildren();
                if (childrens.length > 0) {
                    IResource resource = childrens[0].getResource();
                    IProject project = null;
                    if (resource instanceof IProject && (project = (IProject)resource) != null) {
                        IManagedBuildInfo managedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                        if (managedBuildInfo == null) {
                            return;
                        }
                        IConfiguration curConfig = BuildChangeListener.this.getCurConfiguration(project, childrens[0]);
                        if (event.getBuildKind() == 15) {
                            curConfig = managedBuildInfo.getDefaultConfiguration();
                        }
                        int CoreNum = DebugUtil.getCoreNumByProject((IProject)project);
                        if (curConfig == null || CoreNum < 2) {
                            return;
                        }
                        boolean OtherConfigNeedToBuildOrClean = BuildChangeListener.this.addFinishedCConfigList(project, curConfig.getId());
                        switch (event.getBuildKind()) {
                            case 10: {
                                ICConfigurationDescription cconfigToBuild;
                                if (!OtherConfigNeedToBuildOrClean || (cconfigToBuild = BuildChangeListener.this.getOtherCConfigToBuildOrClean(project, curConfig)) == null) break;
                                CUIPlugin.getDefault().getPreferenceStore().setValue("clearConsole", false);
                                allCConfigBuildOrCleanFinished = false;
                                BuildConfigurationsJob buildJob = new BuildConfigurationsJob(new ICConfigurationDescription[]{cconfigToBuild}, 0, 10);
                                buildJob.schedule();
                                break;
                            }
                            case 15: {
                                ICConfigurationDescription cconfigToClean;
                                if (!OtherConfigNeedToBuildOrClean || (cconfigToClean = BuildChangeListener.this.getOtherCConfigToBuildOrClean(project, curConfig)) == null) break;
                                CUIPlugin.getDefault().getPreferenceStore().setValue("clearConsole", false);
                                allCConfigBuildOrCleanFinished = false;
                                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                                buildInfo.setDefaultConfiguration(cconfigToClean.getName());
                                try {
                                    project.build(15, null);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                                buildInfo.setDefaultConfiguration(curConfig.getName());
                                break;
                            }
                        }
                    }
                    if (allCConfigBuildOrCleanFinished) {
                        FinishedCConfigList.clear();
                        CUIPlugin.getDefault().getPreferenceStore().setToDefault("clearConsole");
                    }
                } else if (event.getBuildKind() == 15) {
                    ICConfigurationDescription cconfigToClean;
                    if (CurProject == null) {
                        return;
                    }
                    IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)CurProject);
                    if (buildInfo == null) {
                        return;
                    }
                    IConfiguration curConfig = buildInfo.getDefaultConfiguration();
                    boolean OtherConfigNeedToBuildOrClean = BuildChangeListener.this.addFinishedCConfigList(CurProject, curConfig.getId());
                    if (OtherConfigNeedToBuildOrClean && (cconfigToClean = BuildChangeListener.this.getOtherCConfigToBuildOrClean(CurProject, curConfig)) != null) {
                        CUIPlugin.getDefault().getPreferenceStore().setValue("clearConsole", false);
                        allCConfigBuildOrCleanFinished = false;
                        buildInfo.setDefaultConfiguration(cconfigToClean.getName());
                        try {
                            CurProject.build(15, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        buildInfo.setDefaultConfiguration(curConfig.getName());
                    }
                    if (allCConfigBuildOrCleanFinished) {
                        FinishedCConfigList.clear();
                        CUIPlugin.getDefault().getPreferenceStore().setToDefault("clearConsole");
                    }
                }
            }
        }, 16);
    }

    public boolean isHasElfFile(File file) {
        File[] fsFiles = file.listFiles();
        if (fsFiles != null) {
            int i = 0;
            while (i < fsFiles.length) {
                if (fsFiles[i].getAbsolutePath().contains(".elf")) {
                    return true;
                }
                if (fsFiles[i].isDirectory() && this.isHasElfFile(fsFiles[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

