/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.logging.ide.IDEUncaughtExceptionLogger;
import com.gigadevice.ui.UpdateProjectConfig;
import com.gigadevice.ui.handlers.WelcomeConfigurationHandler;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.gigadevice.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("SAVE_ALL_BEFORE_BUILD", "true");
        plugin = this;
        this.addIARSupportInWindows();
        this.addKeilSupportInWindows();
        WelcomeConfigurationHandler.welcomeConfigurationModifyFromIni();
        IDEUncaughtExceptionLogger.registerExceptionHandler();
        UpdateProjectConfig.getInstance().startListening();
        UpdateProjectConfig.getInstance().processExistingProjects();
    }

    public void stop(BundleContext context) throws Exception {
        UpdateProjectConfig.getInstance().stopListening();
        plugin = null;
        super.stop(context);
    }

    public void addKeilSupportInWindows() {
        if (TargetOSInfo.isWindows()) {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<plugin>\n   <extension\n         point=\"org.eclipse.ui.importWizards\">\n      <wizard\r\n            category=\"org.eclipse.ui.Basic\"\n            class=\"com.gigadevice.ui.ImportWizardMDK2GD\"\n            icon=\"icons/mdk.png\"\r\n            id=\"com.gigadevice.ui.wizardMDK2GD\"\n            name=\"MDK5 Project into WorkSpace\">\n      </wizard>\r\n   </extension></plugin>";
            this.DynamicLoadExtensionPoint(xml);
        }
    }

    public void addIARSupportInWindows() {
        if (TargetOSInfo.isWindows()) {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<plugin>\n   <extension\n         point=\"org.eclipse.ui.importWizards\">\n      <wizard\r\n            category=\"org.eclipse.ui.Basic\"\n            class=\"com.gigadevice.ui.ImportWizardIAR2GD\"\n            icon=\"icons/iar.png\"\r\n            id=\"com.gigadevice.ui.wizardIAR2GD\"\n            name=\"IAR Project into WorkSpace\">\n      </wizard>\n   </extension></plugin>";
            this.DynamicLoadExtensionPoint(xml);
        }
    }

    public void DynamicLoadExtensionPoint(String xml) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Bundle bundle = this.getBundle();
            IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)bundle);
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            Object token = ((ExtensionRegistry)registry).getTemporaryUserToken();
            registry.addContribution((InputStream)inputStream, contributor, false, null, null, token);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static Activator getDefault() {
        return plugin;
    }
}

