/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.codegenerate.projectmigrate.Option;
import com.gigadevice.ui.baseinfo.TargetInfoStruct;
import com.gigadevice.ui.tool.FolderProcess;
import com.gigadevice.ui.tool.ProjectCreator;
import com.gigadevice.ui.tool.UniqueNumericStringGenerator;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class AbstractKeilIARImportWizard
extends Wizard
implements IImportWizard {
    protected final String CONVERT_PROJECT_DIR = "GD32EBuilder_project";
    protected final String FD_FWLIB = "Firmware";
    protected final String FD_GCC_S = "gcc_startup";
    protected final String FD_CMSIS_UP = "CMSIS";
    protected final String FD_RISCV = "RISCV";
    protected final String FD_LDS = "ldscripts";
    protected final String REPLACE_ID = "${id}";
    protected final String REPLACE_NAME = "${config.name}";
    protected final String REPLACE_ENTRY = "${sourceEntries.entry}";
    protected final String REPLACE_A_SYMBOLS = "${assembler.symbols}";
    protected final String REPLACE_C_SYMBOLS = "${CCompiler.symbols}";
    protected FolderProcess folderProcess = new FolderProcess();
    protected ProjectCreator projectCreator = new ProjectCreator();
    protected MessageConsole myConsole;
    protected MessageConsoleStream out;
    protected File eclipseProjectDir;
    public LinkedHashMap<String, TargetInfoStruct> MapTarget;

    public AbstractKeilIARImportWizard() {
        this.setWindowTitle("Import");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected abstract boolean convertProj(String var1, String var2, TargetInfoStruct var3, String var4);

    public abstract boolean performFinish();

    protected MessageConsole findConsole(String name) {
        IConsole[] existingConsoles;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] iConsoleArray = existingConsoles = consoleManager.getConsoles();
        int n = existingConsoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (name.equals(console.getName()) && console instanceof MessageConsole) {
                return (MessageConsole)console;
            }
            ++n2;
        }
        MessageConsole newConsole = new MessageConsole(name, null);
        consoleManager.addConsoles(new IConsole[]{newConsole});
        return newConsole;
    }

    protected String getFolder(String filePath) {
        java.nio.file.Path grandParent;
        java.nio.file.Path path = Paths.get(filePath, new String[0]);
        java.nio.file.Path parent = path.getParent();
        if (parent != null && (grandParent = parent.getParent()) != null) {
            return grandParent.toString();
        }
        return "";
    }

    protected String analyzeString(String input) {
        int count = this.countOccurrences(input, "..\\");
        String replaceStr = input.replaceAll("\\.\\.\\\\", "");
        String result = String.valueOf(String.format("PARENT-%d-PROJECT_LOC", count)) + File.separator + replaceStr;
        result = result.replace("\\", "/");
        return result;
    }

    protected String convertFilePath(String keilFilePath, String mdkProjPath, String cdtProjFolder) {
        try {
            java.nio.file.Path mdkProjFile = Paths.get(mdkProjPath, new String[0]);
            java.nio.file.Path mdkProjDir = mdkProjFile.getParent();
            java.nio.file.Path keilFileAbsPath = mdkProjDir.resolve(keilFilePath).normalize();
            java.nio.file.Path cdtProjPath = Paths.get(cdtProjFolder, new String[0]).normalize();
            java.nio.file.Path relativePath = cdtProjPath.relativize(keilFileAbsPath);
            int parentCount = 0;
            java.nio.file.Path remainingPath = relativePath;
            while (remainingPath.startsWith("..")) {
                ++parentCount;
                remainingPath = remainingPath.subpath(1, remainingPath.getNameCount());
            }
            String result = parentCount > 0 ? String.format("PARENT-%d-PROJECT_LOC/%s", parentCount, remainingPath.toString()) : "PROJECT_LOC/" + relativePath.toString();
            result = result.replace("\\", "/");
            return result;
        }
        catch (Exception e) {
            System.err.println("\u9352\u55d8\u703d\u74ba\ue21a\u7dde\u6fb6\u8fab\u89e6: " + keilFilePath);
            e.printStackTrace();
            return this.analyzeString(keilFilePath);
        }
    }

    protected int countOccurrences(String input, String pattern) {
        int count = 0;
        int index = 0;
        while ((index = input.indexOf(pattern, index)) != -1) {
            ++count;
            index += pattern.length();
        }
        return count;
    }

    protected static String capitalizeLastCharacter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String allButLast = input.substring(0, input.length() - 1);
        char lastChar = input.charAt(input.length() - 1);
        lastChar = Character.toUpperCase(lastChar);
        return String.valueOf(allButLast) + lastChar;
    }

    protected static String convertToListOptionValues(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "";
        }
        LinkedHashSet<String> macros = new LinkedHashSet<String>();
        String[] stringArray = input.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String trimmed = item.trim();
            if (!trimmed.isEmpty()) {
                macros.add(trimmed);
            }
            ++n2;
        }
        macros.add("GD_ECLIPSE_GCC");
        macros.add("USE_STDPERIPH_DRIVER");
        StringBuilder result = new StringBuilder();
        for (String macro : macros) {
            result.append("\t\t\t\t\t\t\t\t\t<listOptionValue builtIn=\"false\" value=\"").append(macro).append("\"/>\n");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    protected String processSecure(String fileContent, TargetInfoStruct targetInfoStruct) {
        try {
            String strnSecure = targetInfoStruct.getStrnSecure();
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(fileContent));
            List toolChains = document.selectNodes("//toolChain");
            for (Node node : toolChains) {
                Element toolChain = (Element)node;
                Node otherOptionNode = toolChain.selectSingleNode(".//option[contains(@superClass, 'com.gigadevice.mbs.arm.option.targetProcessor.other')]");
                Element otherOption = otherOptionNode != null ? (Element)otherOptionNode : null;
                Node allOptionsNode = toolChain.selectSingleNode(".//option[contains(@superClass, 'com.gigadevice.mbs.arm.option.targetProcessor.allOptions')]");
                if (allOptionsNode != null) {
                    Element cfr_ignored_0 = (Element)allOptionsNode;
                }
                if (strnSecure != null && !strnSecure.isEmpty() && !"0".equals(strnSecure)) {
                    if (otherOption == null) {
                        otherOption = toolChain.addElement("option");
                        otherOption.addAttribute("id", "com.gigadevice.mbs.arm.option.targetProcessor.other." + System.currentTimeMillis());
                        otherOption.addAttribute("superClass", "com.gigadevice.mbs.arm.option.targetProcessor.other");
                        otherOption.addAttribute("value", "-mcmse");
                        otherOption.addAttribute("valueType", "string");
                        continue;
                    }
                    otherOption.attribute("value").setValue("-mcmse");
                    continue;
                }
                if (otherOption == null) continue;
                otherOption.attribute("value").setValue("");
            }
            return AbstractKeilIARImportWizard.outputDocumentWithOriginalFormat(document);
        }
        catch (DocumentException e) {
            System.err.println("\u6fb6\u52ed\u608aXML\u93c3\u8dfa\u56ad\u95bf\ufffd: " + e.getMessage());
            e.printStackTrace();
            return fileContent;
        }
    }

    protected static String outputDocumentWithOriginalFormat(Document document) {
        try {
            OutputFormat format = new OutputFormat();
            format.setSuppressDeclaration(true);
            format.setIndent(false);
            format.setNewlines(false);
            format.setTrimText(false);
            format.setPadText(false);
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            xmlWriter.close();
            return String.valueOf(writer.toString()) + System.lineSeparator();
        }
        catch (IOException e) {
            System.err.println("\u6748\u64b3\u56adXML\u93c3\u8dfa\u56ad\u95bf\ufffd: " + e.getMessage());
            e.printStackTrace();
            return document.asXML();
        }
    }

    protected void showResultDialog(final String title, final String message, final boolean isError) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (shell != null && !shell.isDisposed()) {
                    MessageDialog.open((int)(isError ? 1 : 2), (Shell)shell, (String)title, (String)message, (int)0);
                }
            }
        });
    }

    protected void executeConversionWithProgress(String projectPath, String projectName, String parserType, IRunnableWithProgress runnable) {
        File projectFile = new File(projectPath);
        if (projectFile.exists()) {
            Shell shell = Display.getCurrent().getActiveShell();
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            progressDialog.setCancelable(false);
            try {
                progressDialog.run(true, false, runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMsg = "Convert failed!";
                this.out.println(errorMsg);
                this.showResultDialog(String.valueOf(parserType) + " to GD Project Conversion Failed", errorMsg, true);
            }
            shell.dispose();
        } else {
            this.showResultDialog("Error", "The file does not exist. Please check the project path.", true);
        }
    }

    protected boolean processCProjectFile(String projFolder, String cConfigContent) {
        block3: {
            try {
                String cprojectFilePath = String.valueOf(projFolder) + File.separator + ".cproject";
                if (!Files.exists(Paths.get(cprojectFilePath, new String[0]), new LinkOption[0])) break block3;
                String fileContent = new String(Files.readAllBytes(Paths.get(cprojectFilePath, new String[0])));
                fileContent = fileContent.replace("${cconfiguration}", cConfigContent);
                Files.write(Paths.get(cprojectFilePath, new String[0]), fileContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                String errorMsg = "Failed to write .cproject file!\nConvert failed.";
                this.out.println(errorMsg);
                this.showResultDialog("Project Conversion Failed", errorMsg, true);
                return false;
            }
        }
        String errorMsg = "cproject file not found.\nConvert failed.";
        this.out.println(errorMsg);
        this.showResultDialog("Project Conversion Failed", errorMsg, true);
        return false;
    }

    protected String prepareProjectFolder(String projectName, String projRootFolder) {
        if (projRootFolder == null || projRootFolder.isEmpty()) {
            String errorMsg = "Get project root folder failed.";
            this.out.println(errorMsg);
            this.showResultDialog("Project Conversion Failed", errorMsg, true);
            return null;
        }
        String projFolder = String.valueOf(projRootFolder) + File.separator + "GD32EBuilder_project";
        File folder = new File(projFolder);
        if (folder.exists()) {
            String errorMsg = "Convert failed!\n\nA project already exists at: " + projFolder;
            this.out.println(errorMsg);
            this.showResultDialog("Project Conversion Failed", errorMsg, true);
            return null;
        }
        this.folderProcess.createFolder(projFolder);
        Path projLocation = new Path(projFolder);
        this.projectCreator.createProject(projectName, (IPath)projLocation);
        return projFolder;
    }

    protected String readTemplateUnitFile(String toolChainName) {
        String fileContent = "";
        String ProSettingFolderPath = String.valueOf(GeneralPathUtil.ResourcePath) + "ProjectSetting";
        String filePath = toolChainName.toUpperCase().equals("ARM") ? String.valueOf(ProSettingFolderPath) + File.separator + "unit.xml" : String.valueOf(ProSettingFolderPath) + File.separator + "unit_riscv.xml";
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContent;
    }

    protected String processTemplateContent(String fileContent, TargetInfoStruct targetInfoStruct, String targetName) {
        if (fileContent.isEmpty()) {
            return "";
        }
        String idString = UniqueNumericStringGenerator.generateRandomNumericString();
        fileContent = fileContent.replace("${id}", idString);
        fileContent = fileContent.replace("${config.name}", targetName);
        String symbols = AbstractKeilIARImportWizard.convertToListOptionValues(targetInfoStruct.getStrDefine());
        fileContent = fileContent.replace("${assembler.symbols}", symbols);
        fileContent = fileContent.replace("${CCompiler.symbols}", symbols);
        fileContent = this.processSecure(fileContent, targetInfoStruct);
        return fileContent;
    }

    public void updatePartNoByDifferentConfig(String projectName, int projectType) {
        try {
            IProject project = this.getProjectByName(projectName);
            for (String targetName : this.MapTarget.keySet()) {
                IOption option;
                IToolChain toolchain;
                TargetInfoStruct targetInfoStruct = this.MapTarget.get(targetName);
                String TempMCUPartNo = targetInfoStruct.getStrDevice();
                MCUSeletorInfo SeletorInfo = McuFactory.getSeletorInfoByPartNo((int)projectType, (String)TempMCUPartNo);
                String MCUPartNo = SeletorInfo.getMCUPart();
                String Core = SeletorInfo.getCore();
                IConfiguration Config = this.getManagedBuildConfigByName(projectName, targetName);
                if (Config == null || (toolchain = Config.getToolChain()) == null) continue;
                String PartNoID = Option.OPTIONID_TARGETMCU_PARTNO;
                if (Core.equalsIgnoreCase("risc-v")) {
                    PartNoID = PartNoID.replace("arm", "riscv");
                }
                if ((option = toolchain.getOptionById(PartNoID)) == null) continue;
                Config.setOption((IHoldsOptions)toolchain, option, MCUPartNo);
                IBuilder builder = Config.getBuilder();
                if (builder == null) continue;
                builder.setBuildPath("${workspace_loc:/${ProjName}}/" + targetName);
            }
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IProject getProjectByName(String projectName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject project = root.getProject(projectName);
        return project;
    }

    public IConfiguration getManagedBuildConfigByName(String projectName, String configName) {
        IProject project = this.getProjectByName(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IManagedProject mproj = info.getManagedProject();
        if (mproj == null) {
            return null;
        }
        IConfiguration[] iConfigurationArray = mproj.getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            if (cfg != null && configName.equals(cfg.getName())) {
                return cfg;
            }
            ++n2;
        }
        return null;
    }

    public LinkedHashMap<String, TargetInfoStruct> moveKeyToFront(LinkedHashMap<String, TargetInfoStruct> map, String keyToFront) {
        if (map == null || map.isEmpty() || keyToFront == null) {
            return map;
        }
        if (!map.containsKey(keyToFront)) {
            return map;
        }
        if (map.keySet().iterator().next().equalsIgnoreCase(keyToFront)) {
            return map;
        }
        LinkedHashMap<String, TargetInfoStruct> result = new LinkedHashMap<String, TargetInfoStruct>(map.size());
        result.put(keyToFront, map.get(keyToFront));
        for (Map.Entry<String, TargetInfoStruct> e : map.entrySet()) {
            if (keyToFront.equals(e.getKey())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }
}

