/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.xmlparse;

import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.FunctionPositionStruct;
import com.gigadevice.venustool.baseinfo.PerisTreeStruct;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PerisTreeXMLParse {
    private static final String TREE_TOPNODE = "Peripherals";
    private static final String TREE_NODE = "Peripheral";
    private static final String ATTRIBUTES_TYPE = "Type";
    private static final String ATTRIBUTES_FUNC = "Function";
    private static final String ATTRIBUTES_ACTION = "Action";
    private static final String ATTRIBUTES_NODE = "NodeName";
    private static final String ATTRIBUTES_PARENT = "Parent";
    private static String G_PerisName = "";
    private static String G_NodeName = "";

    public static PerisTreeStruct parsePeripheralXML(String filePath, Map<String, List<FunctionPositionStruct>> FunctionMap) {
        PerisTreeStruct treePeripherals = new PerisTreeStruct(TREE_TOPNODE);
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            List PeripheralList = rootElm.elements(TREE_NODE);
            PerisTreeXMLParse.PraseNode(null, treePeripherals, PeripheralList, FunctionMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return treePeripherals;
    }

    private static void PraseNode(PerisTreeStruct parentNode, PerisTreeStruct currentNode, List lstNode, Map<String, List<FunctionPositionStruct>> FunctionMap) {
        for (Element elm : lstNode) {
            String itemText;
            String mNodeName = elm.attributeValue(ATTRIBUTES_NODE);
            boolean isParentNode = PerisTreeXMLParse.GetExpandEnable(elm);
            List<String> lstAttributes = Arrays.asList(ATTRIBUTES_TYPE, ATTRIBUTES_FUNC, ATTRIBUTES_ACTION);
            Map<String, String> map = PerisTreeXMLParse.GetInfoMap(elm, lstAttributes);
            PerisTreeStruct childNode = new PerisTreeStruct(mNodeName);
            childNode.setParentAttribute(isParentNode);
            childNode.setInfo(map);
            currentNode.addChildNode(childNode);
            currentNode.setParentNode(parentNode);
            if (isParentNode) {
                G_PerisName = mNodeName;
                List lstChildNode = elm.elements();
                PerisTreeXMLParse.PraseNode(currentNode, childNode, lstChildNode, FunctionMap);
                continue;
            }
            if (parentNode.getParentNode() != null && parentNode.getParentNode().getName() != TREE_TOPNODE && !currentNode.getParentAttribute()) {
                PerisTreeXMLParse.GetMultipleTreePath(parentNode);
            }
            if (map.containsKey(ATTRIBUTES_TYPE)) {
                String strType = map.get(ATTRIBUTES_TYPE);
                if (strType.equals("2")) {
                    G_NodeName = mNodeName;
                    List lstChildNode = elm.elements();
                    PerisTreeXMLParse.PraseNode(currentNode, childNode, lstChildNode, FunctionMap);
                    continue;
                }
                if (!map.containsKey(ATTRIBUTES_FUNC)) continue;
                FunctionPositionStruct functionPos = new FunctionPositionStruct();
                functionPos.setPeris(G_PerisName);
                functionPos.setNode(mNodeName);
                if (childNode.getAction().isEmpty() || childNode.getAction().equals("")) {
                    childNode.setAction("SET");
                }
                PerisTreeXMLParse.FunctionProcess(childNode, functionPos, FunctionMap);
                continue;
            }
            childNode.setItemFlag(true);
            String Strtemp = itemText = elm.getText();
            if (itemText == null) continue;
            childNode.setData((Object)itemText);
            Strtemp = Strtemp.replace("Disable", "");
            Strtemp = Strtemp.replace(" ", "");
            if (!map.containsKey(ATTRIBUTES_FUNC) || Strtemp.length() <= 0) continue;
            FunctionPositionStruct functionPos = new FunctionPositionStruct();
            functionPos.setPeris(G_PerisName);
            functionPos.setNode(G_NodeName);
            functionPos.setItem(itemText);
            PerisTreeXMLParse.FunctionProcess(childNode, functionPos, FunctionMap);
        }
    }

    private static boolean GetExpandEnable(Element elm) {
        boolean bl = false;
        String strAttributes = elm.attributeValue(ATTRIBUTES_PARENT);
        if (strAttributes != null && strAttributes.equals("Y")) {
            bl = true;
        }
        return bl;
    }

    private static Map<String, String> GetInfoMap(Element elm, List<String> lstAttributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String strAttribute : lstAttributes) {
            String strAttributesValue = elm.attributeValue(strAttribute);
            if (strAttributesValue == null) continue;
            map.put(strAttribute, strAttributesValue);
        }
        return map;
    }

    private static void GetMultipleTreePath(PerisTreeStruct node) {
        String LeafNodeName = node.getName();
        if (GlobalVariables.PeripheralMultipleTreeMap.containsKey(LeafNodeName)) {
            return;
        }
        ArrayList<String> lstPath = new ArrayList<String>();
        while (node.getParentNode() != null) {
            node.getName();
            lstPath.add(node.getName());
            node = node.getParentNode();
        }
        Collections.reverse(lstPath);
        GlobalVariables.PeripheralMultipleTreeMap.put(LeafNodeName, lstPath);
    }

    private static void FunctionProcess(PerisTreeStruct node, FunctionPositionStruct functionPos, Map<String, List<FunctionPositionStruct>> FunctionMap) {
        List lstFunction = node.getFunction();
        functionPos.setFunction(lstFunction);
        if (node.getAction().toUpperCase().equals("SET")) {
            for (String strFunction : lstFunction) {
                if (FunctionMap.containsKey(strFunction)) {
                    FunctionMap.get(strFunction).add(functionPos);
                    continue;
                }
                ArrayList<FunctionPositionStruct> lstValue = new ArrayList<FunctionPositionStruct>();
                lstValue.add(functionPos);
                FunctionMap.put(strFunction, lstValue);
            }
        }
    }
}

