/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.utils;

import com.gigadevice.periconfigview.utils.GPIOConfigUtil;
import com.gigadevice.periconfigview.utils.PerisConfigUtil;
import com.gigadevice.pinoutview.peritree.PerisTreeView;
import com.gigadevice.pinoutview.pinpackage.PackageAbstract;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.PinFunctionStruct;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PinoutUtil {
    public static final Color Color_DEFAULT = new Color(220, 220, 220);
    public static final Color Color_POWER_PIN = new Color(176, 226, 255);
    public static final Color Color_AUTO_SELECTED = new Color(128, 255, 128);
    public static final Color Color_MANU_SELECTED = new Color(255, 255, 128);
    public static final Color Color_Search_PIN = new Color(255, 128, 255);
    public static final Color Color_Config = new Color(128, 128, 255);
    public static final Color Color_ANALOG_MODE_PIN = new Color(255, 226, 255);
    public static final Color Color_UNUSED_AUTO_USED = new Color(128, 255, 220);
    public static final Color Color_Foreground = new Color(0, 104, 179);
    public static final int left_pin = 0;
    public static final int top_pin = 1;
    public static final int right_pin = 2;
    public static final int bottom_pin = 3;
    public static final int bga_pin = 4;
    public static final int Magnify = 0;
    public static final int Shrink = 1;
    public static final int Common = 2;
    public static final int LeftRotate = 3;
    public static final int RightRotate = 4;
    public static final int RefreshPin = 5;
    public static boolean pinRepaintPeriTree = true;
    public static boolean userPackageLocationManu = false;
    public static final String isCheckBox = "Checkbox";
    public static final String isComBox = "Combox";
    public static PackageAbstract packageAbstract;
    public static Map<String, List<NodeStruct>> pinPeritreeRelateMap;
    public static TreeMap<String, List<Integer>> PinFunctionMap;
    public static TreeMap<String, List<Integer>> PinNameMap;
    public static List<String> MANUPinList;
    public static Map<String, Integer> buttonIndexByName;
    public static List<String> highlightedPinList;
    public static boolean isHighlightedPin;

    static {
        pinPeritreeRelateMap = new HashMap<String, List<NodeStruct>>();
        PinFunctionMap = new TreeMap();
        PinNameMap = new TreeMap();
        MANUPinList = new ArrayList<String>();
        buttonIndexByName = new HashMap<String, Integer>();
        highlightedPinList = new ArrayList<String>();
        isHighlightedPin = false;
    }

    public static void ClearUserConfigVars() {
        pinPeritreeRelateMap.clear();
        MANUPinList.clear();
    }

    public static void ClearAllGlobalVars() {
        pinPeritreeRelateMap.clear();
        MANUPinList.clear();
        PinFunctionMap.clear();
        PinNameMap.clear();
        buttonIndexByName.clear();
        highlightedPinList.clear();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(pinPeritreeRelateMap);
            out.writeObject(MANUPinList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                PinoutUtil.DeSerializeV1(ins);
            }
        }
    }

    public static void LoadAllGlobalVars() {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = (GD32PinPad)GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinUsedType() != 0) {
                if (pinPadObj.getPinUsedType() == 1) {
                    MANUPinList.add(pinPadObj.getPinUsedFunctionStr());
                    PinoutUtil.UpdateGPIOPinInfo(pinPadObj.getPinIndex(), true);
                } else if (pinPadObj.getGPIOModel() == 1) {
                    for (GD32PinPad child : pinPadObj.getChildGD32PinPads()) {
                        if (child.getPinUsedType() <= 1) continue;
                        PinoutUtil.updatePinPeritreeRelateMap(child);
                    }
                    PinoutUtil.UpdateGPIOPinInfo(pinPadObj, true);
                } else {
                    if (pinPadObj.getPinUsedType() > 1) {
                        PinoutUtil.updatePinPeritreeRelateMap(pinPadObj);
                    }
                    PinoutUtil.UpdateGPIOPinInfo(pinPadObj.getPinIndex(), true);
                }
            }
            ++i;
        }
    }

    private static void updatePinPeritreeRelateMap(GD32PinPad pinPadObj) {
        String pinName = pinPadObj.getPinName();
        String usedFunc = pinPadObj.getPinUsedFunctionStr();
        String usedPeri = pinPadObj.getPinUsedPeri();
        if (!GlobalVariables.PeripheralConfigObjMap.containsKey(usedPeri)) {
            return;
        }
        Map mapNodeInfo = (Map)GlobalVariables.PeripheralConfigObjMap.get(usedPeri);
        for (String strNode : mapNodeInfo.keySet()) {
            NodeStruct nodeStruct = (NodeStruct)mapNodeInfo.get(strNode);
            List usedFuncList = new ArrayList();
            if (nodeStruct.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                usedFuncList = nodeStruct.getFunctionLst();
            } else {
                LinkedHashMap mapItem = nodeStruct.getItems();
                for (String itemStr : mapItem.keySet()) {
                    if (!itemStr.equals(nodeStruct.getValue())) continue;
                    usedFuncList = ((ItemStruct)mapItem.get(itemStr)).getFunctionLst();
                    break;
                }
            }
            if (!usedFuncList.contains(usedFunc)) continue;
            PinoutUtil.pinPeritreeRelateMapInsert(pinName, nodeStruct);
        }
    }

    public static String Serialize() {
        String output = "";
        return output;
    }

    /*
     * Unable to fully structure code
     */
    public static void DeSerialize(String input, String version) {
        var2_2 = version;
        tmp = -1;
        switch (var2_2.hashCode()) {
            case 48563: {
                if (!var2_2.equals("1.0")) break;
                tmp = 1;
                break;
            }
        }
        ** switch (tmp)
lbl10:
        // 2 sources

    }

    private static void DeSerializeV1(String input) {
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            pinPeritreeRelateMap = (Map)ins.readObject();
            MANUPinList = (List)ins.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void UpdateGPIOPinInfo(int Index, boolean isAdd) {
        if (!GlobalVariables.isSupportCodeGen()) {
            return;
        }
        if (Index < 0) {
            return;
        }
        if (GlobalVariables.GetPinInfo((int)Index).getGPIOModel() == 1) {
            for (GD32PinPad child : GlobalVariables.GetPinInfo((int)Index).getChildGD32PinPads()) {
                GD32PinPad GD32PinPadCopy = null;
                if (child.getPinUsedType() == 1) {
                    GD32PinPadCopy = (GD32PinPad)GlobalVariables.cloneFrom((Object)GlobalVariables.GetPinInfo((int)Index));
                    GD32PinPadCopy.putPinUsedPeri("GPIO");
                    GD32PinPadCopy.putPinUsedType(1);
                } else {
                    GD32PinPadCopy = (GD32PinPad)GlobalVariables.cloneFrom((Object)child);
                }
                if (isAdd) {
                    PerisConfigUtil.AddPinList.add(GD32PinPadCopy);
                    continue;
                }
                PerisConfigUtil.DeletePinList.add(GD32PinPadCopy);
            }
        } else if (isAdd) {
            PerisConfigUtil.AddPinList.add(GlobalVariables.GetPinInfo((int)Index));
        } else {
            PerisConfigUtil.DeletePinList.add(GlobalVariables.GetPinInfo((int)Index));
        }
        GPIOConfigUtil.UpdatePeriConfigInfo();
    }

    public static void UpdateGPIOPinInfo(GD32PinPad GD32PinPadObj, boolean isAdd) {
        if (!GlobalVariables.isSupportCodeGen()) {
            return;
        }
        boolean isGPIOPin = false;
        for (GD32PinPad child : GD32PinPadObj.getChildGD32PinPads()) {
            if (child.getPinUsedType() == 1) {
                isGPIOPin = true;
                continue;
            }
            if (child.getPinUsedType() <= 1) continue;
            GD32PinPad GD32PinPadCopy = (GD32PinPad)GlobalVariables.cloneFrom((Object)child);
            if (isAdd) {
                PerisConfigUtil.AddPinList.add(GD32PinPadCopy);
                continue;
            }
            PerisConfigUtil.DeletePinList.add(GD32PinPadCopy);
        }
        if (isGPIOPin) {
            GD32PinPad GD32PinPadCopy = (GD32PinPad)GlobalVariables.cloneFrom((Object)GD32PinPadObj);
            GD32PinPadCopy.putPinUsedPeri("GPIO");
            GD32PinPadCopy.putPinUsedType(1);
            if (isAdd) {
                PerisConfigUtil.AddPinList.add(GD32PinPadCopy);
            } else {
                PerisConfigUtil.DeletePinList.add(GD32PinPadCopy);
            }
        }
        GPIOConfigUtil.UpdatePeriConfigInfo();
    }

    public static void ResetPinList(List<GD32PinPad> ResetPinList, NodeStruct node) {
        for (String pinNameStr : highlightedPinList) {
            int pinIndex = GlobalVariables.gd32mcuObj.GetPinIndexByPinName(pinNameStr);
            if (pinIndex == -1) continue;
            PinoutUtil.packageAbstract.PinPanels[pinIndex].removeHighlightedState();
        }
        highlightedPinList.clear();
        ArrayList<String> deletePinList = new ArrayList<String>();
        if (!ResetPinList.isEmpty()) {
            int i = ResetPinList.size() - 1;
            while (i >= 0) {
                GD32PinPad GD32PinPadObj = ResetPinList.get(i);
                String pinName = GD32PinPadObj.getPinName();
                if (deletePinList.contains(pinName)) {
                    ResetPinList.remove(i);
                } else {
                    deletePinList.add(pinName);
                    if (pinPeritreeRelateMap.containsKey(pinName)) {
                        List<NodeStruct> nodes = pinPeritreeRelateMap.get(pinName);
                        int j = nodes.size() - 1;
                        while (j >= 0) {
                            NodeStruct nodeObj = nodes.get(j);
                            String nodePath = "";
                            nodePath = ControlConflict.getFullPath((NodeStruct)nodeObj, (String)nodePath);
                            String newPath = "";
                            if (nodePath.equals(newPath = ControlConflict.getFullPath((NodeStruct)node, (String)newPath))) {
                                nodes.remove(nodeObj);
                                if (nodes.size() == 0) {
                                    pinPeritreeRelateMap.remove(pinName);
                                }
                            }
                            --j;
                        }
                        if (nodes.size() != 0) {
                            pinPeritreeRelateMap.put(pinName, nodes);
                        }
                    }
                    if (GlobalVariables.GetPinInfo((int)GD32PinPadObj.getPinIndex()).getGPIOModel() != 1 && pinPeritreeRelateMap.containsKey(pinName)) {
                        ResetPinList.remove(i);
                    }
                }
                --i;
            }
        }
        packageAbstract.ResetPinList(ResetPinList);
    }

    public static void UpdatePinList(List<GD32PinPad> pUpdatePinList, List<String> functionContentList, NodeStruct node) {
        isHighlightedPin = true;
        for (String pinNameStr : highlightedPinList) {
            int Index = GlobalVariables.gd32mcuObj.GetPinIndexByPinName(pinNameStr);
            if (Index == -1) continue;
            PinoutUtil.packageAbstract.PinPanels[Index].removeHighlightedState();
        }
        highlightedPinList.clear();
        if (functionContentList == null) {
            functionContentList = new ArrayList<String>();
            functionContentList.add("");
        }
        if (!pUpdatePinList.isEmpty()) {
            ArrayList<String> funcList = new ArrayList<String>();
            int i = 0;
            while (i < pUpdatePinList.size()) {
                PinoutUtil.migrateAutoSeletedPins(i, functionContentList, pUpdatePinList, funcList);
                ++i;
            }
            i = 0;
            while (i < pUpdatePinList.size()) {
                String Function2 = pUpdatePinList.get(i).getPinUsedFunctionStr();
                String pinName = pUpdatePinList.get(i).getPinName();
                if (functionContentList.contains(Function2)) {
                    if (pUpdatePinList.get(i).getPinUsedType() != 0) {
                        PinoutUtil.pinPeritreeRelateMapInsert(pinName, node);
                        highlightedPinList.add(pinName);
                    } else {
                        PinoutUtil.pinPeritreeRelateMapDelete(pinName, node);
                    }
                }
                ++i;
            }
            packageAbstract.UpdatePinList(pUpdatePinList);
        }
        isHighlightedPin = false;
    }

    public static void migrateAutoSeletedPins(int index, List<String> functionContentList, List<GD32PinPad> pUpdatePinList, List<String> funcList) {
        String func;
        GD32PinPad GD32PinPadObj = pUpdatePinList.get(index);
        String Function2 = GD32PinPadObj.getPinUsedFunctionStr();
        if (functionContentList.contains(Function2) || funcList.contains(Function2)) {
            return;
        }
        if (GD32PinPadObj.getPinUsedType() == 0) {
            return;
        }
        funcList.add(Function2);
        String OldPinName = GlobalVariables.gd32mcuObj.GetPinNameByUsedFunc(Function2);
        String NewPinName = GD32PinPadObj.getPinName();
        int Index = GlobalVariables.gd32mcuObj.GetPinIndexByPinName(NewPinName);
        if (Index != -1 && GlobalVariables.GetPinInfo((int)Index).getPinUsedType() != 0 && (Index = GlobalVariables.gd32mcuObj.FuncContainInUpdatePinList(func = GlobalVariables.GetPinInfo((int)Index).getPinUsedFunctionStr(), pUpdatePinList)) != -1) {
            PinoutUtil.migrateAutoSeletedPins(Index, functionContentList, pUpdatePinList, funcList);
        }
        if (GlobalVariables.gd32mcuObj.PinContainInUpdatePinList(OldPinName, pUpdatePinList) == -1) {
            packageAbstract.ResetPinandButtonStatus(GlobalVariables.gd32mcuObj.GetPinIndexByPinName(OldPinName));
        }
        int oldIndex = GlobalVariables.gd32mcuObj.GetPinIndexByPinName(OldPinName);
        PinoutUtil.UpdateGPIOPinInfo(oldIndex, false);
        PinoutUtil.pinPeritreeRelateMapUpdate(OldPinName, NewPinName);
    }

    public static void pinPeritreeRelateMapInsert(String pinName, NodeStruct node) {
        List<NodeStruct> nodeList = new ArrayList<NodeStruct>();
        if (pinPeritreeRelateMap.containsKey(pinName)) {
            nodeList = pinPeritreeRelateMap.get(pinName);
        }
        nodeList.add(node);
        pinPeritreeRelateMap.put(pinName, nodeList);
    }

    public static void pinPeritreeRelateMapDelete(String pinName, NodeStruct node) {
        if (pinPeritreeRelateMap.containsKey(pinName)) {
            List<NodeStruct> nodeList = pinPeritreeRelateMap.get(pinName);
            if (nodeList.contains(node)) {
                nodeList.remove(node);
            }
            if (nodeList.size() == 0) {
                pinPeritreeRelateMap.remove(pinName);
            }
            pinPeritreeRelateMap.put(pinName, nodeList);
        }
    }

    public static void pinPeritreeRelateMapUpdate(String OldPinName, String NewPinName) {
        if (OldPinName.equals(NewPinName)) {
            return;
        }
        if (pinPeritreeRelateMap.containsKey(OldPinName)) {
            List<NodeStruct> nodeList = pinPeritreeRelateMap.get(OldPinName);
            pinPeritreeRelateMap.remove(OldPinName);
            pinPeritreeRelateMap.put(NewPinName, nodeList);
        }
    }

    public static void UpdatePinFunctionMap(List<PinFunctionStruct> PinFunctionList, int PinIndex) {
        int j = 0;
        while (j < PinFunctionList.size()) {
            String functionName = PinFunctionList.get(j).getPinFunctionName();
            if (!PinFunctionMap.containsKey(functionName)) {
                ArrayList<Integer> tmp = new ArrayList<Integer>();
                tmp.add(PinIndex);
                PinFunctionMap.put(functionName, tmp);
            } else {
                PinFunctionMap.get(functionName).add(PinIndex);
            }
            ++j;
        }
    }

    public static void UpdatePinNameMap(String pinName, int PinIndex) {
        if (!PinNameMap.containsKey(pinName)) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            tmp.add(PinIndex);
            PinNameMap.put(pinName, tmp);
        } else {
            PinNameMap.get(pinName).add(PinIndex);
        }
    }

    public static void updateManuPinList(int Index, String Function2, int UsedType) {
        String formerFunctionStr;
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        int formerUseType = GD32PinPadObj.getPinUsedType();
        if (formerUseType == 1 && MANUPinList.contains(formerFunctionStr = GD32PinPadObj.getPinUsedFunctionStr())) {
            MANUPinList.remove(formerFunctionStr);
        }
        if (UsedType == 1 && !Function2.equals("Reset") && !MANUPinList.contains(Function2)) {
            MANUPinList.add(Function2);
        }
    }

    public static int funcIsRelateUniquePeriTreeNode(String functionName, List<Object> objectList) {
        List lstFunction;
        List lstFunction2;
        ArrayList<List> functionList = new ArrayList<List>();
        ArrayList<List> deleteList = new ArrayList<List>();
        if (GlobalVariables.FunctionPosInItem.containsKey(functionName)) {
            List itemStructs = (List)GlobalVariables.FunctionPosInItem.get(functionName);
            for (ItemStruct itemObj : itemStructs) {
                lstFunction2 = itemObj.getFunctionLst();
                functionList.add(lstFunction2);
            }
        }
        if (GlobalVariables.FunctionPosInWidget.containsKey(functionName)) {
            List nodeStructs = (List)GlobalVariables.FunctionPosInWidget.get(functionName);
            for (WidgetNodeStruct nodeObj : nodeStructs) {
                lstFunction2 = nodeObj.getFunctionLst();
                functionList.add(lstFunction2);
            }
        }
        int i = 0;
        while (i < functionList.size()) {
            int j = i + 1;
            while (j < functionList.size()) {
                int result = PinoutUtil.isSubset((List)functionList.get(i), (List)functionList.get(j));
                if (result == 0) {
                    deleteList.add((List)functionList.get(j));
                } else if (result == 1) {
                    deleteList.add((List)functionList.get(i));
                    deleteList.add((List)functionList.get(j));
                }
                ++j;
            }
            ++i;
        }
        functionList.removeAll(deleteList);
        int index = -1;
        int i2 = 0;
        while (i2 < functionList.size()) {
            if (MANUPinList.containsAll((Collection)functionList.get(i2))) {
                index = i2;
            }
            ++i2;
        }
        if (index == -1) {
            return -1;
        }
        if (GlobalVariables.FunctionPosInItem.containsKey(functionName)) {
            List itemStructs = (List)GlobalVariables.FunctionPosInItem.get(functionName);
            for (ItemStruct itemObj : itemStructs) {
                lstFunction = itemObj.getFunctionLst();
                if (functionList.get(index) != lstFunction) continue;
                objectList.add(itemObj);
                return ConstantsUtil.ControlType.Combox.ordinal();
            }
        }
        if (GlobalVariables.FunctionPosInWidget.containsKey(functionName)) {
            List nodeStructs = (List)GlobalVariables.FunctionPosInWidget.get(functionName);
            for (WidgetNodeStruct nodeObj : nodeStructs) {
                lstFunction = nodeObj.getFunctionLst();
                if (functionList.get(index) != lstFunction) continue;
                objectList.add(nodeObj);
                return ConstantsUtil.ControlType.CheckBox.ordinal();
            }
        }
        return -1;
    }

    public static boolean uniqueFuncToChangePeriTree(Integer controlType, List<Object> objectList) {
        String periName = "";
        String nodeName = "";
        String itemName = "";
        if (controlType.intValue() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
            NodeStruct nodeObj = (NodeStruct)objectList.get(0);
            periName = ControlConflict.getModuleByNode((NodeStruct)nodeObj).getNodeName();
            nodeName = ControlConflict.getNodePath((NodeStruct)nodeObj, (String)nodeName);
            itemName = "true";
            NodeStruct relateNodeObj = (NodeStruct)ControlConflict.getPeriTreeNode((String)periName, (String)nodeName, (String)"", (String)"Control");
            int state = relateNodeObj.getState();
            if ((state &= 3) != 0) {
                return false;
            }
            PerisTreeView.pinSelecteToCheckboxChanged(relateNodeObj, "true");
        } else if (controlType.intValue() == ConstantsUtil.ControlType.Combox.ordinal()) {
            ItemStruct itemObj = (ItemStruct)objectList.get(0);
            periName = ControlConflict.getModuleByItem((ItemStruct)itemObj).getNodeName();
            NodeStruct nodeObj = (NodeStruct)itemObj.getParentNode();
            nodeName = ControlConflict.getNodePath((NodeStruct)nodeObj, (String)nodeName);
            itemName = itemObj.getNodeName();
            NodeStruct relateNodeObj = (NodeStruct)ControlConflict.getPeriTreeNode((String)periName, (String)nodeName, (String)"", (String)"Control");
            int state = relateNodeObj.getState();
            if ((state &= 3) != 0) {
                return false;
            }
            List availableItems = ControlConflict.getNodeAvailableItems((WidgetNodeStruct)relateNodeObj);
            if (!availableItems.contains(itemName)) {
                return false;
            }
            PerisTreeView.pinSelecteToComboxChanged(relateNodeObj, itemName);
        }
        return true;
    }

    public static int isSubset(List<String> list1, List<String> list2) {
        ArrayList<String> list1_1 = new ArrayList<String>();
        list1_1.addAll(list1);
        ArrayList<String> list2_1 = new ArrayList<String>();
        list2_1.addAll(list2);
        int differ = list1_1.size() - list2_1.size();
        list1_1.removeAll(list2_1);
        if (differ >= 0 && differ == list1_1.size()) {
            return 0;
        }
        if (differ < 0 && list1_1.size() == 0) {
            return 1;
        }
        return -1;
    }

    public static boolean checkAllFunctionhasPin(List<String> lstFunction) {
        int i = 0;
        while (i < lstFunction.size()) {
            String function = lstFunction.get(i);
            if (!PinFunctionMap.containsKey(function)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static TreeMap<String, List<Integer>> getTreeMap() {
        return PinFunctionMap;
    }
}

