/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import com.gigadevice.pinoutview.pinpackage.RotateLabel;
import com.gigadevice.pinoutview.utils.PinoutUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PinPanel
extends JPanel {
    protected JButton PinButton = new JButton();
    private RotateLabel PinButtonLabel = new RotateLabel(0);
    private RotateLabel PinConfigLabel = new RotateLabel(0);
    private int direction = 0;
    private int wordSizePercent = 20;
    private double buttonPercent = 0.2;
    private Font font;
    private boolean isTSSOP = false;
    private int WordSize = 0;

    public PinPanel() {
    }

    public PinPanel(boolean _isTSSOP) {
        if (GlobalVariables.GetPinPackageNum() >= 100 && GlobalVariables.GetPinPackageNum() < 128) {
            this.wordSizePercent = 30;
            this.buttonPercent = 0.15;
        } else if (GlobalVariables.GetPinPackageNum() >= 128 && GlobalVariables.GetPinPackageNum() <= 144) {
            this.wordSizePercent = 40;
            this.buttonPercent = 0.1;
        } else if (GlobalVariables.GetPinPackageNum() > 144) {
            this.wordSizePercent = 50;
            this.buttonPercent = 0.1;
        }
        if (_isTSSOP) {
            this.isTSSOP = true;
            this.buttonPercent = 0.3;
            this.wordSizePercent = 12;
        }
    }

    public void Init(int Index, int direction, int x, int y, int width, int height) {
        this.setLayout(null);
        this.setBounds(x, y, width, height);
        this.direction = direction;
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(null);
        labelPanel.setBorder(null);
        labelPanel.setBackground(Color.white);
        this.PinButton.setMargin(new Insets(0, 0, 0, 0));
        this.PinButton.setLayout(null);
        this.PinButton.setBorder(BorderFactory.createEtchedBorder());
        this.PinButton.setBackground(PinoutUtil.Color_DEFAULT);
        if (direction == 0 || direction == 2) {
            int sizel = (int)((double)width * this.buttonPercent);
            int size2 = (int)((double)width * (1.0 - this.buttonPercent));
            if (direction == 0) {
                this.PinButton.setBounds(width - sizel, 0, sizel, height);
                labelPanel.setBounds(0, 0, size2, height);
                this.PinConfigLabel.setHorizontalAlignment(4);
            } else if (direction == 2) {
                this.PinButton.setBounds(0, 0, sizel, height);
                labelPanel.setBounds(width - size2, 0, size2, height);
                this.PinConfigLabel.setHorizontalAlignment(2);
            }
            this.WordSize = width / this.wordSizePercent;
            this.PinConfigLabel.setBounds(0, 0, size2, height);
            this.PinButtonLabel.setBounds(0, 0, sizel, height);
        } else {
            int sizel = (int)((double)height * this.buttonPercent);
            int size2 = (int)((double)height * (1.0 - this.buttonPercent));
            this.WordSize = height / this.wordSizePercent;
            this.PinConfigLabel = new RotateLabel(270);
            this.PinConfigLabel.setBounds(-((size2 - width) / 2), 0, size2, size2);
            this.PinButtonLabel = new RotateLabel(270);
            this.PinButtonLabel.setBounds(-((sizel - width) / 2), 0, sizel, sizel);
            if (direction == 1) {
                labelPanel.setBounds(0, 0, width, size2);
                this.PinButton.setBounds(0, height - sizel, width, sizel);
                this.PinConfigLabel.setHorizontalAlignment(2);
            } else if (direction == 3) {
                labelPanel.setBounds(0, height - size2, width, size2);
                this.PinButton.setBounds(0, 0, width, sizel);
                this.PinConfigLabel.setHorizontalAlignment(4);
            }
        }
        this.font = new Font("Arial", 0, this.WordSize);
        if (this.isTSSOP) {
            this.font = new Font("Arial", 1, this.WordSize);
        }
        this.PinConfigLabel.setFont(this.font);
        this.PinButtonLabel.setHorizontalAlignment(0);
        labelPanel.add(this.PinConfigLabel);
        this.PinButtonLabel.setFont(this.font);
        this.PinButton.add(this.PinButtonLabel);
        this.add(this.PinButton);
        this.add(labelPanel);
        this.setBackground(Color.white);
    }

    public void setPinFun(String str) {
        str = this.direction == 0 || this.direction == 3 ? String.valueOf(str) + "  " : "  " + str;
        this.PinConfigLabel.setText(str);
    }

    public void setPinName(String str) {
        this.PinButtonLabel.setText(str);
    }

    public void setHighlightedState(final GD32PinPad GD32PinPadObj) {
        if (!PinoutUtil.highlightedPinList.contains(GD32PinPadObj.getPinName())) {
            return;
        }
        if (PinoutUtil.isHighlightedPin && !GlobalVariables.isCubeRoverTest) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    int num = 0;
                    Color pinColor = PinPanel.this.PinButton.getBackground();
                    while (num < 1) {
                        try {
                            Thread.sleep(300L);
                            PinPanel.this.PinButton.setBackground(PinoutUtil.Color_DEFAULT);
                            Thread.sleep(200L);
                            PinPanel.this.PinButton.setBackground(pinColor);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++num;
                    }
                    GD32PinPad obj = GlobalVariables.GetPinInfo((int)GD32PinPadObj.getPinIndex());
                    if (obj == null) {
                        return;
                    }
                    if (obj.getPinUsedType() != GD32PinPadObj.getPinUsedType()) {
                        if (obj.getPinUsedType() == 0) {
                            PinPanel.this.PinButton.setBackground(PinoutUtil.Color_DEFAULT);
                        } else if (obj.getPinUsedType() == 2 || obj.getPinUsedType() == 3) {
                            PinPanel.this.PinButton.setBackground(PinoutUtil.Color_AUTO_SELECTED);
                        } else if (obj.getPinUsedType() == 1) {
                            PinPanel.this.PinButton.setBackground(PinoutUtil.Color_MANU_SELECTED);
                        }
                    }
                }
            }, 0L);
        }
        this.font = new Font("Arial", 1, this.WordSize);
        this.PinButtonLabel.setFont(this.font);
        this.PinButton.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public void removeHighlightedState() {
        this.font = new Font("Arial", 0, this.WordSize);
        this.PinButtonLabel.setFont(this.font);
        this.PinButton.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setPinState(GD32PinPad GD32PinPadObj) {
        String PinName = GD32PinPadObj.getPinName();
        String PinNumber = GD32PinPadObj.getPinNumberStr();
        String functionName = GD32PinPadObj.getPinUsedFunctionStr();
        String pinUseLabel = GD32PinPadObj.getPinUseLabel();
        if (GD32PinPadObj.getPinType() == 1 || GD32PinPadObj.isDisablePin()) {
            this.PinButton.setBackground(PinoutUtil.Color_POWER_PIN);
            String tipsInfo = "<html>(" + PinNumber + ")-" + PinName + "</html>";
            this.PinButton.setToolTipText(tipsInfo);
            return;
        }
        if (GD32PinPadObj.getPinUsedType() == 0) {
            this.PinButton.setBackground(PinoutUtil.Color_DEFAULT);
            functionName = "Reset State";
            this.setPinFun("");
            GD32PinPadObj.setPinUseLabel("");
            this.setBackground(Color.white);
            this.removeHighlightedState();
        } else {
            this.setPinFun(functionName);
            if (!pinUseLabel.equals("") && GlobalVariables.isShowUserLabel) {
                this.setPinFun(pinUseLabel);
            }
            this.setBackground(PinoutUtil.Color_Config);
        }
        if (GD32PinPadObj.getPinUsedType() == 2 || GD32PinPadObj.getPinUsedType() == 3) {
            this.PinButton.setBackground(PinoutUtil.Color_AUTO_SELECTED);
            this.setHighlightedState(GD32PinPadObj);
        } else if (GD32PinPadObj.getPinUsedType() == 1) {
            this.PinButton.setBackground(PinoutUtil.Color_MANU_SELECTED);
        } else if (GD32PinPadObj.getPinUsedType() == 4) {
            this.PinButton.setBackground(PinoutUtil.Color_UNUSED_AUTO_USED);
        }
        String pinoutStr = "";
        if (PinoutUtil.pinPeritreeRelateMap.containsKey(PinName)) {
            List<NodeStruct> nodeList = PinoutUtil.pinPeritreeRelateMap.get(PinName);
            int i = 0;
            while (i < nodeList.size()) {
                NodeStruct nodeObj = nodeList.get(i);
                String periName = ControlConflict.getModuleByNode((NodeStruct)nodeObj).getNodeName();
                pinoutStr = String.valueOf(pinoutStr) + "<br>" + String.valueOf(i + 1) + ". " + String.join((CharSequence)"--", periName, nodeObj.getNodeName(), nodeObj.getValue());
                ++i;
            }
        }
        String tipsInfo = "<html>(" + PinNumber + ")-" + String.join((CharSequence)"-", PinName, functionName);
        if (!pinoutStr.equals("")) {
            tipsInfo = String.valueOf(tipsInfo) + "<br>Pinout control: " + pinoutStr;
        }
        tipsInfo = String.valueOf(tipsInfo) + "</html>";
        this.PinButton.setToolTipText(tipsInfo);
    }

    public void setSearchPinState() {
        this.PinButton.setBackground(PinoutUtil.Color_Search_PIN);
    }

    public JButton getPinButton() {
        return this.PinButton;
    }
}

