/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PackageImageView
extends Component {
    private static final long serialVersionUID = 1L;
    private BufferedImage packageImage;

    public void setImagePath(String path, int angel) {
        try {
            BufferedImage imagePath = ImageIO.read(new File(path));
            this.packageImage = this.rotateImage(imagePath, angel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.packageImage != null) {
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                g.drawImage(this.packageImage, 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                g.drawImage(this.packageImage, 0, 0, null);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.packageImage != null) {
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                return new Dimension(this.getWidth(), this.getHeight());
            }
            return new Dimension(this.packageImage.getWidth(), this.packageImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    private BufferedImage rotateImage(Image image, int angel) {
        int imageW = image.getWidth(null);
        int imageH = image.getHeight(null);
        Rectangle imageRec = this.getNewImageSize(new Rectangle(new Dimension(imageW, imageH)), angel);
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(imageRec.width, imageRec.height, 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.translate((imageRec.width - imageW) / 2, (imageRec.height - imageH) / 2);
        g2.rotate(Math.toRadians(angel), imageW / 2, imageH / 2);
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    private Rectangle getNewImageSize(Rectangle rect, int angel) {
        double cosValue = Math.abs(Math.cos(Math.toRadians(angel)));
        double sinValue = Math.abs(Math.sin(Math.toRadians(angel)));
        int imageW = (int)((double)rect.width * cosValue) + (int)((double)rect.height * sinValue);
        int imageH = (int)((double)rect.height * cosValue) + (int)((double)rect.width * sinValue);
        return new Rectangle(new Dimension(imageW, imageH));
    }
}

