/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.peritreeconflict;

import com.gigadevice.pinoutview.utils.PerisTreeUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.FunctionPositionStruct;
import com.gigadevice.venustool.baseinfo.PerisItemsStruct;
import com.gigadevice.venustool.baseinfo.PerisRelateInfo;
import com.gigadevice.venustool.baseinfo.RelateNodeStruct;
import com.gigadevice.venustool.baseinfo.mComboBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;

public class PerisTreeConflictDetection {
    public static void FunctionConflictDetection(String ModuleName, List<mComboBox> lstCoBox, List<JCheckBox> lstCkBox) {
        PerisTreeConflictDetection.UpdateFunctionConflictDetection(ModuleName, lstCoBox, lstCkBox);
        PerisTreeConflictDetection.ConflictDetection(ModuleName, lstCoBox, lstCkBox);
    }

    private static void ConflictDetection(String ModuleName, List<mComboBox> lstCoBox, List<JCheckBox> lstCkBox) {
        if (PerisTreeUtil.PeriRelateMap.containsKey(ModuleName)) {
            List<PerisRelateInfo> lstPerisRelateInfo = PerisTreeUtil.PeriRelateMap.get(ModuleName);
            for (PerisRelateInfo temp : lstPerisRelateInfo) {
                boolean ret;
                String relateNodename = temp.getNodeName();
                boolean Type2 = temp.getType();
                String strRelate = temp.getRelate();
                boolean relateEnableState = temp.getEnable();
                List lstCondition = temp.getRelateNode();
                List lstConditions = temp.getlstRelateInfos();
                boolean conditionResult = false;
                if (strRelate.equals("OR")) {
                    conditionResult = PerisTreeConflictDetection.ORConditionCheck(lstCondition);
                } else if (strRelate.equals("AND")) {
                    conditionResult = PerisTreeConflictDetection.ANDConditionCheck(lstCondition);
                } else if (strRelate.equals("OR_AND")) {
                    for (List lst : lstConditions) {
                        ret = true;
                        ret = PerisTreeConflictDetection.ANDConditionCheck(lst);
                        if (!ret) continue;
                        conditionResult = true;
                        break;
                    }
                } else if (strRelate.equals("AND_OR")) {
                    conditionResult = true;
                    for (List lst : lstConditions) {
                        ret = true;
                        ret = PerisTreeConflictDetection.ORConditionCheck(lst);
                        if (ret) continue;
                        conditionResult = false;
                        break;
                    }
                }
                if (relateNodename.equals("ALL") && conditionResult) {
                    PerisTreeConflictDetection.EnableBox(relateEnableState, lstCoBox, lstCkBox);
                    break;
                }
                PerisTreeConflictDetection.EnableBox(relateNodename, Type2, conditionResult ^ relateEnableState ^ true, lstCoBox, lstCkBox);
            }
        }
    }

    public static void FunctionConflictDetection(List<String> lstEnableFunction, List<String> lstDisableFunction) {
        String strItem;
        String strNode;
        String strPeris;
        List<FunctionPositionStruct> lstFunctionInfo;
        if (lstEnableFunction.size() == 0 && lstDisableFunction.size() == 0) {
            return;
        }
        for (String str : lstEnableFunction) {
            if (!PerisTreeUtil.lstDisableFunction.contains(str)) continue;
            PerisTreeUtil.lstDisableFunction.remove(str);
        }
        for (String str : lstDisableFunction) {
            if (PerisTreeUtil.lstDisableFunction.contains(str)) continue;
            PerisTreeUtil.lstDisableFunction.add(str);
        }
        for (String str : lstEnableFunction) {
            if (!PerisTreeUtil.FunctionRelateMap.containsKey(str)) continue;
            lstFunctionInfo = PerisTreeUtil.FunctionRelateMap.get(str);
            for (FunctionPositionStruct temp : lstFunctionInfo) {
                strPeris = temp.getPeris();
                strNode = temp.getNode();
                strItem = temp.getItem();
                List lstFunction = temp.getFunction();
                boolean Flag = true;
                for (String strFunction : lstFunction) {
                    if (!PerisTreeUtil.lstDisableFunction.contains(strFunction)) continue;
                    Flag = false;
                    break;
                }
                if (!Flag || !PerisTreeUtil.DisableFunctionMap.containsKey(strPeris)) continue;
                List<FunctionPositionStruct> lst = PerisTreeUtil.DisableFunctionMap.get(strPeris);
                int k = lst.size() - 1;
                while (k >= 0) {
                    if (lst.get(k).getNode().equals(strNode) && lst.get(k).getItem().equals(strItem)) {
                        lst.remove(k);
                    }
                    --k;
                }
            }
        }
        for (String str : lstDisableFunction) {
            if (!PerisTreeUtil.FunctionRelateMap.containsKey(str)) continue;
            lstFunctionInfo = PerisTreeUtil.FunctionRelateMap.get(str);
            for (FunctionPositionStruct temp : lstFunctionInfo) {
                PerisItemsStruct tempPerisItem;
                Map map;
                strPeris = temp.getPeris();
                strNode = temp.getNode();
                strItem = temp.getItem();
                FunctionPositionStruct tempFunctionPosition = new FunctionPositionStruct();
                tempFunctionPosition.setPeris(strPeris);
                tempFunctionPosition.setNode(strNode);
                tempFunctionPosition.setItem(strItem);
                ArrayList<FunctionPositionStruct> lst = new ArrayList<FunctionPositionStruct>();
                if (strItem.equals("")) {
                    if (GlobalVariables.PeripheralTreeMap.containsKey(strPeris) && (map = (Map)GlobalVariables.PeripheralTreeMap.get(strPeris)).containsKey(strNode)) continue;
                    if (PerisTreeUtil.DisableFunctionMap.containsKey(strPeris)) {
                        PerisTreeUtil.DisableFunctionMap.get(strPeris).add(tempFunctionPosition);
                        continue;
                    }
                    lst.add(tempFunctionPosition);
                    PerisTreeUtil.DisableFunctionMap.put(strPeris, lst);
                    continue;
                }
                if (GlobalVariables.PeripheralTreeMap.containsKey(strPeris) && (map = (Map)GlobalVariables.PeripheralTreeMap.get(strPeris)).containsKey(strNode) && (tempPerisItem = (PerisItemsStruct)map.get(strNode)).getValue().equals(strItem)) continue;
                if (PerisTreeUtil.DisableFunctionMap.containsKey(strPeris)) {
                    List<FunctionPositionStruct> Disablelist = PerisTreeUtil.DisableFunctionMap.get(strPeris);
                    Boolean Existflag = false;
                    for (FunctionPositionStruct DisableStruct : Disablelist) {
                        if (!DisableStruct.getItem().equals(tempFunctionPosition.getItem()) || !DisableStruct.getNode().equals(tempFunctionPosition.getNode())) continue;
                        Existflag = true;
                        break;
                    }
                    if (Existflag.booleanValue()) continue;
                    Disablelist.add(tempFunctionPosition);
                    continue;
                }
                lst.add(tempFunctionPosition);
                PerisTreeUtil.DisableFunctionMap.put(strPeris, lst);
            }
        }
    }

    private static void UpdateFunctionConflictDetection(String ModuleName, List<mComboBox> lstCoBox, List<JCheckBox> lstCkBox) {
        if (PerisTreeUtil.DisableFunctionMap.containsKey(ModuleName)) {
            for (JCheckBox ckBox : lstCkBox) {
                ckBox.setEnabled(true);
            }
            for (mComboBox coBox : lstCoBox) {
                int ItemsCount = coBox.getItemCount();
                int i = 0;
                while (i < ItemsCount) {
                    coBox.CtrlItem(i, true);
                    ++i;
                }
            }
            List<FunctionPositionStruct> lst = PerisTreeUtil.DisableFunctionMap.get(ModuleName);
            for (FunctionPositionStruct temp : lst) {
                String strNode = temp.getNode();
                String strItem = temp.getItem();
                if (strItem.equals("")) {
                    for (JCheckBox ckBox : lstCkBox) {
                        if (!ckBox.getText().equals(strNode)) continue;
                        ckBox.setEnabled(false);
                    }
                    continue;
                }
                for (mComboBox coBox : lstCoBox) {
                    if (!coBox.getName().equals(strNode)) continue;
                    coBox.disableItem((Object)strItem);
                }
            }
        }
    }

    public static void EnableBox(String nodeName, boolean type, boolean state, List<mComboBox> lstCoBox, List<JCheckBox> lstCkBox) {
        if (type) {
            for (mComboBox coBox : lstCoBox) {
                if (!nodeName.equals(coBox.getName().trim())) continue;
                if (!state) {
                    coBox.setSelectedIndex(0);
                }
                coBox.setEnabled(state);
                break;
            }
        } else {
            for (JCheckBox ckBox : lstCkBox) {
                if (!nodeName.equals(ckBox.getText().trim())) continue;
                if (!state) {
                    ckBox.setSelected(false);
                }
                ckBox.setEnabled(state);
                break;
            }
        }
    }

    public static void EnableBox(boolean state, List<mComboBox> lstCoBox, List<JCheckBox> lstCkBox) {
        for (mComboBox coBox : lstCoBox) {
            if (!state) {
                coBox.setSelectedIndex(0);
            }
            coBox.setEnabled(state);
        }
        for (JCheckBox ckBox : lstCkBox) {
            if (!state) {
                ckBox.setSelected(false);
            }
            ckBox.setEnabled(state);
        }
    }

    public static void CtrlItem(String nodeName, String strItem, boolean state, List<mComboBox> lstCoBox) {
        for (mComboBox coBox : lstCoBox) {
            if (!nodeName.equals(coBox.getName())) continue;
            if (!state) {
                coBox.disableItem((Object)strItem);
                break;
            }
            coBox.removeItem((Object)strItem);
            break;
        }
    }

    public static boolean ORConditionCheck(List<RelateNodeStruct> lstCondition) {
        boolean ret = false;
        for (RelateNodeStruct condition : lstCondition) {
            String strPeris = condition.getPeris();
            String strNodeName = condition.getNode();
            String strValue = condition.getValue();
            if (GlobalVariables.PeripheralTreeMap.containsKey(strPeris)) {
                Map ChangeValueMap = (Map)GlobalVariables.PeripheralTreeMap.get(strPeris);
                if (ChangeValueMap.containsKey(strNodeName)) {
                    PerisItemsStruct mItems = (PerisItemsStruct)ChangeValueMap.get(strNodeName);
                    if (!mItems.getValue().equals(strValue)) continue;
                    ret = true;
                    break;
                }
                if (!strValue.equals("Disable")) continue;
                ret = true;
                break;
            }
            if (!strValue.equals("Disable")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean ANDConditionCheck(List<RelateNodeStruct> lstCondition) {
        boolean ret = true;
        for (RelateNodeStruct condition : lstCondition) {
            String strPeris = condition.getPeris();
            String strNodeName = condition.getNode();
            String strValue = condition.getValue();
            if (GlobalVariables.PeripheralTreeMap.containsKey(strPeris)) {
                Map ChangeValueMap = (Map)GlobalVariables.PeripheralTreeMap.get(strPeris);
                if (ChangeValueMap.containsKey(strNodeName)) {
                    PerisItemsStruct mItems = (PerisItemsStruct)ChangeValueMap.get(strNodeName);
                    if (mItems.getValue().equals(strValue)) continue;
                    ret = false;
                    break;
                }
                if (strValue.equals("Disable") && !strValue.equals("")) continue;
                ret = false;
                break;
            }
            if (strValue.equals("Disable") && !strValue.equals("")) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean GetWidgetState(String ModuleName, String NodeName) {
        if (PerisTreeUtil.PeriRelateMap.containsKey(ModuleName)) {
            List<PerisRelateInfo> lstPerisRelateInfo = PerisTreeUtil.PeriRelateMap.get(ModuleName);
            for (PerisRelateInfo temp : lstPerisRelateInfo) {
                String relateNodename = temp.getNodeName();
                if (NodeName != relateNodename) continue;
                temp.getType();
                String strRelate = temp.getRelate();
                boolean relateEnableState = temp.getEnable();
                List lstCondition = temp.getRelateNode();
                List lstConditions = temp.getlstRelateInfos();
                boolean conditionResult = false;
                if (strRelate.equals("OR")) {
                    conditionResult = PerisTreeConflictDetection.ORConditionCheck(lstCondition);
                } else if (strRelate.equals("AND")) {
                    conditionResult = PerisTreeConflictDetection.ANDConditionCheck(lstCondition);
                } else if (strRelate.equals("OR_AND")) {
                    for (List lst : lstConditions) {
                        boolean ret = true;
                        ret = PerisTreeConflictDetection.ANDConditionCheck(lst);
                        if (!ret) continue;
                        conditionResult = true;
                        break;
                    }
                } else if (strRelate.equals("AND_OR")) {
                    conditionResult = true;
                    for (List lst : lstConditions) {
                        boolean ret = true;
                        ret = PerisTreeConflictDetection.ORConditionCheck(lst);
                        if (ret) continue;
                        conditionResult = false;
                        break;
                    }
                }
                if (relateNodename.equals("ALL") && conditionResult) {
                    return relateEnableState;
                }
                return conditionResult ^ relateEnableState ^ true;
            }
        }
        return true;
    }
}

