/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.peritree;

import com.gigadevice.venustool.GlobalVariables;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class CustomTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon leafDefaultIcon;
    private Icon leafConfiguredIcon;
    private Font parentFont;
    private Font leafFont;

    public CustomTreeCellRenderer() {
        Font baseFont = this.getFont();
        if (baseFont == null) {
            baseFont = new Font("Arial", 1, 15);
        }
        this.parentFont = new Font(baseFont.getName(), 1, baseFont.getSize() + 2);
        this.leafFont = new Font(baseFont.getName(), 1, baseFont.getSize());
        try {
            this.leafDefaultIcon = new ImageIcon(this.getClass().getResource("/icons/peripheral_default.png"));
            this.leafConfiguredIcon = new ImageIcon(this.getClass().getResource("/icons/peripheral_configured.png"));
        }
        catch (Exception exception) {
            this.leafDefaultIcon = this.createColorIcon(Color.GRAY, 16, 16);
            this.leafConfiguredIcon = this.createColorIcon(Color.GREEN, 16, 16);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        String nodeText = node.getUserObject().toString();
        if (leaf) {
            this.setFont(this.leafFont);
            boolean isConfigured = this.isNodeConfigured(nodeText);
            if (isConfigured) {
                this.setIcon(this.leafConfiguredIcon);
            } else {
                this.setIcon(this.leafDefaultIcon);
            }
            if (!selected) {
                if (isConfigured) {
                    this.setForeground(new Color(2, 104, 181));
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
        } else {
            this.setFont(this.parentFont);
            this.setIcon(null);
            this.setForeground(Color.DARK_GRAY);
        }
        return this;
    }

    private boolean isNodeConfigured(String nodeName) {
        ArrayList<String> lstUsedModules = new ArrayList<String>();
        for (String usedModule : GlobalVariables.PeripheralConfigObjMap.keySet()) {
            lstUsedModules.add(usedModule);
        }
        return lstUsedModules.contains(nodeName);
    }

    private Icon createColorIcon(final Color color, final int width, final int height) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(color);
                g2d.fillOval(x, y, width, height);
                g2d.setColor(Color.DARK_GRAY);
                g2d.drawOval(x, y, width, height);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }
        };
    }
}

