/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.logging.ide;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogConfigurationUtil {
    public static Logger configureProjectLogger(String projectName, String logStoragePath) {
        File logDir = new File(logStoragePath);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        String logFileName = String.format("%s.%s", projectName, "log");
        String logFilePath = String.valueOf(logStoragePath) + File.separator + logFileName;
        String filePattern = String.valueOf(logStoragePath) + File.separator + projectName + "-%d{yyyy-MM-dd}." + "log";
        return LogConfigurationUtil.configureRollingFileLogger(projectName, logFilePath, filePattern, 0x3200000L, 5, Level.INFO, "%d{yyyy-MM-dd HH:mm:ss.SSS} %-5level %logger{36} - %msg%n");
    }

    public static Logger configureIDELogger(String loggerName, String workspacePath) {
        String logDir = String.valueOf(workspacePath) + File.separator + ".metadata";
        File logDirFile = new File(logDir);
        if (!logDirFile.exists()) {
            logDirFile.mkdirs();
        }
        String logFileName = String.format(".%s.%s", loggerName, "log");
        String logFilePath = String.valueOf(logDir) + File.separator + logFileName;
        String filePattern = String.valueOf(logDir) + File.separator + logFileName + "-%d{yyyy-MM-dd}." + "log";
        String logConfigFilePath = String.valueOf(logDir) + File.separator + "log4j.xml";
        File logConfigFile = new File(logConfigFilePath);
        if (!logConfigFile.exists()) {
            LogConfigurationUtil.generateLog4jXml(logConfigFilePath, loggerName, logFilePath, filePattern);
        }
        System.setProperty("log4j.configurationFile", logConfigFile.toURI().toString());
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.reconfigure();
        return context.getLogger(loggerName);
    }

    private static void generateLog4jXml(String filePath, String loggerName, String logFilePath, String filePattern) {
        String normalizedLogFilePath = logFilePath.replace('\\', '/');
        String normalizedFilePattern = filePattern.replace('\\', '/');
        String xmlContent = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Configuration status=\"WARN\">\n    <Appenders>\n        <RollingFile name=\"RollingFile\" fileName=\"%s\" filePattern=\"%s\">\n            <PatternLayout pattern=\"%s\"/>\n            <Policies>\n                <TimeBasedTriggeringPolicy interval=\"%s\" modulate=\"%s\" />\n                <SizeBasedTriggeringPolicy size=\"%s\"/>\n            </Policies>\n        </RollingFile>\n    </Appenders>\n    <Loggers>\n        <Logger name=\"%s\" level=\"info\" additivity=\"false\">\n            <AppenderRef ref=\"RollingFile\"/>\n        </Logger>\n        <Root level=\"all\">\n            <AppenderRef ref=\"RollingFile\"/>\n        </Root>\n    </Loggers>\n</Configuration>", normalizedLogFilePath, normalizedFilePattern, "%d{yyyy-MM-dd HH:mm:ss.SSS} [%-5level] %C{1}:%L - %msg%n", 1, "true", "50MB", loggerName);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileWriter writer = new FileWriter(filePath);){
                writer.write(xmlContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Logger configureRollingFileLogger(String loggerName, String logFilePath, String filePattern, long maxFileSize, int maxBackupIndex, Level level, String layoutPattern) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withPattern(layoutPattern).withConfiguration(config).build();
        ArrayList<Object> policies = new ArrayList<Object>();
        TimeBasedTriggeringPolicy timePolicy = TimeBasedTriggeringPolicy.newBuilder().withInterval(1).withModulate(true).build();
        policies.add(timePolicy);
        SizeBasedTriggeringPolicy sizePolicy = SizeBasedTriggeringPolicy.createPolicy((String)"50MB");
        policies.add(sizePolicy);
        CompositeTriggeringPolicy compositeTriggeringPolicy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])policies.toArray(new TriggeringPolicy[0]));
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("RollingFile-" + loggerName)).withFileName(logFilePath).withFilePattern(filePattern).withLayout((Layout)layout)).withPolicy((TriggeringPolicy)compositeTriggeringPolicy).withAppend(true).withConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (loggerConfig.getName().equals(loggerName)) {
            loggerConfig.addAppender((Appender)appender, level, null);
        } else {
            loggerConfig = new LoggerConfig(loggerName, level, false);
            loggerConfig.addAppender((Appender)appender, level, null);
            config.addLogger(loggerName, loggerConfig);
        }
        context.updateLoggers();
        return context.getLogger(loggerName);
    }

    public static String ensureLogDirectory(String basePath, String ... folderPath) {
        StringBuilder pathBuilder = new StringBuilder(basePath);
        String[] stringArray = folderPath;
        int n = folderPath.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            pathBuilder.append(File.separator).append(folder);
            ++n2;
        }
        String fullPath = pathBuilder.toString();
        File directory = new File(fullPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return fullPath;
    }

    public static Logger configureConsoleLogger(String loggerName, Level level) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n").withConfiguration(config).build();
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)level, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        ConsoleAppender appender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("Console-" + loggerName)).withLayout((Layout)layout)).withFilter((Filter)filter)).build();
        appender.start();
        config.addAppender((Appender)appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (loggerConfig.getName().equals(loggerName)) {
            loggerConfig.addAppender((Appender)appender, level, null);
        } else {
            loggerConfig = new LoggerConfig(loggerName, level, false);
            loggerConfig.addAppender((Appender)appender, level, null);
            config.addLogger(loggerName, loggerConfig);
        }
        context.updateLoggers();
        return context.getLogger(loggerName);
    }

    public static void setLogLevel(String loggerName, Level level) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
        if (loggerConfig.getName().equals(loggerName)) {
            loggerConfig.setLevel(level);
            context.updateLoggers();
        }
    }
}

