/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.log;

import com.gigadevice.log.DataInfo;
import com.gigadevice.log.UncaughtExceptionLogger;
import com.gigadevice.log.WorkbenchListener;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogConfig {
    private static String RootDir;
    private static String xmlPath;
    private static final Logger logger;
    private static String SoftWarePath;
    private static String InfoLogPath;
    private static String ErrorLogPath;
    private static String ProjectName;
    private static boolean isAddProject;
    private static boolean isProject;
    private static boolean isWorkBenchListener;
    private static boolean isLog;
    private static boolean isXmlCorrect;

    static {
        xmlPath = "";
        logger = LogManager.getLogger(LogConfig.class);
        SoftWarePath = "";
        InfoLogPath = "";
        ErrorLogPath = "";
        ProjectName = "";
        isAddProject = false;
        isProject = false;
        isWorkBenchListener = false;
        isLog = true;
        isXmlCorrect = false;
    }

    private static void setWorkbenchListener() {
        UncaughtExceptionLogger.registerExceptionHandler();
        IWorkbench workbench = PlatformUI.getWorkbench();
        WorkbenchListener listener = new WorkbenchListener();
        workbench.addWorkbenchListener((IWorkbenchListener)listener);
        LogConfig.setXmlPath();
        isWorkBenchListener = true;
    }

    public static boolean isWindows() {
        String TargetOSName = System.getProperty("os.name");
        return (TargetOSName = TargetOSName.toLowerCase()).startsWith("win");
    }

    public static void setXmlPath(String XmlPath) {
        xmlPath = XmlPath;
        isXmlCorrect = true;
    }

    private static void setXmlPath() {
        try {
            if (xmlPath == "") {
                Location myLocation = Platform.getInstallLocation();
                if (myLocation != null && myLocation.isSet()) {
                    File xmlFile;
                    SoftWarePath = myLocation.getURL().getPath();
                    if (SoftWarePath.startsWith("/") && LogConfig.isWindows()) {
                        SoftWarePath = SoftWarePath.substring(1, SoftWarePath.length());
                    }
                    if (!(xmlFile = new File(xmlPath = String.valueOf(SoftWarePath) + "log4j2.xml")).exists()) {
                        JOptionPane.showMessageDialog(null, String.valueOf(xmlPath) + " File does not exist", "Tip", 0);
                        logger.error(String.valueOf(xmlPath) + " File does not exist");
                        isXmlCorrect = false;
                        return;
                    }
                    isXmlCorrect = true;
                } else {
                    logger.error("Obtaining the xml file fails!");
                }
            }
        }
        catch (Throwable e) {
            LogConfig.logThrowableWithMessage("Obtaining the xml file fails!", e);
        }
    }

    public static void setLogFormat(String ProjectPath) {
        try {
            if (!isLog) {
                return;
            }
            if (isAddProject) {
                isAddProject = false;
                return;
            }
            if (!isWorkBenchListener) {
                LogConfig.setWorkbenchListener();
            }
            if (!isXmlCorrect) {
                return;
            }
            if (ProjectPath.equals("") || ProjectPath == null) {
                RootDir = SoftWarePath;
                isProject = false;
            } else {
                RootDir = ProjectPath;
                isProject = true;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date date = new Date();
            String currentDate = simpleDateFormat.format(date);
            LogConfig.modifyName(currentDate);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            File xmlFile = new File(xmlPath);
            context.setConfigLocation(xmlFile.toURI());
        }
        catch (Throwable e) {
            LogConfig.logThrowable(e);
        }
    }

    private static void modifyName(String currentDate) {
        try {
            Attr fileNameAttr;
            Element RolloverStrategyElement;
            int i;
            String InfoLogName;
            String ErrorLogName;
            String InfoLogRootPath;
            String ErrorLogRootPath;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(xmlPath));
            NodeList propertyElements = document.getElementsByTagName("property");
            NodeList RolloverStrategyElements = document.getElementsByTagName("DefaultRolloverStrategy");
            NodeList RefElements = document.getElementsByTagName("appender-ref");
            int count = RefElements.getLength();
            RootDir = RootDir.replace("\\", "/");
            if (isProject) {
                ErrorLogRootPath = String.valueOf(RootDir) + "/logs/error";
                InfoLogRootPath = String.valueOf(RootDir) + "/logs/info";
                ErrorLogName = String.valueOf(currentDate) + "_Error";
                InfoLogName = String.valueOf(currentDate) + "_Info";
                if (count == 1) {
                    Node node = RefElements.item(0);
                    Node node2 = node.cloneNode(false);
                    node2.getAttributes().getNamedItem("ref").setNodeValue("RollingFileError");
                    node.getParentNode().appendChild(node2);
                }
                i = 0;
                while (i < RolloverStrategyElements.getLength()) {
                    RolloverStrategyElement = (Element)RolloverStrategyElements.item(i);
                    fileNameAttr = RolloverStrategyElement.getAttributeNode("max");
                    fileNameAttr.setValue("5");
                    ++i;
                }
            } else {
                ErrorLogRootPath = RootDir;
                InfoLogRootPath = RootDir;
                ErrorLogName = "";
                InfoLogName = "";
                if (count == 2) {
                    i = 0;
                    while (i < count) {
                        Node node = RefElements.item(i);
                        Element element = (Element)node;
                        String name = element.getAttributeNode("ref").getValue();
                        if (name.equals("RollingFileError")) {
                            node.getParentNode().removeChild(node);
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < RolloverStrategyElements.getLength()) {
                    RolloverStrategyElement = (Element)RolloverStrategyElements.item(i);
                    fileNameAttr = RolloverStrategyElement.getAttributeNode("max");
                    fileNameAttr.setValue("1");
                    ++i;
                }
            }
            ErrorLogPath = String.valueOf(ErrorLogRootPath) + "/" + ErrorLogName + ".log";
            InfoLogPath = String.valueOf(InfoLogRootPath) + "/" + InfoLogName + ".log";
            i = 0;
            while (i < propertyElements.getLength()) {
                Element propertyElement = (Element)propertyElements.item(i);
                String name = propertyElement.getAttributeNode("name").getValue();
                if (name.equals("ERROR_LOG_HOME")) {
                    propertyElement.setTextContent(ErrorLogRootPath);
                } else if (name.equals("INFO_LOG_HOME")) {
                    propertyElement.setTextContent(InfoLogRootPath);
                } else if (name.equals("ERROR_FILE_NAME")) {
                    propertyElement.setTextContent(ErrorLogName);
                } else if (name.equals("INFO_FILE_NAME")) {
                    propertyElement.setTextContent(InfoLogName);
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(xmlPath));
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            LogConfig.logThrowable(e);
        }
    }

    private static void modifyName1(String currentDate) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(xmlPath));
            NodeList rollingFileElements = document.getElementsByTagName("RollingFile");
            NodeList RefElements = document.getElementsByTagName("appender-ref");
            int count = RefElements.getLength();
            if (isProject) {
                ErrorLogPath = String.valueOf(RootDir) + "/logs/error/" + currentDate + "_Error.txt";
                InfoLogPath = String.valueOf(RootDir) + "/logs/info/" + currentDate + "_Info.txt";
                if (count == 1) {
                    Node node = RefElements.item(0);
                    Node node2 = node.cloneNode(false);
                    node2.getAttributes().getNamedItem("ref").setNodeValue("RollingFileError");
                    node.getParentNode().appendChild(node2);
                }
            } else {
                ErrorLogPath = String.valueOf(RootDir) + "/.log";
                InfoLogPath = String.valueOf(RootDir) + "/.log";
                if (count == 2) {
                    int i = 0;
                    while (i < count) {
                        Node node = RefElements.item(i);
                        Element element = (Element)node;
                        String name = element.getAttributeNode("ref").getValue();
                        if (name.equals("RollingFileError")) {
                            node.getParentNode().removeChild(node);
                        }
                        ++i;
                    }
                }
            }
            ErrorLogPath = ErrorLogPath.replace("\\", "/");
            InfoLogPath = InfoLogPath.replace("\\", "/");
            int i = 0;
            while (i < rollingFileElements.getLength()) {
                Attr filePatternAttr;
                Attr fileNameAttr;
                Element rollingFileElement = (Element)rollingFileElements.item(i);
                String name = rollingFileElement.getAttributeNode("name").getValue();
                if (name.equals("RollingFileError")) {
                    fileNameAttr = rollingFileElement.getAttributeNode("fileName");
                    fileNameAttr.setValue(ErrorLogPath);
                    filePatternAttr = rollingFileElement.getAttributeNode("filePattern");
                    filePatternAttr.setValue(ErrorLogPath);
                } else if (name.equals("RollingFileInfo")) {
                    fileNameAttr = rollingFileElement.getAttributeNode("fileName");
                    fileNameAttr.setValue(InfoLogPath);
                    filePatternAttr = rollingFileElement.getAttributeNode("filePattern");
                    filePatternAttr.setValue(InfoLogPath);
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(xmlPath));
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            LogConfig.logThrowable(e);
        }
    }

    public static void logThrowable(Throwable throwable) {
        throwable.printStackTrace();
        if (isLog) {
            if (throwable instanceof Error) {
                logger.fatal("", throwable);
            } else {
                logger.error("", throwable);
            }
        }
    }

    public static void logException(Exception exception) {
        exception.printStackTrace();
        if (isLog) {
            logger.error("", (Throwable)exception);
        }
    }

    public static void logExceptionWithMessage(Exception e) {
        e.printStackTrace();
        if (isLog) {
            String message = DataInfo.getMessage();
            logger.error(message, (Throwable)e);
        }
    }

    public static void logExceptionWithMessage(String message, Exception e) {
        e.printStackTrace();
        if (isLog) {
            logger.error(message, (Throwable)e);
        }
    }

    public static void logThrowableWithMessage(String message, Throwable e) {
        e.printStackTrace();
        if (isLog) {
            if (e instanceof Error) {
                logger.fatal(message, e);
            } else {
                logger.error(message, e);
            }
        }
    }

    public static void logThrowableWithDetectInfo(Throwable throwable) {
        throwable.printStackTrace();
        if (isLog) {
            String DetectInfo = "";
            if (DataInfo.isDetect()) {
                DetectInfo = DataInfo.getDetectInfo();
            }
            if (throwable instanceof Error) {
                logger.fatal(DetectInfo, throwable);
            } else {
                logger.error(DetectInfo, throwable);
            }
        }
    }

    public static void logExceptionWithDetectInfo(Exception e) {
        e.printStackTrace();
        if (isLog) {
            String DetectInfo = "";
            if (DataInfo.isDetect()) {
                DetectInfo = DataInfo.getDetectInfo();
            }
            logger.error(DetectInfo, (Throwable)e);
        }
    }

    public static void logDectionInfo() {
        String DetectInfo;
        if (DataInfo.isDetect() && isLog && !(DetectInfo = DataInfo.getDetectInfo()).equals("")) {
            DetectInfo = "Complete current detect: " + System.getProperty("line.separator") + DetectInfo;
            logger.info(DetectInfo);
        }
    }

    public static void logMessage(String Message) {
        DataInfo.setMessage(Message);
        if (isLog) {
            logger.info(Message);
        }
    }

    public static void logMessageWithLevel(int level, String Message) {
        DataInfo.setMessage(Message);
        if (isLog && level >= DataInfo.getLOWER_LEVEL()) {
            if (Message.contains("Start testing")) {
                DataInfo.setCaseIndex(0);
            }
            if (Message.contains("Test over")) {
                DataInfo.initialize();
                File ErrorFile = new File(ErrorLogPath);
                if (ErrorFile.exists()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
                    Date date = new Date();
                    String currentDate = simpleDateFormat.format(date);
                    try {
                        if (ErrorFile.length() == 0L) {
                            FileWriter writerInfo = new FileWriter(ErrorFile, true);
                            writerInfo.write("[" + currentDate + "] " + "No software exception occurred in this test!\n");
                            writerInfo.close();
                        }
                    }
                    catch (Throwable e) {
                        LogConfig.logThrowableWithMessage("Write to " + ErrorLogPath + " fails!", e);
                    }
                }
            }
            if (!ProjectName.equals("")) {
                Message = "[" + ProjectName + " Project]  " + Message;
            }
            logger.info(String.valueOf(Message) + System.getProperty("line.separator"));
        }
    }

    public static void setProjectName(String projectName) {
        ProjectName = projectName;
    }

    public static boolean isLog() {
        return isLog;
    }

    public static void setIsLogOpen(boolean isLog) {
        LogConfig.isLog = isLog;
    }

    public static void setAddProject(boolean isAddProject) {
        LogConfig.isAddProject = isAddProject;
    }

    public static String getXmlPath() {
        return xmlPath;
    }

    public static String getInfoLogPath() {
        return InfoLogPath;
    }

    public static String getErrorLogPath() {
        return ErrorLogPath;
    }

    public static void setProjectDir(String ProjectDir) {
        RootDir = ProjectDir;
    }
}

