/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.customui.gdui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;

public class GDEditComboBox<T>
extends JComboBox<T> {
    private List<T> originalItems;
    private boolean filtering = false;
    private T lastValidSelection;
    private boolean suppressEvents = false;
    private boolean navigating = false;
    private boolean userEditing = false;
    private boolean filtered = false;

    public GDEditComboBox() {
        this.initializeComponent();
    }

    public GDEditComboBox(T[] items) {
        super(items);
        this.initializeComponent();
    }

    public GDEditComboBox(Vector<T> items) {
        super(items);
        this.initializeComponent();
    }

    public GDEditComboBox(ComboBoxModel<T> model) {
        super(model);
        this.initializeComponent();
    }

    private void initializeComponent() {
        this.setEditable(true);
        this.saveOriginalItems();
        this.lastValidSelection = this.getSelectedItem();
        this.setEditor(new FilterComboBoxEditor());
        this.setupDocumentListener();
        this.setupKeyListener();
        this.setupSelectionListener();
    }

    private void saveOriginalItems() {
        this.originalItems = new ArrayList<T>();
        ComboBoxModel model = this.getModel();
        int i = 0;
        while (i < model.getSize()) {
            this.originalItems.add(model.getElementAt(i));
            ++i;
        }
    }

    private void setupDocumentListener() {
        JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        textComponent.getDocument().addDocumentListener(new DocumentListener(){

            private void doFilterIfNeeded() {
                if (!GDEditComboBox.this.filtering && !GDEditComboBox.this.suppressEvents && GDEditComboBox.this.userEditing) {
                    SwingUtilities.invokeLater(() -> GDEditComboBox.this.filterItems());
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doFilterIfNeeded();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doFilterIfNeeded();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void setupKeyListener() {
        JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        textComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!e.isControlDown() && GDEditComboBox.this.isPrintableChar(e.getKeyChar())) {
                    GDEditComboBox.this.userEditing = true;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 8: 
                    case 127: {
                        GDEditComboBox.this.userEditing = true;
                        break;
                    }
                    case 40: {
                        if (!GDEditComboBox.this.isPopupVisible()) {
                            if (GDEditComboBox.this.filtered && !GDEditComboBox.this.userEditing) {
                                GDEditComboBox.this.restoreOriginalModel();
                            }
                            GDEditComboBox.this.showPopup();
                        } else {
                            GDEditComboBox.this.navigateDown();
                        }
                        e.consume();
                        return;
                    }
                    case 38: {
                        if (GDEditComboBox.this.isPopupVisible()) {
                            GDEditComboBox.this.navigateUp();
                        }
                        e.consume();
                        return;
                    }
                    case 10: {
                        if (GDEditComboBox.this.isPopupVisible() && GDEditComboBox.this.getSelectedIndex() >= 0) {
                            GDEditComboBox.this.confirmSelection();
                        } else {
                            GDEditComboBox.this.restoreLastValidSelection();
                        }
                        e.consume();
                        return;
                    }
                    case 27: {
                        GDEditComboBox.this.hidePopup();
                        GDEditComboBox.this.restoreLastValidSelection();
                        e.consume();
                        return;
                    }
                    case 9: {
                        if (GDEditComboBox.this.isPopupVisible() && GDEditComboBox.this.getSelectedIndex() >= 0) {
                            GDEditComboBox.this.confirmSelection();
                        } else {
                            GDEditComboBox.this.restoreLastValidSelection();
                        }
                        return;
                    }
                }
            }
        });
        textComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GDEditComboBox.this.userEditing = false;
                if (GDEditComboBox.this.filtered) {
                    GDEditComboBox.this.restoreLastValidSelection();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                GDEditComboBox.this.userEditing = false;
            }
        });
    }

    private void setupSelectionListener() {
        this.addActionListener(e -> {
            Object selectedItem;
            if (!this.suppressEvents && !this.filtering && !this.navigating && (selectedItem = this.getSelectedItem()) != null && this.originalItems.contains(selectedItem)) {
                this.lastValidSelection = selectedItem;
                if (this.isPopupVisible()) {
                    SwingUtilities.invokeLater(() -> this.confirmSelectionFromPopup());
                }
            }
        });
    }

    private void navigateDown() {
        int itemCount;
        this.navigating = true;
        int currentIndex = this.getSelectedIndex();
        if (currentIndex < (itemCount = this.getItemCount()) - 1) {
            this.setSelectedIndex(currentIndex + 1);
        }
        this.navigating = false;
    }

    private void navigateUp() {
        this.navigating = true;
        int currentIndex = this.getSelectedIndex();
        if (currentIndex > 0) {
            this.setSelectedIndex(currentIndex - 1);
        }
        this.navigating = false;
    }

    private void showFullList() {
        this.suppressEvents = true;
        this.filtering = true;
        this.userEditing = false;
        DefaultComboBoxModel<T> model = new DefaultComboBoxModel<T>();
        for (T item : this.originalItems) {
            model.addElement(item);
        }
        this.setModel(model);
        if (this.lastValidSelection != null) {
            this.setSelectedItem(this.lastValidSelection);
        }
        this.filtering = false;
        this.suppressEvents = false;
        this.showPopup();
    }

    private void confirmSelection() {
        if (this.getSelectedIndex() >= 0) {
            Object selectedItem = this.getItemAt(this.getSelectedIndex());
            this.lastValidSelection = selectedItem;
            this.userEditing = false;
            this.suppressEvents = true;
            JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
            textComponent.setText(selectedItem.toString());
            this.suppressEvents = false;
            this.hidePopup();
            if (this.filtered) {
                this.restoreOriginalModel();
                this.setSelectedItem(selectedItem);
            }
            this.fireActionEvent();
        }
    }

    private void confirmSelectionFromPopup() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            this.lastValidSelection = selectedItem;
            this.userEditing = false;
            this.suppressEvents = true;
            this.filtering = true;
            JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
            textComponent.setText(selectedItem.toString());
            this.filtering = false;
            this.suppressEvents = false;
            this.hidePopup();
            if (this.filtered) {
                this.restoreOriginalModel();
                this.setSelectedItem(selectedItem);
            }
        }
    }

    private void restoreLastValidSelection() {
        if (this.lastValidSelection != null) {
            this.userEditing = false;
            if (this.filtered) {
                this.restoreOriginalModel();
            }
            this.suppressEvents = true;
            this.setSelectedItem(this.lastValidSelection);
            JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
            textComponent.setText(this.lastValidSelection.toString());
            this.suppressEvents = false;
            this.hidePopup();
        }
    }

    private void filterItems() {
        String key;
        if (!this.userEditing) {
            return;
        }
        this.filtering = true;
        DefaultComboBoxModel<T> model = new DefaultComboBoxModel<T>();
        JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        String filterText = textComponent.getText();
        String string = key = filterText == null ? "" : filterText.trim().toLowerCase();
        if (key.isEmpty()) {
            for (T item : this.originalItems) {
                model.addElement(item);
            }
            this.setModel(model);
            this.filtered = false;
        } else {
            for (T item : this.originalItems) {
                if (item == null || !item.toString().toLowerCase().contains(key)) continue;
                model.addElement(item);
            }
            this.setModel(model);
            this.filtered = true;
        }
        if (this.getItemCount() > 0) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
        this.filtering = false;
    }

    public void setItems(T[] items) {
        this.filtering = true;
        this.removeAllItems();
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            this.addItem(item);
            ++n2;
        }
        this.saveOriginalItems();
        this.filtering = false;
    }

    public void setItems(List<T> items) {
        this.filtering = true;
        this.removeAllItems();
        for (T item : items) {
            this.addItem(item);
        }
        this.saveOriginalItems();
        this.filtering = false;
    }

    @Override
    public void addItem(T item) {
        super.addItem(item);
        if (this.originalItems != null && !this.filtering) {
            this.originalItems.add(item);
        }
    }

    @Override
    public void removeItem(Object item) {
        super.removeItem(item);
        if (this.originalItems != null && !this.filtering) {
            this.originalItems.remove(item);
        }
    }

    @Override
    public void removeAllItems() {
        super.removeAllItems();
        if (this.originalItems != null && !this.filtering) {
            this.originalItems.clear();
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.navigating) {
            this.getModel().setSelectedItem(anObject);
            return;
        }
        super.setSelectedItem(anObject);
        if (!this.suppressEvents && !this.filtering && anObject != null && this.originalItems != null && this.originalItems.contains(anObject)) {
            this.lastValidSelection = anObject;
        }
    }

    public T getLastValidSelection() {
        return this.lastValidSelection;
    }

    public void setLastValidSelection(T item) {
        if (this.originalItems != null && this.originalItems.contains(item)) {
            this.lastValidSelection = item;
            this.suppressEvents = true;
            this.setSelectedItem(item);
            JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
            textComponent.setText(item != null ? item.toString() : "");
            this.suppressEvents = false;
        }
    }

    public String getInputText() {
        JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        return textComponent.getText();
    }

    public void setInputText(String text) {
        this.suppressEvents = true;
        this.userEditing = false;
        JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        textComponent.setText(text);
        this.suppressEvents = false;
    }

    private boolean isPrintableChar(char c) {
        return c >= ' ' && c < '\u007f';
    }

    private void restoreOriginalModel() {
        if (this.originalItems == null) {
            return;
        }
        this.suppressEvents = true;
        this.filtering = true;
        DefaultComboBoxModel<T> model = new DefaultComboBoxModel<T>();
        for (T item : this.originalItems) {
            model.addElement(item);
        }
        this.setModel(model);
        if (this.lastValidSelection != null && this.originalItems.contains(this.lastValidSelection)) {
            super.setSelectedItem(this.lastValidSelection);
        }
        this.filtering = false;
        this.suppressEvents = false;
        this.filtered = false;
    }

    private class FilterComboBoxEditor
    extends BasicComboBoxEditor {
        private FilterComboBoxEditor() {
        }

        @Override
        public void setItem(Object anObject) {
            if (!(GDEditComboBox.this.filtering || GDEditComboBox.this.navigating || GDEditComboBox.this.suppressEvents)) {
                super.setItem(anObject);
            }
        }
    }
}

