/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.ui;

import com.gigadevice.templates.core.TreeContentProvider;
import com.gigadevice.templates.core.TreeLabelProvider;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.mcuxmlinfo.McuGroup;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.xml.sax.SAXException;

public class WizardPageTargetSettings
extends MBSCustomPage
implements IWizardDataPage {
    private String pageTitle;
    private String pageDescription;
    private String templateType;
    private Composite pageControl;
    private Text flashSize;
    private Text ramSize;
    private Label FPU;
    private Button checkFPU;
    private Combo codeLocation;
    private Button checkSomeWarnings;
    private Button checkMostWarnings;
    private Button enableWerror;
    private Button useOg;
    private Button useNano;
    private Button excludeUnused;
    private Button useLinkOpt;
    private TreeViewer treeviewer;
    private boolean pageComplete = false;
    private IWizardPage next;
    private IWizardPage prev;
    private String chipPartNo;
    private String chipGroupName = "";
    private String cpucore;
    private String svdFileName;
    private String estack;
    private String projectFolder;
    private String srcFolder = "";
    private String excludeFileAndFolder = "";
    private String LdFiles = "";
    private String Startups = "";
    private String Openocds = "";
    public static MCUs mcu;
    private String ldramSize;
    ldsDefault ldsInfo = new ldsDefault();

    public WizardPageTargetSettings() {
        super("com.gigadevice.templates.target.ui.WizardPageTargetSettings");
        this.setTitle("Target processor settings");
        this.setDescription("Select the target processor family and define flash and RAM sizes.");
        this.pageID = "Target processor settings";
    }

    public WizardPageTargetSettings(String temp) {
        super("com.gigadevice.templates.target.ui.WizardPageTargetSettings");
        this.setTitle("Target processor settings");
        this.setDescription("Select the target processor family and define flash and RAM sizes.");
        this.templateType = temp;
    }

    public WizardPageTargetSettings(IWizardPage prev) {
        super("com.gigadevice.templates.target.ui.WizardPageTargetSettings");
        this.setTitle("Target processor settings");
        this.setDescription("Select the target processor family and define flash and RAM sizes.");
        this.prev = prev;
    }

    protected boolean isCustomPageComplete() {
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION", "never");
        return this.pageComplete;
    }

    public boolean isPageComplete() {
        return this.pageComplete;
    }

    public static String analyseSrcFolder() {
        McuSubGroup mcusubgroup = (McuSubGroup)mcu.getParent();
        String MCUSrcFolder = mcu.getSrcFolder();
        if (MCUSrcFolder.length() > 0) {
            return MCUSrcFolder.trim();
        }
        String SubGroupSrcFolder = mcusubgroup.getSrcFolder();
        if (SubGroupSrcFolder.length() > 0) {
            return SubGroupSrcFolder.trim();
        }
        return "";
    }

    public static String analyseExcludeFileAndFolder() {
        McuSubGroup mcusubgroup = (McuSubGroup)mcu.getParent();
        String MCUExcludeFileAndFolder = mcu.getExcludeFileAndFolder();
        if (MCUExcludeFileAndFolder.length() > 0) {
            return MCUExcludeFileAndFolder.trim();
        }
        String SubGroupMCUExcludeFileAndFolder = mcusubgroup.getExcludeFileAndFolder();
        if (SubGroupMCUExcludeFileAndFolder.length() > 0) {
            return SubGroupMCUExcludeFileAndFolder.trim();
        }
        return "";
    }

    public String getName() {
        String a = "Target processor settings";
        return a;
    }

    public static MCUs getSelMcu() {
        return mcu;
    }

    public void createControl(Composite parent) {
        this.pageControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageControl.setLayout((Layout)layout);
        this.pageControl.setLayoutData((Object)new GridData(768));
        try {
            this.createGui(this.pageControl);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private void createGui(Composite parent) throws ParserConfigurationException, SAXException, IOException {
        Composite treeComposite = new Composite(parent, 0);
        this.treeviewer = new TreeViewer(treeComposite, 2052);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 200;
        gridData.horizontalSpan = 2;
        treeComposite.setLayoutData((Object)gridData);
        Tree treev = this.treeviewer.getTree();
        treev.setHeaderVisible(true);
        treev.setLinesVisible(true);
        TreeColumnLayout layout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)layout);
        TreeColumn nameColumn = new TreeColumn(treev, 0);
        nameColumn.setText("Device");
        layout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnPixelData(200));
        TreeColumn descriptionColumn = new TreeColumn(treev, 0);
        descriptionColumn.setAlignment(16384);
        descriptionColumn.setText("Description");
        layout.setColumnData((Widget)descriptionColumn, (ColumnLayoutData)new ColumnPixelData(400));
        this.treeviewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        String mcuType = "mcu_" + this.templateType;
        this.treeviewer.setInput((Object)McuFactory.getMcuTree((String)mcuType));
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection() != null) {
                    IStructuredSelection is = (IStructuredSelection)e.getSelection();
                    if (is.getFirstElement().getClass().toString().equals("class com.gigadevice.venustool.mcuxmlinfo.MCUs")) {
                        mcu = (MCUs)is.getFirstElement();
                        WizardPageTargetSettings.this.LdFiles = ProjectUtils.ArrayListToString((ArrayList)McuFactory.getFileParaList((String)"ld", (MCUs)mcu));
                        WizardPageTargetSettings.this.Startups = ProjectUtils.ArrayListToString((ArrayList)McuFactory.getFileParaList((String)"startup", (MCUs)mcu));
                        WizardPageTargetSettings.this.Openocds = ProjectUtils.ArrayListToString((ArrayList)McuFactory.getFileParaList((String)"openocd", (MCUs)mcu));
                        WizardPageTargetSettings.this.flashSize.setText(mcu.getFlashSize());
                        WizardPageTargetSettings.this.ramSize.setText(mcu.getRamSize());
                        WizardPageTargetSettings.this.ldramSize = mcu.getldRamSize();
                        WizardPageTargetSettings.this.codeLocation.setEnabled(true);
                        WizardPageTargetSettings.this.codeLocation.select(0);
                        WizardPageTargetSettings.this.pageComplete = true;
                        WizardPageTargetSettings.this.getWizard().getContainer().updateButtons();
                        WizardPageTargetSettings.this.chipPartNo = mcu.getName();
                        McuSubGroup subgroup = (McuSubGroup)mcu.getParent();
                        McuGroup mcugroup = (McuGroup)subgroup.getParent();
                        WizardPageTargetSettings.this.chipGroupName = mcugroup.getName().toLowerCase();
                        WizardPageTargetSettings.this.cpucore = subgroup.getCPUCore();
                        WizardPageTargetSettings.this.svdFileName = mcu.getSVD();
                        WizardPageTargetSettings.this.projectFolder = mcu.getProjectFolder();
                        WizardPageTargetSettings.this.srcFolder = WizardPageTargetSettings.analyseSrcFolder();
                        WizardPageTargetSettings.this.excludeFileAndFolder = WizardPageTargetSettings.analyseExcludeFileAndFolder();
                        if (WizardPageTargetSettings.this.cpucore.equals("cortex-m33") || WizardPageTargetSettings.this.cpucore.equals("cortex-m4")) {
                            WizardPageTargetSettings.this.checkFPU.setSelection(true);
                            WizardPageTargetSettings.this.checkFPU.setEnabled(true);
                            WizardPageTargetSettings.this.codeLocation.setEnabled(true);
                        } else {
                            WizardPageTargetSettings.this.checkFPU.setSelection(false);
                            WizardPageTargetSettings.this.checkFPU.setEnabled(false);
                        }
                    } else {
                        WizardPageTargetSettings.this.flashSize.setText("");
                        WizardPageTargetSettings.this.ramSize.setText("");
                        WizardPageTargetSettings.this.codeLocation.deselectAll();
                        WizardPageTargetSettings.this.codeLocation.setEnabled(false);
                        WizardPageTargetSettings.this.checkFPU.setSelection(false);
                        WizardPageTargetSettings.this.checkFPU.setEnabled(false);
                        WizardPageTargetSettings.this.pageComplete = false;
                        WizardPageTargetSettings.this.getWizard().getContainer().updateButtons();
                    }
                }
            }
        });
        Composite Composite2 = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout(2, false);
        layout1.verticalSpacing = 20;
        Composite2.setLayout((Layout)layout1);
        GridData gridDataLab = new GridData();
        gridDataLab.widthHint = 140;
        GridData gridDataTex = new GridData();
        gridDataTex.widthHint = 430;
        gridDataTex.heightHint = 23;
        Label Flash = new Label(Composite2, 0);
        Flash.setLayoutData((Object)gridDataLab);
        Flash.setText("Flash size(kB)");
        this.flashSize = new Text(Composite2, 2060);
        this.flashSize.setLayoutData((Object)gridDataTex);
        Label Ram = new Label(Composite2, 0);
        Ram.setLayoutData((Object)gridDataLab);
        Ram.setText("RAM size(kB)");
        this.ramSize = new Text(Composite2, 2060);
        this.ramSize.setLayoutData((Object)gridDataTex);
        Label codeLocation = new Label(Composite2, 0);
        codeLocation.setLayoutData((Object)gridDataLab);
        codeLocation.setText("Code location");
        this.codeLocation = new Combo(Composite2, 8);
        this.codeLocation.setLayoutData((Object)gridDataTex);
        this.codeLocation.setEnabled(false);
        this.codeLocation.add("FLASH");
        this.codeLocation.add("RAM");
        this.FPU = new Label(Composite2, 0);
        this.FPU.setLayoutData((Object)gridDataLab);
        this.FPU.setText("Floating point unit");
        this.checkFPU = new Button(Composite2, 32);
        this.checkFPU.setLayoutData((Object)gridDataTex);
        this.checkFPU.setSelection(false);
        this.checkFPU.setEnabled(false);
        Label Checksomewarnings = new Label(Composite2, 0);
        Checksomewarnings.setLayoutData((Object)gridDataLab);
        Checksomewarnings.setText("Check some warnings");
        Checksomewarnings.setEnabled(false);
        this.checkSomeWarnings = new Button(Composite2, 32);
        this.checkSomeWarnings.setLayoutData((Object)gridDataTex);
        this.checkSomeWarnings.setSelection(false);
        this.checkSomeWarnings.setEnabled(false);
        Label Checkmostwarnings = new Label(Composite2, 0);
        Checkmostwarnings.setLayoutData((Object)gridDataLab);
        Checkmostwarnings.setText("Check most warnings");
        Checkmostwarnings.setEnabled(false);
        this.checkMostWarnings = new Button(Composite2, 32);
        this.checkMostWarnings.setLayoutData((Object)gridDataTex);
        this.checkMostWarnings.setSelection(false);
        this.checkMostWarnings.setEnabled(false);
        Label EnableW = new Label(Composite2, 0);
        EnableW.setLayoutData((Object)gridDataLab);
        EnableW.setText("Enable -Werror");
        EnableW.setEnabled(false);
        this.enableWerror = new Button(Composite2, 32);
        this.enableWerror.setLayoutData((Object)gridDataTex);
        this.enableWerror.setSelection(false);
        this.enableWerror.setEnabled(false);
        Label UseOg = new Label(Composite2, 0);
        UseOg.setLayoutData((Object)gridDataLab);
        UseOg.setText("Use -Og on debug");
        UseOg.setEnabled(false);
        this.useOg = new Button(Composite2, 32);
        this.useOg.setLayoutData((Object)gridDataTex);
        this.useOg.setSelection(true);
        this.useOg.setEnabled(false);
        Label UseNano = new Label(Composite2, 0);
        UseNano.setLayoutData((Object)gridDataLab);
        UseNano.setText("Use newlib nano");
        UseNano.setEnabled(false);
        this.useNano = new Button(Composite2, 32);
        this.useNano.setLayoutData((Object)gridDataTex);
        this.useNano.setSelection(true);
        this.useNano.setEnabled(false);
        Label ExcludeUnused = new Label(Composite2, 0);
        ExcludeUnused.setLayoutData((Object)gridDataLab);
        ExcludeUnused.setText("Exclude unused");
        ExcludeUnused.setEnabled(false);
        this.excludeUnused = new Button(Composite2, 32);
        this.excludeUnused.setLayoutData((Object)gridDataTex);
        this.excludeUnused.setSelection(true);
        this.excludeUnused.setEnabled(false);
        Label UseLinkOpt = new Label(Composite2, 0);
        UseLinkOpt.setLayoutData((Object)gridDataLab);
        UseLinkOpt.setText("Use link optimization");
        UseLinkOpt.setEnabled(false);
        this.useLinkOpt = new Button(Composite2, 32);
        this.useLinkOpt.setLayoutData((Object)gridDataTex);
        this.useLinkOpt.setSelection(false);
        this.useLinkOpt.setEnabled(false);
    }

    private String getEstack() {
        String flashOriginS = mcu.getRamAddress().substring(2);
        long flashOrigin = Integer.parseInt(flashOriginS, 16);
        long flashSize = Integer.parseInt(this.ramSize.getText(), 10) * 1024;
        this.estack = Long.toHexString(flashOrigin + flashSize);
        String estack = "0x" + this.estack;
        return estack;
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.pageControl;
    }

    public String getDescription() {
        return this.pageDescription;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        return this.pageTitle;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
        this.pageDescription = description;
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String title) {
        this.pageTitle = title;
    }

    public void setVisible(boolean visible) {
        this.pageControl.setVisible(visible);
    }

    public String getSelectedChipShort() {
        String chipPartNo = this.chipPartNo;
        String chipShortPartNo = chipPartNo.substring(0, 8);
        return chipShortPartNo;
    }

    public String getChipFlshAddress() {
        if (this.codeLocation.getText().equals("RAM")) {
            return this.ldsInfo.flashOrigin_riscv;
        }
        return mcu.getFlashAddress();
    }

    public String getChipRamAddress() {
        if (this.codeLocation.getText().equals("RAM")) {
            return this.ldsInfo.ramOrigin_riscv;
        }
        return mcu.getRamAddress();
    }

    public String getChipFlshSize() {
        if (this.codeLocation.getText().equals("RAM")) {
            return this.ldsInfo.flashLength_riscv;
        }
        return this.flashSize.getText();
    }

    public String getChipRamSize() {
        if (this.codeLocation.getText().equals("RAM")) {
            return this.ldsInfo.ramLength_riscv;
        }
        if (!this.ldramSize.equals("")) {
            return this.ldramSize;
        }
        return this.ramSize.getText();
    }

    public String getStackSize() {
        return this.ldsInfo.stackSize;
    }

    public String getSelectionCheckSomeWarnings() {
        return this.checkSomeWarnings.getSelection() ? "true" : "false";
    }

    public String getSelectionCheckMostWarnings() {
        return this.checkMostWarnings.getSelection() ? "true" : "false";
    }

    public String getSelectionEnableWerror() {
        return this.enableWerror.getSelection() ? "true" : "false";
    }

    public String getSelectionUseOg() {
        return this.useOg.getSelection() ? "true" : "false";
    }

    public String getSelectionUseNano() {
        return this.useNano.getSelection() ? "true" : "false";
    }

    public String getSelectionExcludeUnused() {
        return this.excludeUnused.getSelection() ? "true" : "false";
    }

    public String getSelectionUseLinkOpt() {
        return this.useLinkOpt.getSelection() ? "true" : "false";
    }

    public String getCodeLocation() {
        return this.codeLocation.getText();
    }

    public void getLdscriptsInfo() {
        String lable = null;
        if (this.templateType.equals("riscv")) {
            lable = this.chipPartNo.substring(10, 11);
        } else if (this.templateType.equals("arm")) {
            lable = this.chipPartNo.substring(9, 10);
        }
        if (lable == null) {
            return;
        }
        if (lable.equals("4")) {
            this.ldsInfo.flashOrigin_riscv = "0x20000000";
            this.ldsInfo.flashLength_riscv = "4";
            this.ldsInfo.ramOrigin_riscv = "0x20001000";
            this.ldsInfo.ramLength_riscv = "2";
            this.ldsInfo.stackSize = "1";
        } else if (lable.equals("6")) {
            this.ldsInfo.flashOrigin_riscv = "0x20000000";
            this.ldsInfo.flashLength_riscv = "7";
            this.ldsInfo.ramOrigin_riscv = "0x20001C00";
            this.ldsInfo.ramLength_riscv = "3";
            this.ldsInfo.stackSize = "1";
        } else if (lable.equals("8")) {
            this.ldsInfo.flashOrigin_riscv = "0x20000000";
            this.ldsInfo.flashLength_riscv = "15";
            this.ldsInfo.ramOrigin_riscv = "0x20003C00";
            this.ldsInfo.ramLength_riscv = "5";
            this.ldsInfo.stackSize = "2";
        } else if (lable.equals("B")) {
            this.ldsInfo.flashOrigin_riscv = "0x20000000";
            this.ldsInfo.flashLength_riscv = "24";
            this.ldsInfo.ramOrigin_riscv = "0x20006000";
            this.ldsInfo.ramLength_riscv = "8";
            this.ldsInfo.stackSize = "2";
        }
    }

    public void getProjectFolder() {
    }

    public Map<String, String> getPageData() {
        this.getLdscriptsInfo();
        HashMap<String, String> valMap = new HashMap<String, String>();
        valMap.put("chipPartNo", this.chipPartNo);
        valMap.put("chipShortPartNo", this.getSelectedChipShort());
        valMap.put("estack", this.getEstack());
        valMap.put("MinStackSize", this.getStackSize());
        valMap.put("flashOrigin", this.getChipFlshAddress());
        valMap.put("ramOrigin", this.getChipRamAddress());
        valMap.put("flashLength", this.getChipFlshSize());
        valMap.put("ramLength", this.getChipRamSize());
        valMap.put("checkFPU", this.checkFPU.getSelection() ? "true" : "false");
        valMap.put("checkSomeWarnings", this.getSelectionCheckSomeWarnings());
        valMap.put("checkMostWarnings", this.getSelectionCheckMostWarnings());
        valMap.put("enableWerror", this.getSelectionEnableWerror());
        valMap.put("useOg", this.getSelectionUseOg());
        valMap.put("useNano", this.getSelectionUseNano());
        valMap.put("excludeUnused", this.getSelectionExcludeUnused());
        valMap.put("useLinkOpt", this.getSelectionUseLinkOpt());
        valMap.put("chipGroupName", this.chipGroupName);
        valMap.put("codeLocation", this.getCodeLocation());
        valMap.put("MCUCore", this.cpucore);
        valMap.put("MCUSVDFileName", this.svdFileName);
        valMap.put("projectFolder", this.projectFolder);
        valMap.put("flashBaseInFlash", mcu.getFlashAddress());
        valMap.put("flashSizeInFlash", mcu.getFlashSize());
        valMap.put("ramBaseInFlash", mcu.getRamAddress());
        valMap.put("ramSizeInFlash", mcu.getRamSize());
        valMap.put("flashBaseInRam", this.ldsInfo.flashOrigin_riscv);
        valMap.put("flashSizeInRam", this.ldsInfo.flashLength_riscv);
        valMap.put("ramBaseInRam", this.ldsInfo.ramOrigin_riscv);
        valMap.put("ramSizeInRam", this.ldsInfo.ramLength_riscv);
        valMap.put("srcFolder", this.srcFolder);
        valMap.put("excludeFileAndFolder", this.excludeFileAndFolder);
        valMap.put("ldFile", this.LdFiles);
        valMap.put("cfg", this.Openocds);
        valMap.put("startup", this.Startups);
        return valMap;
    }

    public void setNextPage(IWizardPage arg0) {
        this.next = arg0;
    }

    public IWizardPage getNextPage() {
        return this.next;
    }

    public void setPreviousPage(IWizardPage arg0) {
        this.prev = arg0;
    }

    public IWizardPage getPreviousPage() {
        return this.prev;
    }

    class ldsDefault {
        private String flashOrigin_riscv = "0x20000000";
        private String flashLength_riscv = "4";
        private String ramOrigin_riscv = "0x20001000";
        private String ramLength_riscv = "2";
        private String stackSize = "1";

        ldsDefault() {
        }
    }
}

