/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.gdconfigui;

import com.gigadevice.gdconfig.ui.access.SerializeAccess_Template;
import com.gigadevice.gdconfig.ui.utils.ProjectConfigUtil;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.templates.target.gdconfigui.GDProjectCreateNamePage;
import com.gigadevice.templates.target.gdconfigui.GDProjectSelectorMCUPage;
import com.gigadevice.venustool.GlobalVariables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;

public class GDProjectWizard
extends Wizard
implements INewWizard {
    private GDProjectCreateNamePage createProjectNamePage;
    private GDProjectSelectorMCUPage page1;

    public GDProjectWizard() {
        this.setWindowTitle("NEW GD Project");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.createProjectNamePage = new GDProjectCreateNamePage();
        this.addPage((IWizardPage)this.createProjectNamePage);
        this.page1 = new GDProjectSelectorMCUPage();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        IEditorPart[] iEditParts = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditors();
        int i = 0;
        while (i < iEditParts.length) {
            String strEditorTitle = iEditParts[i].getTitle();
            if (strEditorTitle != null && strEditorTitle.contains(".gdc")) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(iEditParts[i], true);
            }
            ++i;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        String ProjectName = this.createProjectNamePage.getName();
        IProject project = root.getProject(this.createProjectNamePage.getName());
        if (!project.exists()) {
            try {
                project.create(null);
                project.open(null);
                String GdcFilePath = project.getLocation().toOSString();
                File GdcFile = new File(GdcFilePath, String.valueOf(ProjectName) + "." + "gdc");
                GdcFile.createNewFile();
                project.refreshLocal(2, null);
                GlobalVariables.McuSeletorInfo = this.page1.getMCUSeletorInfo();
                if (!GlobalVariables.McuSeletorInfo.getSupportCodeGen()) {
                    String tips = "Regarding the current selection:" + System.lineSeparator() + "  1. Code generation is not supported, but the functionality for pin assignment is available, and the gdc file can be saved. " + System.lineSeparator() + "  2. There is no support for clock configuration and peripheral configuration features.";
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Message", (String)tips);
                }
                GlobalVariables.isInitProject = true;
                ProjectConfigUtil.ClearAllGlobalVars();
                GlobalVariables.ProjectName = ProjectName;
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask("Initializing  Project...", -1);
                            ProjectConfigUtil.InitAllGlobalVars();
                            monitor.done();
                        }
                        catch (Throwable e) {
                            LogManager.getInstance().logThrowable(e);
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                Shell shell = Display.getCurrent().getActiveShell();
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                try {
                    progressMonitorDialog.run(true, false, iRunnableWithProgress);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IFile file = project.getFile(String.valueOf(File.separator) + ProjectName + "." + "gdc");
                try {
                    if (file != null) {
                        IDE.openEditor((IWorkbenchPage)wbPage, (IFile)file);
                        IntroPlugin.closeIntro();
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SerializeAccess_Template.SerializeSave((IProject)project);
        } else {
            Object[] options = new Object[]{"OK"};
            JOptionPane.showOptionDialog(null, "The project already exists!", "Message", -1, -1, null, options, options[0]);
        }
        return true;
    }
}

