/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.gdconfigui;

import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.mcuxmlinfo.McuGroup;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.xml.sax.SAXException;

public class GDProjectSelectorMCUPage
extends WizardPage {
    private Table table = null;
    private List<MCUSeletorInfo> MCUSeletorInfoList;
    public static Map<Integer, Combo> FilterComboMap;
    public static Map<Integer, List<String>> FilterComboItemMap;
    private String MCUPart;
    public final int MCU = 0;
    public final int SERIES = 1;
    public final int PACKAGE = 2;
    public final int CORE = 3;
    public final int FLASH = 4;
    public final int RAM = 5;
    public final int IO = 6;
    public static boolean WriteChangeLog;

    static {
        WriteChangeLog = true;
    }

    public GDProjectSelectorMCUPage() {
        super("New GD Project");
        this.setTitle("New GD Project");
        this.setDescription("Please select the target");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.MCUSeletorInfoList = new ArrayList<MCUSeletorInfo>();
        FilterComboMap = new HashMap<Integer, Combo>();
        FilterComboItemMap = new HashMap<Integer, List<String>>();
        this.InitMCUSeletorInfoList("arm");
        this.InitMCUSeletorInfoList("riscv");
        this.InitFilterComboItemMap();
        try {
            this.createGui(container);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private void createGui(Composite parent) throws ParserConfigurationException, SAXException, IOException {
        Composite filterComposite = new Composite(parent, 0);
        GridLayout filterLayout = new GridLayout(3, true);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterComposite.setLayout((Layout)filterLayout);
        GridData filterData = new GridData(4, 128, true, false);
        filterData.horizontalSpan = 3;
        filterComposite.setLayoutData((Object)filterData);
        this.addFilterControl(filterComposite, "Series:", 1);
        this.addFilterControl(filterComposite, "Package:", 2);
        this.addFilterControl(filterComposite, "Core:", 3);
        this.addFilterControl(filterComposite, "Flash >= ", 4);
        this.addFilterControl(filterComposite, "RAM >= ", 5);
        this.addFilterControl(filterComposite, "IO >= ", 6);
        this.table = new Table(parent, 67586);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.horizontalSpan = 3;
        tableData.heightHint = 400;
        this.table.setLayoutData((Object)tableData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] tableHeader = new String[]{"  MCU", "  Series", "  Package", "  Core", "  Flash", "  Ram", "  IO", "Support Code Gen"};
        int[] Headerlength = new int[]{120, 100, 100, 80, 80, 80, 80, 120};
        int i = 0;
        while (i < tableHeader.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(tableHeader[i]);
            tableColumn.setWidth(Headerlength[i]);
            tableColumn.setMoveable(true);
            tableColumn.setResizable(true);
            ++i;
        }
        this.table.setHeaderBackground(new Color(null, 210, 210, 210));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int total = GDProjectSelectorMCUPage.this.table.getItemCount();
                int i = 0;
                while (i < total) {
                    TableItem item = GDProjectSelectorMCUPage.this.table.getItem(i);
                    if (GDProjectSelectorMCUPage.this.table.isSelected(i)) {
                        GDProjectSelectorMCUPage.this.MCUPart = item.getText();
                        GDProjectSelectorMCUPage.this.setPageComplete(true);
                    }
                    ++i;
                }
            }
        });
        this.updateTable(this.MCUSeletorInfoList);
    }

    public void addFilterControl(Composite parent, String FilterLab, int FilterType) {
        Composite filterContainer = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 5;
        containerLayout.marginHeight = 5;
        filterContainer.setLayout((Layout)containerLayout);
        GridData containerData = new GridData(4, 0x1000000, true, false);
        filterContainer.setLayoutData((Object)containerData);
        Label label = new Label(filterContainer, 0);
        label.setText(FilterLab);
        GridData labelData = new GridData(16384, 0x1000000, false, false);
        labelData.widthHint = 80;
        label.setLayoutData((Object)labelData);
        Combo filterCombo = new Combo(filterContainer, 8);
        GridData comboData = new GridData(4, 0x1000000, true, false);
        comboData.minimumWidth = 100;
        filterCombo.setLayoutData((Object)comboData);
        filterCombo.add("ALL");
        List<String> filterList = FilterComboItemMap.get(FilterType);
        int i = 0;
        while (i < filterList.size()) {
            filterCombo.add(filterList.get(i));
            ++i;
        }
        filterCombo.select(0);
        filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArrayList<MCUSeletorInfo> MCUList = new ArrayList<MCUSeletorInfo>();
                MCUList.addAll(GDProjectSelectorMCUPage.this.ReturnMatchMCUList());
                GDProjectSelectorMCUPage.this.updateTable(MCUList);
            }
        });
        FilterComboMap.put(FilterType, filterCombo);
    }

    public void updateTable(List<MCUSeletorInfo> MCUSeletorInfoList) {
        this.setPageComplete(false);
        this.table.removeAll();
        int i = 0;
        while (i < MCUSeletorInfoList.size()) {
            String[] test = new String[this.table.getColumnCount()];
            test[0] = MCUSeletorInfoList.get(i).getMCUPart();
            test[1] = MCUSeletorInfoList.get(i).getSeries();
            test[2] = MCUSeletorInfoList.get(i).getPackageType();
            test[3] = MCUSeletorInfoList.get(i).getCore();
            test[4] = MCUSeletorInfoList.get(i).getFlashSize();
            test[5] = MCUSeletorInfoList.get(i).getRamSize();
            test[6] = MCUSeletorInfoList.get(i).getIOType();
            test[7] = MCUSeletorInfoList.get(i).getSupportCodeGen() ? "true" : "false";
            TableItem item = new TableItem(this.table, 0);
            item.setText(test);
            ++i;
        }
        this.table.update();
    }

    private List<MCUSeletorInfo> ReturnMatchMCUList() {
        ArrayList<MCUSeletorInfo> MCUList = new ArrayList<MCUSeletorInfo>();
        int i = 0;
        while (i < this.MCUSeletorInfoList.size()) {
            String Series = FilterComboMap.get(1).getText();
            String Package = FilterComboMap.get(2).getText();
            String Core = FilterComboMap.get(3).getText();
            boolean FlashSizeMatch = this.checkSelectCondition(this.MCUSeletorInfoList.get(i), 4);
            boolean RamSizeMatch = this.checkSelectCondition(this.MCUSeletorInfoList.get(i), 5);
            boolean IOMatch = this.checkSelectCondition(this.MCUSeletorInfoList.get(i), 6);
            if ((Series.equals(this.MCUSeletorInfoList.get(i).getSeries()) || Series.equals("ALL")) && (Package.equals(this.MCUSeletorInfoList.get(i).getPackageType()) || Package.equals("ALL")) && (Core.equals(this.MCUSeletorInfoList.get(i).getCore()) || Core.equals("ALL")) && FlashSizeMatch && RamSizeMatch && IOMatch) {
                MCUList.add(this.MCUSeletorInfoList.get(i));
            }
            ++i;
        }
        return MCUList;
    }

    private boolean checkSelectCondition(MCUSeletorInfo MCUSeletorInfoObj, int filterType) {
        String tmpSizeStr;
        int Size;
        block10: {
            String condition = FilterComboMap.get(filterType).getText();
            if (condition.equals("ALL")) {
                return true;
            }
            Size = Integer.parseInt(condition);
            tmpSizeStr = "";
            if (filterType == 4) {
                tmpSizeStr = MCUSeletorInfoObj.getFlashSize();
            } else if (filterType == 5) {
                tmpSizeStr = MCUSeletorInfoObj.getRamSize();
            } else if (filterType == 6) {
                tmpSizeStr = MCUSeletorInfoObj.getIOType();
            }
            if (!tmpSizeStr.equals("")) break block10;
            return false;
        }
        try {
            int tmpSize = Integer.parseInt(tmpSizeStr);
            if (tmpSize >= Size) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void InitFilterComboItemMap() {
        ArrayList<String> SeriesList = new ArrayList<String>();
        ArrayList<String> PackageList = new ArrayList<String>();
        ArrayList<String> CoreList = new ArrayList<String>();
        ArrayList<String> FlashList = new ArrayList<String>();
        ArrayList<String> RamList = new ArrayList<String>();
        ArrayList<String> IOList = new ArrayList<String>();
        int i = 0;
        while (i < this.MCUSeletorInfoList.size()) {
            String IOType;
            String RamSize;
            String FlashSize;
            String CoreType;
            String PackageType;
            String Series = this.MCUSeletorInfoList.get(i).getSeries();
            if (!SeriesList.contains(Series)) {
                SeriesList.add(Series);
            }
            if (!PackageList.contains(PackageType = this.MCUSeletorInfoList.get(i).getPackageType())) {
                PackageList.add(PackageType);
            }
            if (!CoreList.contains(CoreType = this.MCUSeletorInfoList.get(i).getCore())) {
                CoreList.add(CoreType);
            }
            if (!FlashList.contains(FlashSize = this.MCUSeletorInfoList.get(i).getFlashSize())) {
                FlashList.add(FlashSize);
            }
            if (!RamList.contains(RamSize = this.MCUSeletorInfoList.get(i).getRamSize())) {
                RamList.add(RamSize);
            }
            if (!IOList.contains(IOType = this.MCUSeletorInfoList.get(i).getIOType())) {
                IOList.add(IOType);
            }
            ++i;
        }
        Collections.sort(SeriesList);
        Collections.sort(PackageList);
        Collections.sort(CoreList);
        FilterComboItemMap.put(1, SeriesList);
        FilterComboItemMap.put(2, PackageList);
        FilterComboItemMap.put(3, CoreList);
        FilterComboItemMap.put(4, FlashList);
        FilterComboItemMap.put(5, RamList);
        FilterComboItemMap.put(6, IOList);
    }

    private void InitMCUSeletorInfoList(String CoreType) {
        List McuList = new ArrayList();
        String mcuType = "mcu_" + CoreType;
        McuList = McuFactory.getGDMcuTree((String)mcuType);
        String ChangeLogPath = String.valueOf(McuFactory.getResourcePath()) + "ChangeLog.txt";
        BufferedWriter bufferedWriter = null;
        WriteChangeLog = false;
        try {
            if (WriteChangeLog) {
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ChangeLogPath, true), StandardCharsets.UTF_8);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.newLine();
                bufferedWriter.write("<GD Project>");
                bufferedWriter.newLine();
                WriteChangeLog = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < McuList.size()) {
            int WritePartNoCount = 0;
            Object mcuGroup = McuList.get(i);
            List mcuSubGroup = ((McuGroup)mcuGroup).getChildren();
            String MCUGroup = ((McuGroup)mcuGroup).getName();
            String fwlibType = ((McuGroup)mcuGroup).getFwlibType();
            int j = 0;
            while (j < mcuSubGroup.size()) {
                String Series = ((McuSubGroup)mcuSubGroup.get(j)).getName();
                boolean isSupportSubGroup = ((McuSubGroup)mcuSubGroup.get(j)).isSupport();
                if (isSupportSubGroup) {
                    String Core = ((McuSubGroup)mcuSubGroup.get(j)).getCPUCore();
                    String PerisRelationFilePath = ((McuSubGroup)mcuSubGroup.get(j)).getRelationFilePath();
                    String RCUPath = ((McuSubGroup)mcuSubGroup.get(j)).getRCUPath();
                    String CodeGroup = ((McuSubGroup)mcuSubGroup.get(j)).getCodeGroup();
                    boolean SupportCodeGen = ((McuSubGroup)mcuSubGroup.get(j)).getSupportCodeGen();
                    String spPeri2FuncFilePath = ((McuSubGroup)mcuSubGroup.get(j)).getSPPeri2FuncFilePath();
                    if (CodeGroup.equals("")) {
                        CodeGroup = MCUGroup;
                    }
                    List MCUList = ((McuSubGroup)mcuSubGroup.get(j)).getChildren();
                    int k = 0;
                    while (k < MCUList.size()) {
                        MCUSeletorInfo mcuSeletorInfo = new MCUSeletorInfo();
                        String MCUPart = ((MCUs)MCUList.get(k)).getName();
                        String FlashSize = ((MCUs)MCUList.get(k)).getFlashSize();
                        String RamSize = ((MCUs)MCUList.get(k)).getRamSize();
                        String PackageType = ((MCUs)MCUList.get(k)).getPackageType();
                        String IO = ((MCUs)MCUList.get(k)).getIO();
                        String DataSheetPath = ((MCUs)MCUList.get(k)).getDataSheetPath();
                        String AFIOPath = ((MCUs)MCUList.get(k)).getAFIOPath();
                        String PeriTreeFilePath = ((MCUs)MCUList.get(k)).getPerisTreeFilePath();
                        ArrayList Symbols = ((MCUs)MCUList.get(k)).getSymbols();
                        mcuSeletorInfo.setFwlibType(fwlibType);
                        mcuSeletorInfo.setCodeGroup(CodeGroup);
                        mcuSeletorInfo.setMCUGroup(MCUGroup);
                        mcuSeletorInfo.setSeries(Series);
                        mcuSeletorInfo.setCore(Core);
                        mcuSeletorInfo.setMCUPart(MCUPart);
                        mcuSeletorInfo.setFlashSize(FlashSize);
                        mcuSeletorInfo.setPackageType(PackageType);
                        mcuSeletorInfo.setRamSize(RamSize);
                        mcuSeletorInfo.setIOType(IO);
                        mcuSeletorInfo.setDataSheetPath(DataSheetPath);
                        mcuSeletorInfo.setAFIOPath(AFIOPath);
                        mcuSeletorInfo.setPerisTreeFilePath(PeriTreeFilePath);
                        mcuSeletorInfo.setPerisRelationFilePath(PerisRelationFilePath);
                        mcuSeletorInfo.setRCUPath(RCUPath);
                        mcuSeletorInfo.setSvdPath(((MCUs)MCUList.get(k)).getSVD());
                        mcuSeletorInfo.setSymbols((List)Symbols);
                        mcuSeletorInfo.setSupportCodeGen(SupportCodeGen);
                        mcuSeletorInfo.setSPPeri2FuncFilePath(spPeri2FuncFilePath);
                        mcuSeletorInfo.setMcuObj((MCUs)MCUList.get(k));
                        this.MCUSeletorInfoList.add(mcuSeletorInfo);
                        if (bufferedWriter != null) {
                            try {
                                bufferedWriter.write(String.valueOf(MCUPart) + " ");
                                if (++WritePartNoCount >= 8) {
                                    bufferedWriter.newLine();
                                    WritePartNoCount = 0;
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.newLine();
                    if (WritePartNoCount != 0) {
                        bufferedWriter.newLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MCUSeletorInfo getMCUSeletorInfo() {
        MCUSeletorInfo mcuSeletorInfo = new MCUSeletorInfo();
        int i = 0;
        while (i < this.MCUSeletorInfoList.size()) {
            if (this.MCUPart.equals(this.MCUSeletorInfoList.get(i).getMCUPart())) {
                return this.MCUSeletorInfoList.get(i);
            }
            ++i;
        }
        return mcuSeletorInfo;
    }
}

