/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.gdconfigui;

import java.io.File;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GDProjectBrowsegdcFile<IPath>
extends WizardPage {
    private Text mNameText;
    private Text pNameText;
    private Text projectLocation;
    private String basePath;
    private Button useDefaultsButton;

    protected GDProjectBrowsegdcFile() {
        super("GD32 Project from an Existing GD32 Configuration File (.gdc)");
        this.setTitle("GD32 Project from an Existing GD32 Configuration File (.gdc)");
        this.setDescription("Empty GD32 configuration file (.gdc) is not supported");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(6, false));
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 6, 1));
        group.setText("GD32 .gdc file");
        GridLayout groupLayout = new GridLayout(6, false);
        group.setLayout((Layout)groupLayout);
        GridData nameGd = new GridData(16384, 0x1000000, false, false);
        nameGd.widthHint = 25;
        Label labelName = new Label((Composite)group, 0);
        labelName.setText("File:");
        labelName.setLayoutData((Object)nameGd);
        this.mNameText = new Text((Composite)group, 2048);
        this.mNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.setPageComplete(false);
        this.mNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textString = GDProjectBrowsegdcFile.this.mNameText.getText();
                File file = new File(textString);
                if (!file.exists()) {
                    GDProjectBrowsegdcFile.this.setMessage("The selected .gdc file does not exist.", 3);
                    GDProjectBrowsegdcFile.this.pNameText.setEnabled(false);
                    GDProjectBrowsegdcFile.this.pNameText.setText("");
                    GDProjectBrowsegdcFile.this.useDefaultsButton.setEnabled(false);
                    GDProjectBrowsegdcFile.this.setPageComplete(false);
                } else {
                    GDProjectBrowsegdcFile.this.pNameText.setEnabled(true);
                    GDProjectBrowsegdcFile.this.useDefaultsButton.setEnabled(true);
                    GDProjectBrowsegdcFile.this.basePath = file.getParent();
                    if (GDProjectBrowsegdcFile.this.basePath != null && !GDProjectBrowsegdcFile.this.basePath.isEmpty()) {
                        String fileNameWithExtension = file.getName();
                        String fileNameWithoutExtension = GDProjectBrowsegdcFile.this.getFileNameWithoutExtension(fileNameWithExtension);
                        String trimmedBasePath = GDProjectBrowsegdcFile.this.removeLastDirectory(GDProjectBrowsegdcFile.this.basePath);
                        String relativeFilePath = GDProjectBrowsegdcFile.this.getRelativePath(trimmedBasePath, textString);
                        if (GDProjectBrowsegdcFile.isGdcFileUsedOrOpen(relativeFilePath)) {
                            GDProjectBrowsegdcFile.this.pNameText.setText(fileNameWithoutExtension);
                            GDProjectBrowsegdcFile.this.pNameText.setEnabled(false);
                            GDProjectBrowsegdcFile.this.setMessage("Project is already existing within current workspace", 3);
                            GDProjectBrowsegdcFile.this.setPageComplete(false);
                        } else {
                            GDProjectBrowsegdcFile.this.pNameText.setText(fileNameWithoutExtension);
                            GDProjectBrowsegdcFile.this.pNameText.setEnabled(true);
                            GDProjectBrowsegdcFile.this.setMessage("Directory with specified name already exists", 2);
                            GDProjectBrowsegdcFile.this.setPageComplete(true);
                        }
                    } else {
                        GDProjectBrowsegdcFile.this.setErrorMessage("GD32 configuration file(.gdc) is empty!");
                        GDProjectBrowsegdcFile.this.setPageComplete(false);
                    }
                }
            }
        });
        Button BrowseButton = new Button((Composite)group, 0);
        BrowseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        BrowseButton.setText("Browse...");
        Group group_Project = new Group(container, 0);
        group_Project.setLayoutData((Object)new GridData(4, 4, true, false, 6, 1));
        group_Project.setText("Project");
        GridLayout groupLayout_Projrct = new GridLayout(6, false);
        group_Project.setLayout((Layout)groupLayout_Projrct);
        GridData namePro = new GridData(16384, 0x1000000, false, false);
        namePro.widthHint = 85;
        Label labelNamePro = new Label((Composite)group_Project, 0);
        labelNamePro.setText("Project Name:");
        labelNamePro.setLayoutData((Object)namePro);
        this.pNameText = new Text((Composite)group_Project, 2048);
        this.pNameText.setEnabled(false);
        this.pNameText.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 5, 1));
        this.pNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String projectName = GDProjectBrowsegdcFile.this.pNameText.getText();
                if (projectName == null || projectName.isEmpty()) {
                    GDProjectBrowsegdcFile.this.setMessage("Project name cannot be empty", 3);
                    GDProjectBrowsegdcFile.this.setPageComplete(false);
                    return;
                }
                if (GDProjectBrowsegdcFile.this.isProjectExistInWorkspace(projectName)) {
                    GDProjectBrowsegdcFile.this.setMessage("Project with name '" + projectName + "' already exists in workspace", 3);
                    GDProjectBrowsegdcFile.this.setPageComplete(false);
                } else {
                    String filePath = GDProjectBrowsegdcFile.this.mNameText.getText();
                    if (filePath != null && !filePath.isEmpty()) {
                        GDProjectBrowsegdcFile.this.setMessage("Directory with specified name already exists", 2);
                        GDProjectBrowsegdcFile.this.setPageComplete(true);
                    }
                }
            }
        });
        this.useDefaultsButton = new Button((Composite)group_Project, 32);
        this.useDefaultsButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 6, 2));
        this.useDefaultsButton.setText("Use default location");
        this.useDefaultsButton.setSelection(true);
        this.useDefaultsButton.setEnabled(false);
        Label pathLabelName = new Label((Composite)group_Project, 0);
        pathLabelName.setText("Location:");
        pathLabelName.setEnabled(false);
        pathLabelName.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 3));
        this.projectLocation = new Text((Composite)group_Project, 2048);
        this.projectLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 3));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        this.projectLocation.setText(root.getLocation().toString());
        this.projectLocation.setToolTipText(root.getLocation().toString());
        this.projectLocation.setEnabled(false);
        Button browerButton = new Button((Composite)group_Project, 0);
        browerButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 3));
        browerButton.setText("Browse...");
        browerButton.setEnabled(false);
        this.attachBrowseButtonListener(BrowseButton, this.useDefaultsButton);
        this.attachUseDefaultsButtonListener(this.useDefaultsButton, browerButton, this.projectLocation);
        this.attachbrowerButtonListener(browerButton, this.projectLocation);
    }

    private void attachBrowseButtonListener(Button BrowseButton, final Button useDefaultsButton) {
        BrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(GDProjectBrowsegdcFile.this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.gdc"});
                String selectedFile = fileDialog.open();
                if (selectedFile != null && !selectedFile.isEmpty()) {
                    File file = new File(selectedFile);
                    GDProjectBrowsegdcFile.this.basePath = file.getParent();
                    if (GDProjectBrowsegdcFile.this.basePath != null && !GDProjectBrowsegdcFile.this.basePath.isEmpty()) {
                        String fileNameWithExtension = file.getName();
                        String fileNameWithoutExtension = GDProjectBrowsegdcFile.this.getFileNameWithoutExtension(fileNameWithExtension);
                        String trimmedBasePath = GDProjectBrowsegdcFile.this.removeLastDirectory(GDProjectBrowsegdcFile.this.basePath);
                        GDProjectBrowsegdcFile.this.getRelativePath(trimmedBasePath, selectedFile);
                        if (GDProjectBrowsegdcFile.isGdcFileUsedOrOpen(fileNameWithExtension)) {
                            GDProjectBrowsegdcFile.this.mNameText.setText(selectedFile);
                            GDProjectBrowsegdcFile.this.pNameText.setText(fileNameWithoutExtension);
                            GDProjectBrowsegdcFile.this.pNameText.setEnabled(true);
                            GDProjectBrowsegdcFile.this.setMessage("Project is already existing within current workspace", 3);
                            GDProjectBrowsegdcFile.this.setPageComplete(false);
                            useDefaultsButton.setEnabled(true);
                        } else {
                            GDProjectBrowsegdcFile.this.mNameText.setText(selectedFile);
                            GDProjectBrowsegdcFile.this.pNameText.setText(fileNameWithoutExtension);
                            GDProjectBrowsegdcFile.this.pNameText.setEnabled(true);
                            GDProjectBrowsegdcFile.this.setMessage("Directory with specified name already exists", 2);
                            GDProjectBrowsegdcFile.this.setPageComplete(true);
                            useDefaultsButton.setEnabled(true);
                        }
                    } else {
                        GDProjectBrowsegdcFile.this.setMessage("Base directory could not be determined.", 3);
                        GDProjectBrowsegdcFile.this.setPageComplete(false);
                    }
                } else {
                    GDProjectBrowsegdcFile.this.setMessage("GD32 configuration file(.gdc) is empty!", 3);
                    GDProjectBrowsegdcFile.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void attachUseDefaultsButtonListener(final Button button, final Button browerButton, final Text projectLocation) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = button.getSelection();
                projectLocation.setEnabled(!isSelected);
                browerButton.setEnabled(!isSelected);
                String projectLocationStr = projectLocation.getText();
                if (projectLocationStr.isEmpty()) {
                    GDProjectBrowsegdcFile.this.setMessage("Setup GD32 project!", 1);
                    GDProjectBrowsegdcFile.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void attachprojectLocationListener(final Text projectLocation) {
        projectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String projectLocationString = projectLocation.getText();
                File file = new File(projectLocationString);
                GDProjectBrowsegdcFile.this.basePath = file.getParent();
                if (GDProjectBrowsegdcFile.this.basePath != null && !GDProjectBrowsegdcFile.this.basePath.isEmpty()) {
                    String fileNameWithExtension = file.getName();
                    String fileNameWithoutExtension = GDProjectBrowsegdcFile.this.getFileNameWithoutExtension(fileNameWithExtension);
                    String trimmedBasePath = GDProjectBrowsegdcFile.this.removeLastDirectory(GDProjectBrowsegdcFile.this.basePath);
                    String relativeFilePath = GDProjectBrowsegdcFile.this.getRelativePath(trimmedBasePath, projectLocationString);
                    if (GDProjectBrowsegdcFile.isGdcFileUsedOrOpen(relativeFilePath)) {
                        GDProjectBrowsegdcFile.this.pNameText.setText(fileNameWithoutExtension);
                        GDProjectBrowsegdcFile.this.pNameText.setEnabled(false);
                        GDProjectBrowsegdcFile.this.setMessage("Project is already existing within current workspace", 3);
                        GDProjectBrowsegdcFile.this.setPageComplete(false);
                    } else {
                        GDProjectBrowsegdcFile.this.pNameText.setText(fileNameWithoutExtension);
                        GDProjectBrowsegdcFile.this.pNameText.setEnabled(false);
                        GDProjectBrowsegdcFile.this.setMessage("Directory with specified name already exists", 2);
                        GDProjectBrowsegdcFile.this.setPageComplete(true);
                    }
                } else {
                    GDProjectBrowsegdcFile.this.setErrorMessage("GD32 configuration file(.gdc) is empty!");
                    GDProjectBrowsegdcFile.this.setPageComplete(false);
                }
            }
        });
    }

    private void attachbrowerButtonListener(Button browerButton, final Text projectLocation) {
        browerButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDir;
                DirectoryDialog directoryDialog = new DirectoryDialog(GDProjectBrowsegdcFile.this.getShell(), 4096);
                directoryDialog.setMessage("Select a directory");
                if (!projectLocation.getText().isEmpty()) {
                    directoryDialog.setFilterPath(projectLocation.getText());
                }
                if ((selectedDir = directoryDialog.open()) != null) {
                    projectLocation.setText(selectedDir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean containsChineseCharacters(String text) {
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getRelativePath(String basePath, String absoluteFilePath) {
        java.nio.file.Path base = Paths.get(basePath, new String[0]).toAbsolutePath().normalize();
        java.nio.file.Path target = Paths.get(absoluteFilePath, new String[0]).toAbsolutePath().normalize();
        return base.relativize(target).toString();
    }

    private String removeLastDirectory(String fullPath) {
        java.nio.file.Path path = Paths.get(fullPath, new String[0]);
        java.nio.file.Path parentPath = path.getParent();
        return parentPath != null ? parentPath.toString() : fullPath;
    }

    private boolean isProjectExistInWorkspace(String projectName) {
        if (projectName == null || projectName.isEmpty()) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        return project.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGdcFileUsedOrOpen(String filePath) {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        System.out.println("Workspace location: " + workspace.getRoot().getLocation().toOSString());
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IProject project = iProjectArray[n2];
                try {
                    if (project.isOpen()) {
                        System.out.println("Checking project: " + project.getName());
                        IResource resource = project.findMember((IPath)new Path(filePath));
                        if (resource != null) {
                            System.out.println("Resource path: " + filePath.toString());
                            if (resource.exists()) {
                                System.out.println("Resource found: " + resource.getFullPath().toString());
                                return true;
                            }
                            System.out.println("Resource does not exist.");
                            break block7;
                        } else {
                            System.out.println("Resource not found in project: " + project.getName());
                        }
                        break block7;
                    }
                    System.out.println("Project is not open: " + project.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return false;
    }

    private String getFileNameWithoutExtension(String fileNameWithExtension) {
        if (fileNameWithExtension == null || fileNameWithExtension.isEmpty()) {
            return fileNameWithExtension;
        }
        int dotIndex = fileNameWithExtension.lastIndexOf(46);
        if (dotIndex == -1) {
            return fileNameWithExtension;
        }
        return fileNameWithExtension.substring(0, dotIndex);
    }

    public String getSelectedFilePath() {
        return this.basePath;
    }

    public String getSourceFilePath() {
        if (this.mNameText != null) {
            return this.mNameText.getText();
        }
        return "";
    }

    public String getProjectName() {
        if (this.pNameText != null) {
            return this.pNameText.getText();
        }
        return "";
    }

    public String getProjectLocation() {
        if (this.projectLocation != null) {
            String location = this.projectLocation.getText();
            if (!location.isEmpty()) {
                if (!location.endsWith(File.separator)) {
                    location = String.valueOf(location) + File.separator;
                }
                return location;
            }
            return location;
        }
        return "";
    }
}

