/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs;

import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.utils.preferences.EclipsePreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;

public class ProjectUpdateFile {
    public static String[] getLdFileListFormProjectConfig(IProject project, String TOOL_LINKER_ID, String TOOLID_GENERAL_SCRIPTFILE) {
        ITool[] OtherTools;
        IToolChain toolchain;
        String[] LdFileList = null;
        IConfiguration cfg = ProjectUtils.getActiveConfigurationsForProject((IProject)project);
        if (cfg != null && (toolchain = cfg.getToolChain()) != null && (OtherTools = toolchain.getToolsBySuperClassId(TOOL_LINKER_ID)) != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption option = tool.getOptionBySuperClassId(TOOLID_GENERAL_SCRIPTFILE);
                if (option != null) {
                    try {
                        String[] LdFilePathList = option.getStringListValue();
                        if (LdFilePathList.length > 0) {
                            return LdFilePathList;
                        }
                    }
                    catch (BuildException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return LdFileList;
    }

    public static String getFirstLdFileNameFromLdList(String[] LdFileList) {
        int i;
        String LdFileName = "";
        if (LdFileList != null && LdFileList.length > 0 && (i = 0) < LdFileList.length) {
            LdFileName = LdFileList[0];
            LdFileName = LdFileName.replace("\\", "/");
            int beginIndex = 0;
            beginIndex = LdFileName.lastIndexOf("/");
            if (beginIndex > 0) {
                LdFileName = LdFileName.endsWith("}\"") ? LdFileName.substring(beginIndex + 1, LdFileName.length() - 2) : LdFileName.substring(beginIndex + 1, LdFileName.length() - 1);
            }
            return LdFileName;
        }
        return LdFileName;
    }

    public static String parseLdFilePath(String projectPath, String ldFileName) {
        String ret = "";
        File dir = new File(projectPath);
        if (!dir.exists()) {
            System.out.println("\u74ba\ue21a\u7dde\u6d93\u5d85\u74e8\u9366\ufffd:" + projectPath);
            return "";
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return "";
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                String dirPath = f.getAbsolutePath();
                ret = ProjectUpdateFile.parseLdFilePath(dirPath, ldFileName);
                if (ret != "") {
                    return ret;
                }
            } else if (f.isFile()) {
                String filePath = f.getAbsolutePath();
                String fileName = f.getName();
                if (fileName.equals(ldFileName)) {
                    return filePath;
                }
            }
            ++n2;
        }
        return ret;
    }

    public static boolean updateLinkFile(IProject project, EclipsePreferences projPreferences) {
        String SourcePath = projPreferences.getLinkFileSrcPath(project);
        String TargetPath = projPreferences.getLinkFileTargetPath(project);
        String flashOrigin = projPreferences.getLinkFileFlashOrigin(project);
        String flashLength = projPreferences.getLinkFileFlashlength(project);
        String ramOrigin = projPreferences.getLinkFileRamOrigin(project);
        String ramLength = projPreferences.getLinkFileRamLength(project);
        String content = "";
        if (SourcePath.equals("")) {
            return false;
        }
        File file = new File(TargetPath);
        BufferedReader read = null;
        String tempLineStr = null;
        try {
            read = new BufferedReader(new FileReader(SourcePath));
            while ((tempLineStr = read.readLine()) != null) {
                if (tempLineStr.indexOf("$(") >= 0) {
                    tempLineStr = tempLineStr.replace("$(flashOrigin)", flashOrigin);
                    tempLineStr = tempLineStr.replace("$(flashLength)", flashLength);
                    tempLineStr = tempLineStr.replace("$(ramOrigin)", ramOrigin);
                    tempLineStr = tempLineStr.replace("$(ramLength)", ramLength);
                }
                content = String.valueOf(content) + tempLineStr + "\n";
            }
            read.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            FileWriter fw = new FileWriter(file.getAbsolutePath());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

