/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs.arm;

import com.gigadevice.mbs.arm.Activator;
import com.gigadevice.mbs.arm.Option;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.File;
import java.util.List;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public class PATHEnvironmentVariable
implements IBuildEnvironmentVariable {
    private static String environmentVariableName = "PATH";
    private static String environmentVariableValue;

    public PATHEnvironmentVariable(String environmentVariable) {
        environmentVariableValue = environmentVariable;
    }

    public String getName() {
        return environmentVariableName;
    }

    public String getValue() {
        return environmentVariableValue;
    }

    public int getOperation() {
        return 3;
    }

    public String getDelimiter() {
        return TargetOSInfo.getSystemPathSeparator();
    }

    public static boolean isDefined(String variableName) {
        return Platform.getOS().equals("win32") ? variableName.equalsIgnoreCase(environmentVariableName) : variableName.equals(environmentVariableName);
    }

    public static IBuildEnvironmentVariable create(IConfiguration configuration) {
        IToolChain toolchain = configuration.getToolChain();
        IProject cfr_ignored_0 = (IProject)configuration.getManagedProject().getOwner();
        Activator.getInstance().getProjectPreferences();
        toolchain.getOptionBySuperClassId(Option.OPTIONID_BUILDTOOL_PATH);
        String BuildToolPath = null;
        BuildToolPath = Option.getOptionStringValue((IConfiguration)configuration, (String)Option.OPTIONID_BUILDTOOL_PATH);
        IOption option = toolchain.getOptionBySuperClassId(Option.OPTIONID_TOOLCHAIN_NAME);
        String cfr_ignored_1 = (String)option.getValue();
        String toolchainPath = null;
        IOption optionToolChainPath = toolchain.getOptionBySuperClassId(Option.OPTIONID_TOOLCHAIN_PATH);
        toolchainPath = (String)optionToolChainPath.getValue();
        toolchainPath = Option.getOptionStringValue((IConfiguration)configuration, (String)Option.OPTIONID_TOOLCHAIN_PATH);
        BuildToolPath = Option.getAbsolutePath(BuildToolPath);
        toolchainPath = Option.getAbsolutePath(toolchainPath);
        String path = "";
        if (!BuildToolPath.isEmpty()) {
            path = String.valueOf(BuildToolPath) + TargetOSInfo.getSystemPathSeparator();
        }
        if (!toolchainPath.isEmpty()) {
            path = String.valueOf(path) + toolchainPath;
        }
        if (!path.isEmpty()) {
            if (path.indexOf("${") >= 0) {
                path = PATHEnvironmentVariable.resolveMacros(path, configuration);
            }
            environmentVariableValue = path;
            if (Activator.getInstance().isDebugging()) {
                System.out.println("com.gigadevice.mbs.arm.PATHEnvironmentVariable.create() PATH=\"" + environmentVariableValue + "\" cfg=" + configuration + " prj=" + configuration.getManagedProject().getOwner().getName());
            }
            return new PATHEnvironmentVariable(environmentVariableValue);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("com.gigadevice.mbs.arm.PATHEnvironmentVariable.create(" + configuration.getName() + ") returns null");
        }
        return null;
    }

    private static String resolveMacros(String pathStr, IConfiguration configuration) {
        String result = pathStr;
        try {
            result = ManagedBuildManager.getBuildMacroProvider().resolveValue(pathStr, "", " ", 3, (Object)configuration);
        }
        catch (CdtVariableException e) {
            Activator.log("com.gigadevice.mbs.arm.PATHEnvironmentVariable.resolveMacros Throws:" + e.getMessage());
        }
        if (Activator.getInstance().isDebugging()) {
            Activator.log("com.gigadevice.mbs.arm.PATHEnvironmentVariable.resolveMacros(\"" + pathStr + "\", \"" + configuration.getName() + "\") returns  \"" + result + "\"");
        }
        return result;
    }

    public static List getALLFilesPath(File dir, String fileName, List<String> fileList) {
        File[] fs = dir.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getAbsolutePath().contains(fileName)) {
                    fileList.add(fs[i].getAbsolutePath());
                }
                if (fs[i].isDirectory()) {
                    try {
                        PATHEnvironmentVariable.getALLFilesPath(fs[i], fileName, fileList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return fileList;
    }
}

