/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameModuleProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating {
    protected IModuleDescription fModule;
    private IJavaProject fJavaProject;
    protected boolean fUpdateReferences;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;

    public RenameModuleProcessor(IModuleDescription moduleDesc) {
        this(moduleDesc, new TextChangeManager(true), null);
    }

    public RenameModuleProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void assignModule(IModuleDescription moduleDesc) {
        this.fModule = moduleDesc;
        if (this.fModule != null) {
            this.fJavaProject = this.fModule.getJavaProject();
        }
        this.fUpdateReferences = true;
    }

    RenameModuleProcessor(IModuleDescription module, TextChangeManager manager, GroupCategorySet categorySet) {
        this.assignModule(module);
        this.fChangeManager = manager;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 17) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.module");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.assignModule((IModuleDescription)element);
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.parseBoolean(references);
        return new RefactoringStatus();
    }

    @Override
    public Object getNewElement() throws CoreException {
        return super.getNewElementName();
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkModuleName(newName, (IJavaElement)this.fModule);
        return result;
    }

    @Override
    public boolean canEnableTextUpdating() {
        return false;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return false;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
    }

    @Override
    public String getCurrentElementName() {
        return this.fModule.getElementName();
    }

    @Override
    public String getCurrentElementQualifier() {
        return "";
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fModule, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            pm.beginTask("", 7);
            pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(Checks.checkIfCuBroken((IMember)this.fModule));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            if (this.fUpdateReferences) {
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_searching);
                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            } else {
                this.fReferences = new SearchResultGroup[0];
                pm.worked(3);
            }
            if (this.fUpdateReferences) {
                result.merge(this.analyzeAffectedCompilationUnits());
            } else {
                Checks.checkCompileErrorsInAffectedFile(result, this.fModule.getResource());
            }
            result.merge(this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 4)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus createChanges(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 10);
        RefactoringStatus result = new RefactoringStatus();
        this.addDeclarationUpdate();
        if (this.fUpdateReferences) {
            this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 2)));
            if (result.hasFatalError()) {
                return result;
            }
        } else {
            pm.worked(3);
        }
        pm.done();
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        newWorkingCopies = null;
        newWCOwner = new WorkingCopyOwner(){};
        try {
            pm.beginTask("", 2);
            result = new RefactoringStatus();
            oldReferences = this.fReferences;
            compilationUnitsToModify = new ArrayList<ICompilationUnit>();
            compilationUnitsToModify.addAll(Arrays.asList(this.fChangeManager.getAllCompilationUnits()));
            newWorkingCopies = RenameAnalyzeUtil.createNewWorkingCopies(compilationUnitsToModify.toArray(new ICompilationUnit[compilationUnitsToModify.size()]), this.fChangeManager, newWCOwner, new SubProgressMonitor(pm, 1));
            newReferences = this.getNewReferences((IProgressMonitor)new SubProgressMonitor(pm, 1), result, newWCOwner, newWorkingCopies);
            result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, oldReferences, newReferences, this.getNewElementName()));
            var9_8 = result;
            return var9_8;
        }
        finally {
            pm.done();
            if (newWorkingCopies == null) return var9_8;
            var13_9 = newWorkingCopies;
            var12_11 = newWorkingCopies.length;
            var11_13 = 0;
            ** while (var11_13 < var12_11)
        }
lbl-1000:
        // 1 sources

        {
            newWorkingCopy = var13_9[var11_13];
            newWorkingCopy.discardWorkingCopy();
            ++var11_13;
            continue;
        }
lbl26:
        // 1 sources

        return var9_8;
    }

    private SearchResultGroup[] getNewReferences(IProgressMonitor pm, RefactoringStatus status, WorkingCopyOwner owner, ICompilationUnit[] newWorkingCopies) throws CoreException {
        pm.beginTask("", 2);
        ICompilationUnit declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(newWorkingCopies, this.fModule.getCompilationUnit());
        if (declaringCuWorkingCopy == null) {
            return new SearchResultGroup[0];
        }
        IModuleDescription module = this.getModuleInWorkingCopy();
        if (module == null || !module.exists()) {
            return new SearchResultGroup[0];
        }
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchPattern newPattern = SearchPattern.createPattern((IJavaElement)module, (int)2);
        if (newPattern == null) {
            return new SearchResultGroup[0];
        }
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fModule, true, true);
        return RefactoringSearchEngine.search(newPattern, owner, scope, requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
    }

    private IModuleDescription getModuleInWorkingCopy() {
        if (this.fJavaProject != null) {
            try {
                return this.fJavaProject.getModuleDescription();
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return null;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fModule);
    }

    @Override
    public int getSaveMode() {
        return 4;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fModule};
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameModuleProcessor";
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameModuleRefactoring_name;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isRenameModuleAvailable(this.fModule);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IModuleDescription primary = (IModuleDescription)this.fModule.getPrimaryElement();
        if (primary == null || !primary.exists()) {
            String message = Messages.format(RefactoringCoreMessages.RenameModuleRefactoring_deleted, BasicElementLabels.getFileName((ITypeRoot)this.fModule.getCompilationUnit()));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.assignModule(primary);
        return Checks.checkIfCuBroken((IMember)this.fModule);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 1);
            TextChange[] changes = this.fChangeManager.getAllChanges();
            RenameJavaElementDescriptor descriptor = this.createRefactoringDescriptor();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, this.getProcessorName(), (Change[])changes);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    protected RenameJavaElementDescriptor createRefactoringDescriptor() {
        String project = null;
        IJavaProject javaProject = this.fModule.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589826;
        try {
            if (!Flags.isPrivate((int)this.fModule.getFlags())) {
                flags |= 4;
            }
        }
        catch (JavaModelException exception) {
            JavaManipulationPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.RenameModuleRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fModule.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.RenameModuleProcessor_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fModule.getElementName()), project, this.getNewElementName()});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor("org.eclipse.jdt.ui.rename.module");
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment.asString());
        descriptor.setFlags(flags);
        descriptor.setJavaElement((IJavaElement)this.fModule);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        descriptor.setUpdateTextualOccurrences(false);
        return descriptor;
    }

    private void addTextEdit(TextChange change, String groupName, TextEdit textEdit) {
        TextChangeCompatibility.addTextEdit(change, groupName, textEdit);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.getCurrentElementName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        SearchPattern searchPattern = this.createSearchPattern();
        if (searchPattern == null) {
            return new SearchResultGroup[0];
        }
        SearchResultGroup[] result = RefactoringSearchEngine.search(searchPattern, this.createRefactoringScope(), new CuCollectingSearchRequestor(binaryRefs), pm, status);
        binaryRefs.addErrorIfNecessary(status);
        return result;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.fModule, (int)2);
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fModule, true, false);
    }

    private void addReferenceUpdates(IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        String editName = RefactoringCoreMessages.RenameModuleRefactoring_Update_module_reference;
        SearchResultGroup[] searchResultGroupArray = this.fReferences;
        int n = this.fReferences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup reference = searchResultGroupArray[n2];
            ICompilationUnit cu = reference.getCompilationUnit();
            if (cu != null) {
                SearchMatch[] searchMatchArray = reference.getSearchResults();
                int n3 = searchMatchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch result = searchMatchArray[n4];
                    this.addTextEdit(this.fChangeManager.get(cu), editName, this.createTextChange(result));
                    ++n4;
                }
                pm.worked(1);
            }
            ++n2;
        }
    }

    private TextEdit createTextChange(SearchMatch match) {
        return new ReplaceEdit(match.getOffset(), match.getLength(), this.getNewElementName());
    }

    private void addDeclarationUpdate() throws CoreException {
        ISourceRange nameRange = this.fModule.getNameRange();
        ReplaceEdit textEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        ICompilationUnit cu = this.fModule.getCompilationUnit();
        String groupName = RefactoringCoreMessages.RenameModuleRefactoring_Update_module_declaration;
        this.addTextEdit(this.fChangeManager.get(cu), groupName, (TextEdit)textEdit);
    }
}

