/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.preferences;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.MavenConfigurationChangeEvent;
import org.eclipse.m2e.core.embedder.MavenSettingsLocations;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IMavenConfiguration.class})
public class MavenConfigurationImpl
implements IMavenConfiguration,
IEclipsePreferences.IPreferenceChangeListener,
IEclipsePreferences.INodeChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MavenConfigurationImpl.class);
    private final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    @Reference
    private IPreferencesService preferenceStore;
    private final ListenerList<IMavenConfigurationChangeListener> listeners = new ListenerList(1);
    private static final IPreferenceFilter[] PREFERENCE_FILTERS = new IPreferenceFilter[]{new IPreferenceFilter(){

        public String[] getScopes() {
            return new String[]{"instance", "default"};
        }

        public Map<String, PreferenceFilterEntry[]> getMapping(String scope) {
            return null;
        }
    }};

    private boolean exists(IEclipsePreferences preferenceNode) {
        if (preferenceNode == null) {
            return false;
        }
        try {
            return preferenceNode.nodeExists("");
        }
        catch (BackingStoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Activate
    void init() {
        if (this.exists(this.preferencesLookup[0])) {
            ((IEclipsePreferences)this.preferencesLookup[0].parent()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferencesLookup[0].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.preferencesLookup[0] = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.exists(this.preferencesLookup[1])) {
            ((IEclipsePreferences)this.preferencesLookup[1].parent()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferencesLookup[1].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.preferencesLookup[1] = DefaultScope.INSTANCE.getNode("org.eclipse.m2e.core");
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
    }

    @Override
    public String getGlobalSettingsFile() {
        return this.getStringPreference("eclipse.m2.globalSettingsFile", null);
    }

    @Override
    public String getUserSettingsFile() {
        return this.getStringPreference("eclipse.m2.userSettingsFile", null);
    }

    @Override
    public String getUserToolchainsFile() {
        return this.getStringPreference("eclipse.m2.userToolchainsFile", null);
    }

    @Override
    public boolean isDebugOutput() {
        return this.getBooleanPreference("eclipse.m2.debugOutput");
    }

    public void setDebugOutput(boolean debug) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.debugOutput", debug);
    }

    @Override
    public boolean isDownloadJavaDoc() {
        return this.getBooleanPreference("eclipse.m2.downloadJavadoc");
    }

    @Override
    public boolean isDownloadSources() {
        return this.getBooleanPreference("eclipse.m2.downloadSources");
    }

    public void setDownloadSources(boolean downloadSources) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.downloadSources", downloadSources);
    }

    public void setDownloadJavadoc(boolean downloadJavadoc) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.downloadJavadoc", downloadJavadoc);
    }

    @Override
    public boolean isHideFoldersOfNestedProjects() {
        return this.getBooleanPreference("eclipse.m2.hideFoldersOfNestedProjects");
    }

    @Override
    public boolean isOffline() {
        return this.getBooleanPreference("eclipse.m2.offline");
    }

    @Override
    public void setUserSettingsFile(String settingsFile) throws CoreException {
        this.setSettingsFile(settingsFile, "eclipse.m2.userSettingsFile");
    }

    @Override
    public void setGlobalSettingsFile(String globalSettingsFile) throws CoreException {
        this.setSettingsFile(globalSettingsFile, "eclipse.m2.globalSettingsFile");
    }

    @Override
    public void setUserToolchainsFile(String settingsFile) throws CoreException {
        this.setSettingsFile(settingsFile, "eclipse.m2.userToolchainsFile");
    }

    private void setSettingsFile(String settingsFile, String preferenceKey) throws CoreException {
        if (settingsFile != null) {
            String string = settingsFile = settingsFile.isBlank() ? null : settingsFile.strip();
        }
        if (!Objects.equals(settingsFile, this.preferencesLookup[0].get(preferenceKey, null))) {
            if (settingsFile != null) {
                this.preferencesLookup[0].put(preferenceKey, settingsFile);
            } else {
                this.preferencesLookup[0].remove(preferenceKey);
            }
            this.preferenceStore.applyPreferences(this.preferencesLookup[0], PREFERENCE_FILTERS);
        }
    }

    @Override
    public boolean isUpdateProjectsOnStartup() {
        return this.getBooleanPreference("eclipse.m2.updateProjects");
    }

    @Override
    public boolean isUpdateIndexesOnStartup() {
        return this.getBooleanPreference("eclipse.m2.updateIndexes");
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public synchronized void addConfigurationChangeListener(IMavenConfigurationChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public synchronized void removeConfigurationChangeListener(IMavenConfigurationChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        MavenConfigurationChangeEvent mavenEvent = new MavenConfigurationChangeEvent(event.getKey(), event.getNewValue(), event.getOldValue());
        for (IMavenConfigurationChangeListener listener : this.listeners) {
            try {
                listener.mavenConfigurationChange(mavenEvent);
            }
            catch (Exception e) {
                log.error("Could not deliver maven configuration change event", (Throwable)e);
            }
        }
    }

    @Override
    public MavenSettingsLocations getSettingsLocations() {
        String configSettingsFile = this.getUserSettingsFile();
        File userSettings = configSettingsFile == null ? SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE : new File(configSettingsFile);
        String configGlobalSettingsFile = this.getGlobalSettingsFile();
        File globalSettings = configGlobalSettingsFile == null ? null : new File(configGlobalSettingsFile);
        return new MavenSettingsLocations(globalSettings, userSettings);
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
        if (event.getChild() == this.preferencesLookup[0] || event.getChild() == this.preferencesLookup[1]) {
            this.init();
        }
    }

    @Override
    public String getGlobalUpdatePolicy() {
        String string = this.getStringPreference("eclipse.m2.globalUpdatePolicy", null);
        if (string == null || "true".equalsIgnoreCase(string)) {
            return "never";
        }
        if ("default".equals(string) || "false".equals(string)) {
            return null;
        }
        return string;
    }

    public void setGlobalUpdatePolicy(String policy) {
        if (policy == null) {
            this.preferencesLookup[0].remove("eclipse.m2.globalUpdatePolicy");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.globalUpdatePolicy", policy);
        }
    }

    @Override
    public String getWorkspaceLifecycleMappingMetadataFile() {
        IPath stateLocation = MavenPluginActivator.getDefault().getStateLocation();
        String defaultValue = stateLocation.append("lifecycle-mapping-metadata.xml").toString();
        return this.getStringPreference("eclipse.m2.WorkspacelifecycleMappingsLocation", defaultValue);
    }

    @Override
    public void setWorkspaceLifecycleMappingMetadataFile(String location) throws CoreException {
        if (location != null) {
            this.preferencesLookup[0].put("eclipse.m2.WorkspacelifecycleMappingsLocation", location);
        } else {
            this.preferencesLookup[0].remove("eclipse.m2.WorkspacelifecycleMappingsLocation");
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], PREFERENCE_FILTERS);
    }

    @Override
    public String getOutOfDateProjectSeverity() {
        return this.getStringPreference("eclipse.m2.problem.outofdateProjectConfig", ProblemSeverity.error.toString());
    }

    public void setOutOfDateProjectSeverity(String severity) throws CoreException {
        if (severity == null) {
            this.preferencesLookup[0].remove("eclipse.m2.problem.outofdateProjectConfig");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.problem.outofdateProjectConfig", severity);
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], PREFERENCE_FILTERS);
    }

    @Override
    public String getGlobalChecksumPolicy() {
        return this.getStringPreference("eclipse.m2.globalChecksumPolicy", null);
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        if (checksumPolicy == null) {
            this.preferencesLookup[0].remove("eclipse.m2.globalChecksumPolicy");
        } else if ("fail".equals(checksumPolicy) || "warn".equals(checksumPolicy) || "ignore".equals(checksumPolicy)) {
            this.preferencesLookup[0].put("eclipse.m2.globalChecksumPolicy", checksumPolicy);
        } else {
            throw new IllegalArgumentException(String.valueOf(checksumPolicy) + " is not a valid checksum policy");
        }
    }

    @Override
    public String getNotCoveredMojoExecutionSeverity() {
        return this.getStringPreference("eclipse.m2.problem.notCoveredMojoExecution", ProblemSeverity.warning.toString());
    }

    public void setNotCoveredMojoExecutionSeverity(String severity) throws CoreException {
        if (severity == null) {
            this.preferencesLookup[0].remove("eclipse.m2.problem.notCoveredMojoExecution");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.problem.notCoveredMojoExecution", severity);
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], PREFERENCE_FILTERS);
    }

    @Override
    public String getOverridingManagedVersionExecutionSeverity() {
        return this.getStringPreference("eclipse.m2.problem.overridingManagedVersion", ProblemSeverity.warning.toString());
    }

    public void setOverridingManagedVersionExecutionSeverity(String severity) throws CoreException {
        if (severity == null) {
            this.preferencesLookup[0].remove("eclipse.m2.problem.overridingManagedVersion");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.problem.overridingManagedVersion", severity);
        }
        this.preferenceStore.applyPreferences(this.preferencesLookup[0], PREFERENCE_FILTERS);
    }

    @Override
    public boolean isAutomaticallyUpdateConfiguration() {
        return this.getBooleanPreference("eclipse.m2.autoUpdateProjects");
    }

    public void setAutomaticallyUpdateConfiguration(boolean value) {
        this.preferencesLookup[0].putBoolean("eclipse.m2.autoUpdateProjects", value);
    }

    @Override
    public void setDefaultMojoExecutionAction(PluginExecutionAction mojoAction) {
        this.preferencesLookup[0].put("eclipse.m2.unkownMojoExecutionAction", mojoAction.name());
    }

    @Override
    public PluginExecutionAction getDefaultMojoExecutionAction() {
        String value = this.getStringPreference("eclipse.m2.unkownMojoExecutionAction", PluginExecutionAction.DEFAULT_ACTION.toString());
        try {
            return PluginExecutionAction.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return PluginExecutionAction.DEFAULT_ACTION;
        }
    }

    @Override
    public boolean buildWithNullSchedulingRule() {
        return this.getBooleanPreference("builderUsesNullSchedulingRule");
    }

    private boolean getBooleanPreference(String key) {
        return Boolean.parseBoolean(this.getStringPreference(key, null));
    }

    private String getStringPreference(String key, String defaultValue) {
        return this.preferenceStore.get(key, defaultValue, (Preferences[])this.preferencesLookup);
    }
}

