/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JButton;

public class RoundButton
extends JButton {
    Shape buttonShape;

    public RoundButton() {
        Dimension size = this.getPreferredSize();
        size.height = 20;
        size.width = 20;
        this.setPreferredSize(size);
        this.setContentAreaFilled(false);
        this.setBorderPainted(true);
        this.setFocusPainted(false);
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getModel().isArmed()) {
            g.setColor(Color.lightGray);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillOval(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHints(renderingHints);
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        g.setColor(this.getBackground());
        g.drawOval(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.buttonShape == null || !this.buttonShape.getBounds().equals(this.getBounds())) {
            this.buttonShape = new Ellipse2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        return this.buttonShape.contains(x, y);
    }
}

