/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import com.gigadevice.pinoutview.pinpackage.BGAPinPanel;
import com.gigadevice.pinoutview.pinpackage.PackageAbstract;
import com.gigadevice.pinoutview.pinpackage.RoundButton;
import com.gigadevice.pinoutview.utils.PinoutUtil;
import com.gigadevice.venustool.GlobalVariables;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;

public class PackageBGA
extends PackageAbstract {
    private int borderWidth = 20;

    @Override
    public void InitPackagePanel() {
        super.InitPackagePanel();
        this.CenterX = 260;
        this.CenterY = 268;
    }

    @Override
    public void UpdatePackagePanel() {
        this.jPanelPackage.removeAll();
        int row = GlobalVariables.GetBGAPinPackageRowNum();
        if (this.PackageViewWidth < 50) {
            this.PackageViewWidth = 50;
        }
        int buttonWidth = this.PackageViewWidth / (row + 2);
        int interval = buttonWidth * 2 / (row - 1);
        this.PackageViewWidth = (buttonWidth + interval) * row - interval;
        this.borderWidth = buttonWidth / 4;
        int extendWidth = this.PackageViewWidth + this.borderWidth * 2;
        this.jPanelPackage.setSize(extendWidth, extendWidth);
        this.jPanelPackage.setLocation(this.CenterX - extendWidth / 2, this.CenterY - extendWidth / 2);
        if (this.RotateNum % 4 != 0) {
            if (this.RotateNum % 4 == 1) {
                int cfr_ignored_0 = extendWidth - this.borderWidth;
            } else if (this.RotateNum % 4 == 2) {
                int cfr_ignored_1 = extendWidth - this.borderWidth;
                int cfr_ignored_2 = extendWidth - this.borderWidth;
            } else if (this.RotateNum % 4 == 3) {
                int cfr_ignored_3 = extendWidth - this.borderWidth;
            }
        }
        Font font = new Font("Arial", 1, buttonWidth / 4);
        this.PinPanels = new BGAPinPanel[GlobalVariables.GetPinPackageNum()];
        PinoutUtil.buttonIndexByName.clear();
        int i = 0;
        while (i < GlobalVariables.GetPinPackageNum()) {
            String PinNumberStr = GlobalVariables.GetPinInfo((int)i).getPinNumberStr();
            if (!PinNumberStr.equals("")) {
                int PinRow = this.getRow(PinNumberStr.replaceAll("[^a-zA-Z]", ""));
                int PinColumn = Integer.parseInt(PinNumberStr.replaceAll("[^0-9]", ""));
                int num = (4 + this.RotateNum) % 4;
                int tx = (buttonWidth + interval) * (PinColumn - 1) - this.PackageViewWidth / 2 + buttonWidth / 2;
                int ty = this.PackageViewWidth / 2 - (buttonWidth + interval) * (PinRow - 1) - buttonWidth / 2;
                List<Integer> result = this.GetRotate(tx, ty, buttonWidth, buttonWidth, num);
                int newX = this.borderWidth + result.get(0) + this.PackageViewWidth / 2;
                int newY = this.borderWidth + this.PackageViewWidth / 2 - result.get(1);
                this.InitButton(i, false, 4, newX, newY, buttonWidth, buttonWidth + interval);
            }
            ++i;
        }
        boolean isFillingArea = false;
        int minFillIndex = 0;
        int maxFillIndex = 0;
        if (GlobalVariables.GetPinPackageNum() == 176) {
            isFillingArea = true;
            minFillIndex = 6;
            maxFillIndex = 10;
        } else if (GlobalVariables.GetPinPackageNum() == 240) {
            isFillingArea = true;
            minFillIndex = 7;
            maxFillIndex = 11;
        }
        if (isFillingArea) {
            int i2 = minFillIndex;
            while (i2 <= maxFillIndex) {
                int j = minFillIndex;
                while (j <= maxFillIndex) {
                    String PinNum = "(" + this.getAlpha(i2) + String.valueOf(j) + ")-VSS-Reset State";
                    RoundButton button = new RoundButton();
                    int num = (4 + this.RotateNum) % 4;
                    int tx = (buttonWidth + interval) * (j - 1) - this.PackageViewWidth / 2 + buttonWidth / 2;
                    int ty = this.PackageViewWidth / 2 - (buttonWidth + interval) * (i2 - 1) - buttonWidth / 2;
                    List<Integer> result = this.GetRotate(tx, ty, buttonWidth, buttonWidth, num);
                    int newX = this.borderWidth + result.get(0) + this.PackageViewWidth / 2;
                    int newY = this.borderWidth + this.PackageViewWidth / 2 - result.get(1);
                    button.setBounds(newX, newY, buttonWidth, buttonWidth);
                    Color colorY = new Color(255, 255, 145);
                    button.setBackground(colorY);
                    button.setToolTipText(PinNum);
                    button.setMargin(new Insets(0, 0, 0, 0));
                    button.setText("VSS");
                    button.setFont(font);
                    this.jPanelPackage.add(button);
                    ++j;
                }
                ++i2;
            }
        }
    }

    private int getRow(String Alpha) {
        switch (Alpha) {
            case "A": {
                return 1;
            }
            case "B": {
                return 2;
            }
            case "C": {
                return 3;
            }
            case "D": {
                return 4;
            }
            case "E": {
                return 5;
            }
            case "F": {
                return 6;
            }
            case "G": {
                return 7;
            }
            case "H": {
                return 8;
            }
            case "J": {
                return 9;
            }
            case "K": {
                return 10;
            }
            case "L": {
                return 11;
            }
            case "M": {
                return 12;
            }
            case "N": {
                return 13;
            }
            case "P": {
                return 14;
            }
            case "R": {
                return 15;
            }
            case "T": {
                return 16;
            }
            case "U": {
                return 17;
            }
        }
        return -1;
    }

    private String getAlpha(int Row) {
        switch (Row) {
            case 1: {
                return "A";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "D";
            }
            case 5: {
                return "E";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "G";
            }
            case 8: {
                return "H";
            }
            case 9: {
                return "J";
            }
            case 10: {
                return "K";
            }
            case 11: {
                return "L";
            }
            case 12: {
                return "M";
            }
            case 13: {
                return "N";
            }
            case 14: {
                return "P";
            }
            case 15: {
                return "R";
            }
            case 16: {
                return "T";
            }
            case 17: {
                return "U";
            }
        }
        return " ";
    }

    private List<Integer> GetRotate(int sx, int sy, int width, int height, int num) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int rx = 0;
        int ry = 0;
        if (num == 0) {
            rx = sx - width / 2;
            ry = sy + height / 2;
        } else if (num == 1) {
            rx = sy - height / 2;
            ry = -sx + width / 2;
        } else if (num == 2) {
            rx = -sx - width / 2;
            ry = -sy + height / 2;
        } else if (num == 3) {
            rx = -sy - height / 2;
            ry = sx + width / 2;
        }
        result.add(rx);
        result.add(ry);
        return result;
    }
}

