/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import com.gigadevice.conflict.NVICConflictExecute;
import com.gigadevice.pinoutview.peritree.PerisTreeView;
import com.gigadevice.pinoutview.pinpackage.BGAPinPanel;
import com.gigadevice.pinoutview.pinpackage.CustomPinSearchPanel;
import com.gigadevice.pinoutview.pinpackage.PinPanel;
import com.gigadevice.pinoutview.utils.PinoutUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.PinFunctionStruct;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.swing.event.MouseInputListener;

public class PackageAbstract {
    public JPanel jPanelPackage;
    public JButton[] buttons;
    public PinPanel[] PinPanels;
    public int PackageFrameWidth = 0;
    public int PackageFrameHeight = 0;
    public int PackageInitWidth = 800;
    public int PackageChangeWidth = 80;
    public int PackageViewWidth = 0;
    public int RotateNum = 0;
    public int CenterX = 400;
    public int CenterY = 300;
    public boolean isTSSOP = false;
    public boolean switchPin = true;
    public String FormFuncSearch = "NULL";

    public void InitPackagePanel() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.PackageInitWidth = dimension.width * 2 / 5;
        this.CenterX = this.PackageInitWidth / 2;
        this.CenterY = dimension.height / 4;
        this.RotateNum = 0;
        PinoutUtil.userPackageLocationManu = false;
        this.jPanelPackage = new JPanel();
        this.jPanelPackage.setBackground(Color.WHITE);
        this.jPanelPackage.setLayout(null);
        Drag drag = new Drag();
        this.jPanelPackage.addMouseListener(drag);
        this.jPanelPackage.addMouseMotionListener(drag);
        this.setPackageViewWidth(this.PackageInitWidth);
        ArrayList<Integer> pinIndexList = new ArrayList<Integer>();
        pinIndexList.add(-1);
        PinoutUtil.PinFunctionMap.put("NULL", pinIndexList);
    }

    public void UpdatePackagePanel() {
    }

    public void InitButton(int Index, boolean insertLabel, int Rotate, int x, int y, int width, int Height) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        if (Rotate == 4) {
            this.PinPanels[Index] = new BGAPinPanel();
            this.PinPanels[Index].setPinName(GD32PinPadObj.getPinName());
        } else {
            this.PinPanels[Index] = new PinPanel(this.isTSSOP);
        }
        this.PinPanels[Index].Init(Index, Rotate, x, y, width, Height);
        this.PinPanels[Index].setPinName(GD32PinPadObj.getPinName());
        this.InitButtonMenuAction(Index);
        this.jPanelPackage.add(this.PinPanels[Index]);
        PinoutUtil.buttonIndexByName.put(GD32PinPadObj.getPinName(), Index);
    }

    public void InitPinSearch(final CustomPinSearchPanel searchPanel) {
        ArrayList<String> PinSearchList = new ArrayList<String>();
        PinSearchList.addAll(PinoutUtil.PinFunctionMap.keySet());
        PinSearchList.addAll(PinoutUtil.PinNameMap.keySet());
        Object[] Functions = PinSearchList.toArray();
        List<Object> functionList = Arrays.asList(Functions);
        searchPanel.updateFunction(functionList);
        searchPanel.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String ItemName;
                    if (!PackageAbstract.this.FormFuncSearch.equals("NULL") && !PackageAbstract.this.FormFuncSearch.equals("")) {
                        List<Integer> PinIndexs;
                        if (PinoutUtil.PinFunctionMap.containsKey(PackageAbstract.this.FormFuncSearch)) {
                            PinIndexs = PinoutUtil.PinFunctionMap.get(PackageAbstract.this.FormFuncSearch);
                            int i = 0;
                            while (i < PinIndexs.size()) {
                                PackageAbstract.this.UpdateButtonState(PinIndexs.get(i));
                                ++i;
                            }
                        } else if (PinoutUtil.PinNameMap.containsKey(PackageAbstract.this.FormFuncSearch)) {
                            PinIndexs = PinoutUtil.PinNameMap.get(PackageAbstract.this.FormFuncSearch);
                            int i = 0;
                            while (i < PinIndexs.size()) {
                                PackageAbstract.this.UpdateButtonState(PinIndexs.get(i));
                                ++i;
                            }
                        }
                    }
                    PackageAbstract.this.FormFuncSearch = ItemName = searchPanel.getComboBox().getSelectedItem().toString();
                    PackageAbstract.this.showSearchButton();
                }
            }
        });
    }

    private void showSearchButton() {
        if (!PinoutUtil.PinFunctionMap.containsKey(this.FormFuncSearch) && !PinoutUtil.PinNameMap.containsKey(this.FormFuncSearch) || this.FormFuncSearch.equals("NULL") || this.FormFuncSearch.equals("")) {
            return;
        }
        List<Object> PinIndexs = new ArrayList();
        if (PinoutUtil.PinFunctionMap.containsKey(this.FormFuncSearch)) {
            PinIndexs = PinoutUtil.PinFunctionMap.get(this.FormFuncSearch);
        } else if (PinoutUtil.PinNameMap.containsKey(this.FormFuncSearch)) {
            PinIndexs = PinoutUtil.PinNameMap.get(this.FormFuncSearch);
        }
        int i = 0;
        while (i < PinIndexs.size()) {
            this.PinPanels[(Integer)PinIndexs.get(i)].setSearchPinState();
            ++i;
        }
    }

    private void setPackageViewWidth(int width) {
        this.PackageViewWidth = width;
    }

    public void InitButtonMenuAction(final int Index) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        final JButton button = this.PinPanels[Index].getPinButton();
        button.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        final String PinNumber = GD32PinPadObj.getPinNumberStr();
        final String PinName = GD32PinPadObj.getPinName();
        this.UpdateButtonState(Index);
        if (GD32PinPadObj.getPinType() == 1 || GD32PinPadObj.isDisablePin()) {
            return;
        }
        final ArrayList<PinFunctionStruct> PinFunctionList = new ArrayList<PinFunctionStruct>();
        final ArrayList<String> disableFunctionList = new ArrayList<String>();
        PinFunctionList.addAll(GD32PinPadObj.getPinFunctionList());
        if (GlobalVariables.GetPinInfoByPinName((String)(String.valueOf(PinName) + "_C")) != null) {
            GD32PinPadObj.setSharedPin(true);
            GD32PinPadObj.setReUsedSharedPin(String.valueOf(PinName) + "_C");
        }
        if (GD32PinPadObj.isSharedPin()) {
            GD32PinPad sharePinPadObj = null;
            if (!GD32PinPadObj.getReSharedPin().equals("") && (sharePinPadObj = GlobalVariables.GetPinInfoByPinName((String)GD32PinPadObj.getReSharedPin())) != null) {
                for (PinFunctionStruct pinFuncObj : sharePinPadObj.getPinFunctionList()) {
                    disableFunctionList.add(pinFuncObj.getPinFunctionName());
                }
                int j = PinFunctionList.size() - 1;
                while (j >= 0) {
                    if (disableFunctionList.contains(((PinFunctionStruct)PinFunctionList.get(j)).getPinFunctionName())) {
                        PinFunctionList.remove(j);
                    }
                    --j;
                }
                if (sharePinPadObj.getPinUsedType() == 0) {
                    disableFunctionList.clear();
                }
                for (PinFunctionStruct pinFuncObj : sharePinPadObj.getPinFunctionList()) {
                    if (pinFuncObj.getPinFunctionName().contains("ADC")) continue;
                    PinFunctionList.add(pinFuncObj);
                }
            }
            if (!GD32PinPadObj.getReUsedSharedPin().equals("") && (sharePinPadObj = GlobalVariables.GetPinInfoByPinName((String)GD32PinPadObj.getReUsedSharedPin())).getPinUsedType() != 0) {
                for (PinFunctionStruct pinFuncObj : PinFunctionList) {
                    disableFunctionList.add(pinFuncObj.getPinFunctionName());
                }
                boolean sign = false;
                String[] functionList = sharePinPadObj.getPinUsedFunctionStr().split(",");
                int i = 0;
                while (i < functionList.length) {
                    if (disableFunctionList.contains(functionList[i])) {
                        sign = true;
                    }
                    ++i;
                }
                if (!sign) {
                    disableFunctionList.clear();
                }
            }
        }
        PinoutUtil.UpdatePinFunctionMap(GD32PinPadObj.getPinFunctionList(), Index);
        PinoutUtil.UpdatePinNameMap(PinName, Index);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu jPopupMenuOne = new JPopupMenu();
                JMenuItem item = new JMenuItem("(" + PinNumber + ")-" + PinName);
                item.setBackground(Color.white);
                item.setEnabled(false);
                jPopupMenuOne.add(item);
                jPopupMenuOne.addSeparator();
                int wordsize = button.getWidth() > button.getHeight() ? button.getWidth() : button.getHeight();
                Font font = new Font("", 1, wordsize / 4);
                JMenuItem itemReset = new JMenuItem("Reset State");
                itemReset.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (GlobalVariables.GetPinInfo((int)Index).getPinUsedType() == 0) {
                            return;
                        }
                        PackageAbstract.this.PinFunctionManualChanged(Index, "Reset", "");
                        PackageAbstract.this.UpdateReSharePinButton(Index);
                    }
                });
                itemReset.setFont(font);
                jPopupMenuOne.add(itemReset);
                int j = 0;
                while (j < PinFunctionList.size()) {
                    block10: {
                        JMenuItem menuItem;
                        block11: {
                            String functionName;
                            block8: {
                                List analogPins;
                                block9: {
                                    functionName = ((PinFunctionStruct)PinFunctionList.get(j)).getPinFunctionName();
                                    final String PeriName = ((PinFunctionStruct)PinFunctionList.get(j)).getPinFunctionPeri();
                                    menuItem = new JMenuItem(functionName);
                                    menuItem.setOpaque(true);
                                    if (disableFunctionList.contains(functionName)) {
                                        menuItem.setEnabled(false);
                                    }
                                    menuItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            if (GlobalVariables.GetPinInfo((int)Index).getGPIOModel() == 1 && GlobalVariables.GetPinInfo((int)Index).checkFunctionUsedInGD32PinPad(functionName)) {
                                                PackageAbstract.this.PinFunctionManualChanged(Index, functionName, PeriName);
                                                PackageAbstract.this.UpdateReSharePinButton(Index);
                                                return;
                                            }
                                            if (functionName.equals(GlobalVariables.GetPinInfo((int)Index).getPinUsedFunctionStr())) {
                                                return;
                                            }
                                            PackageAbstract.this.PinFunctionManualChanged(Index, functionName, PeriName);
                                            PackageAbstract.this.UpdateReSharePinButton(Index);
                                        }
                                    });
                                    if (GlobalVariables.GetPinInfo((int)Index).getGPIOModel() != 1) break block8;
                                    analogPins = GlobalVariables.GetPinInfo((int)Index).getAnalogModeFunctionInPin();
                                    if (!GlobalVariables.GetPinInfo((int)Index).checkFunctionUsedInGD32PinPad(functionName)) break block9;
                                    GD32PinPad child = GlobalVariables.GetPinInfo((int)Index).getChildGD32PinPadByFunction(functionName, "");
                                    if (child == null) break block10;
                                    if (child.getPinUsedType() == 1) {
                                        menuItem.setBackground(PinoutUtil.Color_MANU_SELECTED);
                                    } else {
                                        menuItem.setBackground(PinoutUtil.Color_AUTO_SELECTED);
                                    }
                                    break block11;
                                }
                                if (analogPins.contains(functionName)) {
                                    menuItem.setBackground(PinoutUtil.Color_ANALOG_MODE_PIN);
                                    menuItem.setText("+ " + functionName);
                                }
                                break block11;
                            }
                            if (GlobalVariables.GetPinInfo((int)Index).getGPIOModel() == 0 && GlobalVariables.GetPinInfo((int)Index).checkFunctionUsedInGD32PinPad(functionName)) {
                                if (GlobalVariables.GetPinInfo((int)Index).getPinUsedType() == 1) {
                                    menuItem.setBackground(PinoutUtil.Color_MANU_SELECTED);
                                } else {
                                    menuItem.setBackground(PinoutUtil.Color_AUTO_SELECTED);
                                }
                            }
                        }
                        menuItem.setFont(font);
                        jPopupMenuOne.add(menuItem);
                    }
                    ++j;
                }
                jPopupMenuOne.show(button, 20, 20);
            }
        });
    }

    private void UpdateReSharePinButton(int Index) {
        if (GlobalVariables.GetPinInfo((int)Index).isSharedPin()) {
            GD32PinPad sharePinPadObj = null;
            if (!GlobalVariables.GetPinInfo((int)Index).getReSharedPin().equals("")) {
                sharePinPadObj = GlobalVariables.GetPinInfoByPinName((String)GlobalVariables.GetPinInfo((int)Index).getReSharedPin());
            }
            if (!GlobalVariables.GetPinInfo((int)Index).getReUsedSharedPin().equals("")) {
                sharePinPadObj = GlobalVariables.GetPinInfoByPinName((String)GlobalVariables.GetPinInfo((int)Index).getReUsedSharedPin());
            }
            if (sharePinPadObj != null) {
                JButton reSharePinbutton = this.PinPanels[sharePinPadObj.getPinIndex()].getPinButton();
                reSharePinbutton.removeActionListener(reSharePinbutton.getActionListeners()[0]);
                this.InitButtonMenuAction(sharePinPadObj.getPinIndex());
            }
        }
    }

    private void UpdateButtonState(int Index) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        this.PinPanels[Index].setPinState(GD32PinPadObj);
    }

    private void PinFunctionManualChanged(int Index, String Function2, String PeriName) {
        int result;
        boolean isFinish;
        GlobalVariables.isDirtyFlag = true;
        for (String pinNameStr : PinoutUtil.highlightedPinList) {
            int pinIndex = GlobalVariables.gd32mcuObj.GetPinIndexByPinName(pinNameStr);
            if (pinIndex == -1) continue;
            this.PinPanels[pinIndex].removeHighlightedState();
        }
        PinoutUtil.highlightedPinList.clear();
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        String PinName = GD32PinPadObj.getPinName();
        PinoutUtil.updateManuPinList(Index, Function2, 1);
        if (GD32PinPadObj.getGPIOModel() == 0) {
            this.pinToPeriTreeControlDisable(PinName);
            String formerFunctionStr = GD32PinPadObj.getPinUsedFunctionStr();
            this.setPinFunctionIsReset(GD32PinPadObj, true);
            if (formerFunctionStr.indexOf("EXTI") != -1) {
                NVICConflictExecute.NVICConflictExecuteByPin((String)formerFunctionStr);
            }
            if (Function2.equals("Reset")) {
                this.PinToPeriTreeNodeEnableUpdate();
                return;
            }
        }
        int useType = 1;
        if (GD32PinPadObj.checkFunctionUsedInGD32PinPad(Function2)) {
            useType = 0;
            boolean flag = this.pinFunctionToPeriTreeControlDisable(PinName, Function2, PeriName);
            if (flag) {
                this.PinToPeriTreeNodeEnableUpdate();
                return;
            }
        }
        if ((isFinish = this.prePinFunctionChanged(Index, Function2, useType, PeriName)) || useType == 0) {
            this.PinToPeriTreeNodeEnableUpdate();
            return;
        }
        String RemapValue = GlobalVariables.gd32mcuObj.GetGPIOAFValue(PinName, Function2);
        boolean state = false;
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (GlobalVariables.gd32mcuObj.GetPinIndexByUsedFunc(Function2) == -1 && (result = PinoutUtil.funcIsRelateUniquePeriTreeNode(Function2, objectList)) != -1) {
            GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)RemapValue, (int)1, (String)PeriName);
            PinoutUtil.pinRepaintPeriTree = false;
            state = PinoutUtil.uniqueFuncToChangePeriTree(result, objectList);
            if (state) {
                GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)RemapValue, (int)3, (String)GlobalVariables.GetPinInfo((int)Index).getPinUsedPeri());
            }
        }
        if (!state) {
            this.PinFunctionChanged(Index, Function2, RemapValue, 1, PeriName);
        }
        PinoutUtil.pinRepaintPeriTree = true;
        this.PinToPeriTreeNodeEnableUpdate();
        if (GlobalVariables.gd32mcuObj.getisRemap()) {
            if (!this.switchPin) {
                return;
            }
            List remapResetPinPad = GlobalVariables.gd32mcuObj.getResetPinInEqualRemapGroup(PeriName, Function2, Index);
            if (remapResetPinPad == null) {
                return;
            }
            this.switchPin = false;
            for (GD32PinPad pinPadObj : remapResetPinPad) {
                this.PinFunctionManualChanged(pinPadObj.getPinIndex(), pinPadObj.getPinUsedFunctionStr(), pinPadObj.getPinUsedPeri());
                GlobalVariables.UpdatePinInfo((int)pinPadObj.getPinIndex(), (String)pinPadObj.getPinUsedFunctionStr(), (String)pinPadObj.getRemapAF_Value(), (int)pinPadObj.getPinUsedType(), (String)pinPadObj.getPinUsedPeri());
            }
            this.switchPin = true;
        }
    }

    private void PinFunctionChanged(int Index, String Function2, String AF_Value, int UsedType, String UsedPeri) {
        boolean isFinish;
        GlobalVariables.isDirtyFlag = true;
        if (Index == -1) {
            return;
        }
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        String PinName = GD32PinPadObj.getPinName();
        if (!GlobalVariables.isCubeRoverTest) {
            SwingWorker worker;
            if (GlobalVariables.McuSeletorInfo.getSeries().contains("GD32G553") && PinName.equals("PB8") && !Function2.equals("Reset") && !Function2.contains("BOOT") && UsedType != 0) {
                worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        JOptionPane.showMessageDialog(null, "Warning: When configuring PB8 for a function not BOOT0, you need to configure the FMC_OBCTL register's nSWBT0 bit.", "Option Bytes Configuration Required", 2);
                        return null;
                    }
                };
                worker.execute();
            }
            if (GlobalVariables.McuSeletorInfo.getSeries().contains("GD32C2") && PinName.equals("PA14") && !Function2.equals("Reset") && !Function2.contains("BOOT") && UsedType != 0) {
                worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        JOptionPane.showMessageDialog(null, "Warning: When configuring PA14 for function not BOOT0, you need to configure the FMC_OBCTL register's SWBT0 bit.", "Option Bytes Configuration Required", 2);
                        return null;
                    }
                };
                worker.execute();
            }
        }
        if (isFinish = this.prePinFunctionChanged(Index, Function2, UsedType, UsedPeri)) {
            return;
        }
        String formerFunctionStr = GD32PinPadObj.getPinUsedFunctionStr();
        int formerUseType = GD32PinPadObj.getPinUsedType();
        if (formerUseType != 0 && UsedType != 0 && GD32PinPadObj.checkFunctionUsedInGD32PinPad(Function2)) {
            GD32PinPad child;
            if (GD32PinPadObj.getGPIOModel() == 1 && (child = GlobalVariables.GetPinInfo((int)Index).getChildGD32PinPadByFunction(Function2, UsedPeri)) == null) {
                this.addAnalogFunctionInPin(Index, Function2, UsedType, UsedPeri);
                return;
            }
            PinoutUtil.UpdateGPIOPinInfo(Index, false);
            GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)AF_Value, (int)UsedType, (String)UsedPeri);
            if (UsedType != 0) {
                PinoutUtil.UpdateGPIOPinInfo(Index, true);
            }
            this.UpdateButtonState(Index);
            return;
        }
        if (GD32PinPadObj.getGPIOModel() == 1 && UsedType != 0) {
            this.addAnalogFunctionInPin(Index, Function2, UsedType, UsedPeri);
            return;
        }
        if (UsedType == 0) {
            Function2 = "Reset";
        }
        if (Function2.equals("Reset")) {
            GlobalVariables.UpdatePinInfo((int)Index, (String)"", (String)"", (int)0, (String)"");
            PinoutUtil.UpdateGPIOPinInfo(Index, false);
            this.UpdateButtonState(Index);
            if (formerFunctionStr.indexOf("EXTI") != -1) {
                NVICConflictExecute.NVICConflictExecuteByPin((String)formerFunctionStr);
            }
            return;
        }
        if (Function2.indexOf("GPIO_") == -1) {
            ArrayList<Integer> ResetPinIndexList = new ArrayList<Integer>();
            new ArrayList();
            int formerPinIndex = -1;
            int k = 0;
            while (k < GlobalVariables.GetPinPackageNum()) {
                if (Function2.equals(GlobalVariables.GetPinInfo((int)k).getPinUsedFunctionStr()) && k != Index) {
                    formerPinIndex = k;
                    break;
                }
                ++k;
            }
            if (formerPinIndex != -1) {
                ResetPinIndexList.add(formerPinIndex);
                int OldUsedType = GlobalVariables.GetPinInfo((int)formerPinIndex).getPinUsedType();
                int NewUsedType = UsedType;
                if (UsedType == 1 && (OldUsedType == 2 || OldUsedType == 3)) {
                    NewUsedType = 3;
                }
                PinoutUtil.UpdateGPIOPinInfo(formerPinIndex, false);
                GlobalVariables.UpdatePinInfo((int)formerPinIndex, (String)Function2, (String)"", (int)0, (String)GlobalVariables.GetPinInfo((int)formerPinIndex).getPinUsedPeri());
                GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)AF_Value, (int)NewUsedType, (String)GlobalVariables.GetPinInfo((int)formerPinIndex).getPinUsedPeri());
                this.SwitchFuncInOtherPin(ResetPinIndexList);
                this.UpdateButtonState(Index);
                PinoutUtil.UpdateGPIOPinInfo(Index, true);
                if (Function2.indexOf("EXTI") != -1) {
                    NVICConflictExecute.NVICConflictExecuteByPin((String)formerFunctionStr);
                }
                return;
            }
        }
        GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)AF_Value, (int)UsedType, (String)UsedPeri);
        this.UpdateButtonState(Index);
        PinoutUtil.UpdateGPIOPinInfo(Index, true);
        if (Function2.indexOf("EXTI") != -1) {
            NVICConflictExecute.NVICConflictExecuteByPin((String)formerFunctionStr);
        }
    }

    private boolean prePinFunctionChanged(int Index, String Function2, int UsedType, String UsedPeri) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        boolean resetPin = false;
        boolean isAddAnalogFunction = false;
        boolean isFinish = false;
        if (GlobalVariables.isAnalogMode) {
            if (GlobalVariables.checkFunctionIsAnalogMode((String)Function2)) {
                if (GD32PinPadObj.getPinUsedType() == 0) {
                    isAddAnalogFunction = true;
                    resetPin = false;
                } else if (GD32PinPadObj.getGPIOModel() == 1) {
                    if (GD32PinPadObj.checkFunctionUsedInGD32PinPad(Function2) && UsedType == 0) {
                        this.deleteAnalogFunctionInPin(Index, Function2, UsedPeri);
                        isFinish = true;
                        return isFinish;
                    }
                    resetPin = false;
                } else if (GD32PinPadObj.getGPIOModel() == 0) {
                    isAddAnalogFunction = true;
                    resetPin = true;
                }
            } else if (GD32PinPadObj.getGPIOModel() == 1) {
                this.removeAllAnalogFunctionInPin(Index);
                resetPin = false;
            }
        }
        if (UsedType == 0) {
            resetPin = true;
            isFinish = true;
        }
        if (resetPin) {
            GD32PinPadObj.putPinUsedType(0);
            this.setPinFunctionIsReset(GD32PinPadObj, true);
        }
        if (isAddAnalogFunction) {
            GD32PinPadObj.setGPIOModel(1);
        }
        return isFinish;
    }

    private void setPinFunctionIsReset(GD32PinPad GD32PinPadObj, boolean isChangePeriTree) {
        PinoutUtil.UpdateGPIOPinInfo(GD32PinPadObj.getPinIndex(), false);
        GlobalVariables.UpdatePinInfo((int)GD32PinPadObj.getPinIndex(), (String)"", (String)"", (int)0, (String)"");
        this.UpdateButtonState(GD32PinPadObj.getPinIndex());
        if (isChangePeriTree) {
            this.pinToPeriTreeControlDisable(GD32PinPadObj.getPinName());
        }
    }

    private void addAnalogFunctionInPin(int Index, String Function2, int UsedType, String PeriName) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        String PinName = GD32PinPadObj.getPinName();
        String RemapValue = GlobalVariables.gd32mcuObj.GetGPIOAFValue(PinName, Function2);
        PinoutUtil.UpdateGPIOPinInfo(GD32PinPadObj, false);
        if (GD32PinPadObj.getPinUsedType() == 0) {
            GD32PinPadObj.setGPIOModel(1);
            GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)RemapValue, (int)UsedType, (String)PeriName);
        } else {
            GlobalVariables.UpdatePinInfo((int)Index, (String)Function2, (String)RemapValue, (int)UsedType, (String)PeriName);
        }
        PinoutUtil.UpdateGPIOPinInfo(GD32PinPadObj, true);
        this.UpdateButtonState(Index);
    }

    private void deleteAnalogFunctionInPin(int Index, String Function2, String PeriName) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        PinoutUtil.UpdateGPIOPinInfo(GD32PinPadObj, false);
        GD32PinPad child = GD32PinPadObj.getChildGD32PinPadByFunction(Function2, PeriName);
        if (child == null) {
            return;
        }
        GD32PinPadObj.removeChildGD32PinPadByFunction(Function2, PeriName);
        GD32PinPadObj.updateGD32PinPadInfo();
        PinoutUtil.UpdateGPIOPinInfo(GD32PinPadObj, true);
        this.pinFunctionToPeriTreeControlDisable(GD32PinPadObj.getPinName(), Function2, PeriName);
        this.UpdateButtonState(Index);
    }

    private void removeAllAnalogFunctionInPin(int Index) {
        GD32PinPad GD32PinPadObj = GlobalVariables.GetPinInfo((int)Index);
        String PinName = GD32PinPadObj.getPinName();
        PinoutUtil.UpdateGPIOPinInfo(GD32PinPadObj, false);
        List ChildGD32PinPads = GD32PinPadObj.getChildGD32PinPads();
        int i = ChildGD32PinPads.size() - 1;
        while (i >= 0) {
            GD32PinPad child = (GD32PinPad)ChildGD32PinPads.get(i);
            GD32PinPadObj.removeChildGD32PinPadByFunction(child.getPinUsedFunctionStr(), "");
            --i;
        }
        GD32PinPadObj.updateGD32PinPadInfo();
        this.pinToPeriTreeControlDisable(PinName);
        this.UpdateButtonState(Index);
    }

    public void SwitchFuncInOtherPin(List<Integer> ResetPinIndexList) {
        int i = 0;
        while (i < ResetPinIndexList.size()) {
            int Index = ResetPinIndexList.get(i);
            String OldPinName = GlobalVariables.GetPinInfo((int)Index).getPinName();
            String Function2 = GlobalVariables.GetPinInfo((int)Index).getPinUsedFunctionStr();
            String NewPinName = GlobalVariables.gd32mcuObj.GetPinNameByUsedFunc(Function2);
            if (NewPinName.equals("")) {
                return;
            }
            PinoutUtil.pinPeritreeRelateMapUpdate(OldPinName, NewPinName);
            GlobalVariables.UpdatePinInfo((int)Index, (String)"", (String)"", (int)0, (String)"");
            this.UpdateButtonState(Index);
            ++i;
        }
    }

    private boolean pinToPeriTreeControlDisable(String PinName) {
        if (PinoutUtil.pinPeritreeRelateMap.containsKey(PinName)) {
            List<NodeStruct> nodeList = PinoutUtil.pinPeritreeRelateMap.get(PinName);
            int i = nodeList.size() - 1;
            while (i >= 0) {
                NodeStruct nodeObj = nodeList.get(i);
                PinoutUtil.pinPeritreeRelateMapDelete(PinName, nodeObj);
                if (nodeObj.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                    PerisTreeView.pinSelecteToCheckboxChanged(nodeObj, "false");
                } else {
                    NodeStruct widgetObj = nodeObj;
                    LinkedHashMap mapItem = widgetObj.getItems();
                    Iterator iterator = mapItem.keySet().iterator();
                    if (iterator.hasNext()) {
                        String itemStr = (String)iterator.next();
                        PerisTreeView.pinSelecteToComboxChanged(nodeObj, itemStr);
                    }
                }
                --i;
            }
            return true;
        }
        return false;
    }

    private boolean pinFunctionToPeriTreeControlDisable(String PinName, String Function2, String PeriName) {
        boolean isChangePeriTree = false;
        if (PinoutUtil.pinPeritreeRelateMap.containsKey(PinName)) {
            List<NodeStruct> nodeList = PinoutUtil.pinPeritreeRelateMap.get(PinName);
            int i = nodeList.size() - 1;
            while (i >= 0) {
                NodeStruct nodeObj = nodeList.get(i);
                String periName = ControlConflict.getModuleByNode((NodeStruct)nodeObj).getNodeName();
                if (periName.contains(PeriName)) {
                    List usedFuncList;
                    if (nodeObj.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                        usedFuncList = nodeObj.getFunctionLst();
                    } else {
                        Object object = ControlConflict.getPeriTreeNode((String)periName, (String)nodeObj.getNodeName(), (String)nodeObj.getValue(), (String)"Item");
                        ItemStruct itemObj = (ItemStruct)object;
                        usedFuncList = itemObj.getFunctionLst();
                    }
                    if (usedFuncList.contains(Function2)) {
                        isChangePeriTree = true;
                        if (nodeObj.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                            PerisTreeView.pinSelecteToCheckboxChanged(nodeObj, "false");
                        } else {
                            PerisTreeView.pinSelecteToComboxChanged(nodeObj, "Disable");
                        }
                    }
                }
                --i;
            }
        }
        return isChangePeriTree;
    }

    public void ResetPinList(List<GD32PinPad> ResetPinList) {
        int i = 0;
        while (i < ResetPinList.size()) {
            int Index = ResetPinList.get(i).getPinIndex();
            this.PinFunctionChanged(Index, ResetPinList.get(i).getPinUsedFunctionStr(), "", 0, ResetPinList.get(i).getPinUsedPeri());
            ++i;
        }
    }

    public void ResetPinandButtonStatus(int Index) {
        this.PinFunctionChanged(Index, "Reset", "", 0, "");
    }

    public void UpdatePinList(List<GD32PinPad> pUpdatePinList) {
        int i = 0;
        while (i < pUpdatePinList.size()) {
            int Index = -1;
            Index = PinoutUtil.buttonIndexByName.get(pUpdatePinList.get(i).getPinName());
            if (Index != -1) {
                GD32PinPad GD32PinPadObj = pUpdatePinList.get(i);
                this.PinFunctionChanged(Index, GD32PinPadObj.getPinUsedFunctionStr(), GD32PinPadObj.getRemapAF_Value(), GD32PinPadObj.getPinUsedType(), GD32PinPadObj.getPinUsedPeri());
            }
            ++i;
        }
    }

    private void PinToPeriTreeNodeEnableUpdate() {
        if (PinoutUtil.pinRepaintPeriTree) {
            PerisTreeView.tableUIRepaint();
        }
    }

    public void updateAllUnusedPintoUsed(String mode) {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.GetPinInfo((int)i);
            if (pinPadObj != null) {
                int useType = pinPadObj.getPinUsedType();
                if (mode.equals("Reset")) {
                    if (useType == 4) {
                        GlobalVariables.GetPinInfo((int)i).putPinUsedType(1);
                        this.PinFunctionManualChanged(i, mode, "");
                    }
                } else if (pinPadObj.checkFunctionExistInGD32PinPad(mode) && (useType == 0 || useType == 4)) {
                    this.PinFunctionManualChanged(i, mode, "GPIO");
                    GlobalVariables.GetPinInfo((int)i).putPinUsedType(4);
                }
            }
            ++i;
        }
        if (!mode.equals("Reset")) {
            this.PackageOper(5);
        }
    }

    public void PackageOper(int Type2) {
        switch (Type2) {
            case 0: {
                this.PackageViewWidth += this.PackageChangeWidth;
                this.PackageViewWidth = (int)((double)this.PackageViewWidth * 1.1);
                PinoutUtil.userPackageLocationManu = true;
                break;
            }
            case 1: {
                if (this.PackageViewWidth <= 100) break;
                this.PackageViewWidth -= this.PackageChangeWidth;
                this.PackageViewWidth = (int)((double)this.PackageViewWidth * 0.9);
                PinoutUtil.userPackageLocationManu = true;
                break;
            }
            case 2: {
                this.PackageInitWidth = this.PackageFrameWidth > this.PackageFrameHeight ? this.PackageFrameHeight : this.PackageFrameWidth;
                String PackageType = GlobalVariables.McuSeletorInfo.getPackageType();
                this.PackageInitWidth = PackageType.contains("BGA") || PackageType.contains("WLCSP") ? this.PackageInitWidth * 5 / 6 : (PackageType.equals("LQFP100") || PackageType.equals("LQFP128") || PackageType.equals("LQFP144") || PackageType.equals("LQFP176") ? (this.PackageInitWidth += this.PackageInitWidth * 3 / 5) : (this.PackageInitWidth += this.PackageInitWidth / 4));
                this.PackageViewWidth = this.PackageInitWidth;
                this.CenterX = this.PackageFrameWidth / 2;
                this.CenterY = this.PackageFrameHeight / 2 - 40;
                this.RotateNum = 0;
                PinoutUtil.userPackageLocationManu = false;
                break;
            }
            case 3: {
                --this.RotateNum;
                if (this.RotateNum != -4) break;
                this.RotateNum = 0;
                break;
            }
            case 4: {
                ++this.RotateNum;
                if (this.RotateNum != 4) break;
                this.RotateNum = 0;
                break;
            }
        }
        this.UpdatePackagePanel();
        this.showSearchButton();
        this.jPanelPackage.updateUI();
        this.jPanelPackage.repaint();
    }

    class Drag
    implements MouseInputListener {
        public int PackageX = 0;
        public int PackageY = 0;
        public int xinit = 0;
        public int yinit = 0;
        public int xnew = 0;
        public int ynew = 0;

        Drag() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.xinit = e.getX();
            this.yinit = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.xnew = e.getX();
            this.ynew = e.getY();
            this.PackageX = this.xnew - this.xinit + PackageAbstract.this.jPanelPackage.getX();
            this.PackageY = this.ynew - this.yinit + PackageAbstract.this.jPanelPackage.getY();
            PackageAbstract.this.CenterX = this.PackageX + PackageAbstract.this.jPanelPackage.getWidth() / 2;
            PackageAbstract.this.CenterY = this.PackageY + PackageAbstract.this.jPanelPackage.getHeight() / 2;
            PackageAbstract.this.jPanelPackage.setBounds(this.PackageX, this.PackageY, PackageAbstract.this.jPanelPackage.getWidth(), PackageAbstract.this.jPanelPackage.getHeight());
            PinoutUtil.userPackageLocationManu = true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.xnew = e.getX();
            this.ynew = e.getY();
            this.PackageX = this.xnew - this.xinit + PackageAbstract.this.jPanelPackage.getX();
            this.PackageY = this.ynew - this.yinit + PackageAbstract.this.jPanelPackage.getY();
            PackageAbstract.this.jPanelPackage.setBounds(this.PackageX, this.PackageY, PackageAbstract.this.jPanelPackage.getWidth(), PackageAbstract.this.jPanelPackage.getHeight());
            PinoutUtil.userPackageLocationManu = true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

