/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview.pinpackage;

import com.gigadevice.pinoutview.utils.PinoutUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class CustomPinSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static JComboBox<String> comboBox;
    static CustomComboBoxModel<String> comboBoxModel;
    static List<String> functionList;

    static {
        functionList = new ArrayList<String>();
    }

    public CustomPinSearchPanel() {
        this.setLayout(null);
    }

    public void updateFunction(List<Object> functions) {
        functionList.clear();
        comboBoxModel = new CustomComboBoxModel();
        for (Object str : functions) {
            comboBoxModel.addElement((String)str);
            functionList.add((String)str);
        }
        comboBox = new JComboBox<String>(comboBoxModel);
        comboBox.setBounds(5, 2, 110, 25);
        comboBox.setEditable(true);
        comboBox.setBackground(Color.white);
        Border border = BorderFactory.createLineBorder(PinoutUtil.Color_Foreground);
        comboBox.setBorder(border);
        comboBox.setForeground(PinoutUtil.Color_Foreground);
        CustomComboBoxEditor editor = new CustomComboBoxEditor();
        comboBox.setEditor(editor);
        this.setBackground(Color.white);
        this.add(comboBox);
    }

    public JComboBox<String> getComboBox() {
        return comboBox;
    }

    private static class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private JTextField editorComponent;

        public CustomComboBoxEditor() {
            this.editorComponent = this.editor;
            this.editor.setForeground(PinoutUtil.Color_Foreground);
            this.editorComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.filterItems(editorComponent.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.filterItems(editorComponent.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.filterItems(editorComponent.getText());
                }
            });
        }

        private void filterItems(String text) {
            if (!text.equals("")) {
                comboBoxModel.setSelectedItem(text);
                comboBoxModel.removeAllElements();
            }
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < functionList.size()) {
                String item = functionList.get(i);
                if (item.toLowerCase().contains(text.toLowerCase())) {
                    items.add(item);
                }
                ++i;
            }
            for (String str : items) {
                comboBoxModel.addElement(str);
            }
            if (text.equals("")) {
                comboBoxModel.setSelectedItem(text);
            }
            comboBox.hidePopup();
            comboBox.showPopup();
        }
    }

    private static class CustomComboBoxModel<E>
    extends DefaultComboBoxModel<E> {
        private static final long serialVersionUID = 1L;
        private List<E> items = new ArrayList();

        private CustomComboBoxModel() {
        }

        @Override
        public void addElement(E item) {
            if (!this.items.contains(item)) {
                this.items.add(item);
            }
        }

        @Override
        public void removeAllElements() {
            this.items.clear();
        }

        @Override
        public E getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }
    }
}

