/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.pinoutview;

import com.gigadevice.pinoutview.pinpackage.CustomPinSearchPanel;
import com.gigadevice.pinoutview.pinpackage.PackageAbstract;
import com.gigadevice.pinoutview.pinpackage.PackageBGA;
import com.gigadevice.pinoutview.pinpackage.PackageLQFP;
import com.gigadevice.pinoutview.pinpackage.PackageQFN;
import com.gigadevice.pinoutview.pinpackage.PackageTSSOP;
import com.gigadevice.pinoutview.utils.PinoutUtil;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PinoutView {
    static String PackageType;
    static int PackageCount;

    static {
        PackageCount = 0;
    }

    public static JComponent createPartControl() {
        String Package;
        JPanel pinoutPanel = new JPanel(false);
        pinoutPanel.setBackground(Color.white);
        pinoutPanel.setLayout(new BorderLayout());
        JPanel pinPanel = new JPanel();
        pinPanel.setBackground(Color.WHITE);
        pinPanel.setLayout(null);
        if (GlobalVariables.McuSeletorInfo.getMCUPart() == null) {
            return pinPanel;
        }
        String PartNumber = GlobalVariables.McuSeletorInfo.getMCUPart();
        String PackageType = GlobalVariables.McuSeletorInfo.getPackageType();
        GlobalVariables.UpdateSeriesPath();
        if (GlobalVariables.isInitProject) {
            GlobalVariables.gd32mcuObj.InitMcuObj(GlobalVariables.SeriesPath, PartNumber, PackageType);
            GlobalVariables.isInitProject = false;
        }
        switch (Package = PackageType.replaceAll("[^a-zA-Z]", "")) {
            case "LQFP": {
                PinoutUtil.packageAbstract = new PackageLQFP();
                break;
            }
            case "LGA": 
            case "QFN": {
                PinoutUtil.packageAbstract = new PackageQFN();
                break;
            }
            case "SOP": 
            case "TSSOP": {
                PinoutUtil.packageAbstract = new PackageTSSOP();
                break;
            }
            case "BGA": 
            case "WLCSP": {
                PinoutUtil.packageAbstract = new PackageBGA();
                break;
            }
            default: {
                PinoutUtil.packageAbstract = new PackageAbstract();
            }
        }
        PinoutUtil.packageAbstract.InitPackagePanel();
        PinoutUtil.packageAbstract.UpdatePackagePanel();
        JPanel FunPanel = new JPanel();
        FunPanel.setLayout(new BorderLayout());
        int preWidth = 500;
        int preHeight = 50;
        FunPanel.setPreferredSize(new Dimension(preWidth, preHeight));
        FunPanel.setBackground(Color.white);
        FunPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel leftPanel = new JPanel();
        leftPanel.setBackground(Color.white);
        leftPanel.setLayout(new FlowLayout(0, 10, 12));
        JLabel seletorLabel = new JLabel("<html>" + GlobalVariables.McuSeletorInfo.getMCUPart() + "<br>" + PackageType + "</html>");
        seletorLabel.setFont(new Font("Arial", 1, 16));
        seletorLabel.setForeground(PinoutUtil.Color_Foreground);
        leftPanel.add(seletorLabel);
        FunPanel.add((Component)leftPanel, "West");
        JPanel centerPanel = new JPanel();
        centerPanel.setBackground(Color.white);
        centerPanel.setLayout(new FlowLayout(1, 5, 2));
        PinoutView.InitPackageOperButton(centerPanel, PinoutUtil.packageAbstract);
        FunPanel.add((Component)centerPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new FlowLayout(2, 5, 12));
        rightPanel.setBackground(Color.white);
        JLabel label = new JLabel("Search: ");
        label.setFont(new Font("Arial", 1, 15));
        label.setForeground(PinoutUtil.Color_Foreground);
        rightPanel.add(label);
        CustomPinSearchPanel searchPanel = new CustomPinSearchPanel();
        searchPanel.setPreferredSize(new Dimension(120, 30));
        rightPanel.add(searchPanel);
        FunPanel.add((Component)rightPanel, "East");
        PinoutUtil.packageAbstract.InitPinSearch(searchPanel);
        pinoutPanel.add((Component)FunPanel, "North");
        JButton pinoutButton = new JButton("Function Suite");
        pinoutButton.setFont(new Font("Arial", 1, 14));
        pinoutButton.setPreferredSize(new Dimension(150, 30));
        pinoutButton.setBackground(Color.white);
        PinoutView.addFunctionSuiteItem(pinoutButton);
        rightPanel.add(pinoutButton);
        pinPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() == 1) {
                    PinoutUtil.packageAbstract.PackageOper(1);
                } else if (e.getWheelRotation() == -1) {
                    PinoutUtil.packageAbstract.PackageOper(0);
                }
            }
        });
        pinPanel.add(PinoutUtil.packageAbstract.jPanelPackage);
        JPanel panelEAST = new JPanel();
        panelEAST.setBackground(Color.white);
        pinoutPanel.add((Component)panelEAST, "East");
        JPanel panelWEST = new JPanel();
        panelWEST.setBackground(Color.white);
        pinoutPanel.add((Component)panelWEST, "West");
        pinoutPanel.add((Component)pinPanel, "Center");
        JPanel panelSOUTH = new JPanel();
        panelSOUTH.setBackground(Color.white);
        pinoutPanel.add((Component)panelSOUTH, "South");
        PinoutView.AddTipsInfo(panelSOUTH);
        return pinoutPanel;
    }

    protected static void AddTipsInfo(JPanel jpanel) {
        JPanel tipInfoPanel = new JPanel(new BorderLayout());
        tipInfoPanel.setBackground(Color.white);
        JPanel tipContentPanel = new JPanel();
        tipContentPanel.setBackground(Color.white);
        final JPanel buttonLabelPanel = new JPanel();
        buttonLabelPanel.setBackground(Color.white);
        tipInfoPanel.add((Component)tipContentPanel, "East");
        tipContentPanel.add(buttonLabelPanel);
        ArrayList<String> buttonTipsTexts = new ArrayList<String>();
        buttonTipsTexts.add("Green(Auto Select) represents the pins associated with the pinout function, which support automatic and manual assignment.");
        buttonTipsTexts.add("Yellow(Manu Select) represents the pins that are not associated with the pinout function and only support manual assignment.");
        buttonTipsTexts.add("Blue(Power Pin) represents non-configurable pins.");
        buttonTipsTexts.add("Gray(Analog Mode) represents configurable pins.");
        buttonTipsTexts.add("Batch Auto Assignment represents set all unused pins to GPIO mode.");
        ArrayList<Color> colorList = new ArrayList<Color>();
        colorList.add(PinoutUtil.Color_AUTO_SELECTED);
        colorList.add(PinoutUtil.Color_MANU_SELECTED);
        colorList.add(PinoutUtil.Color_POWER_PIN);
        colorList.add(PinoutUtil.Color_ANALOG_MODE_PIN);
        colorList.add(PinoutUtil.Color_UNUSED_AUTO_USED);
        ArrayList<String> labelTexts = new ArrayList<String>();
        labelTexts.add("Auto Select");
        labelTexts.add("Manu Select");
        labelTexts.add("Power Pin");
        labelTexts.add("Analog Mode");
        labelTexts.add("Batch Auto");
        int i = 0;
        while (i < buttonTipsTexts.size()) {
            JButton button0 = new JButton();
            button0.setBackground((Color)colorList.get(i));
            button0.setPreferredSize(new Dimension(10, 10));
            button0.setToolTipText((String)buttonTipsTexts.get(i));
            buttonLabelPanel.add(button0);
            JLabel label0 = new JLabel();
            label0.setPreferredSize(new Dimension(80, 15));
            label0.setText((String)labelTexts.get(i));
            buttonLabelPanel.add(label0);
            ++i;
        }
        String Path2 = GeneralPathUtil.ResourcePath;
        final JButton buttonOpenTips = new JButton();
        buttonOpenTips.setText("Open");
        buttonOpenTips.setBackground(Color.white);
        buttonOpenTips.setPreferredSize(new Dimension(30, 15));
        ImageIcon icon = new ImageIcon(String.valueOf(Path2) + "icons" + File.separator + "PackageOper" + File.separator + "OpenTip.png");
        Image image = icon.getImage();
        int n = buttonOpenTips.getPreferredSize().width;
        int n2 = buttonOpenTips.getPreferredSize().height;
        icon.getImage();
        Image temp = image.getScaledInstance(n, n2, 1);
        icon.setImage(temp);
        buttonOpenTips.setIcon(icon);
        buttonOpenTips.setBorderPainted(false);
        buttonOpenTips.setVisible(false);
        final JButton buttonCloseTips = new JButton();
        buttonCloseTips.setText("Close");
        buttonCloseTips.setBackground(Color.white);
        buttonCloseTips.setPreferredSize(new Dimension(30, 14));
        ImageIcon icon1 = new ImageIcon(String.valueOf(Path2) + "icons" + File.separator + "PackageOper" + File.separator + "CloseTip.png");
        Image image2 = icon.getImage();
        int n3 = buttonCloseTips.getPreferredSize().width;
        int n4 = buttonCloseTips.getPreferredSize().height;
        icon.getImage();
        Image temp1 = image2.getScaledInstance(n3, n4, 1);
        icon.setImage(temp1);
        buttonCloseTips.setIcon(icon1);
        buttonCloseTips.setBorderPainted(false);
        tipContentPanel.add(buttonOpenTips);
        tipContentPanel.add(buttonCloseTips);
        buttonOpenTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonLabelPanel.setVisible(true);
                buttonCloseTips.setVisible(true);
                buttonOpenTips.setVisible(false);
            }
        });
        buttonCloseTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonLabelPanel.setVisible(false);
                buttonCloseTips.setVisible(false);
                buttonOpenTips.setVisible(true);
            }
        });
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)tipInfoPanel, "South");
    }

    protected static void InitPackageOperButton(JPanel jpanel, PackageAbstract PackageObj) {
        int buttonSize = 50;
        int buttonGap = 5;
        JPanel OperPanel = new JPanel(new FlowLayout(1, buttonGap, 0));
        OperPanel.setBackground(Color.white);
        PinoutView.AddOperButton(OperPanel, PackageObj, "Magnify.png", 0, buttonSize, "Package Magnify");
        PinoutView.AddOperButton(OperPanel, PackageObj, "Shrink.png", 1, buttonSize, "Package Shrink");
        PinoutView.AddOperButton(OperPanel, PackageObj, "Common.png", 2, buttonSize, "Default Package Display");
        PinoutView.AddOperButton(OperPanel, PackageObj, "leftRotate.png", 3, buttonSize, "Package Left Rotate");
        PinoutView.AddOperButton(OperPanel, PackageObj, "rightRotate.png", 4, buttonSize, "Package Right Rotate");
        jpanel.add(OperPanel);
    }

    private static void AddOperButton(JPanel OperPanel, final PackageAbstract PackageObj, String PicturePath, final int OperType, int buttonSize, String tooltip) {
        String Path2 = GeneralPathUtil.ResourcePath;
        JButton button = new JButton();
        button.setPreferredSize(new Dimension(buttonSize, buttonSize));
        button.setBackground(Color.white);
        ImageIcon icon = new ImageIcon(String.valueOf(Path2) + "icons" + File.separator + "PackageOper" + File.separator + PicturePath);
        Image image = icon.getImage();
        icon.getImage();
        Image temp = image.getScaledInstance(buttonSize, buttonSize, 1);
        icon.setImage(temp);
        button.setIcon(icon);
        button.setBorderPainted(false);
        button.setToolTipText(tooltip);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageObj.PackageOper(OperType);
            }
        });
        OperPanel.add(button);
    }

    public static void updatePackageShow(int width, int height) {
        if (PinoutUtil.userPackageLocationManu) {
            return;
        }
        PinoutUtil.packageAbstract.PackageFrameWidth = width;
        PinoutUtil.packageAbstract.PackageFrameHeight = height;
        PinoutUtil.packageAbstract.PackageOper(2);
    }

    public static void updatePackageUI() {
        PinoutUtil.packageAbstract.PackageOper(5);
    }

    private static void addFunctionSuiteItem(final JButton pinoutButton) {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item_ExportPinoutFunction = new JMenuItem("Export Pinout Functions");
        JCheckBoxMenuItem item_AllowAutoChangePinPlace = new JCheckBoxMenuItem("Allow Auto Change Pin Place");
        JCheckBoxMenuItem item_ShowUserLabel = new JCheckBoxMenuItem("Show User Label");
        JMenuItem item_SetUnusedPins = new JMenuItem("Set unused Pins");
        item_ExportPinoutFunction.setBackground(Color.white);
        item_AllowAutoChangePinPlace.setBackground(Color.white);
        item_ShowUserLabel.setBackground(Color.white);
        item_SetUnusedPins.setBackground(Color.white);
        item_AllowAutoChangePinPlace.setSelected(GlobalVariables.isAllowChangePinPlace);
        item_ShowUserLabel.setSelected(GlobalVariables.isShowUserLabel);
        item_ExportPinoutFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block15: {
                    PinoutUtil.packageAbstract.jPanelPackage.setCursor(new Cursor(3));
                    try {
                        int overwriteChoice;
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setDialogTitle("Save Pinout Information as CSV");
                        FileNameExtensionFilter filter = new FileNameExtensionFilter("CSV Files (*.csv)", "csv");
                        fileChooser.setFileFilter(filter);
                        fileChooser.setSelectedFile(new File(String.valueOf(GlobalVariables.McuSeletorInfo.getMCUPart()) + "_PINOUT.csv"));
                        int userSelection = fileChooser.showSaveDialog(null);
                        if (userSelection != 0) break block15;
                        File fileToSave = fileChooser.getSelectedFile();
                        if (!fileToSave.getAbsolutePath().toLowerCase().endsWith(".csv")) {
                            fileToSave = new File(String.valueOf(fileToSave.getAbsolutePath()) + ".csv");
                        }
                        if (fileToSave.exists() && (overwriteChoice = JOptionPane.showOptionDialog(null, "File " + fileToSave.getAbsolutePath() + " already exists. Do you want to overwrite it?", "File Already Exists", 0, 2, null, new Object[]{"OK", "NO"}, "OK")) != 0) {
                            return;
                        }
                        try {
                            FileWriter csvWriter = new FileWriter(fileToSave);
                            csvWriter.append("Pin Number,Pin Name,Type,Function,User Label\n");
                            List pins = GlobalVariables.gd32mcuObj.GD32PinPads;
                            for (GD32PinPad pin : pins) {
                                String functionStr;
                                String userLabel = "";
                                int index = GPIOInfoUtil.getConfigColIndex((String)"UserLabel");
                                if (index > 0) {
                                    for (String key : GPIOInfoUtil.GPIOConfigInfoMap.keySet()) {
                                        Map GPIOTableDataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(key);
                                        for (String PinName : GPIOTableDataMap.keySet()) {
                                            Vector vector;
                                            if (!PinName.equals(pin.getPinName()) || (vector = (Vector)GPIOTableDataMap.get(PinName)).size() <= index) continue;
                                            userLabel = (String)vector.get(index);
                                        }
                                    }
                                }
                                if ((functionStr = pin.getPinUsedFunctionStr()).contains(",")) {
                                    functionStr = functionStr.replace(",", "/");
                                }
                                csvWriter.append(pin.getPinNumberStr()).append(",").append(pin.getPinName()).append(",").append(pin.getPinTypeStr()).append(",").append(functionStr).append(",").append(userLabel).append("\n");
                            }
                            csvWriter.flush();
                            csvWriter.close();
                            Object[] options = new Object[]{"OK", "Open Folder"};
                            int choice = JOptionPane.showOptionDialog(null, "Pinout information successfully exported to " + fileToSave.getAbsolutePath(), "Export Successful", 1, 1, null, options, options[0]);
                            if (choice != 1) break block15;
                            try {
                                Desktop desktop = Desktop.getDesktop();
                                desktop.open(fileToSave.getParentFile());
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(null, "Could not open folder: " + ex.getMessage(), "Error", 0);
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "Error exporting pinout information: " + ex.getMessage(), "Export Error", 0);
                        }
                    }
                    finally {
                        PinoutUtil.packageAbstract.jPanelPackage.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        item_AllowAutoChangePinPlace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem checkBoxItem = (JCheckBoxMenuItem)e.getSource();
                boolean isSelected = checkBoxItem.isSelected();
                if (isSelected != GlobalVariables.isAllowChangePinPlace) {
                    GlobalVariables.isAllowChangePinPlace = isSelected;
                }
            }
        });
        item_ShowUserLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem checkBoxItem = (JCheckBoxMenuItem)e.getSource();
                boolean isSelected = checkBoxItem.isSelected();
                if (isSelected != GlobalVariables.isShowUserLabel) {
                    GlobalVariables.isShowUserLabel = isSelected;
                    PinoutView.updatePackageUI();
                }
            }
        });
        item_SetUnusedPins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PinoutView.showSetUnusedPinsDialog();
            }
        });
        popupMenu.add(item_ExportPinoutFunction);
        popupMenu.add(item_AllowAutoChangePinPlace);
        popupMenu.add(item_ShowUserLabel);
        popupMenu.add(item_SetUnusedPins);
        pinoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.show(pinoutButton, 0, pinoutButton.getHeight());
            }
        });
    }

    private static void showSetUnusedPinsDialog() {
        final JDialog dialog = new JDialog(null, "Set Unused Pins", true);
        dialog.setSize(350, 180);
        dialog.setLocationRelativeTo(null);
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(false);
        dialog.setAlwaysOnTop(true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBackground(Color.white);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Set unused pins to:");
        label.setFont(new Font("Arial", 0, 14));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 10);
        contentPanel.add((Component)label, gbc);
        String[] options = new String[]{"Reset", "GPIO_Input", "GPIO_Output", "GPIO_Analog"};
        final JComboBox<String> comboBox = new JComboBox<String>(options);
        comboBox.setPreferredSize(new Dimension(120, 25));
        comboBox.setBackground(Color.white);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        contentPanel.add(comboBox, gbc);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setBackground(Color.white);
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(80, 30));
        okButton.setBackground(Color.white);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedOption = (String)comboBox.getSelectedItem();
                PinoutUtil.packageAbstract.updateAllUnusedPintoUsed(selectedOption);
                dialog.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(80, 30));
        cancelButton.setBackground(Color.white);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        buttonPanel.add(okButton);
        mainPanel.add((Component)contentPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        dialog.add(mainPanel);
        dialog.setVisible(true);
    }
}

