/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict.tool;

import java.math.BigDecimal;
import java.util.ArrayDeque;

public class CalculatorFunctions {
    private static int maxReservedBits = 10;

    public double calculate(String s) {
        double resultValue = CalculatorFunctions.evaluateExpression(s).doubleValue();
        return resultValue;
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    private static boolean isOperand(char c) {
        return Character.isDigit(c) || c == '.';
    }

    private static BigDecimal calculate(BigDecimal num1, BigDecimal num2, char operator) {
        switch (operator) {
            case '+': {
                return num1.add(num2);
            }
            case '-': {
                return num1.subtract(num2);
            }
            case '*': {
                return num1.multiply(num2);
            }
            case '/': {
                if (num2.compareTo(BigDecimal.ZERO) == 0) {
                    return BigDecimal.ZERO;
                }
                return num1.divide(num2, maxReservedBits, 4);
            }
        }
        throw new IllegalArgumentException("\u95c8\u70b4\u7876\u93bf\u5d84\u7d94\u7ed7\ufffd");
    }

    public static BigDecimal evaluateExpression(String expression) {
        expression = expression.toLowerCase();
        ArrayDeque<BigDecimal> numStack = new ArrayDeque<BigDecimal>();
        ArrayDeque<Character> opStack = new ArrayDeque<Character>();
        boolean isHex = false;
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            if (c != ' ') {
                char operator;
                BigDecimal num1;
                BigDecimal num2;
                if (c == '(') {
                    opStack.push(Character.valueOf(c));
                } else if (CalculatorFunctions.isOperand(c)) {
                    StringBuilder operand = new StringBuilder();
                    while (i < expression.length() && (CalculatorFunctions.isOperand(expression.charAt(i)) || expression.charAt(i) == 'x')) {
                        operand.append(expression.charAt(i++));
                        if (!operand.toString().equals("0x")) continue;
                        isHex = true;
                    }
                    if (isHex) {
                        while (i < expression.length() && (CalculatorFunctions.isOperand(expression.charAt(i)) || Character.isLetter(expression.charAt(i)))) {
                            operand.append(expression.charAt(i++));
                        }
                    }
                    isHex = false;
                    --i;
                    BigDecimal num = operand.toString().startsWith("0x") ? new BigDecimal(Long.parseUnsignedLong(operand.toString().substring(2), 16)) : new BigDecimal(operand.toString());
                    numStack.push(num);
                } else if (c == ')') {
                    while (!opStack.isEmpty() && ((Character)opStack.peek()).charValue() != '(') {
                        num2 = (BigDecimal)numStack.pop();
                        num1 = (BigDecimal)numStack.pop();
                        operator = ((Character)opStack.pop()).charValue();
                        numStack.push(CalculatorFunctions.calculate(num1, num2, operator));
                    }
                    opStack.pop();
                } else if (CalculatorFunctions.isOperator(c)) {
                    while (!opStack.isEmpty() && ((Character)opStack.peek()).charValue() != '(' && CalculatorFunctions.precedence(((Character)opStack.peek()).charValue()) >= CalculatorFunctions.precedence(c)) {
                        num2 = (BigDecimal)numStack.pop();
                        num1 = (BigDecimal)numStack.pop();
                        operator = ((Character)opStack.pop()).charValue();
                        numStack.push(CalculatorFunctions.calculate(num1, num2, operator));
                    }
                    opStack.push(Character.valueOf(c));
                }
            }
            ++i;
        }
        while (!opStack.isEmpty()) {
            BigDecimal num2 = (BigDecimal)numStack.pop();
            BigDecimal num1 = (BigDecimal)numStack.pop();
            char operator = ((Character)opStack.pop()).charValue();
            numStack.push(CalculatorFunctions.calculate(num1, num2, operator));
        }
        return (BigDecimal)numStack.pop();
    }

    private static int precedence(char operator) {
        switch (operator) {
            case '+': 
            case '-': {
                return 1;
            }
            case '*': 
            case '/': {
                return 2;
            }
        }
        throw new IllegalArgumentException("\u95c8\u70b4\u7876\u93bf\u5d84\u7d94\u7ed7\ufffd");
    }
}

