/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict;

import com.gigadevice.conflict.NewConflictCheck;
import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictControlInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.PeriTreeColumnInfoStruct;
import com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.DMAInfoUtil;
import com.gigadevice.venustool.baseinfo.dma.MDMAInfoUtil;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeComboxNode;
import com.gigadevice.venustool.baseinfo.nvic.NVICParameterGroupNode;
import com.gigadevice.venustool.baseinfo.nvic.ParameterNode;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.controlconflict.NVICConfigConflict;
import com.gigadevice.venustool.controlconflict.PeriParaTreeConflict;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import com.gigadevice.venustool.mcubasestruct.ControlStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConflictCheck {
    public static boolean checkControlVisble = true;

    public static boolean ConditionCheck(ConflictGroupInfo conflictGroupObj) {
        if (conflictGroupObj.getConditionType() == 0) {
            return ConflictCheck.PrivilegeCheck(conflictGroupObj.getType(), conflictGroupObj.getConditionsList());
        }
        if (conflictGroupObj.getConditionType() == 1) {
            return NewConflictCheck.PrivilegeCheck(conflictGroupObj.getNestConditionGroupObj());
        }
        return false;
    }

    public static boolean PrivilegeCheck(String type, List<List<ConditionInfo>> UserList) {
        if (type.equals("OR")) {
            return ConflictCheck.OR(UserList);
        }
        if (type.equals("AND")) {
            return ConflictCheck.AND(UserList);
        }
        if (type.equals("OR_AND")) {
            return ConflictCheck.OR_AND(UserList);
        }
        if (type.equals("AND_OR")) {
            return ConflictCheck.AND_OR(UserList);
        }
        return false;
    }

    private static boolean OR(List<List<ConditionInfo>> UserList) {
        int i = 0;
        while (i < UserList.size()) {
            int j = 0;
            while (j < UserList.get(i).size()) {
                ConditionInfo User = UserList.get(i).get(j);
                if (ConflictCheck.conditionCheck(User)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean AND(List<List<ConditionInfo>> UserList) {
        int i = 0;
        while (i < UserList.size()) {
            int j = 0;
            while (j < UserList.get(i).size()) {
                ConditionInfo User = UserList.get(i).get(j);
                if (!ConflictCheck.conditionCheck(User)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static boolean OR_AND(List<List<ConditionInfo>> UserList) {
        boolean sign = false;
        int i = 0;
        while (i < UserList.size()) {
            sign = true;
            int j = 0;
            while (j < UserList.get(i).size()) {
                ConditionInfo User = UserList.get(i).get(j);
                if (!ConflictCheck.conditionCheck(User)) {
                    sign = false;
                }
                ++j;
            }
            if (sign) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean AND_OR(List<List<ConditionInfo>> UserList) {
        boolean sign = false;
        int i = 0;
        while (i < UserList.size()) {
            sign = false;
            int j = 0;
            while (j < UserList.get(i).size()) {
                ConditionInfo User = UserList.get(i).get(j);
                if (ConflictCheck.conditionCheck(User)) {
                    sign = true;
                }
                ++j;
            }
            if (!sign) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean conditionCheck(ConditionInfo User) {
        if (User.getRelateFrom().equals("-1")) {
            return true;
        }
        if (User.getGroupName().contains("!N")) {
            return ConflictCheck.NonNConditionCheck(User);
        }
        String Oper = User.getOper();
        String Type = User.getType();
        if (Type.equals("3")) {
            return ConflictCheck.otherCompare(User);
        }
        if (Oper.equals("Equal")) {
            return ConflictCheck.Equal(User.getPeriName(), User.getGroupName(), User.getControlName(), User.getItemName(), User.getRelateFrom(), User);
        }
        if (Oper.equals("NotEqual")) {
            return !ConflictCheck.Equal(User.getPeriName(), User.getGroupName(), User.getControlName(), User.getItemName(), User.getRelateFrom(), User);
        }
        if (Oper.equals("Contain")) {
            return ConflictCheck.Contain(User.getPeriName(), User.getGroupName(), User.getControlName(), User.getItemName(), User.getRelateFrom(), User);
        }
        if (Oper.equals("NotContain")) {
            return !ConflictCheck.Contain(User.getPeriName(), User.getGroupName(), User.getControlName(), User.getItemName(), User.getRelateFrom(), User);
        }
        if (Oper.equals("ExMatch")) {
            return ConflictCheck.RegularExpressionMatching(User.getPeriName(), User.getGroupName(), User.getControlName(), User.getItemName(), User.getRelateFrom(), User);
        }
        Object tmp = ConflictCheck.userOperCompare(User);
        if (tmp != null) {
            return Boolean.parseBoolean(tmp.toString());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean Equal(String periName, String groupName, String controlName, String itemName, String relateForm, ConditionInfo User) {
        String configValue;
        if (User == null) {
            User = new ConditionInfo();
            User.setOper("Equal");
        }
        if (periName.equals("*")) {
            return true;
        }
        if (relateForm.equals("1")) {
            Map nodeList;
            if (controlName.equals("") && (itemName.equals("") || itemName.equals("*"))) {
                return GlobalVariables.PeripheralConfigObjMap.containsKey(periName);
            }
            if (controlName.equals("") && !itemName.equals("")) {
                Map nodeMap = (Map)GlobalVariables.PeripheralConfigObjMap.get(periName);
                if (nodeMap == null) {
                    return false;
                }
                for (Map.Entry entry : nodeMap.entrySet()) {
                    NodeStruct nodeObj = (NodeStruct)entry.getValue();
                    if (!nodeObj.getValue().toUpperCase().equals(itemName.toUpperCase())) continue;
                    return true;
                }
                return false;
            }
            if (controlName.contains("##*") && !itemName.equals("")) {
                Map nodeMap = (Map)GlobalVariables.PeripheralConfigObjMap.get(periName);
                if (nodeMap == null) {
                    return false;
                }
                for (Map.Entry entry : nodeMap.entrySet()) {
                    NodeStruct nodeObj = (NodeStruct)entry.getValue();
                    controlName = controlName.replace("*", "");
                    String path = "";
                    if (!(path = ControlConflict.getNodePath((NodeStruct)nodeObj, (String)path)).contains(controlName) || !nodeObj.getValue().toUpperCase().equals(itemName.toUpperCase())) continue;
                    return true;
                }
                return false;
            }
            String controlType = "Node";
            if (controlName.equals("")) {
                return false;
            }
            Object object = ControlConflict.getPeriTreeNode((String)periName, (String)controlName, (String)"", (String)controlType);
            if (object == null) {
                return false;
            }
            String configValue2 = "";
            WidgetNodeStruct nodeObj = (WidgetNodeStruct)object;
            if (!itemName.equals("")) return (configValue2 = nodeObj.getValue()).toUpperCase().equals(itemName.toUpperCase());
            return GlobalVariables.PeripheralConfigObjMap.containsKey(periName) && (nodeList = (Map)GlobalVariables.PeripheralConfigObjMap.get(periName)).containsKey(controlName);
        }
        if (relateForm.equals("0")) {
            String configValue3;
            AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)periName, (String)groupName, (String)controlName);
            if (configNode == null) {
                return false;
            }
            if (User.getOper().equals("NotEqual")) {
                if (controlName == null || itemName == null) {
                    return true;
                }
                if (controlName != "" && !itemName.equals("")) return (configValue3 = configNode.getValue()).toUpperCase().equals(itemName.toUpperCase());
                return true;
            }
            if (checkControlVisble && !GlobalVariables.isCubeRoverTest && !PeriParaTreeConflict.getNodeVisibleState((AbstractJTreeNode)configNode, (boolean)configNode.isVisible())) {
                return User.getOper().equals("NotEqual");
            }
            if (controlName == null || controlName.equals("")) {
                int state = configNode.getState();
                return state == 0;
            }
            if (!itemName.equals("CheckVisible")) return (configValue3 = configNode.getValue()).toUpperCase().equals(itemName.toUpperCase());
            return configNode.isVisible();
        }
        if (relateForm.equals("2")) {
            if (User != null && User.getConditionType() != null && User.getConditionType().equals("4")) {
                return RCUCondition.ConditionExaminebyType4((String)User.getControlName(), (String)User.getItemName());
            }
            if (!(User != null && User.getType() != null && !itemName.equals("") ? RCUCondition.CheckRCUControlValue((String)controlName, (String)itemName) : RCUCondition.GetRCUControlState((String)controlName))) return false;
            return true;
        }
        if (relateForm.equals("3")) {
            if (!groupName.equals("")) {
                for (Map.Entry entry : DMAInfoUtil.DMAConfigInfo.entrySet()) {
                    for (Map.Entry entry1 : ((LinkedHashMap)entry.getValue()).entrySet()) {
                        String Channel = (String)entry1.getKey();
                        if (!Channel.equals(groupName)) continue;
                        if (controlName.equals("")) {
                            return true;
                        }
                        DMAConfigInfo DMAConfigInfoObj = (DMAConfigInfo)entry1.getValue();
                        String configValue4 = DMAConfigInfoObj.getContorlValue(controlName);
                        if (!configValue4.equals(itemName)) continue;
                        return true;
                    }
                }
                return false;
            } else {
                if (itemName.equals("*")) {
                    if (DMAInfoUtil.DMAConfigInfo.size() <= 0) return false;
                    return true;
                }
                for (Map.Entry entry : DMAInfoUtil.DMAConfigInfo.entrySet()) {
                    for (Map.Entry entry1 : ((LinkedHashMap)entry.getValue()).entrySet()) {
                        DMAConfigInfo DMAConfigInfoObj = (DMAConfigInfo)entry1.getValue();
                        String configValue5 = DMAConfigInfoObj.getContorlValue(controlName);
                        if (configValue5 == null || !configValue5.equals(itemName)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (relateForm.equals("6")) {
            return groupName.equals("") && itemName.equals("*") && MDMAInfoUtil.mDMAConfigInfo.size() > 0;
        }
        if (relateForm.equals("4")) {
            if (controlName.equals("")) NVICParameterGroupNode ConfigGroup;
            return (ConfigGroup = (NVICParameterGroupNode)NVICConfigConflict.getConfigNode((String)periName, (String)groupName, (String)controlName, (String)"")).isVisible();
            ParameterNode ConfigNode = (ParameterNode)NVICConfigConflict.getConfigNode((String)periName, (String)groupName, (String)controlName, (String)"");
            if (ConfigNode == null) return false;
            String ConfigValue = ConfigNode.getValue();
            if (!(ConfigNode.getType() == ConstantsUtil.ControlType.CheckBox.ordinal() ? itemName.toUpperCase().equals(ConfigValue.toUpperCase()) : itemName.equals(ConfigValue))) return false;
            return true;
        }
        if (relateForm.equals("5")) {
            if (!controlName.equals("PIN")) return ConflictCheck.checkPinInfo(User);
            int index = GlobalVariables.gd32mcuObj.GetPinIndexByUsedFunc(itemName);
            if (index < 0) return false;
            return true;
        }
        if (relateForm.equals("99")) {
            String MCU = User.getMCUPartNo();
            if (MCU.equals("")) return false;
            return ConflictCheck.checkSelectInfo("McuPart", MCU);
        }
        if (relateForm.equals("31")) {
            String configValue6;
            return ConflictUtil.DMAConfigInfo.containsKey(controlName) && (configValue6 = ConflictUtil.DMAConfigInfo.get(controlName)).equals(itemName);
        }
        if (relateForm.equals("61")) {
            String configValue7;
            return ConflictUtil.MDMAConfigInfo.containsKey(controlName) && (configValue7 = ConflictUtil.MDMAConfigInfo.get(controlName)).equals(itemName);
        }
        if (relateForm.equals("7")) {
            return ConflictCheck.checkSelectInfo(controlName, itemName);
        }
        if (!relateForm.equals("8") || !(configValue = GPIOInfoUtil.getConfigObjValby((String)periName, (String)groupName, (String)controlName)).equals(itemName)) return false;
        return true;
    }

    public static boolean Contain(String periName, String groupName, String controlName, String itemName, String relateForm, ConditionInfo User) {
        String configValue;
        if (User == null) {
            User = new ConditionInfo();
            User.setOper("Contain");
        }
        if (relateForm.equals("1")) {
            if ((controlName == null || controlName.equals("")) && !itemName.equals("")) {
                Map nodeMap = (Map)GlobalVariables.PeripheralConfigObjMap.get(periName);
                for (Map.Entry entry : nodeMap.entrySet()) {
                    NodeStruct nodeObj = (NodeStruct)entry.getValue();
                    if (!nodeObj.getValue().toUpperCase().contains(itemName.toUpperCase())) continue;
                    return true;
                }
                return false;
            }
            if ((controlName == null || controlName.equals("") && itemName.equals("")) && GlobalVariables.PeripheralConfigObjMap.containsKey(periName)) {
                return true;
            }
            String controlType = "Node";
            Object object = ControlConflict.getPeriTreeNode((String)periName, (String)controlName, (String)"", (String)controlType);
            if (object == null) {
                return false;
            }
            String configValue2 = "";
            WidgetNodeStruct nodeObj = (WidgetNodeStruct)object;
            configValue2 = nodeObj.getValue();
            return configValue2.toUpperCase().contains(itemName.toUpperCase());
        }
        if (relateForm.equals("0")) {
            String configValue3;
            AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)periName, (String)groupName, (String)controlName);
            if (configNode == null) {
                return false;
            }
            if (User.getOper().equals("NotContain")) {
                if (controlName == null || itemName == null) {
                    return true;
                }
                if (controlName == "" || itemName.equals("")) {
                    return true;
                }
            } else {
                if (itemName.equals("")) {
                    return true;
                }
                if (checkControlVisble && !PeriParaTreeConflict.getNodeVisibleState((AbstractJTreeNode)configNode, (boolean)configNode.isVisible())) {
                    return false;
                }
                if (controlName == null || controlName.equals("")) {
                    int state = configNode.getState();
                    return state == 0;
                }
            }
            return (configValue3 = configNode.getValue()).toUpperCase().contains(itemName.toUpperCase());
        }
        if (relateForm.equals("2")) {
            return true;
        }
        return relateForm.equals("8") && (configValue = GPIOInfoUtil.getConfigObjValby((String)periName, (String)groupName, (String)controlName)).contains(itemName);
    }

    public static boolean conditionCheckByExtentNode(String PeriName, String ExtentContent, String ExtentName) {
        String controlName = "";
        String itemName = "";
        int i = 0;
        while (i < GlobalVariables.PeriTreeColInfos.size()) {
            PeriTreeColumnInfoStruct columnInfoObj = (PeriTreeColumnInfoStruct)GlobalVariables.PeriTreeColInfos.get(i);
            if (columnInfoObj.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                if (columnInfoObj.getNodeType().equals(ExtentContent) && columnInfoObj.getNodeName().equals(ExtentName)) {
                    controlName = columnInfoObj.getNodeName();
                    itemName = "true";
                    break;
                }
            } else if (columnInfoObj.getNodeType().equals(ExtentContent)) {
                controlName = columnInfoObj.getNodeName();
                itemName = ExtentName;
                break;
            }
            ++i;
        }
        if (controlName.equals("")) {
            return false;
        }
        Object object = ControlConflict.getPeriTreeNode((String)PeriName, (String)controlName, (String)"", (String)"Control");
        if (object == null) {
            return false;
        }
        ControlStruct controlObj = (ControlStruct)object;
        String configValue = controlObj.getValue();
        return configValue.toUpperCase().equals(itemName.toUpperCase());
    }

    public static Object userOperCompare(ConditionInfo User) {
        Class<ConflictCheck> aClass = ConflictCheck.class;
        Object[] args = new Object[]{User};
        Class[] paraTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            paraTypes[i] = args[i].getClass();
            ++i;
        }
        Method method = null;
        try {
            method = aClass.getMethod(User.getOper(), paraTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        if (method == null) {
            return false;
        }
        try {
            return method.invoke(aClass.newInstance(), args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean GreatEqual(ConditionInfo User) {
        return ConflictCheck.NumberCompare(User);
    }

    public static boolean GreatThan(ConditionInfo User) {
        return ConflictCheck.NumberCompare(User);
    }

    public static boolean LessEqual(ConditionInfo User) {
        return ConflictCheck.NumberCompare(User);
    }

    public static boolean LessThan(ConditionInfo User) {
        return ConflictCheck.NumberCompare(User);
    }

    private static boolean NumberCompare(ConditionInfo User) {
        String configValueStr = ConflictCheck.getConfigValue(User);
        String compareValueStr = User.getItemName();
        double configValue = 0.0;
        double compareValue = 0.0;
        if (configValueStr == null) {
            return false;
        }
        configValue = Double.valueOf(configValueStr);
        compareValue = Double.valueOf(compareValueStr);
        switch (User.getOper()) {
            case "GreatEqual": {
                if (!(configValue >= compareValue)) break;
                return true;
            }
            case "GreatThan": {
                if (!(configValue > compareValue)) break;
                return true;
            }
            case "LessEqual": {
                if (!(configValue <= compareValue)) break;
                return true;
            }
            case "LessThan": {
                if (!(configValue < compareValue)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private static String getConfigValue(ConditionInfo User) {
        String periName = User.getPeriName();
        String groupName = User.getGroupName();
        String controlName = User.getControlName();
        String relateForm = User.getRelateFrom();
        String configValue = "";
        if (relateForm.equals("1")) {
            String controlType = "Node";
            Object object = ControlConflict.getPeriTreeNode((String)periName, (String)controlName, (String)"", (String)controlType);
            if (object == null) {
                return null;
            }
            WidgetNodeStruct nodeObj = (WidgetNodeStruct)object;
            configValue = nodeObj.getValue();
            return configValue;
        }
        if (relateForm.equals("0")) {
            AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)periName, (String)groupName, (String)controlName);
            if (configNode == null) {
                return null;
            }
            configValue = configNode.getValue();
            return configValue;
        }
        if (relateForm.equals("2")) {
            configValue = RCUCondition.getClockCurrentValue((String)controlName);
            if (configValue.equals("")) {
                return null;
            }
            return configValue;
        }
        if (relateForm.equals("31")) {
            if (ConflictUtil.DMAConfigInfo.containsKey(controlName)) {
                configValue = ConflictUtil.DMAConfigInfo.get(controlName);
                return configValue;
            }
        } else if (relateForm.equals("61") && ConflictUtil.MDMAConfigInfo.containsKey(controlName)) {
            configValue = ConflictUtil.MDMAConfigInfo.get(controlName);
            return configValue;
        }
        return null;
    }

    private static boolean otherCompare(ConditionInfo User) {
        String strType = User.getType();
        String Oper = User.getOper();
        if (strType.equals("3") && strType.equals("3")) {
            String strTargetString = User.getNodeAttributesInfo("Value");
            String strPara = User.getNodeAttributesInfo("Para");
            if (Oper.equals("Equal") ? strPara.toUpperCase().equals(strTargetString.toUpperCase()) : (Oper.equals("NotEqual") ? !strPara.toUpperCase().equals(strTargetString.toUpperCase()) : (Oper.equals("Contain") ? strPara.toUpperCase().contains(strTargetString.toUpperCase()) : Oper.equals("NotContain") && !strPara.toUpperCase().contains(strTargetString.toUpperCase())))) {
                return true;
            }
        }
        return false;
    }

    private static boolean NonNConditionCheck(ConditionInfo User) {
        String str;
        int startIndex = User.getGroupName().indexOf("%[");
        int endIndex = User.getGroupName().indexOf("]%") + 2;
        String replaceStr = str = User.getGroupName().substring(startIndex, endIndex);
        str = str.replace("%[", "");
        String[] strList = (str = str.replace("]%", "")).split(",");
        if (strList.length < 4) {
            return false;
        }
        String oper = strList[1];
        String range = strList[2];
        List<Object> minmaxList = new ArrayList();
        try {
            minmaxList = ConflictCheck.parseRange(range);
            if (minmaxList.size() < 2) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String nonNValueStr = strList[3];
        int nonNValue = Integer.valueOf(nonNValueStr);
        int min = (Integer)minmaxList.get(0);
        int max = (Integer)minmaxList.get(1);
        ArrayList<ConditionInfo> conditionInfos = new ArrayList<ConditionInfo>();
        int i = min;
        while (i <= max) {
            if (i != nonNValue) {
                ConditionInfo cInfo = ConflictUtil.cloneFrom(User);
                String groupName = cInfo.getGroupName().replace(replaceStr, String.valueOf(i));
                cInfo.setGroupName(groupName);
                conditionInfos.add(cInfo);
            }
            ++i;
        }
        if (conditionInfos.size() <= 0) {
            return false;
        }
        NewRelationGroup conditionObj = new NewRelationGroup();
        conditionObj.setRelationType(oper);
        conditionObj.setConditionsList(conditionInfos);
        return NewConflictCheck.PrivilegeCheck(conditionObj);
    }

    private static List<Integer> parseRange(String range) {
        int max;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern RANGE_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid range format: " + range);
        }
        int min = Integer.parseInt(matcher.group(1));
        if (min > (max = Integer.parseInt(matcher.group(2)))) {
            throw new IllegalArgumentException("Minimum value is greater than maximum value in: " + range);
        }
        result.add(min);
        result.add(max);
        return result;
    }

    public static boolean checkIsExecute(ConflictGroupInfo conflictGroupObj) {
        if (ConflictUtil.conflictIsCheckItem || GlobalVariables.isCubeRoverTest) {
            return true;
        }
        ConflictControlInfo ConflictControlObj = conflictGroupObj.getControledControl();
        String PeriName = ConflictControlObj.getPeriName();
        String GroupName = ConflictControlObj.getGroupName();
        String Type2 = ConflictControlObj.getControlType();
        String ControlName = ConflictControlObj.getControlName();
        String ItemName = ConflictControlObj.getItemName();
        if (Type2.equals("Item")) {
            AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
            if (controlNode == null) {
                return true;
            }
            if (controlNode.getType() == 2) {
                JTreeComboxNode comBox = (JTreeComboxNode)controlNode;
                Map itemList = comBox.getPossibleValueList();
                if (!itemList.containsKey(controlNode.getValue())) {
                    return true;
                }
                GeneralPariParaNodeItemStruct itemNode = (GeneralPariParaNodeItemStruct)itemList.get(controlNode.getValue());
                if (!itemNode.isVisible() || !itemNode.isEnable()) {
                    return true;
                }
                String Privilege = ConflictControlObj.getPrivilege();
                if ((Privilege.equals("Enable") || Privilege.equals("Disable") || Privilege.equals("Visible") || Privilege.equals("NotVisible")) && !controlNode.getValue().equals(ItemName)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean ConditionControlVisibleCheck(ConflictGroupInfo conflictGroupObj) {
        if (conflictGroupObj.getConditionType() == 0) {
            return ConflictCheck.ConditionVisbleCheck(conflictGroupObj.getConditionsList());
        }
        if (conflictGroupObj.getConditionType() == 1) {
            return NewConflictCheck.ConditionVisbleCheck(conflictGroupObj.getNestConditionGroupObj());
        }
        return false;
    }

    private static boolean ConditionVisbleCheck(List<List<ConditionInfo>> UserList) {
        int i = 0;
        while (i < UserList.size()) {
            int j = 0;
            while (j < UserList.get(i).size()) {
                ConditionInfo User = UserList.get(i).get(j);
                if (ConflictCheck.checkConditionControlIsVisble(User)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean checkConditionControlIsVisble(ConditionInfo User) {
        String controlName;
        String groupName;
        String relateForm = User.getRelateFrom();
        if (!relateForm.equals("0")) {
            return true;
        }
        String periName = User.getPeriName();
        AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)periName, (String)(groupName = User.getGroupName()), (String)(controlName = User.getControlName()));
        if (configNode == null) {
            return false;
        }
        return PeriParaTreeConflict.getNodeVisibleState((AbstractJTreeNode)configNode, (boolean)configNode.isVisible());
    }

    public static boolean checkConditionControlIsValid(ConditionInfo User) {
        if (GlobalVariables.isCubeRoverTest) {
            return true;
        }
        String relateForm = User.getRelateFrom();
        String periName = User.getPeriName();
        String groupName = User.getGroupName();
        String controlName = User.getControlName();
        String Type2 = User.getType();
        if (Type2.equals("3")) {
            return true;
        }
        if (relateForm.equals("0")) {
            if (groupName.contains("!N")) {
                return true;
            }
            if (!ConflictCheck.checkPeriConfigIsValid(periName)) {
                return false;
            }
            AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)periName, (String)groupName, (String)controlName);
            if (configNode == null) {
                return false;
            }
        } else if (relateForm.equals("1")) {
            if (periName.equals("*")) {
                return true;
            }
            Object object = ControlConflict.getPeriTreeNode((String)periName, (String)"", (String)"", (String)"");
            if (object == null) {
                return false;
            }
        }
        return true;
    }

    private static boolean RegularExpressionMatching(String periName, String groupName, String controlName, String itemName, String relateForm, ConditionInfo User) {
        if (relateForm.equals("1")) {
            String controlType = "Node";
            if (controlName.equals("")) {
                return false;
            }
            Object object = ControlConflict.getPeriTreeNode((String)periName, (String)controlName, (String)"", (String)controlType);
            if (object == null) {
                return false;
            }
            String configValue = "";
            WidgetNodeStruct nodeObj = (WidgetNodeStruct)object;
            configValue = nodeObj.getValue();
            return ConflictCheck.RegularExpressionMatchingCheck(itemName, configValue);
        }
        if (relateForm.equals("0")) {
            AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)periName, (String)groupName, (String)controlName);
            if (configNode == null) {
                return false;
            }
            String configValue = configNode.getValue();
            return ConflictCheck.RegularExpressionMatchingCheck(itemName, configValue);
        }
        return false;
    }

    private static boolean RegularExpressionMatchingCheck(String expression, String configValue) {
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(configValue);
        return matcher.find();
    }

    private static boolean checkPeriConfigIsValid(String periName) {
        if (periName.equals("RCU")) {
            return true;
        }
        if (GlobalVariables.PeripheralConfigObjMap.containsKey(periName)) {
            return true;
        }
        return !GlobalVariables.MCUObj.getModules().containsKey(periName);
    }

    public static boolean checkSelectInfo(String controlName, String itemName) {
        switch (controlName) {
            case "Package": {
                if (!itemName.equalsIgnoreCase(GlobalVariables.McuSeletorInfo.getPackageType())) break;
                return true;
            }
            case "McuPart": {
                if (!itemName.equalsIgnoreCase(GlobalVariables.McuSeletorInfo.getMCUPart())) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static boolean checkPinInfo(ConditionInfo User) {
        String groupName = User.getGroupName();
        String controlName = User.getControlName();
        String itemName = User.getItemName();
        if (User.getType().equals("PinFunction")) {
            GD32PinPad pinPadObj = null;
            pinPadObj = groupName.equals("*") ? GlobalVariables.GetPinInfoByPinName((String)controlName) : GlobalVariables.GetPinInfoByPinNumStr((String)groupName);
            if (pinPadObj != null && pinPadObj.getPinName().equals(controlName)) {
                String functionStr = pinPadObj.getPinUsedFunctionStr();
                if (functionStr.equals("")) {
                    functionStr = "Reset";
                }
                return functionStr.contains(itemName);
            }
            if (User.getOper().equals("NotEqual")) {
                return true;
            }
        }
        return false;
    }
}

