/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.xmlparse;

import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIOConfigCtrlStruct;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIOConfigInfo;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIORulesStruct;
import com.gigadevice.periconfigview.utils.GPIOConfigUtil;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GPIOConfigXMLParse {
    private static final String NODE_DEFAULT = "Default";
    private static final String NODE_SOURCE = "Source";
    private static final String NODE_RULES = "Rules";
    private static final String SOURCE_VALUE = "Value";
    private static final String SOURCE_CONTENT = "Content";
    private static final String RULE_MODULE = "ModuleNameStr";
    private static final String RULE_SIGNAL = "SignalOnPin";
    private static final String RULE_ITEMS = "Items";
    private static final String RULE_RELATION = "Relation";
    private static final String RULE_VALUE = "Value";
    private static final String RULE_RELANAME = "Name";
    private static final String CONFIG_COLUMN = "column";
    private static final String CONFIG_ID = "id";
    private static final String CONFIG_NAME = "name";
    private static final String CONFIG_TYPE = "type";
    private static final String CONFIG_HEADER_PATH = "Table/Header";
    private static final String CONFIG_CONFIG_PATH = "Configuration";
    private static boolean isNewCondition = false;

    public static void parseGPIOUIXML(String uiPath) {
        SAXReader saxReader = new SAXReader();
        try {
            File uifile = new File(uiPath);
            if (!uifile.exists()) {
                return;
            }
            Document uiDoc = saxReader.read(new File(uiPath));
            Element uiDocRootElm = uiDoc.getRootElement();
            Element headerElm = (Element)uiDocRootElm.selectSingleNode(CONFIG_HEADER_PATH);
            List lstColumn = headerElm.elements(CONFIG_COLUMN);
            for (Element columnElm : lstColumn) {
                String id = columnElm.attributeValue(CONFIG_ID);
                String name = columnElm.attributeValue(CONFIG_NAME);
                GPIOInfoUtil.mapGPIOConfigObjsIndex.put(id, name);
            }
            Element NodeConfig = (Element)uiDocRootElm.selectSingleNode(CONFIG_CONFIG_PATH);
            List lstControl = NodeConfig.elements();
            for (Element ctrlElm : lstControl) {
                String type = ctrlElm.attributeValue(CONFIG_TYPE);
                String id = ctrlElm.attributeValue(CONFIG_ID);
                String name = ctrlElm.attributeValue(CONFIG_NAME);
                GPIOConfigCtrlStruct control = new GPIOConfigCtrlStruct();
                control.setId(id);
                control.setType(type);
                control.setName(name);
                GPIOConfigUtil.lstConfigControls.add(control);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseGPIOXML(String filePath, Map<String, GPIOConfigInfo> GPIOConfigInfoMap) {
        SAXReader saxReader = new SAXReader();
        try {
            String versionStr;
            File file = new File(filePath);
            if (!file.exists()) {
                return;
            }
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            isNewCondition = false;
            if (rootElm.attributeCount() > 0 && (versionStr = rootElm.attributeValue("Version")) != null && versionStr.equals("V2.0")) {
                isNewCondition = true;
            }
            List lstGPIOConfig = rootElm.elements();
            for (Element configInfoElm : lstGPIOConfig) {
                String strConfigInfoName = configInfoElm.getName();
                List lstConfigInfo = configInfoElm.elements();
                GPIOConfigInfo GPIOInfo = new GPIOConfigInfo();
                for (Element elmObject : lstConfigInfo) {
                    String strNodeName = elmObject.getName();
                    if (strNodeName.equals(NODE_DEFAULT)) {
                        String strDefaultValue = elmObject.getText();
                        GPIOInfo.setDefault(strDefaultValue);
                        continue;
                    }
                    if (strNodeName.equals(NODE_SOURCE)) {
                        GPIOConfigXMLParse.GPIOSourceProcess(elmObject, GPIOInfo);
                        continue;
                    }
                    if (!strNodeName.equals(NODE_RULES)) continue;
                    GPIOConfigXMLParse.GPIORulesProcess(elmObject, GPIOInfo);
                }
                GPIOConfigInfoMap.put(strConfigInfoName, GPIOInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void GPIOSourceProcess(Element Elm, GPIOConfigInfo GPIOInfo) {
        List lstSample = Elm.elements();
        ArrayList<String> lstSource = new ArrayList<String>();
        for (Element elmSample : lstSample) {
            List lstChildNode = elmSample.elements();
            String strValue = "";
            String strContent = "";
            for (Element elmObject : lstChildNode) {
                String nodeName = elmObject.getName();
                if (nodeName.equals("Value")) {
                    strValue = elmObject.getText();
                    continue;
                }
                if (!nodeName.equals(SOURCE_CONTENT)) continue;
                strContent = elmObject.getText();
                lstSource.add(strContent);
            }
            GPIOConfigUtil.GPIOXMLCodeDefineMap.put(strContent, strValue);
        }
        GPIOInfo.setSource(lstSource);
    }

    private static void GPIORulesProcess(Element Elm, GPIOConfigInfo GPIOInfo) {
        List lstRules = Elm.elements();
        for (Element elmRule : lstRules) {
            List lstInfo = elmRule.elements();
            GPIORulesStruct Rule = new GPIORulesStruct();
            for (Element elmInfo : lstInfo) {
                String nodeName = elmInfo.getName();
                if (nodeName.equals(RULE_MODULE)) {
                    Rule.setModule(elmInfo.getText());
                    continue;
                }
                if (nodeName.equals(RULE_SIGNAL)) {
                    Rule.setSignal(elmInfo.getText());
                    continue;
                }
                if (nodeName.equals(RULE_ITEMS)) {
                    List lstItem = elmInfo.elements();
                    for (Element elmItem : lstItem) {
                        Rule.addItems(elmItem.getText());
                    }
                    continue;
                }
                if (nodeName.equals(RULE_RELATION)) {
                    String TypeName = elmInfo.attributeValue(RULE_RELANAME);
                    ConflictGroupInfo GroupInfoObj = new ConflictGroupInfo();
                    if (isNewCondition) {
                        NewRelationGroup NestConditionGroupObj = NewConditionXmlParse.ParseNewConditionRelationNode((Element)elmInfo);
                        GroupInfoObj.setConditionType(1);
                        GroupInfoObj.setNestConditionGroupObj(NestConditionGroupObj);
                    } else {
                        GroupInfoObj.setType(TypeName);
                        GroupInfoObj.setConditionType(0);
                        GPIOConfigXMLParse.ParsePrivilegeInfosList(Rule.getModule(), elmInfo, GroupInfoObj);
                    }
                    Rule.setGroupInfoObj(GroupInfoObj);
                    continue;
                }
                if (!nodeName.equals("Value")) continue;
                Rule.setValue(elmInfo.getText());
            }
            GPIOInfo.addRules(Rule);
        }
    }

    private static void ParsePrivilegeInfosList(String PeriName, Element elmRelation, ConflictGroupInfo GroupInfoObj) {
        List UserList = GroupInfoObj.getConditionsList();
        List PrivilegeInfosList = elmRelation.elements("PrivilegeInfos");
        for (Element elmPrivilegeInfos : PrivilegeInfosList) {
            List PrivilegeUserList = elmPrivilegeInfos.elements("PrivilegeUser");
            ArrayList<ConditionInfo> UList = new ArrayList<ConditionInfo>();
            for (Element elmPrivilegeUser : PrivilegeUserList) {
                ConditionInfo PrivilegeUserObj = new ConditionInfo();
                PrivilegeUserObj.setPeriName(PeriName);
                PrivilegeUserObj.setType("Item");
                Iterator itAttribute = elmPrivilegeUser.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    if (attributeValue.equals("")) continue;
                    PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                }
                UList.add(PrivilegeUserObj);
            }
            UserList.add(UList);
        }
        GroupInfoObj.setConditionsList(UserList);
    }
}

