/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.xmlparse;

import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import com.gigadevice.periconfigview.baseinfo.DMAInfo;
import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAEventStruct;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DMAConfigXMLParse {
    public static void parseDMAXML(String filePath, DMAInfo dmaAllInfo) {
        SAXReader saxReader = new SAXReader();
        LinkedHashMap<String, List<PeriConfigPart>> DMARequsteSetMap = dmaAllInfo.getRequsteInfoMap();
        Map<String, ConflictGroupInfo> DMAEventConditionMap = dmaAllInfo.getRequestConditionMap();
        Map<String, Map<String, String>> DMAXMLCodeDefineMap = dmaAllInfo.getCodeDefineMap();
        dmaAllInfo.getPeriModeEventInfo();
        Map<String, Map<String, List<PeriConfigPart>>> DMAInfoMap = dmaAllInfo.getConfigInfoMap();
        try {
            String versionStr;
            File f = new File(filePath);
            if (!f.exists()) {
                return;
            }
            Document document = saxReader.read(f);
            Element rootElm = document.getRootElement();
            boolean flag = false;
            if (rootElm.attributeCount() > 0 && (versionStr = rootElm.attributeValue("Version")) != null && versionStr.equals("V2.0")) {
                flag = true;
            }
            List ColumnInfo = rootElm.elements("ColumnInfos");
            ArrayList<PeriConfigPart> ColumnPartInfos = new ArrayList<PeriConfigPart>();
            DMAConfigXMLParse.ParseColumnInfo(ColumnInfo, DMAXMLCodeDefineMap, ColumnPartInfos);
            HashMap<String, ArrayList<PeriConfigPart>> PartsMap = new HashMap<String, ArrayList<PeriConfigPart>>();
            PartsMap.put("ColumnInfos", ColumnPartInfos);
            DMAInfoMap.put("ColumnInfos", PartsMap);
            List PerisList = rootElm.elements("Peris");
            List<Object> PeriList = new ArrayList<Element>();
            if (PerisList.size() > 0) {
                PeriList = ((Element)PerisList.get(0)).elements("Peri");
            }
            DMAConfigXMLParse.ParseDMAPeriSet(PeriList, DMAInfoMap, ColumnPartInfos, DMAXMLCodeDefineMap, DMAEventConditionMap, flag);
            Element eleDMARequester = rootElm.element("DMARequester");
            DMAConfigXMLParse.ParseDMAReqSet(eleDMARequester, DMARequsteSetMap, DMAXMLCodeDefineMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ParseColumnInfo(List<Element> ColumnInfos, Map<String, Map<String, String>> DMAXMLCodeDefineMap, List<PeriConfigPart> ColumnPartInfos) {
        if (ColumnInfos.size() <= 0) {
            return;
        }
        Element elmColumnInfos = ColumnInfos.get(0);
        List PartList = elmColumnInfos.elements("Part");
        for (Element elmPart : PartList) {
            PeriConfigPart periConfigPart = DMAConfigXMLParse.getPeriConfigPart(elmPart, DMAXMLCodeDefineMap);
            ColumnPartInfos.add(periConfigPart);
        }
    }

    public static void ParseDMAPeriSet(List<Element> PeriList, Map<String, Map<String, List<PeriConfigPart>>> DMAInfoMap, List<PeriConfigPart> ColumnPartInfos, Map<String, Map<String, String>> DMAXMLCodeDefineMap, Map<String, ConflictGroupInfo> DMAEventConditionMap, boolean isNewCondition) {
        for (Element elmPeri : PeriList) {
            String PeriName = elmPeri.attributeValue("name");
            List PartsList = elmPeri.elements("Parts");
            HashMap PartsMap = new HashMap();
            for (Element elmParts : PartsList) {
                String PartsName = elmParts.attributeValue("name");
                List PartList = elmParts.elements("Part");
                HashMap<String, PeriConfigPart> PartMap = new HashMap<String, PeriConfigPart>();
                for (Element elmPart : PartList) {
                    PeriConfigPart periConfigPart = DMAConfigXMLParse.getPeriConfigPart(elmPart, DMAXMLCodeDefineMap);
                    PartMap.put(periConfigPart.getName(), periConfigPart);
                }
                List RelationList = elmParts.elements("Relation");
                for (Element elmRelation : RelationList) {
                    String TypeName = elmRelation.attributeValue("name");
                    ConflictGroupInfo GroupInfoObj = new ConflictGroupInfo();
                    if (isNewCondition) {
                        NewRelationGroup NestConditionGroupObj = NewConditionXmlParse.ParseNewConditionRelationNode((Element)elmRelation);
                        GroupInfoObj.setConditionType(1);
                        GroupInfoObj.setNestConditionGroupObj(NestConditionGroupObj);
                    } else {
                        GroupInfoObj.setType(TypeName);
                        GroupInfoObj.setConditionType(0);
                        DMAConfigXMLParse.ParsePrivilegeInfosList(PeriName, elmRelation, GroupInfoObj);
                    }
                    DMAEventConditionMap.put(PartsName, GroupInfoObj);
                }
                ArrayList<PeriConfigPart> PeriConfigPartList = new ArrayList<PeriConfigPart>();
                for (PeriConfigPart part : ColumnPartInfos) {
                    String ColumnName = part.getName();
                    if (!PartMap.containsKey(ColumnName)) {
                        PeriConfigPartList.add(part);
                        continue;
                    }
                    PeriConfigPart PartObj = (PeriConfigPart)PartMap.get(ColumnName);
                    PartObj.setType(part.getType());
                    PartObj.setCol(part.getCol());
                    PeriConfigPartList.add(PartObj);
                }
                for (Map.Entry entry : PartMap.entrySet()) {
                    String controlName = (String)entry.getKey();
                    boolean sign = false;
                    for (PeriConfigPart part : ColumnPartInfos) {
                        String ColumnName = part.getName();
                        if (!controlName.equals(ColumnName)) continue;
                        sign = true;
                        break;
                    }
                    if (sign) continue;
                    PeriConfigPart PartObj = (PeriConfigPart)entry.getValue();
                    PartObj.setUILocation(DMAConfigUtil.UILocation.isGroupControl.ordinal());
                    PeriConfigPartList.add(PartObj);
                }
                if (PeriConfigPartList.isEmpty()) continue;
                PartsMap.put(PartsName, PeriConfigPartList);
            }
            if (PartsMap.isEmpty()) continue;
            DMAInfoMap.put(PeriName, PartsMap);
        }
    }

    public static void ParseDMAReqSet(Element eleDMARequester, Map<String, List<PeriConfigPart>> DMARequsteSetMap, Map<String, Map<String, String>> DMAXMLCodeDefineMap) {
        List PartsList = eleDMARequester.elements("Parts");
        for (Element elmParts : PartsList) {
            String groupName = elmParts.attributeValue("name");
            List PartList = elmParts.elements("Part");
            ArrayList<PeriConfigPart> periConfigParts = new ArrayList<PeriConfigPart>();
            for (Element elmPart : PartList) {
                PeriConfigPart periConfigPart = new PeriConfigPart();
                Iterator itAttribute = elmPart.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String value = attribute.getText();
                    periConfigPart.setAttrValue(attributeName, value);
                }
                if (periConfigPart.getType() == 2 || periConfigPart.getType() == 1) {
                    List ItemList = elmPart.elements("Item");
                    for (Element elmItem : ItemList) {
                        PeriConfigItem ItemObj = new PeriConfigItem();
                        Iterator itAttribute2 = elmItem.attributeIterator();
                        while (itAttribute2.hasNext()) {
                            Attribute attribute = (Attribute)itAttribute2.next();
                            String attributeName = attribute.getName();
                            String value = attribute.getText();
                            if (attributeName.equals("name")) {
                                ItemObj.setName(value);
                                continue;
                            }
                            if (attributeName.equals("value")) {
                                ItemObj.setValue(value);
                                continue;
                            }
                            if (!attributeName.equals("disable")) continue;
                            ItemObj.setDisableList(value);
                        }
                        if (ItemObj.getValue() != null) {
                            DMAConfigXMLParse.AddXMLCodeDefine(periConfigPart.getName(), ItemObj.getName(), ItemObj.getValue(), DMAXMLCodeDefineMap);
                        }
                        periConfigPart.setIemList(ItemObj);
                    }
                }
                periConfigParts.add(periConfigPart);
            }
            DMARequsteSetMap.put(groupName, periConfigParts);
        }
    }

    public static void parseDMAPeriModeEventInfoXML(String filePath, Map<String, Map<String, DMAEventStruct>> DMAPeriModeEventInfo) {
        SAXReader saxReader = new SAXReader();
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                return;
            }
            Document document = saxReader.read(f);
            Element rootElm = document.getRootElement();
            List PeriList = rootElm.elements("Peri");
            for (Element elmPeri : PeriList) {
                String PeriName = elmPeri.attributeValue("name");
                List ModeList = elmPeri.elements("Mode");
                HashMap<String, DMAEventStruct> ModeMap = new HashMap<String, DMAEventStruct>();
                for (Element elmMode : ModeList) {
                    String ModeName = elmMode.attributeValue("name");
                    String ModeType = elmMode.attributeValue("type");
                    List EventList = elmMode.elements("Event");
                    DMAEventStruct DMAEventObj = new DMAEventStruct();
                    DMAEventObj.setMode(ModeName);
                    try {
                        DMAEventObj.setType(Integer.parseInt(ModeType));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    for (Element elmEvent : EventList) {
                        String EventName = elmEvent.attributeValue("name");
                        DMAEventObj.setEventSet(EventName);
                    }
                    if (DMAEventObj.getEventSet().size() <= 0) continue;
                    ModeMap.put(ModeName, DMAEventObj);
                }
                if (ModeMap.size() <= 0) continue;
                DMAPeriModeEventInfo.put(PeriName, ModeMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void AddXMLCodeDefine(String ControlName, String ItemName, String ItemValue, Map<String, Map<String, String>> XMLCodeDefineMap) {
        if (XMLCodeDefineMap.containsKey(ControlName)) {
            if (XMLCodeDefineMap.get(ControlName).containsKey(ItemName)) {
                return;
            }
            XMLCodeDefineMap.get(ControlName).put(ItemName, ItemValue);
        } else {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put(ItemName, ItemValue);
            XMLCodeDefineMap.put(ControlName, tmp);
        }
    }

    private static void ParsePrivilegeInfosList(String PeriName, Element elmRelation, ConflictGroupInfo GroupInfoObj) {
        List UserList = GroupInfoObj.getConditionsList();
        List PrivilegeInfosList = elmRelation.elements("PrivilegeInfos");
        for (Element elmPrivilegeInfos : PrivilegeInfosList) {
            List PrivilegeUserList = elmPrivilegeInfos.elements("PrivilegeUser");
            ArrayList<ConditionInfo> UList = new ArrayList<ConditionInfo>();
            for (Element elmPrivilegeUser : PrivilegeUserList) {
                ConditionInfo PrivilegeUserObj = new ConditionInfo();
                PrivilegeUserObj.setPeriName(PeriName);
                PrivilegeUserObj.setType("Item");
                Iterator itAttribute = elmPrivilegeUser.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    if (attributeValue.equals("")) continue;
                    PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                }
                UList.add(PrivilegeUserObj);
            }
            UserList.add(UList);
        }
        GroupInfoObj.setConditionsList(UserList);
    }

    public static PeriConfigPart getPeriConfigPart(Element elmPart, Map<String, Map<String, String>> DMAXMLCodeDefineMap) {
        PeriConfigPart periConfigPart = new PeriConfigPart();
        Iterator itAttribute = elmPart.attributeIterator();
        while (itAttribute.hasNext()) {
            Attribute attribute = (Attribute)itAttribute.next();
            String attributeName = attribute.getName();
            String value = attribute.getText();
            periConfigPart.setAttrValue(attributeName, value);
        }
        List ItemList = elmPart.elements("Item");
        for (Element elmItem : ItemList) {
            PeriConfigItem ItemObj = new PeriConfigItem();
            Iterator itAttribute2 = elmItem.attributeIterator();
            while (itAttribute2.hasNext()) {
                Attribute attribute = (Attribute)itAttribute2.next();
                String attributeName = attribute.getName();
                String value = attribute.getText();
                if (attributeName.equals("name")) {
                    ItemObj.setName(value);
                    continue;
                }
                if (attributeName.equals("value")) {
                    ItemObj.setValue(value);
                    continue;
                }
                ItemObj.setOtherInfoMap(attributeName, value);
            }
            if (ItemObj.getValue() != null) {
                DMAConfigXMLParse.AddXMLCodeDefine(periConfigPart.getName(), ItemObj.getName(), ItemObj.getValue(), DMAXMLCodeDefineMap);
            }
            periConfigPart.setIemList(ItemObj);
        }
        return periConfigPart;
    }
}

