/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberStringComparator
implements Comparator<String> {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+(?:-\\d+)?)MHz");

    @Override
    public int compare(String s1, String s2) {
        Matcher m1 = NUMBER_PATTERN.matcher(s1);
        Matcher m2 = NUMBER_PATTERN.matcher(s2);
        if (!m1.find() || !m2.find()) {
            return s1.compareTo(s2);
        }
        String num1Str = m1.group(1);
        String num2Str = m2.group(1);
        if (num1Str.contains("-") && num2Str.contains("-")) {
            num1Str = num1Str.split("-")[0];
            num2Str = num2Str.split("-")[0];
        } else if (num1Str.contains("/") && num2Str.contains("/")) {
            num1Str = num1Str.split("/")[0];
            num2Str = num2Str.split("/")[0];
        }
        return Integer.compare(Integer.parseInt(num1Str), Integer.parseInt(num2Str));
    }
}

