/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.NVICConflictExecute;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.NVICConfigInfo;
import com.gigadevice.periconfigview.baseinfo.systemperi.NVICConfigXmlInfoStruct;
import com.gigadevice.periconfigview.xmlparse.NVICConfigXMLParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.nvic.NVICConfigStruct;
import com.gigadevice.venustool.baseinfo.nvic.NVICParameterGroupNode;
import com.gigadevice.venustool.baseinfo.nvic.NVICVariables;
import com.gigadevice.venustool.baseinfo.nvic.ParameterNode;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NVICConfigUtil {
    public static NVICConfigXmlInfoStruct NVICXmlInfo = new NVICConfigXmlInfoStruct();
    public static Map<String, Map<String, Map<String, NVICConfigInfo>>> TemNVICConfigInfoMap = new HashMap<String, Map<String, Map<String, NVICConfigInfo>>>();
    public static Map<String, Map<String, Map<String, NVICConfigInfo>>> NVICConfigInfoMap = new HashMap<String, Map<String, Map<String, NVICConfigInfo>>>();
    public static Map<String, Map<String, String>> NVICXMLCodeDefineMap = new HashMap<String, Map<String, String>>();
    public static Map<String, Map<String, ConflictGroupInfo>> NVICPartsConditionMap = new HashMap<String, Map<String, ConflictGroupInfo>>();
    public static LinkedHashMap<String, NVICConfigStruct> NVICConfigInitialObj = new LinkedHashMap();
    public static Map<String, Map<String, String>> DeSerializeConfigInfoList = new HashMap<String, Map<String, String>>();

    public static void ClearUserConfigVars() {
        if (NVICConfigInitialObj.size() > 0) {
            GlobalVariables.NVICConfigTempObj = (LinkedHashMap)GlobalVariables.cloneFrom(NVICConfigInitialObj);
            NVICConflictExecute.initNVICConflictByRank((String)"CommonConflict");
            NVICConfigUtil.updateCommonToPara(((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get("NVIC")).getNVICParameterGroupInfo());
            NVICConflictExecute.initNVICConflictByRank((String)"PrivateConflict");
            NVICVariables.NVICConfigApplyObj = (LinkedHashMap)GlobalVariables.cloneFrom((Object)GlobalVariables.NVICConfigTempObj);
        }
    }

    public static void ClearAllGlobalVars() {
        NVICConfigInfoMap.clear();
        NVICXMLCodeDefineMap.clear();
        NVICXmlInfo.getNVICInfoMap().clear();
        NVICXmlInfo.getCommonPartList().clear();
        NVICXmlInfo.getConfigurationPartList().clear();
        NVICXmlInfo.getHeadColumns().clear();
        NVICXmlInfo.getActionInfos().clear();
        NVICPartsConditionMap.clear();
        NVICConfigInitialObj.clear();
        NVICVariables.NVICConfigApplyObj.clear();
        GlobalVariables.NVICConfigTempObj.clear();
    }

    public static void InitAllGlobalVars() {
        NVICConfigUtil.InitConfigInfo();
    }

    public static String Serialize() {
        String out = "";
        LinkedHashMap<String, LinkedHashMap<String, NVICParameterGroupNode>> EnabledInfo = NVICConfigUtil.getEnabledInfo();
        for (Map.Entry<String, LinkedHashMap<String, NVICParameterGroupNode>> entry : EnabledInfo.entrySet()) {
            String PeriName = entry.getKey();
            for (Map.Entry<String, NVICParameterGroupNode> entry1 : entry.getValue().entrySet()) {
                String GroupName = entry1.getKey();
                LinkedHashMap ParameterInfo = entry1.getValue().getNVICParameterInfo();
                for (Map.Entry entry2 : ParameterInfo.entrySet()) {
                    String ParameterName = (String)entry2.getKey();
                    String ParameterValue = ((ParameterNode)entry2.getValue()).getValue();
                    String path = String.join((CharSequence)"##", GroupName, ParameterName);
                    String str = String.valueOf(String.join((CharSequence)".", PeriName, path)) + "=" + ParameterValue + System.getProperty("line.separator");
                    out = String.valueOf(out) + str;
                }
            }
        }
        return out;
    }

    public static void DeSerialize(String ins, int version) {
        switch (version) {
            case 1: {
                NVICConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(String input) {
        DeSerializeConfigInfoList.clear();
        for (Map.Entry<String, NVICConfigStruct> entry : NVICConfigInitialObj.entrySet()) {
            String NCIVType = entry.getKey();
            LinkedHashMap DeSerializeConfigInfo = GlobalVariables.serializeStrClassification((String)input, (String)NCIVType);
            DeSerializeConfigInfoList.putAll(DeSerializeConfigInfo);
        }
    }

    public static void LoadAllGlobalVars() {
        NVICConflictExecute.initNVICConflictByRank((String)"PrivateConflict");
        for (Map.Entry<String, Map<String, String>> entry : DeSerializeConfigInfoList.entrySet()) {
            String NVIC = entry.getKey();
            Map<String, String> configInfo = entry.getValue();
            for (Map.Entry<String, String> entry1 : configInfo.entrySet()) {
                boolean ret = NVICConfigUtil.updateApplyConfigInfo(NVIC, entry1.getKey(), entry1.getValue());
                if (ret) continue;
                LogManager.getInstance().error("NVIC", "Not found node: " + entry1.getKey());
            }
        }
        NVICVariables.NVICConfigApplyObj = (LinkedHashMap)GlobalVariables.cloneFrom((Object)GlobalVariables.NVICConfigTempObj);
    }

    private static boolean updateApplyConfigInfo(String nvicType, String nodePath, String nodeValue) {
        String groupName = "";
        String nodeName = "";
        boolean nodeFound = false;
        if (nodePath.contains("##")) {
            int index = nodePath.lastIndexOf("##");
            groupName = nodePath.substring(0, index);
            nodeName = nodePath.substring(index + 2, nodePath.length());
        }
        for (Map.Entry entry : GlobalVariables.NVICConfigTempObj.entrySet()) {
            if (!((String)entry.getKey()).equals(nvicType)) continue;
            NVICConfigStruct NVICObj = (NVICConfigStruct)entry.getValue();
            for (Map.Entry entry1 : NVICObj.getNVICParameterGroupInfo().entrySet()) {
                if (!((NVICParameterGroupNode)entry1.getValue()).getContent().equals(groupName)) continue;
                for (Map.Entry entry2 : ((NVICParameterGroupNode)entry1.getValue()).getNVICParameterInfo().entrySet()) {
                    if (!((String)entry2.getKey()).equals(nodeName)) continue;
                    ((ParameterNode)entry2.getValue()).setValue(nodeValue);
                    nodeFound = true;
                }
            }
        }
        if (nodeFound) {
            ConflictUtil.openUpdateValuePrivilege((boolean)false);
            if (groupName.equals("Configuration")) {
                NVICConflictExecute.ConflictExecuteByNVIC((String)nvicType, (String)groupName, (String)nodeName, (String)nodeValue);
                NVICConfigUtil.updateCommonToPara(((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(nvicType)).getNVICParameterGroupInfo());
            } else {
                NVICConflictExecute.ConflictExecuteByNVIC((String)nvicType, (String)groupName, (String)nodeName, (String)nodeValue);
            }
            ConflictUtil.openUpdateValuePrivilege((boolean)true);
        }
        return nodeFound;
    }

    public static String getNVICPeriName(String PeriName, String PeriToNVIC) {
        if (NVICXmlInfo.getNVICInfoMap().size() > 0 && NVICXmlInfo.getNVICInfoMap().containsKey(PeriToNVIC)) {
            for (Map.Entry<String, List<List<PeriConfigPart>>> entry : NVICXmlInfo.getNVICInfoMap().get(PeriToNVIC).entrySet()) {
                String Peri = entry.getKey();
                if (!Peri.contains(",") || !Peri.contains(PeriName)) continue;
                return Peri;
            }
        }
        return PeriName;
    }

    public static void InitConfigInfo() {
        NVICConfigUtil.NVICXMLInfoParse();
    }

    public static void NVICXMLInfoParse() {
        NVICConflictExecute.initNVICConflictXmlInfo();
        if (NVICConfigInitialObj.size() <= 0) {
            GlobalPathUtil.SysPeriXmlPaths sysPeriXmlPathsObj = GlobalPathUtil.getSysPeriXmlPaths();
            String NvicXmlPath = sysPeriXmlPathsObj.NVICConfigXmlPath;
            NVICConfigStruct tempNVICConfigObj = NVICConfigXMLParse.parseNVICConfigXML(NvicXmlPath);
            NVICConfigUtil.updateCommonToPara(tempNVICConfigObj.getNVICParameterGroupInfo());
            NVICConfigInitialObj.put(tempNVICConfigObj.getNVICType(), tempNVICConfigObj);
            GlobalVariables.NVICConfigTempObj = (LinkedHashMap)GlobalVariables.cloneFrom(NVICConfigInitialObj);
            NVICConflictExecute.initNVICConflictByRank((String)"CommonConflict");
            NVICConfigUtil.updateCommonToPara(((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(tempNVICConfigObj.getNVICType())).getNVICParameterGroupInfo());
            NVICConflictExecute.initNVICConflictByRank((String)"PrivateConflict");
            NVICVariables.NVICConfigApplyObj = (LinkedHashMap)GlobalVariables.cloneFrom((Object)GlobalVariables.NVICConfigTempObj);
        }
    }

    public static void updateCommonToPara(LinkedHashMap<String, NVICParameterGroupNode> NVICParameterGroupInfo) {
        if (NVICParameterGroupInfo.size() > 0 && NVICParameterGroupInfo.containsKey("CommonParameter")) {
            NVICParameterGroupNode CommonParameterGroup = NVICParameterGroupInfo.get("CommonParameter");
            for (Map.Entry<String, NVICParameterGroupNode> entry : NVICParameterGroupInfo.entrySet()) {
                NVICParameterGroupNode tempParameterGroup = entry.getValue();
                if (tempParameterGroup.getName().equals("Configuration") || tempParameterGroup.getName().equals("CommonParameter")) continue;
                for (Map.Entry entry1 : tempParameterGroup.getNVICParameterInfo().entrySet()) {
                    String ParameterName = (String)entry1.getKey();
                    for (Map.Entry entry2 : CommonParameterGroup.getNVICParameterInfo().entrySet()) {
                        String CommonParameterName = (String)entry2.getKey();
                        if (!ParameterName.equals(CommonParameterName)) continue;
                        ParameterNode Parameter = (ParameterNode)entry1.getValue();
                        ParameterNode CommonParameter = (ParameterNode)entry2.getValue();
                        LinkedHashMap PossibleValueList = CommonParameter.getPossibleValueList();
                        Parameter.getPossibleValueList().clear();
                        for (Map.Entry entry3 : PossibleValueList.entrySet()) {
                            Parameter.putPossibleValueList((GeneralPariParaNodeItemStruct)entry3.getValue());
                        }
                    }
                }
            }
        }
    }

    public static LinkedHashMap<String, NVICParameterGroupNode> getEnabledInfo(String nvicType) {
        LinkedHashMap<String, NVICParameterGroupNode> enabledInfo = new LinkedHashMap<String, NVICParameterGroupNode>();
        for (Map.Entry entry : NVICVariables.NVICConfigApplyObj.entrySet()) {
            String NVICType = (String)entry.getKey();
            if (!NVICType.equals(nvicType)) continue;
            NVICConfigStruct NVICObj = (NVICConfigStruct)entry.getValue();
            for (Map.Entry entry1 : NVICObj.getNVICParameterGroupInfo().entrySet()) {
                if (((String)entry1.getKey()).equals("Configuration") || ((String)entry1.getKey()).equals("CommonParameter") || !((NVICParameterGroupNode)entry1.getValue()).isVisible()) continue;
                LinkedHashMap NVICParameterInfo = ((NVICParameterGroupNode)entry1.getValue()).getNVICParameterInfo();
                for (Map.Entry entry2 : NVICParameterInfo.entrySet()) {
                    if (!((String)entry2.getKey()).equals("Enabled") || !((ParameterNode)entry2.getValue()).getValue().toUpperCase().equals("TRUE")) continue;
                    enabledInfo.put(((NVICParameterGroupNode)entry1.getValue()).getContent(), (NVICParameterGroupNode)entry1.getValue());
                }
            }
        }
        return enabledInfo;
    }

    public static LinkedHashMap<String, LinkedHashMap<String, NVICParameterGroupNode>> getEnabledInfo() {
        LinkedHashMap<String, LinkedHashMap<String, NVICParameterGroupNode>> NVICEnabledInfo = new LinkedHashMap<String, LinkedHashMap<String, NVICParameterGroupNode>>();
        LinkedHashMap<String, NVICParameterGroupNode> enabledInfo = new LinkedHashMap<String, NVICParameterGroupNode>();
        for (Map.Entry entry : NVICVariables.NVICConfigApplyObj.entrySet()) {
            String NVICType = (String)entry.getKey();
            NVICConfigStruct NVICObj = (NVICConfigStruct)entry.getValue();
            for (Map.Entry entry1 : NVICObj.getNVICParameterGroupInfo().entrySet()) {
                if (!((String)entry1.getKey()).equals("Configuration")) {
                    if (((String)entry1.getKey()).equals("CommonParameter") || !((NVICParameterGroupNode)entry1.getValue()).isVisible()) continue;
                    LinkedHashMap NVICParameterInfo = ((NVICParameterGroupNode)entry1.getValue()).getNVICParameterInfo();
                    for (Map.Entry entry2 : NVICParameterInfo.entrySet()) {
                        if (!((String)entry2.getKey()).equals("Enabled") || !((ParameterNode)entry2.getValue()).getValue().toUpperCase().equals("TRUE")) continue;
                        enabledInfo.put(((NVICParameterGroupNode)entry1.getValue()).getContent(), (NVICParameterGroupNode)entry1.getValue());
                    }
                    continue;
                }
                enabledInfo.put(((NVICParameterGroupNode)entry1.getValue()).getContent(), (NVICParameterGroupNode)entry1.getValue());
            }
            NVICEnabledInfo.put(NVICType, enabledInfo);
        }
        return NVICEnabledInfo;
    }

    public static NVICParameterGroupNode getVisiableInterruptInfo(String nvicType, String interruptName) {
        for (Map.Entry entry : NVICVariables.NVICConfigApplyObj.entrySet()) {
            if (!((String)entry.getKey()).equals(nvicType)) continue;
            NVICConfigStruct NVICObj = (NVICConfigStruct)entry.getValue();
            for (Map.Entry entry1 : NVICObj.getNVICParameterGroupInfo().entrySet()) {
                if (!((NVICParameterGroupNode)entry1.getValue()).isVisible() || !((NVICParameterGroupNode)entry1.getValue()).getContent().equals(interruptName)) continue;
                return (NVICParameterGroupNode)entry1.getValue();
            }
        }
        return null;
    }

    public static String GetVarMacro(String nvicType, String groupName, String nodeName) {
        String VarMacro = "";
        for (Map.Entry entry : NVICVariables.NVICConfigApplyObj.entrySet()) {
            if (!((String)entry.getKey()).equals(nvicType)) continue;
            NVICConfigStruct NVICObj = (NVICConfigStruct)entry.getValue();
            for (Map.Entry entry1 : NVICObj.getNVICParameterGroupInfo().entrySet()) {
                if (!((NVICParameterGroupNode)entry1.getValue()).isVisible()) continue;
                String tempGroupName = ((NVICParameterGroupNode)entry1.getValue()).getName();
                String regex = "\\[[0-9]+\\]$";
                if (!(tempGroupName = tempGroupName.replaceAll(regex, "")).equals(groupName)) continue;
                for (Map.Entry entry2 : ((NVICParameterGroupNode)entry1.getValue()).getNVICParameterInfo().entrySet()) {
                    if (!((String)entry2.getKey()).equals(nodeName)) continue;
                    VarMacro = ((ParameterNode)entry2.getValue()).getValue();
                }
            }
        }
        return VarMacro;
    }

    public static Map<String, Map<String, NVICConfigInfo>> GetNVICEnabledConfigInfo(String NVICType) {
        HashMap<String, Map<String, NVICConfigInfo>> NVICEnabledConfigInfoMap = new HashMap<String, Map<String, NVICConfigInfo>>();
        for (Map.Entry<String, Map<String, NVICConfigInfo>> entry0 : NVICConfigInfoMap.get(NVICType).entrySet()) {
            String PeriName = entry0.getKey();
            HashMap<String, NVICConfigInfo> PartNVICConfigInfo = new HashMap<String, NVICConfigInfo>();
            for (Map.Entry<String, NVICConfigInfo> entry1 : entry0.getValue().entrySet()) {
                String InterruptStr = entry1.getKey();
                if (!entry1.getValue().getActive()) continue;
                NVICConfigInfo NVICConfigObj = new NVICConfigInfo();
                NVICConfigObj.setActive(true);
                Map<String, String> ContorlInfoMap = entry1.getValue().getContorlInfoMap();
                for (Map.Entry<String, String> tmp : ContorlInfoMap.entrySet()) {
                    NVICConfigObj.setContorlValue(tmp.getKey(), tmp.getValue());
                }
                PartNVICConfigInfo.put(InterruptStr, NVICConfigObj);
            }
            if (PartNVICConfigInfo.size() <= 0) continue;
            NVICEnabledConfigInfoMap.put(PeriName, PartNVICConfigInfo);
        }
        return NVICEnabledConfigInfoMap;
    }

    public static String GetGeneralPariToNVIC(String periName) {
        String PariToNVIC = "";
        if (periName.contains("NVIC")) {
            PariToNVIC = periName;
        } else if (NVICXmlInfo.getActionInfos().size() == 0) {
            PariToNVIC = "NVIC";
        } else if (NVICXmlInfo.getActionInfos().size() > 0) {
            block0: for (Map.Entry<String, Map<String, String>> entry : NVICXmlInfo.getActionInfos().entrySet()) {
                for (Map.Entry<String, String> entry1 : entry.getValue().entrySet()) {
                    boolean conditon = ConflictCheck.conditionCheckByExtentNode((String)periName, (String)entry.getKey(), (String)entry1.getValue());
                    if (!conditon) continue;
                    PariToNVIC = entry1.getKey();
                    continue block0;
                }
            }
        }
        return PariToNVIC;
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(NVICConfigInfoMap);
            out.writeObject(NVICXMLCodeDefineMap);
            out.writeObject(NVICXmlInfo);
            out.writeObject(NVICPartsConditionMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        NVICConfigUtil.InitAllGlobalVars();
        switch (version) {
            case "1.1": {
                NVICConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            NVICConfigInfoMap = (Map)ins.readObject();
            NVICXMLCodeDefineMap = (Map)ins.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NVICConfigUtil.loadOldDeSerializeInfo();
    }

    private static void loadOldDeSerializeInfo() {
        for (Map.Entry<String, Map<String, Map<String, NVICConfigInfo>>> entry : NVICConfigInfoMap.entrySet()) {
            String NVICType = entry.getKey();
            Map<String, Map<String, NVICConfigInfo>> NVICMap = entry.getValue();
            for (Map.Entry<String, Map<String, NVICConfigInfo>> entry1 : NVICMap.entrySet()) {
                Map<String, NVICConfigInfo> interruptMap = entry1.getValue();
                for (Map.Entry<String, NVICConfigInfo> entry3 : interruptMap.entrySet()) {
                    String interruptContent = entry3.getKey();
                    NVICConfigInfo configInfo = entry3.getValue();
                    Map<String, String> ContorlInfoMap = configInfo.getContorlInfoMap();
                    if (!configInfo.getActive()) continue;
                    LinkedHashMap ParameterGroupInfo = ((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(NVICType)).getNVICParameterGroupInfo();
                    for (Map.Entry groupE : ParameterGroupInfo.entrySet()) {
                        NVICParameterGroupNode groupNode = (NVICParameterGroupNode)groupE.getValue();
                        String tempInterruptContent = groupNode.getContent();
                        if (!interruptContent.equals(tempInterruptContent) || !((NVICParameterGroupNode)groupE.getValue()).isVisible()) continue;
                        LinkedHashMap ParameterInfo = groupNode.getNVICParameterInfo();
                        for (Map.Entry paraE : ParameterInfo.entrySet()) {
                            String paraContent = ((ParameterNode)paraE.getValue()).getContent();
                            if (ContorlInfoMap.containsKey(paraContent)) {
                                ((ParameterNode)paraE.getValue()).setValue(ContorlInfoMap.get(paraContent).toUpperCase());
                                continue;
                            }
                            if (!paraContent.equals("Enabled")) continue;
                            ((ParameterNode)paraE.getValue()).setValue("TRUE");
                        }
                    }
                }
            }
        }
        NVICVariables.NVICConfigApplyObj = (LinkedHashMap)GlobalVariables.cloneFrom((Object)GlobalVariables.NVICConfigTempObj);
    }
}

