/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.periconfigview.baseinfo.DMAInfo;
import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAConfigInfo;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAEventStruct;
import com.gigadevice.periconfigview.utils.MDMAConfigUtil;
import com.gigadevice.periconfigview.xmlparse.DMAConfigXMLParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.dma.DMAInfoUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DMAConfigUtil {
    public static final String STR_SERIALIZE = "DMA";
    public static DMAInfo dmaAllInfo = new DMAInfo();
    public static List<String> UsedChannelList = new ArrayList<String>();
    private static Map<String, Map<String, String>> dmaDeSerializeMap = new HashMap<String, Map<String, String>>();
    public static LinkedHashMap<String, LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>> TemDMAConfigInfo = new LinkedHashMap();
    public static Map<String, Map<String, DMAConfigInfo>> OldDMAConfigInfo = new HashMap<String, Map<String, DMAConfigInfo>>();
    public static LinkedHashMap<String, LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>> temMDMAConfigInfo = new LinkedHashMap();

    public static void ClearUserConfigVars() {
        DMAInfoUtil.DMAConfigInfo.clear();
        UsedChannelList.clear();
        TemDMAConfigInfo.clear();
        MDMAConfigUtil.ClearUserConfigVars();
    }

    public static void ClearAllGlobalVars() {
        DMAInfoUtil.DMAConfigInfo.clear();
        UsedChannelList.clear();
        TemDMAConfigInfo.clear();
        dmaAllInfo.clearAllInfo();
        MDMAConfigUtil.ClearAllGlobalVars();
    }

    public static void InitAllGlobalVars() {
    }

    public static void LoadAllGlobalVars() {
        DMAInfoUtil.DMAConfigInfo.clear();
        for (Map.Entry<String, Map<String, String>> entry : dmaDeSerializeMap.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> strList = new ArrayList<String>(Arrays.asList(key.split("\\.")));
            if (strList.size() < 3) {
                LogManager.getInstance().error("<DMAConfigContent>", "The format of the DMA information is incorrect, the gdc file may have been manually modified. Serialize Error: " + key);
                continue;
            }
            String periName = (String)strList.get(1);
            String channel = (String)strList.get(2);
            Map<String, String> map = entry.getValue();
            com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo DMAConfigObj = new com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo();
            ArrayList<String> ChannelList = new ArrayList<String>();
            ChannelList.add(channel);
            DMAConfigObj.setChannelList(ChannelList);
            for (Map.Entry<String, String> entry1 : map.entrySet()) {
                DMAConfigObj.setContorlValue(entry1.getKey(), entry1.getValue());
                if (!entry1.getKey().equals("DMA Request")) continue;
                DMAConfigObj.setDMARequest(entry1.getValue());
            }
            LinkedHashMap DMAConfigInfos = new LinkedHashMap();
            if (DMAInfoUtil.DMAConfigInfo.containsKey(periName)) {
                DMAConfigInfos = (LinkedHashMap)DMAInfoUtil.DMAConfigInfo.get(periName);
            }
            DMAConfigInfos.put(channel, DMAConfigObj);
            DMAInfoUtil.DMAConfigInfo.put(periName, DMAConfigInfos);
        }
        dmaDeSerializeMap.clear();
        MDMAConfigUtil.LoadAllGlobalVars();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(DMAInfoUtil.DMAConfigInfo);
            out.writeObject(dmaAllInfo.getConfigInfoMap());
            out.writeObject(dmaAllInfo.getCodeDefineMap());
            out.writeObject(dmaAllInfo.getRequsteInfoMap());
            out.writeObject(dmaAllInfo.getRequestConditionMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                DMAConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            OldDMAConfigInfo = (Map)ins.readObject();
            Map DMAInfoMap = (Map)ins.readObject();
            dmaAllInfo.setConfigInfoMap(DMAInfoMap);
            Map DMAXMLCodeDefineMap = (Map)ins.readObject();
            dmaAllInfo.setCodeDefineMap(DMAXMLCodeDefineMap);
            LinkedHashMap DMARequsteSetMap = (LinkedHashMap)ins.readObject();
            dmaAllInfo.setRequsteInfoMap(DMARequsteSetMap);
            Map DMAEventConditionMap = (Map)ins.readObject();
            dmaAllInfo.setRequestConditionMap(DMAEventConditionMap);
            DMAConfigUtil.CompatibleOldVersionGdc();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void CompatibleOldVersionGdc() {
        for (Map.Entry<String, Map<String, DMAConfigInfo>> entry : OldDMAConfigInfo.entrySet()) {
            String key = entry.getKey();
            LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo> DMAConfigInfos = new LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>();
            Map<String, DMAConfigInfo> DMAConfigInfoMap = entry.getValue();
            for (Map.Entry<String, DMAConfigInfo> entry1 : DMAConfigInfoMap.entrySet()) {
                String key1 = entry1.getKey();
                DMAConfigInfo tmpDMAConfigInfo = entry1.getValue();
                com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo DMAConfigInfoObj = new com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo();
                DMAConfigInfoObj.setDMARequest(tmpDMAConfigInfo.getDMARequest());
                for (String channelStr : tmpDMAConfigInfo.getChannelList()) {
                    DMAConfigInfoObj.setChannelList(channelStr);
                }
                Map<String, String> ContorlInfoMap = tmpDMAConfigInfo.getContorlInfoMap();
                for (Map.Entry<String, String> entry2 : ContorlInfoMap.entrySet()) {
                    DMAConfigInfoObj.setContorlValue(entry2.getKey(), entry2.getValue());
                }
                DMAConfigInfos.put(key1, DMAConfigInfoObj);
            }
            DMAInfoUtil.DMAConfigInfo.put(key, DMAConfigInfos);
        }
    }

    public static String Serialize() {
        String output = "";
        for (Map.Entry entry : DMAInfoUtil.DMAConfigInfo.entrySet()) {
            String periName = (String)entry.getKey();
            Map DMAConfigInfoMap = (Map)entry.getValue();
            for (Map.Entry entry1 : DMAConfigInfoMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                Map ContorlInfoMap = ((com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo)entry1.getValue()).getContorlInfoMap();
                for (Map.Entry entry2 : ContorlInfoMap.entrySet()) {
                    String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, periName, Channel2, (CharSequence)entry2.getKey())) + "=" + (String)entry2.getValue() + System.lineSeparator();
                    output = String.valueOf(output) + str;
                }
            }
        }
        output = String.valueOf(output) + MDMAConfigUtil.Serialize();
        return output;
    }

    public static void DeSerialize(String input, int version) {
        switch (version) {
            case 1: {
                DMAConfigUtil.DeSerializeV1(input);
            }
        }
        MDMAConfigUtil.DeSerialize(input, version);
    }

    private static void DeSerializeV1(String input) {
        dmaDeSerializeMap = GlobalVariables.serializeStrClassification((String)input, (String)STR_SERIALIZE);
    }

    public static void DMAXMLInfoParse() {
        if (dmaAllInfo.getConfigInfoMap().size() <= 0) {
            GlobalPathUtil.SysPeriXmlPaths sysPeriXmlPathsObj = GlobalPathUtil.getSysPeriXmlPaths();
            String DMAConfigXmlPath = sysPeriXmlPathsObj.DMAConfigXmlPath;
            DMAConfigXMLParse.parseDMAXML(DMAConfigXmlPath, dmaAllInfo);
        }
    }

    public static void LoadUserConfigInfo() {
        TemDMAConfigInfo.clear();
        TemDMAConfigInfo = (LinkedHashMap)GlobalVariables.cloneFrom((Object)DMAInfoUtil.DMAConfigInfo);
        UsedChannelList.clear();
        for (Map.Entry<String, LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>> entry : TemDMAConfigInfo.entrySet()) {
            for (Map.Entry<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo> entry1 : entry.getValue().entrySet()) {
                String Channel2 = entry1.getKey();
                UsedChannelList.add(Channel2);
            }
        }
    }

    public static void UpdatePeriConfigInfo(String PeriName) {
        if (DMAInfoUtil.DMAConfigInfo.size() <= 0) {
            return;
        }
        if (!DMAInfoUtil.DMAConfigInfo.containsKey(PeriName)) {
            return;
        }
        ArrayList<String> deleteChannel = new ArrayList<String>();
        for (Map.Entry entry : ((LinkedHashMap)DMAInfoUtil.DMAConfigInfo.get(PeriName)).entrySet()) {
            String Channel2 = (String)entry.getKey();
            String DMARequest = ((com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo)entry.getValue()).getDMARequest();
            if (DMAConfigUtil.DMAReqisValid(DMARequest, PeriName)) continue;
            deleteChannel.add(Channel2);
        }
        int i = 0;
        while (i < deleteChannel.size()) {
            ((LinkedHashMap)DMAInfoUtil.DMAConfigInfo.get(PeriName)).remove(deleteChannel.get(i));
            UsedChannelList.remove(deleteChannel.get(i));
            ++i;
        }
        if (((LinkedHashMap)DMAInfoUtil.DMAConfigInfo.get(PeriName)).size() <= 0) {
            DMAInfoUtil.DMAConfigInfo.remove(PeriName);
        }
    }

    public static com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo GetDMAConfigInfo(String ChannelName) {
        for (Map.Entry<String, LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>> entry : TemDMAConfigInfo.entrySet()) {
            Map DMAConfigInfoMap = entry.getValue();
            for (Map.Entry entry1 : DMAConfigInfoMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                if (!ChannelName.equals(Channel2)) continue;
                return (com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo)entry1.getValue();
            }
        }
        return null;
    }

    public static void ChannelSwitchtoInfoUpdate(String formChannel, String ChannelName) {
        for (Map.Entry<String, LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>> entry : TemDMAConfigInfo.entrySet()) {
            Map DMAConfigInfoMap = entry.getValue();
            for (Map.Entry entry1 : DMAConfigInfoMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                if (!formChannel.equals(Channel2)) continue;
                com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo DMAConfigInfoObj = (com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo)entry1.getValue();
                DMAConfigUtil.DeleteDMAConfigInfo(formChannel);
                DMAConfigInfoObj.getContorlInfoMap().put("Channel", ChannelName);
                DMAConfigUtil.AddDMAConfigInfo(DMAConfigInfoObj);
                return;
            }
        }
    }

    public static String ReturnRequestPeri(String Request) {
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : dmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(Request) || !DMAConfigUtil.DMAReqisValid(Request, entry.getKey())) continue;
            return entry.getKey();
        }
        return STR_SERIALIZE;
    }

    public static List<String> ReturnChannelList(String DMARequest) {
        ArrayList<String> ChannelList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : dmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(DMARequest)) continue;
            List<PeriConfigPart> PartList = PartsMap.get(DMARequest);
            int i = 0;
            while (i < PartList.size()) {
                if ("Channel".equals(PartList.get(i).getName())) {
                    List<PeriConfigItem> IemList = PartList.get(i).getIemList();
                    int j = 0;
                    while (j < IemList.size()) {
                        String ChannelName = IemList.get(j).getName();
                        ChannelList.add(ChannelName);
                        ++j;
                    }
                    return ChannelList;
                }
                ++i;
            }
        }
        return ChannelList;
    }

    public static void AddDMAConfigInfo(com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo DMAConfigInfoObj) {
        String ChannelName = "";
        String DMARequest = "";
        Map ContorlInfoMap = DMAConfigInfoObj.getContorlInfoMap();
        for (Map.Entry entry : ContorlInfoMap.entrySet()) {
            String ContorlName = (String)entry.getKey();
            if (ContorlName.equals("DMA Request")) {
                DMARequest = (String)entry.getValue();
                continue;
            }
            if (!ContorlName.equals("Channel")) continue;
            ChannelName = (String)entry.getValue();
        }
        ContorlInfoMap.put("Channel", ChannelName);
        String PeriName = DMAConfigUtil.ReturnRequestPeri(DMARequest);
        if (TemDMAConfigInfo.containsKey(PeriName)) {
            TemDMAConfigInfo.get(PeriName).put(ChannelName, DMAConfigInfoObj);
        } else {
            LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo> PeriDMAConfig = new LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>();
            PeriDMAConfig.put(ChannelName, DMAConfigInfoObj);
            TemDMAConfigInfo.put(PeriName, PeriDMAConfig);
        }
    }

    public static void UpdateDMAConfigInfo(com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo DMAConfigInfoObj) {
        String ChannelName = "";
        String DMARequest = "";
        Map ContorlInfoMap = DMAConfigInfoObj.getContorlInfoMap();
        for (Map.Entry entry : ContorlInfoMap.entrySet()) {
            String ContorlName = (String)entry.getKey();
            if (ContorlName.equals("DMA Request")) {
                DMARequest = (String)entry.getValue();
                continue;
            }
            if (!ContorlName.equals("Channel")) continue;
            ChannelName = (String)entry.getValue();
        }
        String PeriName = DMAConfigUtil.ReturnRequestPeri(DMARequest);
        ContorlInfoMap.put("Channel", ChannelName);
        TemDMAConfigInfo.get(PeriName).put(ChannelName, DMAConfigInfoObj);
    }

    public static void DeleteDMAConfigInfo(String ChannelName) {
        for (Map.Entry<String, LinkedHashMap<String, com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo>> entry : TemDMAConfigInfo.entrySet()) {
            String PeriName = entry.getKey();
            Map DMAConfigInfoMap = entry.getValue();
            for (Map.Entry entry1 : DMAConfigInfoMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                if (!ChannelName.equals(Channel2)) continue;
                TemDMAConfigInfo.get(PeriName).remove(ChannelName);
                return;
            }
        }
    }

    private static boolean DMAReqisValid(String Requester, String PeriName) {
        ConflictGroupInfo ConflictGroupObj;
        if (STR_SERIALIZE.equals(PeriName)) {
            return true;
        }
        if (!GlobalVariables.PeripheralConfigObjMap.containsKey(PeriName)) {
            return false;
        }
        if (dmaAllInfo.getPeriModeEventInfo().size() == 0 && dmaAllInfo.getRequestConditionMap().containsKey(Requester) && !ConflictCheck.ConditionCheck((ConflictGroupInfo)(ConflictGroupObj = dmaAllInfo.getRequestConditionMap().get(Requester)))) {
            return false;
        }
        if (!dmaAllInfo.getPeriModeEventInfo().containsKey(PeriName)) {
            return true;
        }
        Map<String, DMAEventStruct> ModeEventInfo = dmaAllInfo.getPeriModeEventInfo().get(PeriName);
        for (Map.Entry<String, DMAEventStruct> entry : ModeEventInfo.entrySet()) {
            String ModeName;
            if (!entry.getValue().getEventSet().contains(Requester) || !((ModeName = entry.getValue().getMode()).equals("") ? GlobalVariables.PeripheralTreeMap.containsKey(PeriName) : ConflictCheck.Equal((String)PeriName, (String)"", (String)"", (String)ModeName, (String)"1", null))) continue;
            return true;
        }
        return false;
    }

    public static PeriConfigPart getSpecialControl(String requester, String controlName, Map<String, Map<String, List<PeriConfigPart>>> mapObj) {
        PeriConfigPart periConfigPart = null;
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : mapObj.entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(requester)) continue;
            List<PeriConfigPart> PartList = PartsMap.get(requester);
            int i = 0;
            while (i < PartList.size()) {
                PeriConfigPart partObj = PartList.get(i);
                if (partObj.getName().equals(controlName)) {
                    return partObj;
                }
                ++i;
            }
        }
        return periConfigPart;
    }

    public static PeriConfigPart getControlObj(String groupName, String controlName, Map<String, List<PeriConfigPart>> requsteSetMap) {
        PeriConfigPart periConfigPart = null;
        for (Map.Entry<String, List<PeriConfigPart>> entry : requsteSetMap.entrySet()) {
            List<PeriConfigPart> parts = entry.getValue();
            int i = 0;
            while (i < parts.size()) {
                PeriConfigPart partObj = parts.get(i);
                if (partObj.getName().equals(controlName)) {
                    return partObj;
                }
                ++i;
            }
        }
        return periConfigPart;
    }

    public static boolean checkEditValid(String value, PeriConfigPart partObj) {
        boolean result = true;
        long valueLong = 0L;
        if (partObj.getValueFormat() == 10 ? !DMAConfigUtil.isValidDecimal(value) : partObj.getValueFormat() == 16 && !DMAConfigUtil.isValidHexadecimal(value)) {
            return false;
        }
        valueLong = value.toUpperCase().contains("0X") ? Long.parseLong(value.substring(2), 16) : Long.parseLong(value);
        if (partObj.isHasMax() && valueLong > partObj.getMax()) {
            return false;
        }
        if (partObj.isHasMin() && valueLong < partObj.getMin()) {
            return false;
        }
        return result;
    }

    public static boolean isValidDecimal(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidHexadecimal(String str) {
        str = str.toLowerCase();
        String hexPattern = "^-?0x[0-9a-fA-F]+$";
        return str.matches(hexPattern);
    }

    public static enum UILocation {
        isTable,
        isGroupControl;

    }
}

