/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolbarButtonDisabler {
    private final List<ToolItemState> disabledItems = new ArrayList<ToolItemState>();
    private final List<String> buttonsToDisable;
    private boolean buttonsRestored = false;

    public ToolbarButtonDisabler(List<String> buttonsToDisable) {
        this.buttonsToDisable = buttonsToDisable;
    }

    public ToolbarButtonDisabler(String ... buttonsToDisable) {
        this.buttonsToDisable = Arrays.asList(buttonsToDisable);
    }

    public void disableButtons() {
        this.buttonsRestored = false;
        Display.getDefault().syncExec(() -> {
            try {
                Shell[] shells;
                this.disabledItems.clear();
                Shell[] shellArray = shells = Display.getDefault().getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    this.findAndDisableToolItems((Control)shell);
                    ++n2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void findAndDisableToolItems(Control control) {
        int n;
        int n2;
        ToolItem[] toolItemArray;
        if (control instanceof ToolBar) {
            ToolBar toolbar = (ToolBar)control;
            toolItemArray = toolbar.getItems();
            n2 = toolItemArray.length;
            n = 0;
            while (n < n2) {
                ToolItem item = toolItemArray[n];
                if (this.shouldDisableToolItem(item)) {
                    this.disabledItems.add(new ToolItemState(item, item.getEnabled()));
                    item.setEnabled(false);
                }
                ++n;
            }
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            toolItemArray = composite.getChildren();
            n2 = toolItemArray.length;
            n = 0;
            while (n < n2) {
                ToolItem child = toolItemArray[n];
                this.findAndDisableToolItems((Control)child);
                ++n;
            }
        }
    }

    private boolean shouldDisableToolItem(ToolItem item) {
        String tooltip;
        String text = item.getText();
        if (text != null && !text.isEmpty()) {
            for (String buttonId : this.buttonsToDisable) {
                if (!text.contains(buttonId)) continue;
                return true;
            }
        }
        if ((tooltip = item.getToolTipText()) != null && !tooltip.isEmpty()) {
            for (String buttonId : this.buttonsToDisable) {
                if (!tooltip.contains(buttonId)) continue;
                return true;
            }
        }
        return false;
    }

    private String getToolItemDescription(ToolItem item) {
        StringBuilder desc = new StringBuilder();
        if (item.getText() != null && !item.getText().isEmpty()) {
            desc.append("\u93c2\u56e8\u6e70=[").append(item.getText()).append("] ");
        }
        if (item.getToolTipText() != null && !item.getToolTipText().isEmpty()) {
            desc.append("\u93bb\u612e\u305a=[").append(item.getToolTipText()).append("]");
        }
        return desc.toString();
    }

    public void restoreButtons() {
        if (this.buttonsRestored) {
            return;
        }
        Display.getDefault().syncExec(() -> {
            try {
                for (ToolItemState state : this.disabledItems) {
                    if (state.item.isDisposed()) continue;
                    state.item.setEnabled(state.wasEnabled);
                }
                this.disabledItems.clear();
                this.buttonsRestored = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private static class ToolItemState {
        ToolItem item;
        boolean wasEnabled;

        ToolItemState(ToolItem item, boolean wasEnabled) {
            this.item = item;
            this.wasEnabled = wasEnabled;
        }
    }
}

