/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.periconfigview.GeneralPeriParaConfigTab;
import com.gigadevice.periconfigview.ToolbarButtonDisabler;
import com.gigadevice.periconfigview.dialog.DialogPeri_Interface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PeriConfigFrame
extends JDialog {
    private JPanel contentPane;
    JTabbedPane tabbedPane;
    private int width = 0;
    private int height = 0;
    private ToolbarButtonDisabler buttonDisabler;

    public PeriConfigFrame(String PeriName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.width = dimension.width / 2;
        this.height = dimension.height * 2 / 3;
        this.setBounds(this.width / 2, this.height / 4, this.width, this.height);
        this.setLocationRelativeTo(null);
        try {
            this.InitConfigFrame(PeriName);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.buttonDisabler = new ToolbarButtonDisabler("Generate Code", "Clear");
        this.buttonDisabler.disableButtons();
    }

    public void InitConfigFrame(String PeriName) throws InstantiationException, IllegalAccessException {
        Class<?> aClass = null;
        try {
            String DMAPeri = "DMA";
            String GPIOPeri = "GPIO";
            String NVICPeri = "NVIC";
            aClass = PeriName.contains(DMAPeri) ? (PeriName.equals("MDMA") ? Class.forName("com.gigadevice.periconfigview.dialog.DialogConfig_" + PeriName) : Class.forName("com.gigadevice.periconfigview.dialog.DialogConfig_" + DMAPeri)) : (PeriName.contains(GPIOPeri) ? Class.forName("com.gigadevice.periconfigview.dialog.DialogConfig_" + GPIOPeri) : (PeriName.contains(NVICPeri) ? Class.forName("com.gigadevice.periconfigview.dialog.DialogConfig_" + NVICPeri) : Class.forName("com.gigadevice.periconfigview.dialog.DialogConfig_General")));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (aClass == null) {
            return;
        }
        final DialogPeri_Interface Instance = (DialogPeri_Interface)aClass.newInstance();
        if (Instance == null) {
            return;
        }
        int spaceSize = this.height / 50;
        int tabbedPaneWidth = this.width - spaceSize * 3;
        int tabbedPaneHeight = this.height * 5 / 6;
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBounds(spaceSize, 0, tabbedPaneWidth, tabbedPaneHeight);
        Instance.setSize(tabbedPaneWidth, tabbedPaneHeight - 20);
        Instance.InitPeriConfigInfo(PeriName);
        Instance.Dialog_Init(PeriName, this.tabbedPane);
        this.contentPane = new JPanel(new GridBagLayout());
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, spaceSize, spaceSize, spaceSize);
        this.contentPane.add((Component)this.tabbedPane, gbc);
        JPanel buttonPanel = this.createButtonPanel(PeriName, Instance, spaceSize);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, spaceSize, 5, spaceSize);
        this.contentPane.add((Component)buttonPanel, gbc);
        JButton btnRestore = null;
        JButton btn_Cancel = null;
        btnRestore = this.findButtonByText(buttonPanel, "Restore");
        btn_Cancel = this.findButtonByText(buttonPanel, "Cancel");
        final JButton finalBtnRestore = btnRestore;
        final JButton finalBtnCancel = btn_Cancel;
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index;
                JTabbedPane sourcePane = (JTabbedPane)e.getSource();
                String title = sourcePane.getTitleAt(index = sourcePane.getSelectedIndex());
                if (title.contains("MDMA") || title.contains("DMA") || title.contains("GPIO") || title.contains("NVIC")) {
                    if (finalBtnRestore != null) {
                        finalBtnRestore.setVisible(false);
                    }
                } else if (finalBtnRestore != null) {
                    finalBtnRestore.setVisible(true);
                }
                if (finalBtnRestore != null && finalBtnRestore.getParent() != null) {
                    finalBtnRestore.getParent().revalidate();
                    finalBtnRestore.getParent().repaint();
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PeriConfigFrame.this.buttonDisabler.restoreButtons();
                GeneralPeriParaConfigTab.isWindowClosing = true;
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner instanceof JTextField) {
                    finalBtnCancel.requestFocusInWindow();
                    SwingUtilities.invokeLater(() -> {
                        Instance.Dialog_Cancel();
                        PeriConfigFrame.this.dispose();
                    });
                } else {
                    Instance.Dialog_Cancel();
                    PeriConfigFrame.this.dispose();
                }
                SwingUtilities.invokeLater(() -> {
                    GeneralPeriParaConfigTab.isWindowClosing = false;
                });
            }
        });
    }

    private JPanel createButtonPanel(String PeriName, final DialogPeri_Interface Instance, int spaceSize) {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton btnRestore = new JButton("Restore");
        btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Instance.Dialog_Restore();
            }
        });
        JPanel leftPanel = new JPanel(new FlowLayout(0, spaceSize, 0));
        buttonPanel.add((Component)leftPanel, "West");
        if ("MDMAGPIONVIC".contains(PeriName)) {
            btnRestore.setVisible(false);
        } else {
            leftPanel.add(btnRestore);
        }
        JPanel rightPanel = new JPanel(new FlowLayout(2, spaceSize, 0));
        JButton btn_Apply = new JButton("Apply");
        btn_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Instance.Dialog_Apply();
            }
        });
        rightPanel.add(btn_Apply);
        JButton btn_OK = new JButton("OK");
        btn_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Instance.Dialog_Apply();
                Instance.Dialog_OK();
                PeriConfigFrame.this.dispose();
            }
        });
        rightPanel.add(btn_OK);
        JButton btn_Cancel = new JButton("Cancel");
        btn_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Instance.Dialog_Cancel();
                PeriConfigFrame.this.dispose();
            }
        });
        rightPanel.add(btn_Cancel);
        buttonPanel.add((Component)rightPanel, "East");
        return buttonPanel;
    }

    private JButton findButtonByText(Component container, String buttonText) {
        if (container instanceof JButton) {
            JButton button = (JButton)container;
            if (buttonText.equals(button.getText())) {
                return button;
            }
        } else if (container instanceof JPanel) {
            JPanel panel = (JPanel)container;
            Component[] componentArray = panel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                JButton found = this.findButtonByText(child, buttonText);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        this.buttonDisabler.restoreButtons();
        super.dispose();
    }
}

