/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.conflict.NVICConflictExecute;
import com.gigadevice.periconfigview.model.MyEvent;
import com.gigadevice.periconfigview.model.NVICCellRenderer;
import com.gigadevice.periconfigview.model.NVICTableModel;
import com.gigadevice.periconfigview.model.nvicCheckBoxCellEditor;
import com.gigadevice.periconfigview.model.nvicComboxCellEditor;
import com.gigadevice.periconfigview.utils.NVICConfigUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.nvic.NVICConfigStruct;
import com.gigadevice.venustool.baseinfo.nvic.NVICParameterGroupNode;
import com.gigadevice.venustool.baseinfo.nvic.NVICVariables;
import com.gigadevice.venustool.baseinfo.nvic.ParameterNode;
import com.gigadevice.venustool.baseinfo.nvic.nvicCheckBox;
import com.gigadevice.venustool.baseinfo.nvic.nvicComBox;
import com.gigadevice.venustool.controlconflict.NVICConfigConflict;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;

public class NVICConfigView {
    private LinkedHashMap<String, Integer> HeadParameters = new LinkedHashMap();
    private JPanel panel;
    private JTable table_NVIC;
    private NVICTableModel model_NVIC;
    private Map<Integer, nvicComboxCellEditor> ComboBoxEditorMap;
    private Map<Integer, nvicCheckBoxCellEditor> CheckBoxCellEditorMap;
    TableRowSorter<NVICTableModel> sorter;
    String ConfigPeriName;
    static String ViewPeriToNVIC;
    Vector headVector;
    String oldvalue = "";
    private int tabWidth = 0;
    private int tabHeight = 0;

    public NVICConfigView(String PeriName) {
        ViewPeriToNVIC = NVICConfigUtil.GetGeneralPariToNVIC(PeriName);
        this.ConfigPeriName = NVICConfigUtil.getNVICPeriName(PeriName, ViewPeriToNVIC);
        this.InitColumnInfo();
    }

    public void setSize(int arg0, int arg1) {
        this.tabWidth = arg0;
        this.tabHeight = arg1;
    }

    public JPanel ReturnNVICConfigTab() {
        this.panel = new JPanel(new GridBagLayout());
        this.InitNVICTableModel();
        return this.panel;
    }

    public void UpdateView(String PeriName) {
        ViewPeriToNVIC = NVICConfigUtil.GetGeneralPariToNVIC(PeriName);
        this.ConfigPeriName = NVICConfigUtil.getNVICPeriName(PeriName, ViewPeriToNVIC);
        this.panel.removeAll();
        this.InitNVICTableModel();
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void RestoreNVICConfigInfo() {
        GlobalVariables.NVICConfigTempObj = (LinkedHashMap)GlobalVariables.cloneFrom((Object)NVICVariables.NVICConfigApplyObj);
    }

    private void InitNVICTableModel() {
        int configCount = this.InitConfiguration();
        this.headVector = new Vector();
        for (Map.Entry<String, Integer> entry : this.HeadParameters.entrySet()) {
            this.headVector.add(entry.getKey());
        }
        JPanel searchPanel = this.createSearchPanel();
        JScrollPane scrollPane = new JScrollPane();
        this.setupGridBagLayout(configCount > 0, searchPanel, scrollPane);
    }

    private void InitColumnInfo() {
        this.HeadParameters.put("Interrupt Table", ConstantsUtil.ControlType.Label.ordinal());
        if (GlobalVariables.NVICConfigTempObj.containsKey(ViewPeriToNVIC)) {
            LinkedHashMap NVICParameterGroupInfo = ((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC)).getNVICParameterGroupInfo();
            for (Map.Entry entry : NVICParameterGroupInfo.entrySet()) {
                String ParameterGroupName = (String)entry.getKey();
                if (ParameterGroupName.equals("Configuration") || ParameterGroupName.equals("CommonParameter")) continue;
                NVICParameterGroupNode ParameterGroups = (NVICParameterGroupNode)entry.getValue();
                for (Map.Entry entry1 : ParameterGroups.getNVICParameterInfo().entrySet()) {
                    this.HeadParameters.put(((ParameterNode)entry1.getValue()).getContent(), ((ParameterNode)entry1.getValue()).getType());
                }
            }
        }
    }

    private JPanel createSearchPanel() {
        JPanel searchPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lblSearchSignal = new JLabel("Search ");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 10, 5, 5);
        searchPanel.add((Component)lblSearchSignal, gbc);
        final JTextField txtSearch = new JTextField();
        gbc.gridx = 1;
        gbc.weightx = 0.3;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 10);
        searchPanel.add((Component)txtSearch, gbc);
        txtSearch.setColumns(10);
        Document dtSearch = txtSearch.getDocument();
        dtSearch.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String strTarget = txtSearch.getText();
                if (strTarget.length() == 0) {
                    NVICConfigView.this.model_NVIC.setRowCount(0);
                    NVICConfigView.this.InitNVICConfigInfo();
                    NVICConfigView.this.sorter.setRowFilter(null);
                } else {
                    NVICConfigView.this.model_NVIC.setRowCount(0);
                    NVICConfigView.this.InitNVICConfigInfo();
                    NVICConfigView.this.sorter.setRowFilter(RowFilter.regexFilter(strTarget, new int[0]));
                    NVICConfigView.this.traverseFilteredRows(NVICConfigView.this.sorter);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String strTarget = txtSearch.getText();
                if (strTarget.length() == 0) {
                    NVICConfigView.this.model_NVIC.setRowCount(0);
                    NVICConfigView.this.InitNVICConfigInfo();
                    NVICConfigView.this.sorter.setRowFilter(null);
                } else {
                    NVICConfigView.this.model_NVIC.setRowCount(0);
                    NVICConfigView.this.InitNVICConfigInfo();
                    NVICConfigView.this.sorter.setRowFilter(RowFilter.regexFilter(strTarget, new int[0]));
                    NVICConfigView.this.traverseFilteredRows(NVICConfigView.this.sorter);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        return searchPanel;
    }

    private void traverseFilteredRows(TableRowSorter<NVICTableModel> sorter) {
        int filteredRows = sorter.getViewRowCount();
        ArrayList<String> groupNameList = new ArrayList<String>();
        int viewIndex = 0;
        while (viewIndex < filteredRows) {
            int modelIndex = this.table_NVIC.convertRowIndexToModel(viewIndex);
            nvicCheckBoxCellEditor value = this.CheckBoxCellEditorMap.get(1);
            String groupName = value.getParameterObj(modelIndex).getGroupName();
            groupNameList.add(groupName);
            ++viewIndex;
        }
        this.model_NVIC.setRowCount(0);
        this.RefreshNVICConfigInfo(groupNameList);
    }

    private int InitConfiguration() {
        int configCount = 0;
        if (GlobalVariables.NVICConfigTempObj.containsKey(ViewPeriToNVIC) && ((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC)).getNVICParameterGroupInfo().containsKey("Configuration")) {
            NVICParameterGroupNode ConfigurationParameterGroup = (NVICParameterGroupNode)((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC)).getNVICParameterGroupInfo().get("Configuration");
            LinkedHashMap ConfigurationParameter = ConfigurationParameterGroup.getNVICParameterInfo();
            for (Map.Entry entry : ConfigurationParameter.entrySet()) {
                final ParameterNode parameter = (ParameterNode)entry.getValue();
                if (parameter.getType() != ConstantsUtil.ControlType.Combox.ordinal()) continue;
                ++configCount;
                JPanel configPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                JLabel JLabel2 = new JLabel(parameter.getName());
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 17;
                gbc.insets = new Insets(5, 10, 5, 10);
                configPanel.add((Component)JLabel2, gbc);
                ArrayList<String> items = new ArrayList<String>();
                for (Map.Entry entry1 : parameter.getPossibleValueList().entrySet()) {
                    String content = (String)entry1.getKey();
                    GeneralPariParaNodeItemStruct Item = (GeneralPariParaNodeItemStruct)entry1.getValue();
                    if (!Item.isVisible()) continue;
                    items.add(content);
                }
                final nvicComBox ComboBox = new nvicComBox(items.toArray(new String[items.size()]));
                ComboBox.setParameterObj(parameter);
                ComboBox.setSelectedItem((Object)parameter.getValue());
                gbc.gridx = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                configPanel.add((Component)ComboBox, gbc);
                ComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() != 1) {
                            return;
                        }
                        String NodeItem = ComboBox.getSelectedItem().toString();
                        String GroupName = parameter.getGroupName();
                        String NodeName = parameter.getName();
                        NVICConfigView.this.updateTempNodeValue(GroupName, NodeName, NodeItem);
                        NVICConfigView.this.executeConflict(GroupName, NodeName, NodeItem);
                        NVICConfigUtil.updateCommonToPara(((NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC)).getNVICParameterGroupInfo());
                        NVICConfigView.this.ClearPriority();
                        NVICConfigView.this.DeleteTableData();
                        NVICConfigView.this.InitNVICConfigInfo();
                        NVICConfigView.this.table_NVIC.updateUI();
                        GlobalVariables.isDirtyFlag = true;
                    }
                });
                GridBagConstraints mainGbc = new GridBagConstraints();
                mainGbc.gridx = 0;
                mainGbc.gridy = configCount - 1;
                mainGbc.weightx = 1.0;
                mainGbc.fill = 2;
                mainGbc.insets = new Insets(2, 0, 2, 0);
                this.panel.add((Component)configPanel, mainGbc);
            }
        }
        return configCount;
    }

    private void updateTempNodeValue(String groupName, String nodeName, String nodeValue) {
        ParameterNode node = (ParameterNode)NVICConfigConflict.getConfigNode((String)ViewPeriToNVIC, (String)groupName, (String)nodeName, (String)"");
        node.setValue(nodeValue);
    }

    private void executeConflict(String groupName, String nodeName, String nodeValue) {
        NVICConflictExecute.ConflictExecuteByNVIC((String)"NVIC", (String)groupName, (String)nodeName, (String)nodeValue);
    }

    private void ClearPriority() {
        if (GlobalVariables.NVICConfigTempObj.containsKey(ViewPeriToNVIC)) {
            NVICConfigStruct NVICConfigObj = (NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC);
            LinkedHashMap NVICParameterGroupInfo = NVICConfigObj.getNVICParameterGroupInfo();
            for (Map.Entry entry : NVICParameterGroupInfo.entrySet()) {
                NVICParameterGroupNode ParameterGroups;
                String ParameterGroupName = (String)entry.getKey();
                if (ParameterGroupName.equals("Configuration") || ParameterGroupName.equals("CommonParameter") || !(ParameterGroups = (NVICParameterGroupNode)entry.getValue()).isVisible()) continue;
                LinkedHashMap Parameters = ParameterGroups.getNVICParameterInfo();
                for (Map.Entry entry1 : Parameters.entrySet()) {
                    LinkedHashMap PossibleValueList;
                    ParameterNode parameter = (ParameterNode)entry1.getValue();
                    if (parameter.getType() != ConstantsUtil.ControlType.Combox.ordinal() || ((GeneralPariParaNodeItemStruct)(PossibleValueList = parameter.getPossibleValueList()).get(parameter.getValue())).isVisible()) continue;
                    parameter.setValue(parameter.getDefaultValue());
                }
            }
        }
    }

    private void AddTableRenderEditor() {
        int colunm = 0;
        for (Map.Entry<String, Integer> entry : this.HeadParameters.entrySet()) {
            MyEvent event;
            if (entry.getValue().intValue() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                this.table_NVIC.getColumnModel().getColumn(colunm).setCellRenderer(new NVICCellRenderer());
                nvicCheckBoxCellEditor CheckBoxCellEditor = new nvicCheckBoxCellEditor();
                this.table_NVIC.getColumnModel().getColumn(colunm).setCellEditor(CheckBoxCellEditor);
                event = new MyEvent(){

                    @Override
                    public void invoke(ItemEvent e) {
                        nvicCheckBox CheckBoxObj = (nvicCheckBox)e.getSource();
                        int rowIndex = NVICConfigView.this.table_NVIC.getSelectedRow();
                        int colIndex = NVICConfigView.this.table_NVIC.getSelectedColumn();
                        if (rowIndex >= 0 && colIndex >= 0) {
                            String GroupName = CheckBoxObj.getParameterObj().getGroupName();
                            String NodeName = CheckBoxObj.getParameterObj().getName();
                            String NodeValue = "FALSE";
                            if (CheckBoxObj.isSelected()) {
                                NodeValue = "TRUE";
                            }
                            NVICConfigView.this.updateTempNodeValue(GroupName, NodeName, NodeValue);
                            NVICConfigView.this.executeConflict(GroupName, NodeName, NodeValue);
                            GlobalVariables.isDirtyFlag = true;
                        }
                    }
                };
                CheckBoxCellEditor.SetEvent(event);
                this.CheckBoxCellEditorMap.put(colunm, CheckBoxCellEditor);
            } else if (entry.getValue().intValue() == ConstantsUtil.ControlType.Combox.ordinal()) {
                nvicComboxCellEditor nvicComboBoxCellEditor = new nvicComboxCellEditor();
                this.table_NVIC.getColumnModel().getColumn(colunm).setCellEditor(nvicComboBoxCellEditor);
                event = new MyEvent(){

                    @Override
                    public void invoke(ItemEvent e) {
                        nvicComBox ComboBoxObj = (nvicComBox)e.getSource();
                        int rowIndex = NVICConfigView.this.table_NVIC.getSelectedRow();
                        int colIndex = NVICConfigView.this.table_NVIC.getSelectedColumn();
                        if (rowIndex >= 0 && colIndex >= 0) {
                            String GroupName = ComboBoxObj.getParameterObj().getGroupName();
                            String NodeName = ComboBoxObj.getParameterObj().getName();
                            String NodeItem = ComboBoxObj.getSelectedItem().toString();
                            NVICConfigView.this.updateTempNodeValue(GroupName, NodeName, NodeItem);
                            NVICConfigView.this.executeConflict(GroupName, NodeName, NodeItem);
                            GlobalVariables.isDirtyFlag = true;
                        }
                    }
                };
                nvicComboBoxCellEditor.SetEvent(event);
                this.ComboBoxEditorMap.put(colunm, nvicComboBoxCellEditor);
            }
            ++colunm;
        }
    }

    private void InitNVICConfigInfo() {
        this.model_NVIC.clearCheckBoxDisableRow();
        this.model_NVIC.clearComboxDisableRow();
        if (GlobalVariables.NVICConfigTempObj.containsKey(ViewPeriToNVIC)) {
            NVICConfigStruct NVICConfigObj = (NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC);
            LinkedHashMap NVICParameterGroupInfo = NVICConfigObj.getNVICParameterGroupInfo();
            for (Map.Entry entry : NVICParameterGroupInfo.entrySet()) {
                List PeriList;
                NVICParameterGroupNode ParameterGroups;
                String ParameterGroupName = (String)entry.getKey();
                if (ParameterGroupName.equals("Configuration") || ParameterGroupName.equals("CommonParameter") || !(ParameterGroups = (NVICParameterGroupNode)entry.getValue()).isVisible() || !this.ConfigPeriName.contains("NVIC") && !(PeriList = ParameterGroups.getPeriNameList()).contains(this.ConfigPeriName)) continue;
                LinkedHashMap Parameters = ParameterGroups.getNVICParameterInfo();
                Object[] object = new Object[Parameters.size() + 1];
                int col = 0;
                object[0] = ParameterGroups.getContent();
                ++col;
                for (Map.Entry entry1 : Parameters.entrySet()) {
                    ParameterNode Parameter = (ParameterNode)entry1.getValue();
                    if (Parameter.getType() == ConstantsUtil.ControlType.Label.ordinal()) {
                        object[col] = Parameter.getContent();
                    } else if (Parameter.getType() == ConstantsUtil.ControlType.Combox.ordinal()) {
                        ArrayList<String> comboxItemList = new ArrayList<String>();
                        for (Map.Entry entry2 : Parameter.getPossibleValueList().entrySet()) {
                            if (!((GeneralPariParaNodeItemStruct)entry2.getValue()).isVisible()) continue;
                            comboxItemList.add((String)entry2.getKey());
                        }
                        object[col] = Parameter.getValue();
                        this.ComboBoxEditorMap.get(col).setItem(comboxItemList, this.model_NVIC.getRowCount());
                        this.ComboBoxEditorMap.get(col).setParameterObj(Parameter, this.model_NVIC.getRowCount());
                        if (!Parameter.isEnable()) {
                            this.ComboBoxEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), false);
                            this.model_NVIC.setComboxDisableRow(this.model_NVIC.getRowCount(), col);
                        } else {
                            this.ComboBoxEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), true);
                        }
                    } else if (Parameter.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                        object[col] = Parameter.getValue().toUpperCase().equals("TRUE") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        if (!Parameter.isEnable()) {
                            this.CheckBoxCellEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), false);
                            this.model_NVIC.setCheckBoxDisable(this.model_NVIC.getRowCount());
                        } else {
                            this.CheckBoxCellEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), true);
                        }
                        this.CheckBoxCellEditorMap.get(col).setParameterObj(Parameter, this.model_NVIC.getRowCount());
                    }
                    ++col;
                }
                this.model_NVIC.addRow(object);
            }
        }
    }

    private void RefreshNVICConfigInfo(List<String> nvicGroupNameList) {
        this.model_NVIC.clearCheckBoxDisableRow();
        this.model_NVIC.clearComboxDisableRow();
        if (GlobalVariables.NVICConfigTempObj.containsKey(ViewPeriToNVIC)) {
            NVICConfigStruct NVICConfigObj = (NVICConfigStruct)GlobalVariables.NVICConfigTempObj.get(ViewPeriToNVIC);
            LinkedHashMap NVICParameterGroupInfo = NVICConfigObj.getNVICParameterGroupInfo();
            for (Map.Entry entry : NVICParameterGroupInfo.entrySet()) {
                List PeriList;
                NVICParameterGroupNode ParameterGroups;
                String ParameterGroupName = (String)entry.getKey();
                if (ParameterGroupName.equals("Configuration") || ParameterGroupName.equals("CommonParameter") || !(ParameterGroups = (NVICParameterGroupNode)entry.getValue()).isVisible() || !this.ConfigPeriName.contains("NVIC") && !(PeriList = ParameterGroups.getPeriNameList()).contains(this.ConfigPeriName) || !nvicGroupNameList.contains(ParameterGroups.getName())) continue;
                LinkedHashMap Parameters = ParameterGroups.getNVICParameterInfo();
                Object[] object = new Object[Parameters.size() + 1];
                int col = 0;
                object[0] = ParameterGroups.getContent();
                ++col;
                for (Map.Entry entry1 : Parameters.entrySet()) {
                    ParameterNode Parameter = (ParameterNode)entry1.getValue();
                    if (Parameter.getType() == ConstantsUtil.ControlType.Label.ordinal()) {
                        object[col] = Parameter.getContent();
                    } else if (Parameter.getType() == ConstantsUtil.ControlType.Combox.ordinal()) {
                        ArrayList<String> comboxItemList = new ArrayList<String>();
                        for (Map.Entry entry2 : Parameter.getPossibleValueList().entrySet()) {
                            if (!((GeneralPariParaNodeItemStruct)entry2.getValue()).isVisible()) continue;
                            comboxItemList.add((String)entry2.getKey());
                        }
                        object[col] = Parameter.getValue();
                        this.ComboBoxEditorMap.get(col).setItem(comboxItemList, this.model_NVIC.getRowCount());
                        this.ComboBoxEditorMap.get(col).setParameterObj(Parameter, this.model_NVIC.getRowCount());
                        if (!Parameter.isEnable()) {
                            this.ComboBoxEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), false);
                            this.model_NVIC.setComboxDisableRow(this.model_NVIC.getRowCount(), col);
                        } else {
                            this.ComboBoxEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), true);
                        }
                    } else if (Parameter.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                        object[col] = Parameter.getValue().toUpperCase().equals("TRUE") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        if (!Parameter.isEnable()) {
                            this.CheckBoxCellEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), false);
                            this.model_NVIC.setCheckBoxDisable(this.model_NVIC.getRowCount());
                        } else {
                            this.CheckBoxCellEditorMap.get(col).setEnable(this.model_NVIC.getRowCount(), true);
                        }
                        this.CheckBoxCellEditorMap.get(col).setParameterObj(Parameter, this.model_NVIC.getRowCount());
                    }
                    ++col;
                }
                this.model_NVIC.addRow(object);
            }
        }
    }

    private void DeleteTableData() {
        int i = this.model_NVIC.getRowCount() - 1;
        while (i >= 0) {
            this.model_NVIC.removeRow(i);
            --i;
        }
    }

    private void setupGridBagLayout(boolean hasConfig, JPanel searchPanel, JScrollPane scrollPane) {
        GridBagConstraints gbc = new GridBagConstraints();
        int currentRow = 0;
        if (hasConfig) {
            currentRow = this.panel.getComponentCount();
        }
        gbc.gridx = 0;
        gbc.gridy = currentRow;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.panel.add((Component)searchPanel, gbc);
        this.model_NVIC = new NVICTableModel(null, this.headVector);
        this.table_NVIC = new JTable(this.model_NVIC);
        this.table_NVIC.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table_NVIC.setRowHeight(30);
        this.sorter = new TableRowSorter<NVICTableModel>(this.model_NVIC){

            @Override
            public boolean isSortable(int column) {
                return false;
            }
        };
        this.table_NVIC.setRowSorter(this.sorter);
        JTableHeader head = this.table_NVIC.getTableHeader();
        head.setFont(new Font("Arial", 1, 15));
        this.table_NVIC.setFont(new Font("Arial", 1, 15));
        this.table_NVIC.getTableHeader().setReorderingAllowed(false);
        this.table_NVIC.getTableHeader().setResizingAllowed(true);
        this.table_NVIC.setShowHorizontalLines(true);
        this.table_NVIC.setShowVerticalLines(true);
        scrollPane.setViewportView(this.table_NVIC);
        gbc.gridx = 0;
        gbc.gridy = currentRow + 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 10, 10, 10);
        this.panel.add((Component)scrollPane, gbc);
        this.ComboBoxEditorMap = new HashMap<Integer, nvicComboxCellEditor>();
        this.CheckBoxCellEditorMap = new HashMap<Integer, nvicCheckBoxCellEditor>();
        this.AddTableRenderEditor();
        this.InitNVICConfigInfo();
        this.table_NVIC.updateUI();
        this.panel.revalidate();
        this.panel.repaint();
    }
}

