/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.DMAConflictExecute;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.ControlStateInfo;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAEventStruct;
import com.gigadevice.periconfigview.model.ComboBoxTreeCellEditor;
import com.gigadevice.periconfigview.model.ComboBoxTreeCellRenderer;
import com.gigadevice.periconfigview.model.ComboBoxTreeNode;
import com.gigadevice.periconfigview.model.JComboBoxCellEditor;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import com.gigadevice.periconfigview.utils.MDMAConfigUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAConfigGroupInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAInfoUtil;
import com.gigadevice.venustool.baseinfo.mComboBox;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MDMAConfigView {
    private JPanel panel;
    private JPanel commonJPanel;
    private JTable table_DMA;
    private DefaultTableModel model_DMA;
    private JPanel panel_DMAReqSet;
    private int width = 0;
    private int height = 0;
    private boolean adaptiveMode = true;
    private ComponentAdapter resizeListener;
    private JScrollPane treeScrollPane;
    Vector<Object> headVector;
    String ConfigPeriName = "";
    DefaultMutableTreeNode root;
    JTree tree;
    JButton btn_AddChannel;
    JButton btn_AddRequest;
    private int dmaRequestColumn = 0;
    private int channelColumn = 1;
    boolean ignoreChannelActionEvents = false;
    boolean ignoreActionEvents = false;
    private List<String> mDMARequestList = new ArrayList<String>();
    private Map<Integer, JComboBoxCellEditor> ComboBoxEditorMap;
    private Map<Integer, Component> configComponentMap = new HashMap<Integer, Component>();
    private Map<String, Component> requestComponentMap = new HashMap<String, Component>();
    private static final Insets insets = new Insets(0, 0, 0, 0);

    public MDMAConfigView(String PeriName) {
        this.ConfigPeriName = PeriName;
        this.initPeriDMARequest();
        ConflictUtil.InitPrivilegeXmlInfo((String)"MDMA");
        this.adaptiveMode = true;
    }

    public void UpdateView() {
        if (this.adaptiveMode) {
            this.triggerAdaptiveAdjustment();
        }
        this.refreshUI();
    }

    public void RestoreDMAConfigInfo() {
    }

    public void ReloadDMAConfigPanel() {
        this.setupResizeListener();
        if (this.adaptiveMode) {
            this.triggerAdaptiveAdjustment();
        }
        this.refreshUI();
    }

    public void setSize(int arg0, int arg1) {
        this.width = arg0;
        this.height = arg1;
        if (this.adaptiveMode && this.panel != null) {
            this.performAdaptiveAdjustment();
        }
    }

    private JPanel returnJtreePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.gray);
        this.root = new DefaultMutableTreeNode("Root");
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.ignoreActionEvents = true;
        this.onBtnAddMDMAChannel();
        this.tree = new JTree(model);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 1 && (path = MDMAConfigView.this.tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    MDMAConfigView.this.updateTableAndConfigBySelectedNode(node);
                }
            }
        });
        this.tree.setCellRenderer(new ComboBoxTreeCellRenderer());
        this.tree.setCellEditor(new ComboBoxTreeCellEditor(this.tree, new ComboBoxTreeCellRenderer()));
        this.tree.setEditable(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.InitDMATableModel();
        this.initConfigInfo();
        this.ignoreActionEvents = false;
        this.treeScrollPane = new JScrollPane(this.tree);
        panel.add(this.treeScrollPane);
        return panel;
    }

    public JPanel returnDMAConfigPanel() {
        this.panel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        this.panel.setLayout(mainLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.commonJPanel = new JPanel();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.4;
        gbc.weighty = 0.2;
        this.panel.add((Component)this.commonJPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonGbc = new GridBagConstraints();
        buttonGbc.insets = new Insets(10, 0, 10, 0);
        buttonGbc.gridx = 0;
        buttonGbc.fill = 0;
        buttonGbc.anchor = 10;
        this.btn_AddChannel = new JButton("Add Channel");
        this.btn_AddChannel.setOpaque(true);
        this.btn_AddChannel.setContentAreaFilled(true);
        this.btn_AddChannel.setPreferredSize(new Dimension(120, 30));
        this.btn_AddChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MDMAConfigView.this.onBtnAddMDMAChannel();
                MDMAConfigView.this.tree.repaint();
                MDMAConfigView.this.tree.updateUI();
                MDMAConfigView.this.panel.updateUI();
            }
        });
        buttonPanel.add((Component)this.btn_AddChannel, buttonGbc);
        buttonGbc.gridy = 1;
        this.btn_AddRequest = new JButton("Add Request");
        this.btn_AddRequest.setOpaque(true);
        this.btn_AddRequest.setContentAreaFilled(true);
        this.btn_AddRequest.setPreferredSize(new Dimension(120, 30));
        this.btn_AddRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MDMAConfigView.this.onBtnAddMDMARequest();
                MDMAConfigView.this.tree.repaint();
                MDMAConfigView.this.tree.updateUI();
                MDMAConfigView.this.panel.updateUI();
            }
        });
        buttonPanel.add((Component)this.btn_AddRequest, buttonGbc);
        buttonGbc.gridy = 2;
        JButton btn_Delete = new JButton("Delete");
        btn_Delete.setOpaque(true);
        btn_Delete.setContentAreaFilled(true);
        btn_Delete.setPreferredSize(new Dimension(120, 30));
        btn_Delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MDMAConfigView.this.onBtnDelete();
                MDMAConfigView.this.tree.repaint();
                MDMAConfigView.this.tree.updateUI();
                MDMAConfigView.this.panel.updateUI();
                MDMAConfigView.this.commonJPanel.setVisible(false);
                MDMAConfigView.this.panel_DMAReqSet.removeAll();
                MDMAConfigView.this.panel_DMAReqSet.updateUI();
            }
        });
        buttonPanel.add((Component)btn_Delete, buttonGbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.2;
        this.panel.add((Component)buttonPanel, gbc);
        this.panel_DMAReqSet = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.8;
        this.panel.add((Component)this.panel_DMAReqSet, gbc);
        JPanel jtreePanel = this.returnJtreePanel();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.2;
        this.panel.add((Component)jtreePanel, gbc);
        MDMAConfigView.expandAll(this.tree, new TreePath(this.root));
        this.setupResizeListener();
        return this.panel;
    }

    private static void expandAll(JTree tree, TreePath parent) {
        int childCount = tree.getModel().getChildCount(parent.getLastPathComponent());
        int i = 0;
        while (i < childCount) {
            TreePath path = parent.pathByAddingChild(tree.getModel().getChild(parent.getLastPathComponent(), i));
            tree.expandPath(path);
            MDMAConfigView.expandAll(tree, path);
            ++i;
        }
    }

    private void initConfigInfo() {
        if (MDMAInfoUtil.mDMAConfigInfo.size() > 0) {
            for (Map.Entry entry : MDMAInfoUtil.mDMAConfigInfo.entrySet()) {
                LinkedHashMap mSortChannelInfo = MDMAInfoUtil.GetSortMap((Map)((Map)entry.getValue()));
                block1: for (Map.Entry entry1 : mSortChannelInfo.entrySet()) {
                    String Channel2 = (String)entry1.getKey();
                    boolean isAddChannelNode = true;
                    Enumeration<TreeNode> e = this.root.children();
                    while (e.hasMoreElements()) {
                        ComboBoxTreeNode childNode = (ComboBoxTreeNode)((Object)e.nextElement());
                        if (!childNode.getValue().equals(Channel2) && !childNode.getValue().equals("")) continue;
                        isAddChannelNode = false;
                        break;
                    }
                    if (isAddChannelNode) {
                        this.onBtnAddMDMAChannel();
                    }
                    MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry1.getValue();
                    LinkedHashMap DMAInfoMap = mDMAConfigObj.getMDMAInfoMap();
                    block3: for (String key : mDMAConfigObj.getMDMAInfoSort()) {
                        if (!DMAInfoMap.containsKey(key)) continue;
                        String requestName = key;
                        requestName = requestName.split("%")[0];
                        if (this.root.getChildCount() <= 0) continue block1;
                        Enumeration<TreeNode> e2 = this.root.children();
                        while (e2.hasMoreElements()) {
                            ComboBoxTreeNode requestNode;
                            ComboBoxTreeNode channelNode = (ComboBoxTreeNode)((Object)e2.nextElement());
                            if (!channelNode.getValue().equals(Channel2) && !channelNode.getValue().equals("")) continue;
                            if (channelNode.getValue().equals(Channel2)) {
                                this.addMDMARequestTreeNode(channelNode);
                            }
                            if (!(requestNode = (ComboBoxTreeNode)((Object)channelNode.getLastChild())).getValue().equals("Selected Request")) continue block3;
                            requestNode.getComboBox().setSelectedItem(requestName);
                            requestNode.setValue(requestName);
                            requestNode.setUniqueName(key);
                            this.updateChannelByRequest(requestName);
                            channelNode.getComboBox().setSelectedItem(Channel2);
                            continue block3;
                        }
                    }
                }
            }
        }
    }

    private void onBtnAddMDMAChannel() {
        String[] item0 = new String[]{""};
        final ComboBoxTreeNode channelNode = new ComboBoxTreeNode("", item0, NodeType.isChannelNode.ordinal());
        this.root.add((MutableTreeNode)((Object)channelNode));
        this.addMDMARequestTreeNode(channelNode);
        channelNode.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String selectedItem = (String)e.getItem();
                    String value = channelNode.getValue();
                    GlobalVariables.isDirtyFlag = true;
                    if (selectedItem != null && !value.equals(selectedItem)) {
                        channelNode.setValue(selectedItem);
                        MDMAConfigView.this.updateChannelByOtherChannelNode();
                    }
                }
            }
        });
        if (!this.ignoreActionEvents) {
            MDMAConfigView.expandAll(this.tree, new TreePath(this.root));
        }
    }

    private void addMDMARequestTreeNode(ComboBoxTreeNode channelNode) {
        this.mDMARequestList.clear();
        this.initPeriDMARequest();
        Collections.sort(this.mDMARequestList);
        this.mDMARequestList.add(0, "Selected Request");
        String[] item1 = this.mDMARequestList.toArray(new String[0]);
        final ComboBoxTreeNode requestNode = new ComboBoxTreeNode("Selected Request", item1, NodeType.isRequestNode.ordinal());
        channelNode.add((MutableTreeNode)((Object)requestNode));
        this.btn_AddChannel.setEnabled(false);
        this.btn_AddRequest.setEnabled(false);
        requestNode.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                String selectedItem = (String)comboBox.getSelectedItem();
                if (!selectedItem.equals("Selected Request")) {
                    ArrayList<String> strList = new ArrayList<String>();
                    strList.add(selectedItem);
                    requestNode.updateComboxItems(strList);
                    requestNode.setValue(selectedItem);
                    if (MDMAConfigView.this.ignoreActionEvents) {
                        return;
                    }
                    GlobalVariables.isDirtyFlag = true;
                    MDMAConfigView.this.updateChannelByRequest(selectedItem);
                    ComboBoxTreeNode channelNode = (ComboBoxTreeNode)((Object)requestNode.getParent());
                    String uniqueName = selectedItem;
                    if (channelNode != null) {
                        uniqueName = MDMAConfigView.this.getRequestUniqueName(channelNode, selectedItem);
                    }
                    requestNode.setUniqueName(uniqueName);
                    MDMAConfigInfo mDMAConfigObj = new MDMAConfigInfo();
                    mDMAConfigObj.setMDMARequest(uniqueName);
                    if (channelNode != null) {
                        String ChannelName = channelNode.getValue();
                        mDMAConfigObj.setChannelName(ChannelName);
                        MDMAConfigUtil.AddDMAConfigInfo(mDMAConfigObj);
                    }
                    MDMAConfigView.this.updateTableAndConfigBySelectedNode((DefaultMutableTreeNode)((Object)requestNode));
                }
            }
        });
    }

    private void onBtnAddMDMARequest() {
        ComboBoxTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode == null) {
            return;
        }
        if (selectedNode.getType() == NodeType.isRequestNode.ordinal()) {
            ComboBoxTreeNode parentNode = (ComboBoxTreeNode)((Object)selectedNode.getParent());
            if (parentNode != null) {
                this.addMDMARequestTreeNode(parentNode);
            }
        } else if (selectedNode.getType() == NodeType.isChannelNode.ordinal()) {
            this.addMDMARequestTreeNode(selectedNode);
        } else {
            return;
        }
    }

    private void onBtnDelete() {
        boolean isEnableAddButton = false;
        ComboBoxTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode == null) {
            return;
        }
        if (selectedNode.getType() == NodeType.isRequestNode.ordinal()) {
            ComboBoxTreeNode parentNode;
            if (selectedNode.getValue().equals("Selected Request")) {
                isEnableAddButton = true;
            }
            if ((parentNode = (ComboBoxTreeNode)((Object)selectedNode.getParent())) != null) {
                MDMAConfigUtil.DeleteDMAConfigInfo(parentNode.getValue(), selectedNode.getUniqueName());
            }
            if (parentNode.getChildCount() == 1) {
                this.root.remove((MutableTreeNode)((Object)parentNode));
            } else {
                parentNode.remove((MutableTreeNode)((Object)selectedNode));
            }
            GlobalVariables.isDirtyFlag = true;
        } else if (selectedNode.getType() == NodeType.isChannelNode.ordinal()) {
            if (selectedNode.getValue().equals("")) {
                isEnableAddButton = true;
            }
            MDMAConfigUtil.DeleteDMAConfigInfo(selectedNode.getValue());
            this.root.remove((MutableTreeNode)((Object)selectedNode));
            GlobalVariables.isDirtyFlag = true;
        } else {
            return;
        }
        if (isEnableAddButton) {
            this.btn_AddChannel.setEnabled(true);
            this.btn_AddRequest.setEnabled(true);
        }
    }

    private void updateChannelByRequest(String request) {
        ArrayList<String> requestList = new ArrayList<String>();
        requestList.add(request);
        List<String> allAvailableChannels = this.getAllAvailableChannels(requestList);
        if (this.root.getChildCount() >= 0) {
            Enumeration<TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                ComboBoxTreeNode childNode = (ComboBoxTreeNode)((Object)e.nextElement());
                if (!childNode.getValue().equals("")) continue;
                childNode.updateComboxItems(allAvailableChannels);
                if (allAvailableChannels.size() > 0) {
                    childNode.setValue(allAvailableChannels.get(0));
                }
                this.updateChannelByOtherChannelNode();
                break;
            }
        }
        this.btn_AddChannel.setEnabled(true);
        this.btn_AddRequest.setEnabled(true);
        this.tree.repaint();
        this.tree.updateUI();
        this.panel.updateUI();
    }

    private void updateChannelByOtherChannelNode() {
        if (this.root.getChildCount() <= 0) {
            return;
        }
        this.ignoreChannelActionEvents = true;
        ArrayList<String> channelList = new ArrayList<String>();
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            ComboBoxTreeNode childNode = (ComboBoxTreeNode)((Object)e.nextElement());
            if (childNode.getType() != NodeType.isChannelNode.ordinal()) continue;
            channelList.add(childNode.getValue());
        }
        String currentChannel = "";
        Enumeration<TreeNode> e2 = this.root.children();
        while (e2.hasMoreElements()) {
            ComboBoxTreeNode childNode = (ComboBoxTreeNode)((Object)e2.nextElement());
            if (childNode.getType() != NodeType.isChannelNode.ordinal()) continue;
            currentChannel = childNode.getValue();
            ArrayList<String> requestList = new ArrayList<String>();
            Enumeration child = childNode.children();
            while (child.hasMoreElements()) {
                ComboBoxTreeNode rChildNode = (ComboBoxTreeNode)((Object)child.nextElement());
                if (rChildNode.getType() != NodeType.isRequestNode.ordinal()) continue;
                requestList.add(rChildNode.getValue());
            }
            List<String> allAvailableChannels = this.getAllChannels(requestList);
            for (String UsedChannel : channelList) {
                if (UsedChannel.equals(currentChannel)) continue;
                allAvailableChannels.remove(UsedChannel);
            }
            childNode.updateComboxItems(allAvailableChannels);
            childNode.setValue(currentChannel);
        }
    }

    private String getRequestUniqueName(ComboBoxTreeNode channelNode, String requestName) {
        String uniqueName = String.valueOf(requestName) + "%1";
        String maxIndexUniqueName = "";
        Enumeration child = channelNode.children();
        while (child.hasMoreElements()) {
            ComboBoxTreeNode requestNode = (ComboBoxTreeNode)((Object)child.nextElement());
            if (requestNode.getType() != NodeType.isRequestNode.ordinal() || !requestNode.getValue().contains(requestName) || !requestNode.getUniqueName().contains(requestName) || requestNode.getUniqueName().length() <= maxIndexUniqueName.length()) continue;
            maxIndexUniqueName = requestNode.getUniqueName();
        }
        if (!maxIndexUniqueName.equals("")) {
            uniqueName = String.valueOf(maxIndexUniqueName) + "1";
        }
        return uniqueName;
    }

    private List<String> getAllChannels(List<String> requestList) {
        ArrayList<String> channelList = new ArrayList<String>();
        Iterator<String> iterator = requestList.iterator();
        if (iterator.hasNext()) {
            String mDMARequest = iterator.next();
            block0: for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : MDMAConfigUtil.mdmaAllInfo.getConfigInfoMap().entrySet()) {
                Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
                if (!PartsMap.containsKey(mDMARequest)) continue;
                List<PeriConfigPart> PartList = PartsMap.get(mDMARequest);
                int i = 0;
                while (i < PartList.size()) {
                    PeriConfigPart partObj = PartList.get(i);
                    if (partObj.getCol() == this.channelColumn) {
                        List<PeriConfigItem> IemList = partObj.getIemList();
                        int j = 0;
                        while (j < IemList.size()) {
                            String Channel2 = IemList.get(j).getName();
                            channelList.add(Channel2);
                            ++j;
                        }
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return channelList;
    }

    private List<String> getAllAvailableChannels(List<String> requestList) {
        List<String> channelList = this.getAllChannels(requestList);
        if (this.root.getChildCount() <= 0) {
            return channelList;
        }
        ArrayList<String> usedChannelList = new ArrayList<String>();
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            ComboBoxTreeNode childNode = (ComboBoxTreeNode)((Object)e.nextElement());
            if (childNode.getType() != NodeType.isChannelNode.ordinal()) continue;
            usedChannelList.add(childNode.getValue());
        }
        for (String channelStr : usedChannelList) {
            if (!channelList.contains(channelStr)) continue;
            channelList.remove(channelStr);
        }
        return channelList;
    }

    private ComboBoxTreeNode getSelectedTreeNode() {
        ComboBoxTreeNode selectedNode = null;
        TreePath selectedPath = this.tree.getSelectionPath();
        if (selectedPath != null) {
            selectedNode = (ComboBoxTreeNode)((Object)selectedPath.getLastPathComponent());
        }
        return selectedNode;
    }

    private void initPeriDMARequest() {
        if ("MDMA".equals(this.ConfigPeriName)) {
            this.AddPeriDMARequest("MDMA");
            this.AddPeriDMARequest("DMA");
            for (Map.Entry entry : GlobalVariables.PeripheralConfigObjMap.entrySet()) {
                this.AddPeriDMARequest((String)entry.getKey());
            }
        } else if ("MEMTOMEM".equals(this.ConfigPeriName)) {
            this.mDMARequestList.add("MEMTOMEM");
        } else {
            this.AddPeriDMARequest(this.ConfigPeriName);
        }
    }

    private void AddPeriDMARequest(String PeriNameStr) {
        if (MDMAConfigUtil.mdmaAllInfo.getPeriModeEventInfo().size() == 0) {
            if (!MDMAConfigUtil.mdmaAllInfo.getConfigInfoMap().containsKey(PeriNameStr)) {
                return;
            }
            Map<String, List<PeriConfigPart>> DMAConfigInfoMap = MDMAConfigUtil.mdmaAllInfo.getConfigInfoMap().get(PeriNameStr);
            for (Map.Entry<String, List<PeriConfigPart>> entry : DMAConfigInfoMap.entrySet()) {
                String requestName = entry.getKey();
                if (MDMAConfigUtil.mdmaAllInfo.getRequestConditionMap().containsKey(requestName)) {
                    ConflictGroupInfo ConflictGroupObj = MDMAConfigUtil.mdmaAllInfo.getRequestConditionMap().get(requestName);
                    if (!ConflictCheck.PrivilegeCheck((String)ConflictGroupObj.getType(), (List)ConflictGroupObj.getConditionsList())) continue;
                    this.mDMARequestList.add(requestName);
                    continue;
                }
                this.mDMARequestList.add(requestName);
            }
            return;
        }
        if (!MDMAConfigUtil.mdmaAllInfo.getPeriModeEventInfo().containsKey(PeriNameStr)) {
            return;
        }
        Map<String, DMAEventStruct> ModeEventInfo = MDMAConfigUtil.mdmaAllInfo.getPeriModeEventInfo().get(PeriNameStr);
        Map NodeMap = (Map)GlobalVariables.PeripheralConfigObjMap.get(PeriNameStr);
        block1: for (Map.Entry<String, DMAEventStruct> entry : ModeEventInfo.entrySet()) {
            String ModeName = entry.getKey();
            if (ModeName.equals("")) {
                this.mDMARequestList.addAll(entry.getValue().getEventSet());
                continue;
            }
            if (NodeMap == null) {
                return;
            }
            int Type2 = entry.getValue().getType();
            if (Type2 == 1) {
                for (Map.Entry NodeMapEntry : NodeMap.entrySet()) {
                    NodeStruct NodeObj = (NodeStruct)NodeMapEntry.getValue();
                    String ItemName = NodeObj.getValue();
                    if (!ModeName.equals(ItemName)) continue;
                    this.mDMARequestList.addAll(entry.getValue().getEventSet());
                    continue block1;
                }
                continue;
            }
            if (Type2 != 0 || !NodeMap.containsKey(ModeName)) continue;
            this.mDMARequestList.addAll(entry.getValue().getEventSet());
        }
    }

    private void updateTableAndConfigBySelectedNode(DefaultMutableTreeNode node) {
        ComboBoxTreeNode selectedNode = (ComboBoxTreeNode)((Object)node);
        if (selectedNode.getType() != NodeType.isRequestNode.ordinal()) {
            return;
        }
        if (selectedNode.getValue().equals("Selected Request")) {
            return;
        }
        String DMARequestName = selectedNode.getUniqueName();
        ComboBoxTreeNode parentNode = (ComboBoxTreeNode)((Object)selectedNode.getParent());
        if (parentNode == null) {
            return;
        }
        if (parentNode.getValue().equals("")) {
            return;
        }
        String ChannelName = parentNode.getValue();
        this.DMARequestSelectedUpdateTabel(DMARequestName, ChannelName);
    }

    public void DMARequestSelectedUpdateTabel(String DMARequestName, String ChannelName) {
        MDMAConfigInfo mDMAConfigInfo;
        JLabel label;
        this.commonJPanel.setVisible(true);
        String requestName = DMARequestName;
        if (this.configComponentMap.containsKey(this.dmaRequestColumn)) {
            label = (JLabel)this.configComponentMap.get(this.dmaRequestColumn);
            requestName = DMARequestName.split("%")[0];
            label.setText(requestName);
        }
        if (this.configComponentMap.containsKey(this.channelColumn)) {
            label = (JLabel)this.configComponentMap.get(this.channelColumn);
            label.setText(ChannelName);
        }
        if ((mDMAConfigInfo = MDMAConfigUtil.GetMDMAConfigInfo(ChannelName, DMARequestName)) == null) {
            return;
        }
        List<PeriConfigPart> PartList = MDMAConfigUtil.getControlListByRequest(requestName);
        if (PartList == null) {
            return;
        }
        int i = 0;
        while (i < PartList.size()) {
            PeriConfigPart partObj = PartList.get(i);
            if (partObj.getUILocation() == DMAConfigUtil.UILocation.isTable.ordinal() && partObj.getCol() != this.dmaRequestColumn && partObj.getCol() != this.channelColumn) {
                if (mDMAConfigInfo.getContorlValue(partObj.getName()) == null) {
                    mDMAConfigInfo.setContorlValue(partObj.getName(), partObj.getValue());
                }
                mComboBox combox = (mComboBox)this.configComponentMap.get(partObj.getCol());
                combox.setSelectedItem((Object)mDMAConfigInfo.getContorlValue(partObj.getName()));
                combox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        GlobalVariables.isDirtyFlag = true;
                        MDMAConfigView.this.updateAllControlState((DMAConfigInfo)mDMAConfigInfo);
                    }
                });
            }
            ++i;
        }
        this.InitDMARequestSettingPanel(mDMAConfigInfo);
    }

    private void InitDMATableModel() {
        this.commonJPanel.setLayout(new GridBagLayout());
        GridBagLayout layout = new GridBagLayout();
        JPanel panel1 = new JPanel(layout);
        panel1.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        panel1.setToolTipText("");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.commonJPanel.add((Component)panel1, constraints);
        this.commonJPanel.setVisible(false);
        JScrollPane scrollConfig = new JScrollPane(panel1);
        this.commonJPanel.add((Component)scrollConfig, constraints);
        if (MDMAConfigUtil.mdmaAllInfo.getConfigInfoMap().size() == 0) {
            return;
        }
        List<PeriConfigPart> periConfigs = MDMAConfigUtil.mdmaAllInfo.getConfigInfoMap().get("ColumnInfos").get("ColumnInfos");
        int i = 0;
        while (i < periConfigs.size()) {
            final PeriConfigPart PeriConfigObj = periConfigs.get(i);
            if (PeriConfigObj.getType() == 2) {
                JLabel label = new JLabel(PeriConfigObj.getName());
                MDMAConfigView.addComponent(panel1, label, PeriConfigObj.getCol(), 0, 1, 1, 17, 2);
                ArrayList<String> comboxItemList = new ArrayList<String>();
                if (PeriConfigObj.getName().equals("MDMA Request") || PeriConfigObj.getName().equals("Channel")) {
                    JLabel label_C = new JLabel("NULL");
                    MDMAConfigView.addComponent(panel1, label_C, PeriConfigObj.getCol(), 1, 1, 1, 17, 2);
                    this.configComponentMap.put(PeriConfigObj.getCol(), label_C);
                } else {
                    List<PeriConfigItem> ItemList = PeriConfigObj.getIemList();
                    int t = 0;
                    while (t < ItemList.size()) {
                        comboxItemList.add(ItemList.get(t).getName());
                        ++t;
                    }
                    String[] Options = comboxItemList.toArray(new String[comboxItemList.size()]);
                    final mComboBox comboBox = new mComboBox(Options);
                    comboBox.setSelectedItem(comboxItemList.get(0));
                    comboBox.setFont(new Font("Arial", 1, 10));
                    MDMAConfigView.addComponent(panel1, (Component)comboBox, PeriConfigObj.getCol(), 1, 1, 1, 17, 2);
                    this.configComponentMap.put(PeriConfigObj.getCol(), (Component)comboBox);
                    comboBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            String selectedItem = comboBox.getSelectedItem().toString();
                            MDMAConfigView.this.updateChannelConfig(PeriConfigObj.getName(), selectedItem);
                            GlobalVariables.isDirtyFlag = true;
                        }
                    });
                }
            }
            ++i;
        }
        panel1.updateUI();
        scrollConfig.revalidate();
    }

    public void updateChannelConfig(String controlName, String value) {
        JLabel channelLabel = (JLabel)this.configComponentMap.get(this.channelColumn);
        String channelName = channelLabel.getText();
        MDMAConfigGroupInfo mDMAConfigGroupObj = MDMAConfigUtil.GetMDMAGroupInfo(channelName);
        mDMAConfigGroupObj.setContorlValue(controlName, value);
    }

    private void InitDMARequestSettingPanel(MDMAConfigInfo dmaConfigInfo) {
        this.panel_DMAReqSet.removeAll();
        this.requestComponentMap.clear();
        if (dmaConfigInfo == null) {
            return;
        }
        this.panel_DMAReqSet.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        int col = 0;
        for (Map.Entry<String, List<PeriConfigPart>> entry : MDMAConfigUtil.mdmaAllInfo.getRequsteInfoMap().entrySet()) {
            String groupName = entry.getKey();
            List<PeriConfigPart> parts = entry.getValue();
            GridBagLayout layout = new GridBagLayout();
            JPanel panel = new JPanel(layout);
            panel.setBorder(new TitledBorder(null, groupName, 4, 2, null, null));
            panel.setToolTipText("");
            JScrollPane scrollConfig = new JScrollPane(panel);
            scrollConfig.setBorder(null);
            constraints.gridx = 0;
            constraints.gridy = col++;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 11;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.panel_DMAReqSet.add((Component)scrollConfig, constraints);
            this.addDMARequestGroupControl(panel, dmaConfigInfo, parts);
            panel.revalidate();
            scrollConfig.revalidate();
        }
        this.updateAllControlState((DMAConfigInfo)dmaConfigInfo);
        if (this.adaptiveMode) {
            this.adjustDMARequestSettingPanelSize();
        }
        this.panel_DMAReqSet.revalidate();
        this.panel_DMAReqSet.repaint();
    }

    private void addDMARequestGroupControl(JPanel panel, MDMAConfigInfo dmaConfigInfo, List<PeriConfigPart> parts) {
        int i = 0;
        while (i < parts.size()) {
            JComponent component;
            String Name;
            PeriConfigPart periConfigPart;
            block14: {
                int Type2;
                block16: {
                    PeriConfigPart specConfigPartObj;
                    block15: {
                        block13: {
                            periConfigPart = new PeriConfigPart();
                            periConfigPart = parts.get(i);
                            Type2 = periConfigPart.getType();
                            String value = periConfigPart.getValue();
                            Name = periConfigPart.getName();
                            specConfigPartObj = DMAConfigUtil.getSpecialControl(dmaConfigInfo.getDMARequest(), Name, MDMAConfigUtil.mdmaAllInfo.getConfigInfoMap());
                            if (specConfigPartObj != null) {
                                value = specConfigPartObj.getValue();
                            }
                            if (dmaConfigInfo.getContorlValue(Name) != null) {
                                value = dmaConfigInfo.getContorlValue(Name);
                            } else {
                                dmaConfigInfo.setContorlValue(Name, value);
                            }
                            component = null;
                            if (Type2 != ControlStyle.isLable.ordinal()) break block13;
                            value = " " + value;
                            component = new JLabel(value);
                            break block14;
                        }
                        if (Type2 != ControlStyle.isCheckBox.ordinal()) break block15;
                        component = new JCheckBox("");
                        this.InitCheckBoxControl(component, periConfigPart, (DMAConfigInfo)dmaConfigInfo);
                        break block14;
                    }
                    if (Type2 != ControlStyle.isComBox.ordinal()) break block16;
                    List<PeriConfigItem> PeriConfigItemList = periConfigPart.getIemList();
                    ArrayList<String> ItemList = new ArrayList<String>();
                    int k = 0;
                    while (k < PeriConfigItemList.size()) {
                        block18: {
                            List<String> DisableList;
                            block17: {
                                if (specConfigPartObj == null) break block17;
                                List<PeriConfigItem> spItemList = specConfigPartObj.getIemList();
                                boolean sign = false;
                                for (PeriConfigItem spItemObj : spItemList) {
                                    if (!spItemObj.getName().equals(PeriConfigItemList.get(k).getName())) continue;
                                    sign = true;
                                    break;
                                }
                                if (!sign) break block18;
                            }
                            if (!(DisableList = PeriConfigItemList.get(k).getDisableList()).contains(dmaConfigInfo.getMDMARequest())) {
                                ItemList.add(PeriConfigItemList.get(k).getName());
                            }
                        }
                        ++k;
                    }
                    String[] Options = ItemList.toArray(new String[ItemList.size()]);
                    component = new mComboBox(Options);
                    this.InitComBoxControl(component, periConfigPart, (DMAConfigInfo)dmaConfigInfo);
                    break block14;
                }
                if (Type2 == ControlStyle.isEdit.ordinal()) {
                    component = new JTextField();
                    this.InitEditControl(component, periConfigPart, (DMAConfigInfo)dmaConfigInfo);
                }
            }
            if (component != null) {
                this.requestComponentMap.put(Name, component);
                int FontSize = 11;
                if (parts.size() > 12) {
                    FontSize = 9;
                }
                ((Component)component).setFont(new Font("Arial", 1, FontSize));
                MDMAConfigView.addComponent(panel, component, periConfigPart.getRow(), periConfigPart.getCol(), 1, 1, 17, 2);
            }
            ++i;
        }
    }

    public void InitCheckBoxControl(Component component, PeriConfigPart periConfigPart, final DMAConfigInfo dmaConfigInfo) {
        final String Name = periConfigPart.getName();
        final JCheckBox checkBox = (JCheckBox)component;
        String value = "";
        if (dmaConfigInfo.getContorlValue(Name) != null) {
            value = dmaConfigInfo.getContorlValue(Name);
        } else {
            value = periConfigPart.getValue();
            dmaConfigInfo.setContorlValue(Name, value);
        }
        if ("True".equals(value)) {
            checkBox.setSelected(true);
            dmaConfigInfo.setContorlValue(Name, "True");
        } else if ("False".equals(value)) {
            checkBox.setSelected(false);
            dmaConfigInfo.setContorlValue(Name, "False");
        }
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (checkBox.isSelected()) {
                    dmaConfigInfo.setContorlValue(Name, "True");
                } else {
                    dmaConfigInfo.setContorlValue(Name, "False");
                }
                GlobalVariables.isDirtyFlag = true;
                MDMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }
        });
    }

    public void InitComBoxControl(Component component, PeriConfigPart periConfigPart, final DMAConfigInfo dmaConfigInfo) {
        final mComboBox comboBox = (mComboBox)component;
        final String Name = periConfigPart.getName();
        String value = "";
        if (dmaConfigInfo.getContorlValue(Name) != null) {
            value = dmaConfigInfo.getContorlValue(Name);
        }
        comboBox.setSelectedItem((Object)value);
        String selectedItem = comboBox.getSelectedItem().toString();
        dmaConfigInfo.setContorlValue(Name, selectedItem);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selectedItem = comboBox.getSelectedItem().toString();
                dmaConfigInfo.setContorlValue(Name, selectedItem);
                GlobalVariables.isDirtyFlag = true;
                MDMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }
        });
    }

    public void InitEditControl(Component component, PeriConfigPart periConfigPart, final DMAConfigInfo dmaConfigInfo) {
        final String Name = periConfigPart.getName();
        final JTextField txtfield = (JTextField)component;
        String value = "";
        if (dmaConfigInfo.getContorlValue(Name) != null) {
            value = dmaConfigInfo.getContorlValue(Name);
        } else {
            value = periConfigPart.getValue();
            dmaConfigInfo.setContorlValue(Name, value);
        }
        txtfield.setText(value);
        dmaConfigInfo.setContorlValue(Name, value);
        txtfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeriConfigPart partObj;
                String text = txtfield.getText();
                if (!DMAConfigUtil.checkEditValid(text, partObj = DMAConfigUtil.getControlObj("", Name, MDMAConfigUtil.mdmaAllInfo.getRequsteInfoMap()))) {
                    String messageInfo = "The input value for control " + Name + " is invalid. " + partObj.getValueValidTips();
                    Frame frame = new Frame();
                    frame.setAlwaysOnTop(true);
                    Object[] options = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(frame, messageInfo, "Message", -1, -1, null, options, options[0]);
                    txtfield.setText(dmaConfigInfo.getContorlValue(Name));
                    return;
                }
                dmaConfigInfo.setContorlValue(Name, text);
                GlobalVariables.isDirtyFlag = true;
                MDMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }
        });
        txtfield.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PeriConfigPart partObj;
                String text = txtfield.getText();
                if (!DMAConfigUtil.checkEditValid(text, partObj = DMAConfigUtil.getControlObj("", Name, MDMAConfigUtil.mdmaAllInfo.getRequsteInfoMap()))) {
                    String messageInfo = "The input value for control " + Name + " is invalid. " + partObj.getValueValidTips();
                    Frame frame = new Frame();
                    frame.setAlwaysOnTop(true);
                    Object[] options = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(frame, messageInfo, "Message", -1, -1, null, options, options[0]);
                    txtfield.setText(dmaConfigInfo.getContorlValue(Name));
                    return;
                }
                dmaConfigInfo.setContorlValue(Name, text);
                GlobalVariables.isDirtyFlag = true;
                MDMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        GridBagConstraints gbc = new GridBagConstraints(gridy, gridx, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    private void updateAllControlState(DMAConfigInfo dmaConfigInfo) {
        for (Map.Entry<String, List<PeriConfigPart>> entry : MDMAConfigUtil.mdmaAllInfo.getRequsteInfoMap().entrySet()) {
            String groupName = entry.getKey();
            List<PeriConfigPart> parts = entry.getValue();
            int i = 0;
            while (i < parts.size()) {
                PeriConfigPart periConfigPart = parts.get(i);
                String controlName = periConfigPart.getName();
                int controlType = periConfigPart.getType();
                ControlStateInfo controlState = DMAConflictExecute.getMDMAControlState((String)groupName, (String)controlName, (String)"", (Map)dmaConfigInfo.getContorlInfoMap());
                this.updateDMARequestControl(controlName, "", controlState, controlType);
                Component component = this.requestComponentMap.get(controlName);
                if (component == null) {
                    return;
                }
                if (controlType == ControlStyle.isComBox.ordinal()) {
                    mComboBox comboBox = (mComboBox)component;
                    ComboBoxModel model = comboBox.getModel();
                    int j = 0;
                    while (j < model.getSize()) {
                        String option = (String)model.getElementAt(j);
                        controlState = DMAConflictExecute.getMDMAControlState((String)groupName, (String)controlName, (String)option, (Map)dmaConfigInfo.getContorlInfoMap());
                        this.updateDMARequestControl(controlName, option, controlState, controlType);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void updateDMARequestControl(String controlName, String itemName, ControlStateInfo controlState, int controlType) {
        Component component = this.requestComponentMap.get(controlName);
        if (component == null) {
            return;
        }
        boolean enable = controlState.isEnable();
        boolean visble = controlState.isVisible();
        if (itemName.equals("")) {
            component.setEnabled(enable);
            component.setVisible(visble);
            if ((controlState.getState() >> 2 & 1) != 0) {
                String value = controlState.getValue();
                if (controlType == ControlStyle.isCheckBox.ordinal()) {
                    JCheckBox checkBox = (JCheckBox)component;
                    if (value.toUpperCase().equals("TRUE")) {
                        checkBox.setSelected(true);
                    } else {
                        checkBox.setSelected(false);
                    }
                } else if (controlType == ControlStyle.isComBox.ordinal()) {
                    mComboBox comboBox = (mComboBox)component;
                    if (comboBox.getSelectedItem().equals(value)) {
                        return;
                    }
                    comboBox.setSelectedItem((Object)value);
                } else if (controlType == ControlStyle.isEdit.ordinal()) {
                    JTextField txtfield = (JTextField)component;
                    if (txtfield.getText().equals(value)) {
                        return;
                    }
                    txtfield.setText(value);
                }
            }
        } else if (controlType == ControlStyle.isComBox.ordinal()) {
            mComboBox comboBox = (mComboBox)component;
            if (!enable) {
                comboBox.disableItem((Object)itemName);
            } else {
                comboBox.removeItem((Object)itemName);
            }
        }
    }

    private void setupResizeListener() {
        if (this.panel == null) {
            return;
        }
        if (this.resizeListener != null) {
            this.panel.removeComponentListener(this.resizeListener);
        }
        this.resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MDMAConfigView.this.adaptiveMode) {
                    MDMAConfigView.this.handleWindowResize();
                }
            }
        };
        this.panel.addComponentListener(this.resizeListener);
    }

    private void handleWindowResize() {
        if (this.panel == null) {
            return;
        }
        Dimension currentSize = this.panel.getSize();
        if (currentSize.width <= 0 || currentSize.height <= 0) {
            return;
        }
        this.width = currentSize.width;
        this.height = currentSize.height;
        this.performAdaptiveAdjustment();
    }

    private void performAdaptiveAdjustment() {
        this.adjustTreePanelSize();
        this.adjustButtonPanelSize();
        this.adjustConfigPanelSize();
        this.adjustDMARequestSettingPanelSize();
        this.refreshUI();
    }

    private void adjustTreePanelSize() {
        if (this.treeScrollPane == null || this.width <= 0) {
            return;
        }
        int treeWidth = Math.max(200, (int)((double)this.width * 0.3));
        int treeHeight = Math.max(150, (int)((double)this.height * 0.4));
        Dimension treeSize = new Dimension(treeWidth, treeHeight);
        this.treeScrollPane.setMinimumSize(treeSize);
        this.treeScrollPane.setPreferredSize(treeSize);
    }

    private void adjustButtonPanelSize() {
        Container parent;
        if (this.btn_AddChannel == null || this.width <= 0) {
            return;
        }
        int buttonWidth = Math.max(200, Math.min(300, (int)((double)this.width * 0.16)));
        int buttonHeight = Math.max(25, Math.min(35, (int)((double)this.height * 0.04)));
        Dimension buttonSize = new Dimension(buttonWidth, buttonHeight);
        if (this.btn_AddChannel != null) {
            this.btn_AddChannel.setPreferredSize(buttonSize);
        }
        if (this.btn_AddRequest != null) {
            this.btn_AddRequest.setPreferredSize(buttonSize);
        }
        if ((parent = this.btn_AddChannel.getParent()) != null) {
            Component[] components;
            Component[] componentArray = components = parent.getComponents();
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof JButton && ((JButton)comp).getText().equals("Delete")) {
                    comp.setPreferredSize(buttonSize);
                    break;
                }
                ++n2;
            }
        }
    }

    private void adjustConfigPanelSize() {
        if (this.commonJPanel == null || this.width <= 0) {
            return;
        }
        int configWidth = Math.max(300, (int)((double)this.width * 0.4));
        int configHeight = Math.max(100, (int)((double)this.height * 0.15));
        Dimension configSize = new Dimension(configWidth, configHeight);
        this.commonJPanel.setMinimumSize(configSize);
        this.commonJPanel.setPreferredSize(configSize);
    }

    private void adjustDMARequestSettingPanelSize() {
        if (this.panel_DMAReqSet == null || this.width <= 0) {
            return;
        }
        int reqSetWidth = Math.max(400, (int)((double)this.width * 0.9));
        int reqSetHeight = Math.max(200, (int)((double)this.height * 0.5));
        Dimension reqSetSize = new Dimension(reqSetWidth, reqSetHeight);
        this.panel_DMAReqSet.setMinimumSize(reqSetSize);
        this.panel_DMAReqSet.setPreferredSize(reqSetSize);
        this.adjustFontSizeBasedOnWindowSize();
    }

    private void adjustFontSizeBasedOnWindowSize() {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        int baseFontSize = 11;
        if (this.width < 800 || this.height < 600) {
            baseFontSize = 9;
        } else if (this.width > 1200 && this.height > 800) {
            baseFontSize = 12;
        }
        Font newFont = new Font("Arial", 1, baseFontSize);
        for (Component component : this.requestComponentMap.values()) {
            if (component == null) continue;
            component.setFont(newFont);
        }
        for (Component component : this.configComponentMap.values()) {
            if (component == null) continue;
            component.setFont(newFont);
        }
    }

    private void refreshUI() {
        if (this.panel == null) {
            return;
        }
        this.panel.revalidate();
        this.panel.repaint();
        if (this.commonJPanel != null) {
            this.commonJPanel.revalidate();
            this.commonJPanel.repaint();
        }
        if (this.panel_DMAReqSet != null) {
            this.panel_DMAReqSet.revalidate();
            this.panel_DMAReqSet.repaint();
        }
        if (this.treeScrollPane != null) {
            this.treeScrollPane.revalidate();
            this.treeScrollPane.repaint();
        }
    }

    public void setAdaptiveMode(boolean enabled) {
        this.adaptiveMode = enabled;
        if (enabled && this.panel != null) {
            this.handleWindowResize();
        }
    }

    public boolean isAdaptiveMode() {
        return this.adaptiveMode;
    }

    public void triggerAdaptiveAdjustment() {
        if (this.adaptiveMode) {
            this.handleWindowResize();
        }
    }

    static enum ChannelOp {
        ChannelAdd,
        ChannelSwitch,
        ChannelRelease;

    }

    static enum ControlStyle {
        isLable,
        isCheckBox,
        isComBox,
        isEdit;

    }

    static enum NodeType {
        isChannelNode,
        isRequestNode;

    }
}

