/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.tool;

import com.gigadevice.ui.baseinfo.FilesStruct;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ProjectCreator {
    private final String LINKEDRESOURCES = "linkedResources";
    private final String NODE_LINK = "link";
    private final String NODE_NAME = "name";
    private final String NODE_TYPE = "type";
    private final String NODE_URI = "locationURI";

    public void createProject(String projectName, IPath projctLocation) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!project.exists()) {
                project.create(null);
                project.open(null);
                if (projctLocation != null) {
                    IProjectDescription desc = project.getDescription();
                    desc.setLocation(projctLocation);
                    project.move(desc, 33, null);
                }
                project.refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshProject(String projectName) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                project.refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void linkResources(String projectName, List<FilesStruct> virtualFolders, List<FilesStruct> linkedFiles) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                Element linkElement;
                File projectFile = new File(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toFile(), ".project");
                Document document = this.parseXML(projectFile);
                Element linkedResourcesElement = document.getRootElement().element("linkedResources");
                if (linkedResourcesElement == null) {
                    linkedResourcesElement = document.getRootElement().addElement("linkedResources");
                } else {
                    linkedResourcesElement.getParent().remove(linkedResourcesElement);
                }
                for (FilesStruct virFolder : virtualFolders) {
                    linkElement = linkedResourcesElement.addElement("link");
                    linkElement.addElement("name").setText(virFolder.getFileName());
                    linkElement.addElement("type").setText(virFolder.getFileType());
                    linkElement.addElement("locationURI").setText(virFolder.getFilePath());
                }
                for (FilesStruct linkFile : linkedFiles) {
                    linkElement = linkedResourcesElement.addElement("link");
                    linkElement.addElement("name").setText(linkFile.getFileName());
                    linkElement.addElement("type").setText(linkFile.getFileType());
                    linkElement.addElement("locationURI").setText(linkFile.getFilePath());
                }
                this.saveXML(document, projectFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document parseXML(File file) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(file);
    }

    private void saveXML(Document document, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter writer = new FileWriter(file);){
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateIncludePath(String projectName, String include) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                File projectFile = new File(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toFile(), ".cproject");
                String filePath = projectFile.getPath();
                String cprojectContent = this.readCProjectFile(filePath);
                String modifiedContent = cprojectContent.replace("<listOptionValue builtIn=\"false\" value=\"&quot;&quot;\"/>", include);
                this.writeCProjectFile(filePath, modifiedContent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String readCProjectFile(String filePath) {
        StringBuilder content = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append(System.lineSeparator());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    private void writeCProjectFile(String filePath, String content) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                writer.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getIncludeNode(List<String> lstInclude) {
        String strRet = "";
        for (String filePath : lstInclude) {
            String include = "&quot;" + filePath + "&quot;";
            include = include.replace("\\", "/");
            String value = "<listOptionValue builtIn=\"false\" value=\"" + include + "\"/>" + "\r";
            strRet = String.valueOf(strRet) + value;
        }
        return strRet;
    }
}

