/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.tool;

import com.gigadevice.ui.baseinfo.FilesStruct;
import com.gigadevice.ui.baseinfo.GroupStruct;
import com.gigadevice.ui.baseinfo.TargetInfoStruct;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MDKProjParse {
    private final String ELE_TARGETS = "Targets";
    private final String ELE_TARGET = "Target";
    private final String ELE_TARGETNAME = "TargetName";
    private final String ELE_TARGETOPT = "TargetOption";
    private final String ELE_TARGETCOMMONOPT = "TargetCommonOption";
    private final String ELE_DEVICE = "Device";
    private final String ELE_TARGETARM = "TargetArmAds";
    private final String ELE_CADS = "Cads";
    private final String ELE_ARMADS = "ArmAdsMisc";
    private final String ELE_NSECURE = "nSecure";
    private final String ELE_VARCTRLS = "VariousControls";
    private final String ELE_INCPATH = "IncludePath";
    private final String ELE_DEFINE = "Define";
    private final String ELE_GROUPS = "Groups";
    private final String ELE_GROUP = "Group";
    private final String ELE_GROUPNAME = "GroupName";
    private final String ELE_FILES = "Files";
    private final String ELE_FILE = "File";
    private final String ELE_FILENAME = "FileName";
    private final String ELE_FILETYPE = "FileType";
    private final String ELE_FILEPATH = "FilePath";
    private final String ELE_FILEOPTION = "FileOption";
    private Map<String, TargetInfoStruct> mapTarget = new HashMap<String, TargetInfoStruct>();
    private boolean isMultiple = false;
    private File uvprojxDir;

    public void parseMDKProj(String filePath) {
        SAXReader saxReader = new SAXReader();
        try {
            File uvprojxFile = new File(filePath);
            this.uvprojxDir = uvprojxFile.getParentFile();
            Document document = saxReader.read(uvprojxFile);
            Element rootElm = document.getRootElement();
            Element Targets = rootElm.element("Targets");
            this.processTargetsNode(Targets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processTargetsNode(Element Node2) {
        if (Node2 == null) {
            return;
        }
        List TargetList = Node2.elements("Target");
        this.isMultiple = TargetList.size() > 0;
        for (Element elm : TargetList) {
            this.processTargetNode(elm);
        }
    }

    private void processTargetNode(Element Node2) {
        if (Node2 == null) {
            return;
        }
        TargetInfoStruct targetInfoStruct = new TargetInfoStruct();
        Element TargetName = Node2.element("TargetName");
        String strTargetName = TargetName.getText();
        targetInfoStruct.setStrTargetName(strTargetName);
        this.processTargetOption(Node2, targetInfoStruct);
        this.processGroups(Node2, targetInfoStruct);
        this.mapTarget.put(strTargetName, targetInfoStruct);
    }

    private void processTargetOption(Element Node2, TargetInfoStruct targetInfoStruct) {
        if (Node2 == null) {
            return;
        }
        Element TargetOption = Node2.element("TargetOption");
        if (TargetOption != null) {
            Element TargetArmAds;
            Element Device2;
            Element TargetCommonOption = TargetOption.element("TargetCommonOption");
            if (TargetCommonOption != null && (Device2 = TargetCommonOption.element("Device")) != null) {
                String strDevice = Device2.getText();
                targetInfoStruct.setStrDevice(strDevice);
            }
            if ((TargetArmAds = TargetOption.element("TargetArmAds")) != null) {
                Element VariousControls;
                Element Cads;
                Element nSecure;
                Element ARMADS = TargetArmAds.element("ArmAdsMisc");
                if (ARMADS != null && (nSecure = ARMADS.element("nSecure")) != null) {
                    targetInfoStruct.setStrnSecure(nSecure.getText());
                }
                if ((Cads = TargetArmAds.element("Cads")) != null && (VariousControls = Cads.element("VariousControls")) != null) {
                    Element eDefine;
                    Element IncludePath = VariousControls.element("IncludePath");
                    if (IncludePath != null) {
                        String strIncludePath = IncludePath.getText();
                        List<String> lstIncludePath = this.initIncludePath(strIncludePath);
                        ArrayList<Path> lstIncludePathAbsolution = new ArrayList<Path>();
                        for (String path : lstIncludePath) {
                            Path absolutePath = Paths.get(this.uvprojxDir.getAbsolutePath(), path).normalize();
                            lstIncludePathAbsolution.add(absolutePath);
                        }
                        targetInfoStruct.setLstIncludePath(lstIncludePathAbsolution);
                    }
                    if ((eDefine = VariousControls.element("Define")) != null) {
                        targetInfoStruct.setStrDefine(eDefine.getText());
                    }
                }
            }
        }
    }

    private void processGroups(Element Node2, TargetInfoStruct targetInfoStruct) {
        if (Node2 == null) {
            return;
        }
        Element Groups = Node2.element("Groups");
        if (Groups != null) {
            List groupList = Groups.elements("Group");
            ArrayList<GroupStruct> lstGroups = new ArrayList<GroupStruct>();
            for (Element elm : groupList) {
                Element elmName = elm.element("GroupName");
                Element elmFiles = elm.element("Files");
                GroupStruct group = new GroupStruct();
                if (elmName != null) {
                    group.setGroupName(elmName.getText());
                }
                if (elmFiles != null) {
                    List lstFile = elmFiles.elements("File");
                    ArrayList<FilesStruct> lstFiles = new ArrayList<FilesStruct>();
                    for (Element elmFile : lstFile) {
                        Element elmFileOption;
                        Element elmFilePath;
                        Element elmFileType;
                        FilesStruct filesStruct = new FilesStruct();
                        Element elmFileName = elmFile.element("FileName");
                        if (elmFileName != null) {
                            filesStruct.setFileName(elmFileName.getText());
                        }
                        if ((elmFileType = elmFile.element("FileType")) != null) {
                            filesStruct.setFileType(elmFileType.getText());
                        }
                        if ((elmFilePath = elmFile.element("FilePath")) != null) {
                            filesStruct.setFilePath(elmFilePath.getText());
                        }
                        if ((elmFileOption = elmFile.element("FileOption")) != null) {
                            filesStruct.setFileOption(true);
                        } else {
                            filesStruct.setFileOption(false);
                        }
                        lstFiles.add(filesStruct);
                    }
                    group.setLstFiles(lstFiles);
                }
                lstGroups.add(group);
            }
            targetInfoStruct.setLstGroups(lstGroups);
        }
    }

    private List<String> initIncludePath(String input) {
        return Arrays.asList(input.split(";"));
    }

    public boolean getMultiple() {
        return this.isMultiple;
    }

    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public Map<String, TargetInfoStruct> getMapTarget() {
        return this.mapTarget;
    }

    public void setMapTarget(Map<String, TargetInfoStruct> mapTarget) {
        this.mapTarget = mapTarget;
    }
}

