/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class FolderProcess {
    public List<String> allFiles = new ArrayList<String>();
    public List<String> foldersWithHFiles = new ArrayList<String>();

    public void createFolder(String folderPath) {
        File folder = new File(folderPath);
        if (folder.exists()) {
            Path path = Paths.get(folderPath, new String[0]);
            try {
                this.DeleteDir(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        folder.mkdirs();
    }

    private void DeleteDir(Path path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(FolderProcess::deleteDirectoyStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void deleteDirectoyStream(Path path) {
        try {
            Files.delete(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFolderAndFiles(String srcPath, String desPath) {
        Path src = Paths.get(srcPath, new String[0]);
        Path des = Paths.get(desPath, new String[0]);
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(sourceFile -> {
                try {
                    Path desFile = des.resolve(src.relativize((Path)sourceFile));
                    if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                        Files.createDirectories(desFile, new FileAttribute[0]);
                    } else {
                        Files.copy(sourceFile, desFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFolderAndFiles(String srcPath, String desPath, List<String> lstFiles) {
        Path src = Paths.get(srcPath, new String[0]);
        Path des = Paths.get(desPath, new String[0]);
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(sourceFile -> {
                try {
                    Path desFile = des.resolve(src.relativize((Path)sourceFile));
                    if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                        Files.createDirectories(desFile, new FileAttribute[0]);
                    } else if (!lstFiles.contains(sourceFile.getFileName().toString())) {
                        Files.copy(sourceFile, desFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyTargetFile(String srcPath, String desPath, String fileExtension) throws IOException {
        File[] filesToCopy;
        File src = new File(srcPath);
        File des = new File(desPath);
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("\u5a67\u612f\u77fe\u5bf0\u52ea\u7b09\u93c4\ue21b\u6783\u6d60\u8dfa\u3059: " + src);
        }
        if (!des.exists()) {
            des.mkdirs();
        }
        if ((filesToCopy = src.listFiles((File dir, String name) -> name.endsWith(fileExtension))) == null) {
            throw new IOException("\u7487\u8bf2\u5f47\u5a67\u612d\u6783\u6d60\u8dfa\u3059\u6fb6\u8fab\u89e6: " + src);
        }
        File[] fileArray = filesToCopy;
        int n = filesToCopy.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Path sourcePath = file.toPath();
            Path targetPath = Paths.get(desPath, file.getName());
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            ++n2;
        }
    }

    public void scanFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            boolean hasHFile = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    this.allFiles.add(file.getAbsolutePath());
                    if (file.getName().endsWith(".h")) {
                        hasHFile = true;
                    }
                } else if (file.isDirectory()) {
                    this.scanFolder(file);
                }
                ++n2;
            }
            if (hasHFile) {
                this.foldersWithHFiles.add(folder.getAbsolutePath());
            }
        }
    }

    public boolean containsFilename(List<String> lstFiles, String filename) {
        for (String filePath : lstFiles) {
            if (!filePath.endsWith(String.valueOf(File.separator) + filename)) continue;
            return true;
        }
        return false;
    }

    public List<String> listFiles(String dirPath) {
        return this.listFiles(dirPath, null);
    }

    public List<String> listFiles(String dirPath, String extension) {
        File[] children;
        ArrayList<String> result = new ArrayList<String>();
        if (dirPath == null || dirPath.isBlank()) {
            return result;
        }
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return result;
        }
        String normalizedExt = null;
        if (extension != null && !extension.isBlank()) {
            String ext = extension.trim().toLowerCase();
            if (!ext.startsWith(".")) {
                ext = "." + ext;
            }
            normalizedExt = ext;
        }
        if ((children = dir.listFiles()) == null) {
            return result;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                String name = f.getName();
                if (normalizedExt == null) {
                    result.add(name);
                } else if (name.toLowerCase().endsWith(normalizedExt)) {
                    result.add(name);
                }
            }
            ++n2;
        }
        return result;
    }
}

