/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.actions;

import com.gigadevice.ui.CProjectXml;
import com.gigadevice.ui.GNUArmProjectIds;
import com.gigadevice.ui.GNUProjectIds;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.internal.Workbench;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ImportGNUAction
extends Action {
    private static String PROJECT_TEMPLATE_NAME = "";
    private static String OPTION = "option";
    private static String TOOL = "tool";
    private static String FOLDERINFO = "folderInfo";
    private static IProject project;
    String projectName;
    HashMap<String, String> optionMap = new HashMap();
    HashMap<String, String> AssemblerOptionMap = new HashMap();
    HashMap<String, String> CCompilerOptionMap = new HashMap();
    HashMap<String, String> LinkerOptionMap = new HashMap();
    List<String> includePaths = new ArrayList<String>();
    List<String> assembler_includePaths = new ArrayList<String>();
    List<String> Symbols = new ArrayList<String>();
    List<String> includeFiles = new ArrayList<String>();
    List<String> scriptFile = new ArrayList<String>();
    String RISCVtoolchainPath;
    String ARMtoolchainPath;
    String buildtoolPath;
    String preBuildStepValue;
    String postBuildStepValue;
    List<String> Libs = new ArrayList<String>();
    List<String> Paths = new ArrayList<String>();
    String otherValue = "";
    List<String> tempStrList = new ArrayList<String>();
    HashMap<String, String> commandMap = new HashMap();

    ImportGNUAction() {
    }

    public void run() {
        this.getToolsPath();
        this.createWizard();
    }

    public void getToolsPath() {
        this.RISCVtoolchainPath = "." + File.separator + "Tools" + File.separator + "RISC-V Embedded GCC" + File.separator + "8.2.0-2.2-20190521-0004" + File.separator + "bin";
        this.buildtoolPath = "." + File.separator + "Tools" + File.separator + "Build Tools" + File.separator + "2.10-20180103-1919" + File.separator + "bin";
        this.ARMtoolchainPath = "." + File.separator + "Tools" + File.separator + "GNU Tools ARM Embedded" + File.separator + "xpack-arm-none-eabi-gcc" + File.separator + "9.2.1-1.1" + File.separator + "bin";
    }

    public void createWizard() {
        final Shell shell = new Shell();
        shell.setText("Select root directory");
        shell.setBounds(300, 200, 600, 150);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.verticalSpacing = 30;
        layout.horizontalSpacing = 10;
        shell.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        shell.setLayoutData((Object)layoutData);
        final Text label = new Text((Composite)shell, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        label.setLayoutData((Object)layoutData);
        Button button = new Button((Composite)shell, 0);
        button.setText("Browse");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog filDialog = new FileDialog(shell.getShell(), 65536);
                String browsedFile = filDialog.open();
                label.setText(browsedFile);
            }
        });
        layoutData = new GridData(4, 1024, false, false, 1, 1);
        layoutData.widthHint = 60;
        button.setLayoutData((Object)layoutData);
        Button buttonOK = new Button((Composite)shell, 0);
        buttonOK.setText("Migrate");
        layoutData = new GridData(131072, 1024, false, false, 1, 1);
        layoutData.widthHint = 60;
        buttonOK.setLayoutData((Object)layoutData);
        Button buttonCancel = new Button((Composite)shell, 0);
        buttonCancel.setText("Cancel");
        layoutData = new GridData(131072, 1024, false, false, 1, 1);
        layoutData.widthHint = 60;
        buttonCancel.setLayoutData((Object)layoutData);
        buttonOK.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String path = label.getText();
                if (label.getText().equals("")) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Please select root directory");
                } else {
                    String[] projectIDs = null;
                    if (TargetOSInfo.isWindows()) {
                        projectIDs = path.split("\\\\");
                    } else if (TargetOSInfo.isLinux()) {
                        projectIDs = path.split(File.separator);
                    }
                    String selectFile = projectIDs[projectIDs.length - 1];
                    if (selectFile.equals(".cproject")) {
                        shell.close();
                        ImportGNUAction.this.creatProjects(path);
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Please select the .cproject");
                    }
                }
            }
        });
        buttonCancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        shell.open();
    }

    public void creatProjects(String projectPath) {
        block63: {
            Element optionChange;
            int j;
            List<Element> toolOptionList;
            String id;
            Element toolChild;
            int i;
            String resourcefilepath = projectPath;
            String[] splits = null;
            if (TargetOSInfo.isWindows()) {
                splits = resourcefilepath.split("\\\\");
            } else if (TargetOSInfo.isLinux()) {
                splits = resourcefilepath.split(File.separator);
            }
            String projectFolderPath = splits[0];
            int n = 1;
            while (n < splits.length - 1) {
                projectFolderPath = String.valueOf(projectFolderPath) + File.separator + splits[n];
                ++n;
            }
            File GNUfile = new File(resourcefilepath);
            Document document = null;
            try {
                document = CProjectXml.parseFileToDocument(GNUfile);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (document == null) {
                return;
            }
            Element rootElement = document.getDocumentElement();
            Element storageModuleFirst = CProjectXml.getFirstChild(rootElement, "storageModule");
            List<Element> fstorageModuleList = CProjectXml.getChildrenList(rootElement, "storageModule");
            Element storageModuleSecond = fstorageModuleList.get(1);
            Element projectChild = CProjectXml.getFirstChild(storageModuleSecond, "project");
            String projectID = CProjectXml.getIdAtrribute(projectChild);
            String[] projectIDs = projectID.split("\\.");
            this.projectName = projectIDs[0];
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.getRoot();
            project = ImportGNUAction.getCurrentProject();
            Element cconfiguration = CProjectXml.getFirstChild(storageModuleFirst, "cconfiguration");
            List<Element> storageModuleList = CProjectXml.getChildrenList(cconfiguration, "storageModule");
            Element cdtBuildSystem = storageModuleList.get(1);
            Element configuration = CProjectXml.getFirstChild(cdtBuildSystem, "configuration");
            Element folderInfo = CProjectXml.getFirstChild(configuration, "folderInfo");
            Element toolChain = CProjectXml.getFirstChild(folderInfo, "toolChain");
            String toolchainName = CProjectXml.getAtrributeValueByName(toolChain, "name");
            List<Element> optionList = CProjectXml.getChildrenList(toolChain, OPTION);
            List<Element> toolList = CProjectXml.getChildrenList(toolChain, TOOL);
            this.optionMap = CProjectXml.getAttributesMap(optionList);
            this.preBuildStepValue = CProjectXml.getPreBuildStepAtrribute(configuration);
            this.postBuildStepValue = CProjectXml.getPostBuildStepAtrribute(configuration);
            this.commandMap.put("cross_prefix", "");
            this.commandMap.put("cross_objcopy", "");
            this.commandMap.put("cross_objdump", "");
            this.commandMap.put("cross_suffix", "");
            if (toolchainName.toUpperCase().contains("ARM")) {
                PROJECT_TEMPLATE_NAME = "arm.xml";
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.prefix")) {
                    this.commandMap.put("cross_prefix", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.prefix"));
                }
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.objcopy")) {
                    this.commandMap.put("cross_objcopy", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.objcopy"));
                }
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.objdump")) {
                    this.commandMap.put("cross_objdump", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.objdump"));
                }
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.suffix")) {
                    this.commandMap.put("cross_suffix", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.suffix"));
                }
                this.preBuildStepValue = this.stringReplace(this.preBuildStepValue);
                this.postBuildStepValue = this.stringReplace(this.postBuildStepValue);
                System.out.println("preBuildStepValue\u6d93\u7334\u7d30" + this.preBuildStepValue);
                System.out.println("postBuildStepValue\u6d93\u7334\u7d30" + this.postBuildStepValue);
                i = 0;
                while (i < toolList.size()) {
                    toolChild = toolList.get(i);
                    id = CProjectXml.getIdAtrribute(toolChild);
                    System.out.println("id\u6d93\u7334\u7d30" + id);
                    if (id.equals("ilg.gnuarmeclipse.managedbuild.cross.tool.assembler")) {
                        toolOptionList = CProjectXml.getChildrenList(toolChild, OPTION);
                        this.AssemblerOptionMap = CProjectXml.getAttributesMap(toolOptionList);
                        this.assembler_includePaths = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.assembler.include.paths");
                    } else if (id.equals("ilg.gnuarmeclipse.managedbuild.cross.tool.c.compiler")) {
                        toolOptionList = CProjectXml.getChildrenList(toolChild, OPTION);
                        this.CCompilerOptionMap = CProjectXml.getAttributesMap(toolOptionList);
                        this.includePaths = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.include.paths");
                        this.Symbols = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.defs");
                        this.includeFiles = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.include.s");
                    } else if (id.equals("ilg.gnuarmeclipse.managedbuild.cross.tool.c.linker")) {
                        toolOptionList = CProjectXml.getChildrenList(toolChild, OPTION);
                        this.LinkerOptionMap = CProjectXml.getAttributesMap(toolOptionList);
                        this.scriptFile = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.scriptfile");
                        this.Libs = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.libs");
                        this.Paths = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.paths");
                        j = 0;
                        while (j < toolOptionList.size()) {
                            optionChange = toolOptionList.get(j);
                            System.out.println("GNUArmProjectIds.OPTION_LINKER_OTHER):ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.other");
                            System.out.println("CProjectXml.getIdAtrribute(optionChange)):" + CProjectXml.getIdAtrribute(optionChange));
                            if (CProjectXml.getIdAtrribute(optionChange).equals("ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.other")) {
                                this.otherValue = CProjectXml.getOtherValueAtrribute(optionChange);
                                System.out.println("otherValue\u6d93\u7334\u7d30" + this.otherValue);
                                j = toolOptionList.size();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else if (toolchainName.toUpperCase().contains("RISC-V")) {
                PROJECT_TEMPLATE_NAME = "riscv.xml";
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.prefix")) {
                    this.commandMap.put("cross_prefix", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.prefix"));
                }
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.objcopy")) {
                    this.commandMap.put("cross_objcopy", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.objcopy"));
                }
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.objdump")) {
                    this.commandMap.put("cross_objdump", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.objdump"));
                }
                if (this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.command.suffix")) {
                    this.commandMap.put("cross_suffix", this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.command.suffix"));
                }
                this.preBuildStepValue = this.stringReplace(this.preBuildStepValue);
                this.postBuildStepValue = this.stringReplace(this.postBuildStepValue);
                System.out.println("preBuildStepValue\u6d93\u7334\u7d30" + this.preBuildStepValue);
                System.out.println("postBuildStepValue\u6d93\u7334\u7d30" + this.postBuildStepValue);
                i = 0;
                while (i < toolList.size()) {
                    toolChild = toolList.get(i);
                    id = CProjectXml.getIdAtrribute(toolChild);
                    if (id.equals("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.assembler")) {
                        toolOptionList = CProjectXml.getChildrenList(toolChild, OPTION);
                        this.AssemblerOptionMap = CProjectXml.getAttributesMap(toolOptionList);
                        this.assembler_includePaths = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.assembler.include.paths");
                    } else if (id.equals("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler")) {
                        System.out.println("GNUProjectIds.TOOL_CCOMPILER\u6d93\u7334\u7d30ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler");
                        toolOptionList = CProjectXml.getChildrenList(toolChild, OPTION);
                        this.CCompilerOptionMap = CProjectXml.getAttributesMap(toolOptionList);
                        this.includePaths = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.include.paths");
                        this.Symbols = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.defs");
                        this.includeFiles = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.include.s");
                    } else if (id.equals("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.linker")) {
                        toolOptionList = CProjectXml.getChildrenList(toolChild, OPTION);
                        this.LinkerOptionMap = CProjectXml.getAttributesMap(toolOptionList);
                        this.scriptFile = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.scriptfile");
                        this.Libs = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.libs");
                        this.Paths = CProjectXml.getValueListAtrribute(toolOptionList, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.paths");
                        j = 0;
                        while (j < toolOptionList.size()) {
                            optionChange = toolOptionList.get(j);
                            if (CProjectXml.getIdAtrribute(optionChange).equals("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.other")) {
                                this.otherValue = CProjectXml.getOtherValueAtrribute(optionChange);
                                System.out.println("otherValue\u6d93\u7334\u7d30" + this.otherValue);
                                j = toolOptionList.size();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            String destfilepath = String.valueOf(projectFolderPath) + File.separator + "cproject.bak";
            GNUfile.renameTo(new File(destfilepath));
            try {
                String pluginPath = null;
                String projectXMLPath = null;
                try {
                    if (TargetOSInfo.isWindows()) {
                        pluginPath = FileLocator.toFileURL((URL)Platform.getBundle((String)"com.gigadevice.ui").getEntry("")).getPath().substring(1);
                    } else if (TargetOSInfo.isLinux()) {
                        pluginPath = FileLocator.toFileURL((URL)Platform.getBundle((String)"com.gigadevice.ui").getEntry("")).getPath();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                String filepath = projectXMLPath = String.valueOf(pluginPath) + "cprojectTemplate" + File.separator + PROJECT_TEMPLATE_NAME;
                StringBuilder sb = this.readXML(filepath);
                String input = sb.toString();
                String str = this.ConvertProject(input);
                String targetPath = resourcefilepath;
                FileWriter fout = new FileWriter(targetPath);
                fout.write(str.toCharArray());
                fout.close();
                List<Element> folderInfoList = CProjectXml.getChildrenList(configuration, FOLDERINFO);
                int size_folderInfoList = folderInfoList.size();
                if (size_folderInfoList > 1) {
                    File folderfile = new File(targetPath);
                    Document document_riscv = null;
                    try {
                        document_riscv = CProjectXml.parseFileToDocument(folderfile);
                    }
                    catch (ParserConfigurationException e) {
                        e.printStackTrace();
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    NodeList nodeList = configuration.getChildNodes();
                    int i2 = 0;
                    while (i2 < nodeList.getLength()) {
                        Node node = nodeList.item(i2);
                        if (node.getNodeType() == 1 && node.getNodeName().equals("folderInfo")) {
                            String value_resourcePath = CProjectXml.getResourcePathAtrribute((Element)node);
                            if (value_resourcePath.equals("")) {
                                System.out.println("\u7ed7\ue0ff\u7af4\u6d93\u7323olderInfo\u6d93\u5d85\ue629\u941e\ufffd");
                            } else {
                                List<Element> toolOptionList2;
                                String id2;
                                Element toolChild2;
                                int j2;
                                Element toolChain_folder = CProjectXml.getFirstChild((Element)node, "toolChain");
                                String toolchainName_folder = CProjectXml.getAtrributeValueByName(toolChain_folder, "name");
                                List<Element> toolList_folder = CProjectXml.getChildrenList(toolChain_folder, TOOL);
                                Map<String, Map<String, String>> map_ListOptionValue = null;
                                if (toolchainName_folder.contains("RISC-V")) {
                                    j2 = 0;
                                    while (j2 < toolList_folder.size()) {
                                        toolChild2 = toolList_folder.get(j2);
                                        id2 = CProjectXml.getIdAtrribute(toolChild2);
                                        if (id2.equals("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler") && !(map_ListOptionValue = this.getListOptionValue(toolOptionList2 = CProjectXml.getChildrenList(toolChild2, OPTION), "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.include.paths")).isEmpty()) {
                                            this.setFolderElement(document_riscv, value_resourcePath, map_ListOptionValue, targetPath);
                                            break;
                                        }
                                        ++j2;
                                    }
                                } else if (toolchainName_folder.contains("ARM")) {
                                    j2 = 0;
                                    while (j2 < toolList_folder.size()) {
                                        toolChild2 = toolList_folder.get(j2);
                                        id2 = CProjectXml.getIdAtrribute(toolChild2);
                                        if (id2.equals("ilg.gnuarmeclipse.managedbuild.cross.tool.c.compiler") && !(map_ListOptionValue = this.getListOptionValue(toolOptionList2 = CProjectXml.getChildrenList(toolChild2, OPTION), "ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.include.paths")).isEmpty()) {
                                            this.setARMFolderElement(document_riscv, value_resourcePath, map_ListOptionValue, targetPath);
                                            break;
                                        }
                                        ++j2;
                                    }
                                }
                            }
                        }
                        ++i2;
                    }
                    break block63;
                }
                System.out.println("\u6d93\u5d88\u7e58\u741b\u5c7d\ue629\u941e\u55ed\u7d12");
            }
            catch (FileNotFoundException e1) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Tips", (String)"Migrate failed !");
                e1.printStackTrace();
                return;
            }
            catch (IOException e) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Tips", (String)"Migrate failed !");
                e.printStackTrace();
                return;
            }
        }
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Tips", (String)"Migrate success !");
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String ConvertProject(String input) {
        String includePathsString = this.listOptionValueToString(this.includePaths);
        this.listOptionValueToString(this.includeFiles);
        String symbolsString = this.listOptionValueToString(this.Symbols);
        String scriptFileString = this.listOptionValueToString(this.scriptFile);
        String libsString = this.listOptionValueToString(this.Libs);
        String pathsString = this.listOptionValueToString(this.Paths);
        String output = input.replace("projectName", this.projectName);
        String assembler_includePathsString = this.listOptionValueToString(this.assembler_includePaths);
        if (PROJECT_TEMPLATE_NAME.equals("riscv.xml")) {
            GNUProjectIds.initMapping();
            output = output.replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.base", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.atomic") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.base") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.arch.default")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.atomic", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.atomic") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.atomic") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.multiply", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.multiply") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.multiply") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.compressed", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.compressed") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.compressed") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.abi.integer", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.abi.integer") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.abi.integer") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.abi.integer.default")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.tune", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.tune") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.tune") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.tune.default")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.codemodel", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.codemodel") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.codemodel") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.codemodel.default")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.smalldatalimit", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.smalldatalimit") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.smalldatalimit") : "8").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.saverestore", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.saverestore") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.saverestore") : "true").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.fdiv", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.fdiv") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.fdiv") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.other", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.other") : "").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level.none")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.messagelength", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.messagelength") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.messagelength") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.signedchar", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.signedchar") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.signedchar") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.functionsections", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.functionsections") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.functionsections") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.datasections", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.datasections") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.datasections") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nocommon", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nocommon") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nocommon") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.noinlinefunctions", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.noinlinefunctions") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.noinlinefunctions") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.freestanding", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.freestanding") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.freestanding") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nobuiltin", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nobuiltin") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nobuiltin") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.spconstant", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.spconstant") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.spconstant") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.PIC", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.PIC") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.PIC") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.lto", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.lto") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.lto") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nomoveloopinvariants", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nomoveloopinvariants") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.nomoveloopinvariants") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.syntaxonly", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.pedantic", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.pedanticerrors", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.allwarn", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.nowarn", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.extrawarn", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.conversion", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.uninitialized", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.unused", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.padded", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.floatequal", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.shadow", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.pointerarith", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.logicalop", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.agreggatereturn", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.missingdeclaration", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.toerrors", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.other") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.other", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.other") : "").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.level", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.level") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.level") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.level.default")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.format", GNUProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.format") ? this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.format") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.format.default")).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.prof", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.prof") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.prof") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.gprof", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.gprof") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.gprof") : "false").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.other", this.optionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.other") ? (CharSequence)this.optionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.other") : "").replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.path", this.RISCVtoolchainPath).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.buildtool.path", this.buildtoolPath).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.include.paths", includePathsString).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.defs", symbolsString).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std", GNUProjectIds.correspondingMap.get(this.CCompilerOptionMap.containsKey("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std") ? this.CCompilerOptionMap.get("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std") : "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std.default")).replace("prebuildStepValue", this.preBuildStepValue).replace("postbuildStepValue", this.postBuildStepValue).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.scriptfile", scriptFileString).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.libs", libsString).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.paths", pathsString).replace("otherValue", this.otherValue).replace("ilg.gnumcueclipse.managedbuild.cross.riscv.option.assembler.include.paths", assembler_includePathsString);
        } else if (PROJECT_TEMPLATE_NAME.equals("arm.xml")) {
            GNUArmProjectIds.initMapping();
            output = output.replace("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.family", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.family") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.family") : "ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.mcpu.cortex-m3")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.architecture", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.architecture") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.architecture") : "ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.arch.none")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.abi", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.abi") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.abi") : "ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.abi.default")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.unit", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.unit") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.unit") : "ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.fpu.unit.default")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.instructionset", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.instructionset") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.instructionset") : "ilg.gnuarmeclipse.managedbuild.cross.option.arm.target.instructionset.default")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.target.other", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.target.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.target.other") : "").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.level", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.level") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.level") : "ilg.gnuarmeclipse.managedbuild.cross.option.optimization.level.none")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.messagelength", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.messagelength") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.messagelength") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.signedchar", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.signedchar") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.signedchar") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.functionsections", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.functionsections") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.functionsections") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.datasections", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.datasections") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.datasections") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nocommon", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nocommon") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nocommon") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.noinlinefunctions", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.noinlinefunctions") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.noinlinefunctions") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.freestanding", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.freestanding") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.freestanding") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nobuiltin", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nobuiltin") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nobuiltin") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.spconstant", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.spconstant") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.spconstant") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.PIC", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.PIC") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.PIC") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.lto", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.lto") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.lto") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nomoveloopinvariants", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nomoveloopinvariants") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.nomoveloopinvariants") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.syntaxonly", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.pedantic", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.pedanticerrors", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.allwarn", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.nowarn", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.extrawarn", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.conversion", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.uninitialized", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.unused", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.padded", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.floatequal", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.shadow", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.pointerarith", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.logicalop", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.agreggatereturn", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.missingdeclaration", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.toerrors", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.other") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.other", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.warnings.other") : "").replace("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.level", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.level") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.level") : "ilg.gnuarmeclipse.managedbuild.cross.option.debugging.level.default")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.format", GNUArmProjectIds.correspondingMap.get(this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.format") ? this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.format") : "ilg.gnuarmeclipse.managedbuild.cross.option.debugging.format.default")).replace("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.prof", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.prof") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.prof") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.gprof", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.gprof") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.gprof") : "false").replace("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.other", this.optionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.other") ? (CharSequence)this.optionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.debugging.other") : "").replace("ilg.gnuarmeclipse.managedbuild.cross.option.toolchain.path", this.ARMtoolchainPath).replace("ilg.gnuarmeclipse.managedbuild.cross.option.buildtool.path", this.buildtoolPath).replace("ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.include.paths", includePathsString).replace("ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.defs", symbolsString).replace("ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.std", GNUArmProjectIds.correspondingMap.get(this.CCompilerOptionMap.containsKey("ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.std") ? this.CCompilerOptionMap.get("ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.std") : "ilg.gnuarmeclipse.managedbuild.cross.option.c.compiler.std.default")).replace("prebuildStepValue", this.preBuildStepValue).replace("postbuildStepValue", this.postBuildStepValue).replace("ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.scriptfile", scriptFileString).replace("ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.libs", libsString).replace("ilg.gnuarmeclipse.managedbuild.cross.option.c.linker.paths", pathsString).replace("otherValue", this.otherValue).replace("ilg.gnuarmeclipse.managedbuild.cross.option.assembler.include.paths", assembler_includePathsString);
        }
        return output;
    }

    public String listOptionValueToString(List<String> listOptionValue) {
        String listOptionValuetring = "";
        int i = 0;
        while (i < listOptionValue.size()) {
            String childValue = "<listOptionValue builtIn=\"false\" value=\"" + listOptionValue.get(i) + "\"/>" + "\r";
            listOptionValuetring = String.valueOf(listOptionValuetring) + childValue;
            ++i;
        }
        return listOptionValuetring;
    }

    public static void SetIProvider(IProject iproject) {
        project = iproject;
    }

    public StringBuilder readXML(String filePath) throws IOException {
        FileReader fis = new FileReader(filePath);
        char[] data = new char[0x200000];
        int rn = 0;
        StringBuilder sb = new StringBuilder();
        while ((rn = fis.read(data)) > 0) {
            String str = String.valueOf(data, 0, rn);
            sb.append(str);
        }
        fis.close();
        return sb;
    }

    public void setFolderElement(Document document_riscv, String value_resourcePath, Map<String, Map<String, String>> map_ListOptionValue, String targetPath) {
        Element rootElement_riscv = document_riscv.getDocumentElement();
        Element storageModuleFirst_riscv = CProjectXml.getFirstChild(rootElement_riscv, "storageModule");
        Element cconfiguration_riscv = CProjectXml.getFirstChild(storageModuleFirst_riscv, "cconfiguration");
        List<Element> storageModuleList_riscv = CProjectXml.getChildrenList(cconfiguration_riscv, "storageModule");
        Element cdtBuildSystem_riscv = storageModuleList_riscv.get(1);
        Element configuration_riscv = CProjectXml.getFirstChild(cdtBuildSystem_riscv, "configuration");
        Element folderInfoNode = document_riscv.createElement("folderInfo");
        String str1 = this.GetRandomStr();
        folderInfoNode.setAttribute("id", "com.gigadevice.mbs.riscv.configuration.debug.465677685." + str1);
        folderInfoNode.setAttribute("name", "/");
        folderInfoNode.setAttribute("resourcePath", value_resourcePath);
        Element toolchain = document_riscv.createElement("toolChain");
        String str2 = this.GetRandomStr();
        toolchain.setAttribute("id", "com.gigadevice.mbs.riscv.toolChain.elf.debug." + str2);
        toolchain.setAttribute("name", "GD RISC-V MCU Toolchain");
        toolchain.setAttribute("superClass", "com.gigadevice.mbs.riscv.toolChain.elf.debug");
        toolchain.setAttribute("unusedChildren", "");
        Element tool = document_riscv.createElement("tool");
        String str3 = this.GetRandomStr();
        tool.setAttribute("id", "com.gigadevice.mbs.riscv.tool.CCompiler." + str3);
        tool.setAttribute("name", "GD RISC-V MCU C Compiler");
        tool.setAttribute("superClass", "com.gigadevice.mbs.riscv.tool.CCompiler");
        Element option = document_riscv.createElement("option");
        option.setAttribute("IS_BUILTIN_EMPTY", "false");
        option.setAttribute("IS_VALUE_EMPTY", "false");
        String str5 = this.GetRandomStr();
        option.setAttribute("id", "com.gigadevice.mbs.riscv.option.CCompiler.includes.paths." + str5);
        option.setAttribute("superClass", "com.gigadevice.mbs.riscv.option.CCompiler.includes.paths");
        option.setAttribute("useByScannerDiscovery", "true");
        option.setAttribute("valueType", "includePath");
        tool.appendChild(option);
        Set<String> keySet = map_ListOptionValue.keySet();
        for (String Key2 : keySet) {
            Map<String, String> map = map_ListOptionValue.get(Key2);
            Set<Map.Entry<String, String>> entrySet = map.entrySet();
            for (Map.Entry<String, String> me : entrySet) {
                System.out.println("me.getKey():" + me.getKey());
                System.out.println("me.getValue():" + me.getValue());
                Element listoptionValue = document_riscv.createElement("listOptionValue");
                listoptionValue.setAttribute("builtIn", me.getKey());
                listoptionValue.setAttribute("value", me.getValue());
                option.appendChild(listoptionValue);
            }
        }
        Element inputType = document_riscv.createElement("inputType");
        String str6 = this.GetRandomStr();
        inputType.setAttribute("id", "com.gigadevice.mbs.riscv.inputType.CCompiler." + str6);
        tool.appendChild(inputType);
        toolchain.appendChild(tool);
        folderInfoNode.appendChild(toolchain);
        configuration_riscv.appendChild(folderInfoNode);
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("indent", "yes");
            tf.transform(new DOMSource(document_riscv), new StreamResult(new File(targetPath)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u9422\u71b8\u579axml\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6");
        }
    }

    public void setARMFolderElement(Document document_riscv, String value_resourcePath, Map<String, Map<String, String>> map_ListOptionValue, String targetPath) {
        Element rootElement_riscv = document_riscv.getDocumentElement();
        Element storageModuleFirst_riscv = CProjectXml.getFirstChild(rootElement_riscv, "storageModule");
        Element cconfiguration_riscv = CProjectXml.getFirstChild(storageModuleFirst_riscv, "cconfiguration");
        List<Element> storageModuleList_riscv = CProjectXml.getChildrenList(cconfiguration_riscv, "storageModule");
        Element cdtBuildSystem_riscv = storageModuleList_riscv.get(1);
        Element configuration_riscv = CProjectXml.getFirstChild(cdtBuildSystem_riscv, "configuration");
        Element folderInfoNode = document_riscv.createElement("folderInfo");
        String str1 = this.GetRandomStr();
        folderInfoNode.setAttribute("id", "com.gigadevice.mbs.arm.configuration.debug.1220644957." + str1);
        folderInfoNode.setAttribute("name", "/");
        folderInfoNode.setAttribute("resourcePath", value_resourcePath);
        Element toolchain = document_riscv.createElement("toolChain");
        String str2 = this.GetRandomStr();
        toolchain.setAttribute("id", "com.gigadevice.mbs.arm.toolChain.elf.debug." + str2);
        toolchain.setAttribute("name", "GD ARM MCU Toolchain");
        toolchain.setAttribute("superClass", "com.gigadevice.mbs.arm.toolChain.elf.debug");
        toolchain.setAttribute("unusedChildren", "");
        Element tool = document_riscv.createElement("tool");
        String str3 = this.GetRandomStr();
        tool.setAttribute("id", "com.gigadevice.mbs.arm.tool.CCompiler." + str3);
        tool.setAttribute("name", "GD ARM MCU C Compiler");
        tool.setAttribute("superClass", "com.gigadevice.mbs.arm.tool.CCompiler");
        Element option = document_riscv.createElement("option");
        option.setAttribute("IS_BUILTIN_EMPTY", "false");
        option.setAttribute("IS_VALUE_EMPTY", "false");
        String str5 = this.GetRandomStr();
        option.setAttribute("id", "com.gigadevice.mbs.arm.option.CCompiler.includes.paths." + str5);
        option.setAttribute("superClass", "com.gigadevice.mbs.arm.option.CCompiler.includes.paths");
        option.setAttribute("useByScannerDiscovery", "true");
        option.setAttribute("valueType", "includePath");
        tool.appendChild(option);
        Set<String> keySet = map_ListOptionValue.keySet();
        for (String Key2 : keySet) {
            Map<String, String> map = map_ListOptionValue.get(Key2);
            Set<Map.Entry<String, String>> entrySet = map.entrySet();
            for (Map.Entry<String, String> me : entrySet) {
                System.out.println("me.getKey():" + me.getKey());
                System.out.println("me.getValue():" + me.getValue());
                Element listoptionValue = document_riscv.createElement("listOptionValue");
                listoptionValue.setAttribute("builtIn", me.getKey());
                listoptionValue.setAttribute("value", me.getValue());
                option.appendChild(listoptionValue);
            }
        }
        Element inputType = document_riscv.createElement("inputType");
        String str6 = this.GetRandomStr();
        inputType.setAttribute("id", "com.gigadevice.mbs.arm.inputType.CCompiler." + str6);
        tool.appendChild(inputType);
        toolchain.appendChild(tool);
        folderInfoNode.appendChild(toolchain);
        configuration_riscv.appendChild(folderInfoNode);
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("indent", "yes");
            tf.transform(new DOMSource(document_riscv), new StreamResult(new File(targetPath)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u9422\u71b8\u579axml\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6");
        }
    }

    public Map<String, Map<String, String>> getListOptionValue(List<Element> toolOptionList, String element) {
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>();
        int number = 0;
        int i = 0;
        while (i < toolOptionList.size()) {
            String id = CProjectXml.getIdAtrribute(toolOptionList.get(i));
            if (id.equals(element)) {
                List<Element> listOptionValue = CProjectXml.getChildrenList(toolOptionList.get(i), "listOptionValue");
                int j = 0;
                while (j < listOptionValue.size()) {
                    Element temp = listOptionValue.get(j);
                    NamedNodeMap attrs = temp.getAttributes();
                    ArrayList<String> tempList = new ArrayList<String>();
                    int k = 0;
                    while (k < attrs.getLength()) {
                        Node attr = attrs.item(k);
                        System.out.println("attr.getNodeName():" + attr.getNodeName());
                        System.out.println("attr.getNodeValue():" + attr.getNodeValue());
                        tempList.add(attr.getNodeValue());
                        ++k;
                    }
                    HashMap<String, String> map_temp = new HashMap<String, String>();
                    map_temp.put((String)tempList.get(0), (String)tempList.get(1));
                    res.put(String.valueOf(number), map_temp);
                    ++number;
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    public boolean isunique(List<String> tempList) {
        HashSet<String> stringSet = new HashSet<String>(tempList);
        return tempList.size() == stringSet.size();
    }

    public String GetRandom() {
        double rand = Math.random();
        String str = String.valueOf(rand).replace("0.", "");
        String newStr = str.substring(0, 9);
        System.out.println("newStr:" + newStr);
        return newStr;
    }

    public String GetRandomStr() {
        String tempNumberStr = this.GetRandom();
        this.tempStrList.add(tempNumberStr);
        while (!this.isunique(this.tempStrList)) {
            tempNumberStr = this.GetRandom();
            this.tempStrList.add(tempNumberStr);
        }
        return tempNumberStr;
    }

    public String stringReplace(String str) {
        if (str.contains("${cross_prefix}")) {
            str = str.replace("${cross_prefix}", this.commandMap.get("cross_prefix"));
        }
        if (str.contains("${cross_objcopy}")) {
            str = str.replace("${cross_objcopy}", this.commandMap.get("cross_objcopy"));
        }
        if (str.contains("${cross_objdump}")) {
            str = str.replace("${cross_objdump}", this.commandMap.get("cross_objdump"));
        }
        if (str.contains("${cross_suffix}")) {
            str = str.replace("${cross_suffix}", this.commandMap.get("cross_suffix"));
        }
        return str;
    }

    public static IProject getCurrentProject() {
        ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        IProject project = null;
        Object element = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            project = ((IResource)element).getProject();
        }
        return project;
    }
}

