/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.ui.Activator;
import com.gigadevice.venustool.xmlparse.CPNChangeXmlParse;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class UpdateProjectConfig
implements IResourceChangeListener {
    private static UpdateProjectConfig instance;
    public static final String ARM_OPTIONID_TARGET_MCU = "com.gigadevice.mbs.arm.option.targetMcu.partNo";
    public static final String RISCV_OPTIONID_TARGET_MCU = "com.gigadevice.mbs.riscv.option.targetMcu.partNo";

    private UpdateProjectConfig() {
    }

    public static synchronized UpdateProjectConfig getInstance() {
        if (instance == null) {
            instance = new UpdateProjectConfig();
        }
        return instance;
    }

    public void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() != 1) {
                return;
            }
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IProject) {
                        final IProject project = (IProject)resource;
                        if ((delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && project.isOpen()) && project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                            Job job = new Job("Updating project files: " + project.getName()){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        UpdateProjectConfig.this.modifyCProjectFile(project);
                                        return Status.OK_STATUS;
                                    }
                                    catch (Exception e) {
                                        return new Status(4, "com.gigadevice.ui", "Failed to update project files.", (Throwable)e);
                                    }
                                }
                            };
                            job.setPriority(40);
                            job.schedule(500L);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.gigadevice.ui", "Error processing resource change", (Throwable)e));
        }
    }

    public void processExistingProjects() {
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                final IProject project = iProjectArray[n2];
                if (project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                    Job job = new Job("Updating project files: " + project.getName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                UpdateProjectConfig.this.modifyCProjectFile(project);
                                return Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                return new Status(4, "com.gigadevice.ui", "Failed to update project files.", (Throwable)e);
                            }
                        }
                    };
                    job.setPriority(40);
                    job.schedule(500L);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.gigadevice.ui", "Error processing existing projects", (Throwable)e));
        }
    }

    private void modifyCProjectFile(final IProject project) {
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        block6: {
                            try {
                                ICConfigurationDescription[] configs;
                                ICProjectDescription projectDesc = CCorePlugin.getDefault().getProjectDescription(project, true);
                                if (projectDesc == null) break block6;
                                ICConfigurationDescription[] iCConfigurationDescriptionArray = configs = projectDesc.getConfigurations();
                                int n = configs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                                    IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                                    IConfiguration buildConfig = buildInfo.getManagedProject().getConfiguration(config.getId());
                                    IToolChain toolChain = buildConfig.getToolChain();
                                    IOption option = toolChain.getOptionBySuperClassId(UpdateProjectConfig.ARM_OPTIONID_TARGET_MCU);
                                    if (option != null) {
                                        try {
                                            String currentValue = option.getStringValue();
                                            String newCPN = CPNChangeXmlParse.getNewCPN((String)currentValue, (boolean)false);
                                            ManagedBuildManager.setOption((IConfiguration)buildConfig, (IHoldsOptions)toolChain, (IOption)option, (String)newCPN);
                                        }
                                        catch (BuildException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    ++n2;
                                }
                                CCorePlugin.getDefault().setProjectDescription(project, projectDesc);
                            }
                            catch (Exception e) {
                                throw new CoreException((IStatus)new Status(4, "com.gigadevice.ui", "An error occurred while processing the project configuration.", (Throwable)e));
                            }
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)project, 1, null);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                project.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

