/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.ui.listener.DebugListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class Startup
implements IStartup {
    private static final LogManager logManager = LogManager.getInstance();

    public void earlyStartup() {
        this.setCPerspective();
        Display.getDefault().asyncExec(() -> {
            try {
                Display.getDefault().setRuntimeExceptionHandler(throwable -> logManager.logThrowable((Throwable)throwable));
                Display.getDefault().setErrorHandler(exception -> logManager.logThrowable((Throwable)exception));
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                    DebugListener monitor = new DebugListener();
                    monitor.initialize();
                } else {
                    Display.getDefault().timerExec(1000, () -> this.earlyStartup());
                }
            }
            catch (Exception e) {
                logManager.logThrowable((Throwable)e);
            }
        });
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.debug.ui");
            prefs.putBoolean("org.eclipse.debug.ui.RelaunchAndTerminateLaunchAction", true);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void setCPerspective() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                try {
                    window.getWorkbench().showPerspective("org.eclipse.cdt.ui.CPerspective", window);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

