/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import com.gigadevice.codegenerate.projectmigrate.GenerateProjectFile;
import com.gigadevice.ui.AbstractKeilIARImportWizard;
import com.gigadevice.ui.GetIARProjPage;
import com.gigadevice.ui.baseinfo.FilesStruct;
import com.gigadevice.ui.baseinfo.GroupStruct;
import com.gigadevice.ui.baseinfo.TargetInfoStruct;
import com.gigadevice.ui.tool.IARProjParse;
import com.gigadevice.ui.tool.UniqueNumericStringGenerator;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportWizardIAR2GD
extends AbstractKeilIARImportWizard {
    private GetIARProjPage getIARProjPage;
    private IARProjParse iarProjParse;
    private List<String> specialGroups = Arrays.asList("STARTUP", "RISCV");
    private Set<String> needStartUpFileList = new HashSet<String>();
    private Boolean hasStartUpGroup = false;

    public ImportWizardIAR2GD() {
        this.setWindowTitle("Import");
    }

    public void addPages() {
        this.getIARProjPage = new GetIARProjPage("Import IAR Project");
        this.addPage((IWizardPage)this.getIARProjPage);
    }

    @Override
    public boolean performFinish() {
        Shell shell;
        this.needStartUpFileList.clear();
        this.myConsole = this.findConsole("IAR Convert Console");
        this.out = this.myConsole.newMessageStream();
        final String IARProjPath = this.getIARProjPage.GetIARPath();
        final String ProjectName = this.getIARProjPage.GetProjName();
        File fileIAR = new File(IARProjPath);
        if (fileIAR.exists()) {
            shell = Display.getCurrent().getActiveShell();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            progressMonitorDialog.setCancelable(false);
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Map<String, TargetInfoStruct> mapTarget;
                    monitor.beginTask("Convert IAR Project to GD Project... ", -1);
                    monitor.setCanceled(false);
                    ImportWizardIAR2GD.this.iarProjParse = new IARProjParse();
                    ImportWizardIAR2GD.this.out.println("Parse IAR project information.");
                    if (!ImportWizardIAR2GD.this.iarProjParse.parseIARProj(IARProjPath).booleanValue()) {
                        StringBuilder errorMsg = new StringBuilder("Error: " + ImportWizardIAR2GD.this.iarProjParse.getErrorCodeDescription() + "\n\n");
                        for (String errMsg : ImportWizardIAR2GD.this.iarProjParse.getErrorMessages()) {
                            errorMsg.append("- ").append(errMsg).append("\n");
                        }
                        if (!ImportWizardIAR2GD.this.iarProjParse.getInvalidConfigurations().isEmpty()) {
                            errorMsg.append("\nThe following configurations are missing critical information:\n");
                            for (String invalidConfig : ImportWizardIAR2GD.this.iarProjParse.getInvalidConfigurations()) {
                                errorMsg.append("- ").append(invalidConfig).append("\n");
                            }
                        }
                        errorMsg.append("\nConversion failed: Please ensure the IAR project has at least one valid configuration with device information and include paths.");
                        ImportWizardIAR2GD.this.out.println(errorMsg.toString());
                        ImportWizardIAR2GD.this.showResultDialog("IAR to GD Project Conversion Failed", errorMsg.toString(), true);
                        monitor.done();
                        return;
                    }
                    if (ImportWizardIAR2GD.this.iarProjParse.getErrorCode() != 0 || !ImportWizardIAR2GD.this.iarProjParse.getErrorMessages().isEmpty() || !ImportWizardIAR2GD.this.iarProjParse.getInvalidConfigurations().isEmpty()) {
                        ImportWizardIAR2GD.this.out.println("Warning: " + ImportWizardIAR2GD.this.iarProjParse.getErrorCodeDescription());
                        for (String errMsg : ImportWizardIAR2GD.this.iarProjParse.getErrorMessages()) {
                            ImportWizardIAR2GD.this.out.println("  - " + errMsg);
                        }
                        if (!ImportWizardIAR2GD.this.iarProjParse.getInvalidConfigurations().isEmpty()) {
                            ImportWizardIAR2GD.this.out.println("The following configurations were skipped due to missing information:");
                            for (String invalidConfig : ImportWizardIAR2GD.this.iarProjParse.getInvalidConfigurations()) {
                                ImportWizardIAR2GD.this.out.println("  - " + invalidConfig);
                            }
                        }
                        ImportWizardIAR2GD.this.out.println("Conversion will continue with valid configurations.");
                    }
                    if ((mapTarget = ImportWizardIAR2GD.this.iarProjParse.getMapTarget()).isEmpty()) {
                        String errorMsg = "Error: No valid configuration nodes found.\n\nConversion failed: Please ensure the IAR project has at least one valid configuration.";
                        ImportWizardIAR2GD.this.out.println(errorMsg);
                        ImportWizardIAR2GD.this.showResultDialog("IAR to GD Project Conversion Failed", errorMsg, true);
                        monitor.done();
                        return;
                    }
                    ImportWizardIAR2GD.this.out.println("IAR project Converting.");
                    String cConfigContent = "";
                    TargetInfoStruct gTargetInfoStruct = new TargetInfoStruct();
                    for (String targetName : mapTarget.keySet()) {
                        TargetInfoStruct targetInfoStruct;
                        gTargetInfoStruct = targetInfoStruct = mapTarget.get(targetName);
                        String fileContent = "";
                        String ProSettingFolderPath = String.valueOf(GeneralPathUtil.ResourcePath) + "ProjectSetting";
                        String filePath = "";
                        filePath = ImportWizardIAR2GD.this.iarProjParse.getToolChainName().toUpperCase().equals("ARM") ? String.valueOf(ProSettingFolderPath) + File.separator + "unit.xml" : String.valueOf(ProSettingFolderPath) + File.separator + "unit_riscv.xml";
                        try {
                            fileContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
                            String idString = UniqueNumericStringGenerator.generateRandomNumericString();
                            fileContent = fileContent.replace("${id}", idString);
                            fileContent = fileContent.replace("${config.name}", targetName);
                            String symbols = ImportWizardIAR2GD.convertToListOptionValues(gTargetInfoStruct.getStrDefine());
                            fileContent = fileContent.replace("${assembler.symbols}", symbols);
                            fileContent = fileContent.replace("${CCompiler.symbols}", symbols);
                            fileContent = ImportWizardIAR2GD.this.processSecure(fileContent, gTargetInfoStruct);
                            String entry = "";
                            List<GroupStruct> groupFiles = targetInfoStruct.getLstGroups();
                            for (GroupStruct groupStruct : groupFiles) {
                                if (groupStruct.getGroupName().toUpperCase().equals("STARTUP")) {
                                    ImportWizardIAR2GD.this.hasStartUpGroup = true;
                                    List<FilesStruct> lstFiles = groupStruct.getLstFiles();
                                    for (FilesStruct filesStruct : lstFiles) {
                                        String startupfileName = filesStruct.getFileName();
                                        if (startupfileName.length() > 2) {
                                            ImportWizardIAR2GD.this.needStartUpFileList.add(startupfileName.substring(0, startupfileName.length() - 2));
                                        }
                                        if (!filesStruct.getFileOption()) continue;
                                        String str = "gcc_startup" + File.separator + startupfileName;
                                        if ((str = ImportWizardIAR2GD.capitalizeLastCharacter(str)) == null) continue;
                                        entry = String.valueOf(entry) + str + "|";
                                    }
                                    continue;
                                }
                                entry = ImportWizardIAR2GD.this.processGroupForExclusion(groupStruct, "", entry);
                            }
                            if (!entry.isEmpty()) {
                                String allButLast = entry.substring(0, entry.length() - 1);
                                fileContent = fileContent.replace("${sourceEntries.entry}", allButLast);
                            } else {
                                fileContent = fileContent.replace("${sourceEntries.entry}", "");
                            }
                            cConfigContent = String.valueOf(cConfigContent) + fileContent;
                        }
                        catch (NoSuchFileException e) {
                            System.err.println("\u93c2\u56e6\u6b22\u93c8\ue045\u58d8\u9352\ufffd: " + e.getFile());
                        }
                        catch (AccessDeniedException e) {
                            System.err.println("\u7481\u5757\u68f6\u741a\ue0a3\u5ac6\u7f01\ufffd: " + e.getFile());
                        }
                        catch (FileSystemException e) {
                            System.err.println("\u93c2\u56e6\u6b22\u7eef\u8364\u7cba\u5bee\u509a\u7236: " + e.getFile() + " - " + e.getReason());
                        }
                        catch (IOException e) {
                            System.err.println("I/O\u5bee\u509a\u7236: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    ImportWizardIAR2GD.this.convertProj(ProjectName, IARProjPath, gTargetInfoStruct, cConfigContent);
                    monitor.done();
                }
            };
            try {
                progressMonitorDialog.run(true, false, iRunnableWithProgress);
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMsg = "Convert failed!";
                this.out.println(errorMsg);
                this.showResultDialog("IAR to GD Project Conversion Failed", errorMsg, true);
            }
        } else {
            Object[] options = new Object[]{"OK"};
            JOptionPane.showOptionDialog(null, "The file does not exist, Please check the project path.", "Message", -1, -1, null, options, options[0]);
            return false;
        }
        shell.dispose();
        return true;
    }

    @Override
    protected boolean convertProj(String projectName, String projectPath, TargetInfoStruct targetInfoStruct, String cConfigContent) {
        String projRootFolder = this.getFolder(projectPath);
        if (projRootFolder == null || projRootFolder.isEmpty()) {
            String errorMsg = "Get IAR project root folder failed.";
            this.out.println(errorMsg);
            this.showResultDialog("IAR to GD Project Conversion Failed", errorMsg, true);
            return false;
        }
        String projFolder = String.valueOf(projRootFolder) + File.separator + "GD32EBuilder_project";
        File folder = new File(projFolder);
        if (folder.exists()) {
            String errorMsg = "Convert failed!\n\nA project already exists at: " + projFolder;
            this.out.println(errorMsg);
            this.showResultDialog("IAR to GD Project Conversion Failed", errorMsg, true);
            this.out.println("");
            return false;
        }
        this.out.println("Create project Folder.");
        this.folderProcess.createFolder(projFolder);
        Path projLocation = new Path(projFolder);
        this.projectCreator.createProject(projectName, (IPath)projLocation);
        this.out.println("Initialize MCU information.");
        String targetMCUPartNo = targetInfoStruct.getStrDevice();
        MCUSeletorInfo tmpGDMcuSeletorInfo = GlobalVariables.McuSeletorInfo;
        GlobalVariables.McuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)3, (String)targetMCUPartNo);
        if (!McuFactory.isLastMatchSucceeded()) {
            String errorMsg = "Error: No matching MCU type found in the database for: " + targetMCUPartNo + "\n\nConversion failed.";
            this.out.println(errorMsg);
            this.showResultDialog("IAR to GD Project Conversion Failed", errorMsg, true);
            return false;
        }
        String targetName = GlobalVariables.McuSeletorInfo.getMCUGroup().toLowerCase();
        String pathFWLib = McuFactory.getFirmwarePath((String)this.iarProjParse.getToolChainName(), (String)targetName);
        this.out.println("Modify project configuration information.");
        GenerateProjectFile generateProjectFile = new GenerateProjectFile(projFolder, projectName);
        generateProjectFile.CopyProjectFolder();
        if (!this.processCProjectFile(projFolder, cConfigContent)) {
            return false;
        }
        generateProjectFile.UpdateProjectFile();
        generateProjectFile.UpdateCProjectFile();
        boolean isCopyMode = this.getIARProjPage.GetCopyMode();
        ArrayList<FilesStruct> virtualFolders = new ArrayList<FilesStruct>();
        ArrayList<FilesStruct> linkedFiles = new ArrayList<FilesStruct>();
        this.out.println("Create project structure.");
        for (GroupStruct group : targetInfoStruct.getLstGroups()) {
            this.processGroupStructure(group, projFolder, virtualFolders, linkedFiles, isCopyMode, "");
        }
        if (!isCopyMode) {
            this.out.println("Adding virtual folder structure and linked file resources...");
            this.projectCreator.linkResources(projectName, virtualFolders, linkedFiles);
        }
        this.out.println("Copy firmware-lib files.");
        String destCMSISPath = "";
        if (this.iarProjParse.getToolChainName().toUpperCase().equals("ARM")) {
            String srcStartupPath = String.valueOf(pathFWLib) + File.separator + "gcc_startup";
            String destStartupPath = String.valueOf(projFolder) + File.separator + "gcc_startup";
            this.folderProcess.createFolder(destStartupPath);
            File srcStartupDir = new File(srcStartupPath);
            ArrayList<String> excludeFiles = new ArrayList<String>();
            File[] allStartupFiles = srcStartupDir.listFiles();
            if (allStartupFiles != null) {
                File[] fileArray = allStartupFiles;
                int n = allStartupFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String startupfileName = file.getName();
                    if (this.hasStartUpGroup.booleanValue() && startupfileName.toUpperCase().endsWith(".S") && !this.needStartUpFileList.contains(startupfileName.substring(0, startupfileName.length() - 2))) {
                        excludeFiles.add(file.getName());
                    }
                    ++n2;
                }
                this.folderProcess.copyFolderAndFiles(srcStartupPath, destStartupPath, excludeFiles);
            }
            String srcCMSISPath = String.valueOf(pathFWLib) + File.separator + "Firmware" + File.separator + "CMSIS";
            destCMSISPath = String.valueOf(projFolder) + File.separator + "CMSIS";
            try {
                this.folderProcess.copyTargetFile(srcCMSISPath, destCMSISPath, ".h");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.iarProjParse.getToolChainName().toUpperCase().startsWith("RISC")) {
            String srcRISCVPath = String.valueOf(pathFWLib) + File.separator + "Firmware" + File.separator + "RISCV";
            String destRISCVPath = String.valueOf(projFolder) + File.separator + "RISCV";
            this.folderProcess.createFolder(destRISCVPath);
            this.folderProcess.copyFolderAndFiles(srcRISCVPath, destRISCVPath);
        }
        ArrayList<String> includePaths = new ArrayList<String>();
        List<java.nio.file.Path> IARInclude = targetInfoStruct.getLstIncludePath();
        String projCompilerFolder = String.valueOf(projRootFolder) + File.separator + "GD32EBuilder_project" + File.separator + "CompilerTarget";
        File eclipseProjectCompilerDir = new File(projCompilerFolder);
        for (java.nio.file.Path inc : IARInclude) {
            java.nio.file.Path relativePath = eclipseProjectCompilerDir.toPath().relativize(inc);
            includePaths.add(relativePath.toString());
        }
        if (this.iarProjParse.getToolChainName().toUpperCase().equals("ARM") && !destCMSISPath.isEmpty()) {
            java.nio.file.Path CMSISPath = Paths.get(destCMSISPath, new String[0]);
            includePaths.add(eclipseProjectCompilerDir.toPath().relativize(CMSISPath).toString());
        }
        this.out.println("Add the include path configuration.");
        String includeNode = this.projectCreator.getIncludeNode(includePaths);
        this.projectCreator.updateIncludePath(projectName, includeNode);
        this.projectCreator.refreshProject(projectName);
        GlobalVariables.McuSeletorInfo = tmpGDMcuSeletorInfo;
        this.out.println("");
        String successMsg = "Successfully!\n\nGD32 Eclipse project is generated!\nProject path: " + projFolder;
        this.out.println(successMsg);
        this.showResultDialog("IAR to GD Project Conversion Complete", successMsg, false);
        this.out.println("");
        return true;
    }

    private String processGroupForExclusion(GroupStruct group, String parentGroupName, String entry) {
        List<GroupStruct> subGroups;
        String groupName = group.getGroupName();
        String currentPath = parentGroupName.isEmpty() ? groupName : String.valueOf(parentGroupName) + "/" + groupName;
        List<FilesStruct> lstFiles = group.getLstFiles();
        if (lstFiles != null) {
            for (FilesStruct filesStruct : lstFiles) {
                if (!filesStruct.getFileOption()) continue;
                String fileName = filesStruct.getFileName();
                String str = String.valueOf(currentPath) + File.separator + fileName;
                if (str == null) continue;
                entry = String.valueOf(entry) + str + "|";
            }
        }
        if ((subGroups = group.getSubGroups()) != null) {
            for (GroupStruct subGroup : subGroups) {
                entry = this.processGroupForExclusion(subGroup, currentPath, entry);
            }
        }
        return entry;
    }

    private void processGroupStructure(GroupStruct group, String projFolder, List<FilesStruct> virtualFolders, List<FilesStruct> linkedFiles, boolean isCopyMode, String parentGroupName) {
        String groupName = group.getGroupName();
        if (groupName.isEmpty() || this.specialGroups.contains(groupName.toUpperCase())) {
            return;
        }
        String fullGroupName = String.valueOf(parentGroupName.isEmpty() ? "" : String.valueOf(parentGroupName) + File.separator) + groupName;
        List<FilesStruct> files = group.getLstFiles();
        if (isCopyMode) {
            String folderPath = String.valueOf(projFolder) + "/" + fullGroupName;
            this.folderProcess.createFolder(folderPath);
            for (FilesStruct fileStruct : files) {
                this.folderProcess.copyFolderAndFiles(fileStruct.getFilePath(), folderPath);
            }
        } else {
            FilesStruct virFolder = new FilesStruct();
            virFolder.setFileName(fullGroupName);
            virFolder.setFileType("2");
            virFolder.setFilePath("virtual:/virtual");
            virtualFolders.add(virFolder);
            for (FilesStruct fileStruct : files) {
                FilesStruct linkedFile = new FilesStruct();
                String name = String.valueOf(fullGroupName) + File.separator + fileStruct.getFileName();
                name = name.replace("\\", "/");
                String type = "1";
                String locationURI = this.analyzeString(fileStruct.getFilePath());
                linkedFile.setFileName(name);
                linkedFile.setFileType(type);
                linkedFile.setFilePath(locationURI);
                linkedFiles.add(linkedFile);
            }
        }
        List<GroupStruct> subGroups = group.getSubGroups();
        if (subGroups != null && !subGroups.isEmpty()) {
            for (GroupStruct subGroup : subGroups) {
                this.processGroupStructure(subGroup, projFolder, virtualFolders, linkedFiles, isCopyMode, fullGroupName);
            }
        }
    }

    @Override
    protected String processSecure(String fileContent, TargetInfoStruct gTargetInfoStruct) {
        try {
            String strnSecure = gTargetInfoStruct.getStrnSecure();
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(fileContent));
            List toolChains = document.selectNodes("//toolChain");
            for (Node node : toolChains) {
                Element toolChain = (Element)node;
                Node otherOptionNode = toolChain.selectSingleNode(".//option[contains(@superClass, 'com.gigadevice.mbs.arm.option.targetProcessor.other')]");
                Element otherOption = otherOptionNode != null ? (Element)otherOptionNode : null;
                Node allOptionsNode = toolChain.selectSingleNode(".//option[contains(@superClass, 'com.gigadevice.mbs.arm.option.targetProcessor.allOptions')]");
                if (allOptionsNode != null) {
                    Element cfr_ignored_0 = (Element)allOptionsNode;
                }
                if (!this.iarProjParse.getToolChainName().toUpperCase().equals("ARM")) continue;
                if (strnSecure != null && !strnSecure.isEmpty() && !"0".equals(strnSecure)) {
                    if (otherOption == null) {
                        otherOption = toolChain.addElement("option");
                        otherOption.addAttribute("id", "com.gigadevice.mbs.arm.option.targetProcessor.other." + System.currentTimeMillis());
                        otherOption.addAttribute("superClass", "com.gigadevice.mbs.arm.option.targetProcessor.other");
                        otherOption.addAttribute("value", "-mcmse");
                        otherOption.addAttribute("valueType", "string");
                        continue;
                    }
                    otherOption.attribute("value").setValue("-mcmse");
                    continue;
                }
                if (otherOption == null) continue;
                otherOption.attribute("value").setValue("");
            }
            return ImportWizardIAR2GD.outputDocumentWithOriginalFormat(document);
        }
        catch (DocumentException e) {
            System.err.println("\u6fb6\u52ed\u608aXML\u93c3\u8dfa\u56ad\u95bf\ufffd: " + e.getMessage());
            e.printStackTrace();
            return fileContent;
        }
    }
}

