/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GetIARProjPage
extends WizardPage {
    private Text textfolder;
    private Text textProject;
    private Label labelMessage;
    private boolean isCopyMode = false;
    private static final boolean SHOW_GENERATING_MODE = false;

    protected GetIARProjPage(String pageName) {
        super(pageName);
        this.setTitle("Import IAR Project");
        this.setDescription("Please select a .ewp file for an existing IAR project.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout(null);
        Group grpProjectInfo = new Group(container, 0);
        grpProjectInfo.setBounds(10, 10, 554, 78);
        Label lblNewLabel_1 = new Label((Composite)grpProjectInfo, 0);
        lblNewLabel_1.setBounds(10, 45, 82, 17);
        lblNewLabel_1.setText("Project Name:");
        Label lblNewLabel = new Label((Composite)grpProjectInfo, 0);
        lblNewLabel.setBounds(10, 17, 97, 17);
        lblNewLabel.setText("Import project:");
        this.textfolder = new Text((Composite)grpProjectInfo, 2048);
        this.textfolder.setBounds(113, 14, 331, 23);
        Button btnBrowse = new Button((Composite)grpProjectInfo, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetIARProjPage.this.handleBrowse();
            }
        });
        btnBrowse.setBounds(450, 12, 94, 27);
        btnBrowse.setText("Browse...");
        this.textProject = new Text((Composite)grpProjectInfo, 2048);
        this.textProject.setBounds(113, 42, 331, 23);
        this.textProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GetIARProjPage.this.validatePage();
            }
        });
        this.labelMessage = new Label(container, 0);
        this.labelMessage.setBounds(10, 94, 554, 17);
        this.labelMessage.setForeground(parent.getDisplay().getSystemColor(3));
        this.setPageComplete(false);
    }

    private void createGeneratingModeControls(Composite container) {
        Group grpGeneratingMode = new Group(container, 0);
        grpGeneratingMode.setText("Generating Mode");
        grpGeneratingMode.setBounds(10, 94, 554, 120);
        final Button btnRadioLink = new Button((Composite)grpGeneratingMode, 16);
        btnRadioLink.setSelection(true);
        btnRadioLink.setBounds(10, 22, 97, 17);
        btnRadioLink.setText("Link Files");
        final Button btnRadioCopy = new Button((Composite)grpGeneratingMode, 16);
        btnRadioCopy.setBounds(10, 45, 97, 17);
        btnRadioCopy.setText("Copy Files");
        final Label lbTips = new Label((Composite)grpGeneratingMode, 64);
        lbTips.setBounds(10, 68, 534, 42);
        lbTips.setText("Link Mode: Create links to the original source files.\nChange to the original file will affect the IAR project and GD project simultaneously.");
        btnRadioLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnRadioLink.getSelection()) {
                    GetIARProjPage.this.isCopyMode = false;
                    lbTips.setText("Link Mode: Create links to the original source files.\nChange to the original file will affect the IAR project and GD project simultaneously.");
                }
            }
        });
        btnRadioCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnRadioCopy.getSelection()) {
                    GetIARProjPage.this.isCopyMode = true;
                    lbTips.setText("Copy Mode: Copy the original source files to the new project.\nChange to the original file will NOT affect the GD project.");
                }
            }
        });
    }

    private void handleBrowse() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.ewp"});
        dialog.setFilterNames(new String[]{"IAR Project Files (*.ewp)"});
        String result = dialog.open();
        if (result != null) {
            this.textfolder.setText(result);
            String projName = this.getProjName(result);
            this.textProject.setText(projName);
            this.validatePage();
        }
    }

    private String getProjName(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    private void validatePage() {
        String projName = this.textProject.getText().trim();
        if (projName.isEmpty()) {
            this.setErrorMessage("Project name cannot be empty");
            this.setPageComplete(false);
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projName);
        if (project.exists()) {
            this.labelMessage.setText("The project '" + projName + "' already exists in the workspace!");
            this.setPageComplete(false);
        } else {
            this.labelMessage.setText("");
            this.setPageComplete(true);
        }
    }

    public boolean isPageComplete() {
        String projPath = this.textfolder.getText();
        String projName = this.textProject.getText();
        if (projPath.isEmpty() || projName.isEmpty()) {
            return false;
        }
        File file = new File(projPath);
        if (!(file.exists() && file.isFile() && projPath.toLowerCase().endsWith(".ewp"))) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projName);
        return !project.exists();
    }

    public boolean GetCopyMode() {
        return this.isCopyMode;
    }

    public String GetIARPath() {
        return this.textfolder.getText();
    }

    public String GetProjName() {
        return this.textProject.getText();
    }
}

