/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.gpio;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class GPIOInfoUtil {
    public static Map<String, Map<String, Vector<String>>> GPIOConfigInfoMap = new HashMap<String, Map<String, Vector<String>>>();
    public static LinkedHashMap<String, String> mapGPIOConfigObjsIndex = new LinkedHashMap();
    public static final String STR_PINNAME = "PinName";
    public static final String STR_SIGNAL = "SignalOnPin";
    public static final String STR_LEVEL = "OutputLevel";
    public static final String STR_MODE = "GPIOMode";
    public static final String STR_PULL = "PullUpDown";
    public static final String STR_SPEED = "MaxSpeed";
    public static final String STR_LABEL = "UserLabel";
    public static final String STR_MODIFY = "ModifyFlag";
    public static final String STR_INPUTFILTER = "InputFilter";
    public static final String STR_INPUTFILTERTYPE = "InputFilterType";

    public static int getConfigColIndex(String strConfigObj) {
        int i = -1;
        if (mapGPIOConfigObjsIndex.containsKey(strConfigObj)) {
            for (String key : mapGPIOConfigObjsIndex.keySet()) {
                ++i;
                if (!key.equals(strConfigObj)) continue;
                return i;
            }
        }
        return i;
    }

    public static String getConfigObjValby(String PeriName, String GroupName, String ControlName) {
        String ret = "";
        if (PeriName == null || GroupName == null || ControlName == null) {
            return ret;
        }
        if (!GroupName.contains("##")) {
            return ret;
        }
        String[] parts = GroupName.split("##");
        if (parts.length != 2) {
            return ret;
        }
        String targetConfigObj = parts[0];
        String targetConfigObjVal = parts[1];
        int index1 = GPIOInfoUtil.getConfigColIndex(targetConfigObj);
        int index2 = GPIOInfoUtil.getConfigColIndex(ControlName);
        if (index1 < 0 || index2 < 0) {
            return ret;
        }
        Map<String, Vector<String>> pinMap = GPIOConfigInfoMap.get(PeriName);
        if (pinMap == null) {
            return ret;
        }
        for (Vector<String> rowData : pinMap.values()) {
            if (rowData == null || rowData.size() <= index1 || rowData.size() <= index2 || !targetConfigObjVal.equals(rowData.get(index1))) continue;
            ret = rowData.get(index2);
            break;
        }
        return ret;
    }
}

