/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.gd32mcu;

import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.PinFunctionStruct;
import com.gigadevice.venustool.baseinfo.PinNamesStruct;
import com.gigadevice.venustool.baseinfo.PinStruct;
import com.gigadevice.venustool.gd32mcu.GD32MCU_Interface;
import com.gigadevice.venustool.xmlparse.PinInfoXmlParse;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GD32MCU
implements GD32MCU_Interface,
Serializable {
    private static final long serialVersionUID = 1L;
    public List<GD32PinPad> GD32PinPads;
    public int MCUPackage = 0;
    private Map<String, Map<String, List<PinNamesStruct>>> AFIORemapMap;
    private boolean isRemap = false;
    public List<String> pinAllFunctionList;

    @Override
    public void InitMcuObj(String Series, String mcuPartNumber, String PackageType) {
        this.GD32PinPads = new ArrayList<GD32PinPad>();
        try {
            this.MCUPackage = Integer.parseInt(PackageType.replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        String DataSheetPath = String.valueOf(GeneralPathUtil.ResourcePath) + "DataSheet" + File.separator + GlobalVariables.McuSeletorInfo.getDataSheetPath();
        String AFIOPath = GlobalVariables.McuSeletorInfo.getAFIOPath();
        PinInfoXmlParse.parseDatasheetXML(DataSheetPath, this.GD32PinPads, PackageType, this.MCUPackage);
        String AFIOXMLPath = String.valueOf(GeneralPathUtil.ResourcePath) + AFIOPath;
        this.AFIORemapMap = new HashMap<String, Map<String, List<PinNamesStruct>>>();
        this.isRemap = PinInfoXmlParse.parseAFIOXML(AFIOXMLPath, this.AFIORemapMap);
        String AnalogXMLPath = String.valueOf(GeneralPathUtil.ResourcePath) + "PeriConfig" + File.separator + GlobalVariables.SeriesPath + File.separator + "AnalogPins.xml";
        PinInfoXmlParse.parseAnalogPinsXML(AnalogXMLPath);
        this.pinAllFunctionList = new ArrayList<String>();
        for (GD32PinPad obj : this.GD32PinPads) {
            List<PinFunctionStruct> PinFunctionList = obj.getPinFunctionList();
            for (PinFunctionStruct funObj : PinFunctionList) {
                if (this.pinAllFunctionList.contains(funObj.getPinFunctionName())) continue;
                this.pinAllFunctionList.add(funObj.getPinFunctionName());
            }
        }
    }

    public boolean getisRemap() {
        return this.isRemap;
    }

    @Override
    public List<GD32PinPad> GetUpdatePinByFunction(String FunctionGroupName, List<String> UsedFunctionList) {
        ArrayList<GD32PinPad> pUpdatePinList = new ArrayList<GD32PinPad>();
        List<Object> TemGD32PinPads = new ArrayList();
        TemGD32PinPads = GlobalVariables.cloneFrom(this.GD32PinPads);
        int i = 0;
        while (i < UsedFunctionList.size()) {
            String Function2 = UsedFunctionList.get(i);
            int Index = this.GetPinIndexByUsedFunc(Function2);
            if (Index != -1) {
                GD32PinPad tmpPinPadObj = null;
                String pinNameStr = this.GD32PinPads.get(Index).getPinName();
                int j = 0;
                while (j < pUpdatePinList.size()) {
                    if (pinNameStr.equals(((GD32PinPad)pUpdatePinList.get(j)).getPinName())) {
                        tmpPinPadObj = (GD32PinPad)pUpdatePinList.get(j);
                        GD32PinPad child0 = GlobalVariables.cloneFrom((GD32PinPad)pUpdatePinList.get(j));
                        child0.putPinUsedFunctionStr(Function2);
                        pUpdatePinList.add(child0);
                        break;
                    }
                    ++j;
                }
                if (tmpPinPadObj == null) {
                    tmpPinPadObj = GlobalVariables.cloneFrom(this.GD32PinPads.get(Index));
                    tmpPinPadObj.putPinUsedFunctionStr(Function2);
                    pUpdatePinList.add(tmpPinPadObj);
                }
            } else {
                if (!this.ReturnUpdatePinList(FunctionGroupName, Function2, pUpdatePinList)) {
                    pUpdatePinList.clear();
                    break;
                }
                for (GD32PinPad pinPadObj : pUpdatePinList) {
                    if (this.GD32PinPads.get(pinPadObj.getPinIndex()).getPinUsedType() != 0) continue;
                    this.GD32PinPads.get(pinPadObj.getPinIndex()).putPinUsedType(-10);
                }
            }
            ++i;
        }
        for (GD32PinPad pinPadObj : pUpdatePinList) {
            if (UsedFunctionList.contains(pinPadObj.getPinUsedFunctionStr()) || pinPadObj.getPinUsedFunctionStr().contains(",")) {
                int UsedType = pinPadObj.getPinUsedType();
                UsedType = UsedType == 1 || UsedType == 3 ? 3 : 2;
                pinPadObj.putPinUsedType(UsedType);
            }
            for (GD32PinPad childPinPadObj : pinPadObj.getChildGD32PinPads()) {
                if (!UsedFunctionList.contains(childPinPadObj.getPinUsedFunctionStr()) && !childPinPadObj.getPinUsedFunctionStr().contains(",")) continue;
                int UsedType = childPinPadObj.getPinUsedType();
                UsedType = UsedType == 1 || UsedType == 3 ? 3 : 2;
                childPinPadObj.putPinUsedType(UsedType);
            }
        }
        this.GD32PinPads.clear();
        this.GD32PinPads = GlobalVariables.cloneFrom(TemGD32PinPads);
        return pUpdatePinList;
    }

    public boolean ReturnUpdatePinList(String FunctionGroupName, String Function2, List<GD32PinPad> pUpdatePinList) {
        boolean result = true;
        ArrayList<GD32PinPad> tmpUpdatePinList = new ArrayList<GD32PinPad>();
        ArrayList<String> pNoPinFuncList = new ArrayList<String>();
        if (!this.getUpdatePinList(FunctionGroupName, Function2, tmpUpdatePinList, pNoPinFuncList)) {
            if (pNoPinFuncList.size() <= 0) {
                return false;
            }
            ArrayList<GD32PinPad> pSwitchPinList = new ArrayList<GD32PinPad>();
            this.switchPinToUnused(pNoPinFuncList, pSwitchPinList);
            result = this.getUpdatePinList(FunctionGroupName, Function2, tmpUpdatePinList, pNoPinFuncList);
            if (!result) {
                return false;
            }
            int i = 0;
            while (i < tmpUpdatePinList.size()) {
                int Index = this.GetPinIndexByPinName(((GD32PinPad)tmpUpdatePinList.get(i)).getPinName());
                this.GD32PinPads.get(Index).putPinUsedFunctionStr(((GD32PinPad)tmpUpdatePinList.get(i)).getPinUsedFunctionStr());
                this.GD32PinPads.get(Index).putPinUsedType(1);
                this.GD32PinPads.get(Index).putRemapAF_Value(((GD32PinPad)tmpUpdatePinList.get(i)).getRemapAF_Value());
                this.GD32PinPads.get(Index).putPinUsedPeri(FunctionGroupName);
                ++i;
            }
            result = this.SwitchPinToNewPin(pSwitchPinList, tmpUpdatePinList);
            if (!result) {
                pUpdatePinList.clear();
                return false;
            }
        }
        int i = 0;
        while (i < tmpUpdatePinList.size()) {
            this.AddPinToUpdatePinList((GD32PinPad)tmpUpdatePinList.get(i), pUpdatePinList);
            ++i;
        }
        return result;
    }

    private boolean SwitchPinToNewPin(List<GD32PinPad> pSwitchPinList, List<GD32PinPad> pUpdatePinList) {
        boolean result = true;
        int i = 0;
        while (i < pSwitchPinList.size()) {
            GD32PinPad GD32PinPadObj = pSwitchPinList.get(i);
            int Index = GD32PinPadObj.getPinIndex();
            if (this.GD32PinPads.get(Index).getPinUsedType() == 0 && !this.isRemap) {
                this.GD32PinPads.get(Index);
                this.GD32PinPads.get(Index).putPinUsedFunctionStr(GD32PinPadObj.getPinUsedFunctionStr());
                this.GD32PinPads.get(Index).putPinUsedType(GD32PinPadObj.getPinUsedType());
                GlobalVariables.cloneFrom(GD32PinPadObj);
            } else {
                result = this.ReturnUpdatePinList(GD32PinPadObj.getPinUsedPeri(), GD32PinPadObj.getPinUsedFunctionStr(), pUpdatePinList);
                if (!result) {
                    return false;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean getUpdatePinList(String FunctionGroupName, String Function2, List<GD32PinPad> pUpdatePinList, List<String> pNoPinFuncList) {
        String PeriName = this.getPeriName(FunctionGroupName);
        boolean result = false;
        result = Function2.contains("#[") ? this.getUpdatePinWithoutAFIO(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList) : (!this.AFIORemapMap.containsKey(PeriName) ? this.getUpdatePinWithoutAFIO(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList) : (!this.isRemap ? this.getUpdatePinInAFIO(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList) : this.getUpdatePinInRemap(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList)));
        return result;
    }

    private boolean getUpdatePinInAFIO(String FunctionGroupName, String Function2, List<GD32PinPad> pUpdatePinList, List<String> pNoPinFuncList) {
        Map<String, List<PinNamesStruct>> PinNamesMap = this.AFIORemapMap.get(this.getPeriName(FunctionGroupName));
        if (!PinNamesMap.containsKey(Function2)) {
            return this.getUpdatePinWithoutAFIO(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList);
        }
        GD32PinPad GD32PinPadObj = this.GetUnusedPinInAFIOGroup(Function2, PinNamesMap.get(Function2));
        if (GD32PinPadObj == null) {
            pNoPinFuncList.add(Function2);
            return false;
        }
        GD32PinPadObj.putPinUsedPeri(FunctionGroupName);
        pUpdatePinList.add(GD32PinPadObj);
        return true;
    }

    private boolean getUpdatePinInRemap(String FunctionGroupName, String Function2, List<GD32PinPad> pUpdatePinList, List<String> pNoPinFuncList) {
        boolean result = false;
        Map<String, List<PinNamesStruct>> PinNamesMap = this.AFIORemapMap.get(this.getPeriName(FunctionGroupName));
        if (!PinNamesMap.containsKey(FunctionGroupName)) {
            return this.getUpdatePinWithoutAFIO(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList);
        }
        List<PinNamesStruct> PinNamesStructList = PinNamesMap.get(FunctionGroupName);
        result = this.getUnusedPinListInRemap(FunctionGroupName, Function2, pUpdatePinList, PinNamesStructList, pNoPinFuncList);
        return result;
    }

    private boolean getUpdatePinWithoutAFIO(String FunctionGroupName, String Function2, List<GD32PinPad> pUpdatePinList, List<String> pNoPinFuncList) {
        boolean result = true;
        GD32PinPad GD32PinPadObj = this.getPinWithoutAFIO(Function2);
        if (GD32PinPadObj != null && result) {
            GD32PinPadObj.putPinUsedPeri(FunctionGroupName);
            pUpdatePinList.add(GD32PinPadObj);
        } else {
            pNoPinFuncList.add(Function2);
            result = false;
        }
        if (!result) {
            pUpdatePinList.clear();
        }
        return result;
    }

    private GD32PinPad getPinWithoutAFIO(String FunctionItem) {
        GD32PinPad GD32PinPadObj = null;
        if (FunctionItem.contains("#[")) {
            String[] tmp = FunctionItem.split("#\\[");
            String pinName = tmp[1];
            pinName = pinName.replaceAll("\\]", "");
            FunctionItem = tmp[0];
            int index = this.GetPinIndexByPinName(pinName);
            if (index >= 0 && index < this.GD32PinPads.size()) {
                if (!this.pinIsCanAssigned(FunctionItem, this.GD32PinPads.get(index))) {
                    return null;
                }
                GD32PinPadObj = this.GD32PinPads.get(index);
            }
        } else {
            int j = 0;
            while (j < this.MCUPackage) {
                if (this.FunctionContainInGD32PinPad(this.GD32PinPads.get(j), FunctionItem) && this.pinIsCanAssigned(FunctionItem, this.GD32PinPads.get(j))) {
                    GD32PinPadObj = this.GD32PinPads.get(j);
                    break;
                }
                ++j;
            }
        }
        if (GD32PinPadObj != null) {
            GD32PinPad newGD32PinPadObj = new GD32PinPad();
            String PinName = GD32PinPadObj.getPinName();
            int UsedType = 2;
            String RemapAFValue = this.GetAFIOValue(PinName, FunctionItem);
            String PeriName = "";
            newGD32PinPadObj.putPinIndex(GD32PinPadObj.getPinIndex());
            this.AddConfigInfoInGD32PinPad(PinName, FunctionItem, UsedType, RemapAFValue, PeriName, newGD32PinPadObj);
            return newGD32PinPadObj;
        }
        return null;
    }

    private GD32PinPad GetUnusedPinInAFIOGroup(String FunctionItem, List<PinNamesStruct> PinNamesStructList) {
        int i = 0;
        while (i < PinNamesStructList.size()) {
            List<PinStruct> PinStructList = PinNamesStructList.get(i).getPinStructList();
            int j = 0;
            while (j < PinStructList.size()) {
                String PinName;
                int Index;
                if (FunctionItem.equals(PinStructList.get(j).getPinUsedFunction()) && (Index = this.GetPinIndexByPinName(PinName = PinStructList.get(j).getPinName())) != -1 && this.FunctionContainInGD32PinPad(this.GD32PinPads.get(Index), FunctionItem) && this.pinIsCanAssigned(FunctionItem, this.GD32PinPads.get(Index))) {
                    String availableParts;
                    int MCUFlashSize = 0;
                    int FlashSize = 0;
                    if (!PinStructList.get(j).getFlashSizeType().equals("")) {
                        try {
                            MCUFlashSize = Integer.parseInt(GlobalVariables.McuSeletorInfo.getFlashSize());
                            FlashSize = Integer.parseInt(PinStructList.get(j).getFlashSize());
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!(PinStructList.get(j).getFlashSizeType().equals("FlashSize") ? MCUFlashSize != FlashSize : (PinStructList.get(j).getFlashSizeType().equals("FlashSizeMin") ? MCUFlashSize < FlashSize : (PinStructList.get(j).getFlashSizeType().equals("FlashSizeMax") ? MCUFlashSize > FlashSize : !PinStructList.get(j).getAvailablePart().equals("") && PinStructList.get(j).getAvailablePart() != null && !(availableParts = PinStructList.get(j).getAvailablePart()).contains(GlobalVariables.McuSeletorInfo.getMCUPart()))))) {
                        GD32PinPad GD32PinPadObj = new GD32PinPad();
                        int UsedType = 2;
                        String RemapAFValue = PinNamesStructList.get(i).getRemapAFValue();
                        String PeriName = "";
                        this.AddConfigInfoInGD32PinPad(PinName, FunctionItem, UsedType, RemapAFValue, PeriName, GD32PinPadObj);
                        return GD32PinPadObj;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private boolean getUnusedPinListInRemap(String FunctionGroupName, String Function2, List<GD32PinPad> pUpdatePinList, List<PinNamesStruct> PinNamesStructList, List<String> pNoPinFuncList) {
        ArrayList<String> RemapFucList = new ArrayList<String>();
        if (PinNamesStructList.size() <= 0) {
            return false;
        }
        if (!this.FunctionIsInRemap(Function2, PinNamesStructList.get(0))) {
            return this.getUpdatePinWithoutAFIO(FunctionGroupName, Function2, pUpdatePinList, pNoPinFuncList);
        }
        RemapFucList.add(Function2);
        ArrayList<PinNamesStruct> AvailablePinNamesList = new ArrayList<PinNamesStruct>();
        this.getAllFuncAndGroupInRemap(FunctionGroupName, RemapFucList, AvailablePinNamesList);
        boolean result = false;
        int i = 0;
        while (i < AvailablePinNamesList.size()) {
            if (this.CheckAllocationInGroup(((PinNamesStruct)AvailablePinNamesList.get(i)).getPinStructList(), RemapFucList, pNoPinFuncList)) {
                this.AllocationPinInRemapGroup(RemapFucList, (PinNamesStruct)AvailablePinNamesList.get(i), pUpdatePinList);
                return true;
            }
            ++i;
        }
        if (!result) {
            pUpdatePinList.clear();
        }
        return result;
    }

    private void getAllFuncAndGroupInRemap(String FunctionGroupName, List<String> RemapFucList, List<PinNamesStruct> AvailablePinNamesList) {
        Map<String, List<PinNamesStruct>> PinNamesMap = this.AFIORemapMap.get(this.getPeriName(FunctionGroupName));
        List<PinNamesStruct> PinNamesStructList = PinNamesMap.get(FunctionGroupName);
        int i = 0;
        while (i < PinNamesStructList.size()) {
            List<PinStruct> PinStructList = PinNamesStructList.get(i).getPinStructList();
            boolean manuPin = false;
            boolean manuPinInGroup = true;
            int j = 0;
            while (j < PinStructList.size()) {
                String FunctionStr = PinStructList.get(j).getPinUsedFunction();
                int Index = this.GetPinIndexByUsedFunc(FunctionStr);
                if (Index != -1) {
                    String PinName;
                    if (i == 0) {
                        RemapFucList.add(FunctionStr);
                    }
                    if (this.isManualPin(this.GetPinIndexByPinName(PinName = PinStructList.get(j).getPinName()))) {
                        manuPin = true;
                        if (!PinName.equals(this.GetPinNameByUsedFunc(FunctionStr))) {
                            manuPinInGroup = false;
                        }
                    }
                }
                ++j;
            }
            if (manuPin && manuPinInGroup) {
                AvailablePinNamesList.add(PinNamesStructList.get(i));
            }
            ++i;
        }
        if (AvailablePinNamesList.size() <= 0) {
            AvailablePinNamesList.addAll(PinNamesStructList);
        }
    }

    private boolean CheckAllocationInGroup(List<PinStruct> PinStructList, List<String> RemapFucList, List<String> pNoPinFuncList) {
        boolean isMatchRemap = true;
        int j = 0;
        while (j < PinStructList.size()) {
            String PinName = PinStructList.get(j).getPinName();
            String FunctionStr = PinStructList.get(j).getPinUsedFunction();
            int Index = this.GetPinIndexByPinName(PinName);
            if (Index == -1) {
                isMatchRemap = false;
            } else if (RemapFucList.contains(FunctionStr)) {
                if (!this.pinIsCanAssigned(FunctionStr, this.GD32PinPads.get(Index))) {
                    isMatchRemap = false;
                    if (!pNoPinFuncList.contains(FunctionStr)) {
                        pNoPinFuncList.add(FunctionStr);
                    }
                } else if (pNoPinFuncList.contains(FunctionStr)) {
                    pNoPinFuncList.remove(FunctionStr);
                }
            }
            ++j;
        }
        return isMatchRemap;
    }

    /*
     * Unable to fully structure code
     */
    private void AllocationPinInRemapGroup(List<String> RemapFucList, PinNamesStruct PinNamesStructObj, List<GD32PinPad> pUpdatePinList) {
        FunctionGroupName = PinNamesStructObj.getFunctionGroupName();
        RemapAFValue = PinNamesStructObj.getRemapAFValue();
        PinStructList = PinNamesStructObj.getPinStructList();
        j = 0;
        while (j < RemapFucList.size()) {
            FunctionStr = RemapFucList.get(j);
            PinName = this.GetPinNameByFuncInRemap(RemapFucList.get(j), PinStructList);
            OldIndex = this.GetPinIndexByUsedFunc(FunctionStr);
            if (OldIndex == -1) ** GOTO lbl21
            if (this.GD32PinPads.get(OldIndex).getPinName().equals(PinName)) {
                GD32PinPad = this.GD32PinPads.get(OldIndex);
                GD32PinPadObj = GlobalVariables.cloneFrom(GD32PinPad);
                GD32PinPadObj.putRemapAF_Value(RemapAFValue);
                this.AddPinToUpdatePinList(GD32PinPadObj, pUpdatePinList);
            } else {
                this.GD32PinPads.get(OldIndex).putPinUsedFunctionStr("");
                this.GD32PinPads.get(OldIndex).putPinUsedType(0);
                this.GD32PinPads.get(OldIndex).putRemapAF_Value("");
                this.GD32PinPads.get(OldIndex).putPinUsedPeri("");
                this.AddPinToUpdatePinList(this.GD32PinPads.get(OldIndex), pUpdatePinList);
lbl21:
                // 2 sources

                GD32PinPadObj = new GD32PinPad();
                UsedType = 2;
                Index = this.GetPinIndexByPinName(PinName);
                if (this.isManualPin(Index)) {
                    UsedType = 3;
                }
                this.AddConfigInfoInGD32PinPad(PinName, FunctionStr, UsedType, RemapAFValue, FunctionGroupName, GD32PinPadObj);
                this.AddConfigInfoInGD32PinPad(PinName, FunctionStr, UsedType, RemapAFValue, FunctionGroupName, this.GD32PinPads.get(Index));
                this.AddPinToUpdatePinList(GD32PinPadObj, pUpdatePinList);
            }
            ++j;
        }
    }

    private void switchPinToUnused(List<String> pNoPinFuncList, List<GD32PinPad> pSwitchPinList) {
        int i = 0;
        while (i < pNoPinFuncList.size()) {
            String Function2 = pNoPinFuncList.get(i);
            List<Integer> pSwitchPinIndexList = this.getSwitchPinByContainFunc(Function2);
            int j = 0;
            while (j < pSwitchPinIndexList.size()) {
                int Index = pSwitchPinIndexList.get(j);
                if (Index != -1 && this.GD32PinPads.get(Index).getGPIOModel() != 1) {
                    GD32PinPad GD32PinPadObj = new GD32PinPad();
                    GD32PinPadObj = GlobalVariables.cloneFrom(this.GD32PinPads.get(Index));
                    pSwitchPinList.add(GD32PinPadObj);
                    this.GD32PinPads.get(Index).putPinUsedFunctionStr("");
                    this.GD32PinPads.get(Index).putPinUsedType(0);
                    this.GD32PinPads.get(Index).putRemapAF_Value("");
                    this.GD32PinPads.get(Index).putPinUsedPeri("");
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private List<Integer> getSwitchPinByContainFunc(String Function2) {
        ArrayList<Integer> pSwitchPinIndexList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.MCUPackage) {
            List<PinFunctionStruct> PinFunctionList = this.GD32PinPads.get(i).getPinFunctionList();
            int j = 0;
            while (j < PinFunctionList.size()) {
                String FunctionStr = PinFunctionList.get(j).getPinFunctionName();
                if (FunctionStr.equals(Function2)) {
                    int UsedType = this.GD32PinPads.get(i).getPinUsedType();
                    if (GlobalVariables.isAllowChangePinPlace && UsedType == 2) {
                        pSwitchPinIndexList.add(i);
                    }
                }
                ++j;
            }
            ++i;
        }
        return pSwitchPinIndexList;
    }

    public void AddPinToUpdatePinList(GD32PinPad GD32PinPadObj, List<GD32PinPad> pUpdatePinList) {
        String PinName = GD32PinPadObj.getPinName();
        int Index = this.PinContainInUpdatePinList(PinName, pUpdatePinList);
        if (Index >= 0) {
            pUpdatePinList.remove(Index);
        }
        pUpdatePinList.add(GD32PinPadObj);
    }

    public int PinContainInUpdatePinList(String PinName, List<GD32PinPad> pUpdatePinList) {
        int i = 0;
        while (i < pUpdatePinList.size()) {
            if (PinName.equals(pUpdatePinList.get(i).getPinName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int FuncContainInUpdatePinList(String Function2, List<GD32PinPad> pUpdatePinList) {
        int i = 0;
        while (i < pUpdatePinList.size()) {
            if (Function2.equals(pUpdatePinList.get(i).getPinUsedFunctionStr())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean FunctionContainInGD32PinPad(GD32PinPad GD32PinPadObj, String FunctionItem) {
        List<PinFunctionStruct> PinFunctionList = GD32PinPadObj.getPinFunctionList();
        int i = 0;
        while (i < PinFunctionList.size()) {
            if (PinFunctionList.get(i).getPinFunctionName().equals(FunctionItem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getPeriName(String FunctionGroupName) {
        String PeriName = GlobalVariables.GetMultipleTreePeriName(FunctionGroupName);
        int i = FunctionGroupName.length() - 1;
        while (i >= 0) {
            if (!Character.isDigit(FunctionGroupName.charAt(i))) {
                PeriName = FunctionGroupName.substring(0, i + 1);
                break;
            }
            --i;
        }
        return PeriName;
    }

    private boolean FunctionIsInRemap(String PinFunctionItem, PinNamesStruct pinNamesStruct) {
        List<PinStruct> PinStructList = pinNamesStruct.getPinStructList();
        int j = 0;
        while (j < PinStructList.size()) {
            if (PinFunctionItem.equals(PinStructList.get(j).getPinUsedFunction())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public int GetPinIndexByPinName(String PinNameStr) {
        int i = 0;
        while (i < this.MCUPackage) {
            if (!this.GD32PinPads.get(i).getDisplayName().equals("") ? PinNameStr.equals(this.GD32PinPads.get(i).getDisplayName()) : PinNameStr.equals(this.GD32PinPads.get(i).getPinName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int GetPinIndexByPinNumStr(String PinNumStr) {
        int i = 0;
        while (i < this.MCUPackage) {
            if (PinNumStr.equals(this.GD32PinPads.get(i).getPinNumberStr())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int GetPinIndexByUsedFunc(String UsedFunctionStr) {
        int i = 0;
        while (i < this.MCUPackage) {
            if (this.functionIsAssignedInPin(UsedFunctionStr, this.GD32PinPads.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String GetPinNameByUsedFunc(String UsedFunctionStr) {
        int i = 0;
        while (i < this.MCUPackage) {
            if (this.GD32PinPads.get(i).getPinUsedType() != 0 && this.functionIsAssignedInPin(UsedFunctionStr, this.GD32PinPads.get(i))) {
                return this.GD32PinPads.get(i).getPinName();
            }
            ++i;
        }
        return "";
    }

    private String GetPinNameByFuncInRemap(String FunctionStr, List<PinStruct> PinStructList) {
        int i = 0;
        while (i < PinStructList.size()) {
            if (FunctionStr.equals(PinStructList.get(i).getPinUsedFunction())) {
                return PinStructList.get(i).getPinName();
            }
            ++i;
        }
        return "";
    }

    private void AddConfigInfoInGD32PinPad(String PinName, String Function2, int UsedType, String RemapAFValue, String pinUsedPeri, GD32PinPad GD32PinPadObj) {
        int index = this.GetPinIndexByPinName(PinName);
        GD32PinPadObj.putPinIndex(index);
        GD32PinPadObj.putPinName(PinName);
        GD32PinPadObj.putPinUsedFunctionStr(Function2);
        GD32PinPadObj.putPinUsedType(UsedType);
        GD32PinPadObj.putRemapAF_Value(RemapAFValue);
        GD32PinPadObj.putPinUsedPeri(pinUsedPeri);
    }

    private boolean isManualPin(int Index) {
        if (Index == -1) {
            return false;
        }
        int UsedType = this.GD32PinPads.get(Index).getPinUsedType();
        return UsedType == 1 || UsedType == 3;
    }

    public String GetPinAFValueByPinName(String PinNameStr) {
        int i = 0;
        while (i < this.MCUPackage) {
            if (PinNameStr.equals(this.GD32PinPads.get(i).getPinName()) && this.GD32PinPads.get(i).getPinUsedType() != 0) {
                return this.GD32PinPads.get(i).getRemapAF_Value();
            }
            ++i;
        }
        return null;
    }

    public List<GD32PinPad> getResetPinIndexByFuncList(List<String> functionList) {
        ArrayList<GD32PinPad> ResetPinIndexList = new ArrayList<GD32PinPad>();
        int i = 0;
        while (i < functionList.size()) {
            int j = 0;
            while (j < this.MCUPackage) {
                int UsedType;
                String functionName = functionList.get(i);
                if (functionName.contains("#[")) {
                    String[] tmp = functionName.split("#\\[");
                    functionName = tmp[0];
                }
                if (this.functionIsAssignedInPin(functionName, this.GD32PinPads.get(j)) && (UsedType = this.GD32PinPads.get(j).getPinUsedType()) != 1) {
                    GD32PinPad GD32PinPadObj = new GD32PinPad();
                    GD32PinPadObj.putPinIndex(j);
                    GD32PinPadObj.putPinName(this.GD32PinPads.get(j).getPinName());
                    GD32PinPadObj.putPinUsedFunctionStr(functionName);
                    GD32PinPadObj.putPinUsedPeri(this.GD32PinPads.get(j).getPinUsedPeri());
                    GD32PinPadObj.putPinUsedType(this.GD32PinPads.get(j).getPinUsedType());
                    GD32PinPadObj.putRemapAF_Value(this.GD32PinPads.get(j).getRemapAF_Value());
                    ResetPinIndexList.add(GD32PinPadObj);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return ResetPinIndexList;
    }

    public String GetGPIOAFValue(String PinName, String Function2) {
        if (this.isRemap) {
            return this.GetRemapValue(PinName, Function2);
        }
        return this.GetAFIOValue(PinName, Function2);
    }

    private String GetAFIOValue(String PinName, String Function2) {
        Map<String, List<PinNamesStruct>> PinNamesMap;
        String AFIOValue = "AF0";
        if (Function2.equals("")) {
            return AFIOValue;
        }
        String PeriName = Function2.split("_")[0];
        if (Function2.contains(",")) {
            Function2 = Function2.split(",")[0];
        }
        if ((PinNamesMap = this.AFIORemapMap.get(this.getPeriName(PeriName))) == null) {
            return AFIOValue;
        }
        if (!PinNamesMap.containsKey(Function2)) {
            return AFIOValue;
        }
        List<PinNamesStruct> PinNamesStructList = PinNamesMap.get(Function2);
        int i = 0;
        while (i < PinNamesStructList.size()) {
            PinNamesStruct PinNamesStructObj = PinNamesStructList.get(i);
            List<PinStruct> pinStructs = PinNamesStructObj.getPinStructList();
            for (PinStruct obj : pinStructs) {
                if (!obj.getPinName().equals(PinName) || !obj.getPinUsedFunction().equals(Function2)) continue;
                return PinNamesStructObj.getRemapAFValue();
            }
            ++i;
        }
        return AFIOValue;
    }

    private String GetRemapValue(String PinName, String Function2) {
        List<PinNamesStruct> PinNamesStructList;
        String RemapValue = "AF0";
        if (Function2.contains(",")) {
            Function2 = Function2.split(",")[0];
        }
        if ((PinNamesStructList = this.GetRemapListInRemapMap(Function2)) == null) {
            return RemapValue;
        }
        int i = 0;
        while (i < PinNamesStructList.size()) {
            List<PinStruct> PinStructList = PinNamesStructList.get(i).getPinStructList();
            int j = 0;
            while (j < PinStructList.size()) {
                String FunctionStr = PinStructList.get(j).getPinUsedFunction();
                String PinNameStr = PinStructList.get(j).getPinName();
                if (Function2.equals(FunctionStr) && PinName.equals(PinNameStr)) {
                    return PinNamesStructList.get(i).getRemapAFValue();
                }
                ++j;
            }
            ++i;
        }
        return RemapValue;
    }

    public List<PinNamesStruct> GetRemapListInRemapMap(String Function2) {
        Map<String, List<PinNamesStruct>> PinNamesMap;
        if (!this.isRemap) {
            return null;
        }
        String FunctionGroupName = Function2.split("_")[0];
        String PeriName = this.getPeriName(FunctionGroupName);
        if (this.AFIORemapMap.containsKey(PeriName) && (PinNamesMap = this.AFIORemapMap.get(PeriName)).containsKey(FunctionGroupName)) {
            return PinNamesMap.get(FunctionGroupName);
        }
        return null;
    }

    private boolean pinIsCanAssigned(String Function2, GD32PinPad GD32PinPadObj) {
        if (!this.FunctionContainInGD32PinPad(GD32PinPadObj, Function2)) {
            return false;
        }
        if (GD32PinPadObj.getPinName().contains("*")) {
            return false;
        }
        if (GD32PinPadObj.getPinUsedType() == 0) {
            return true;
        }
        return GD32PinPadObj.getGPIOModel() == 1 ? GlobalVariables.checkFunctionIsAnalogMode(Function2) : GD32PinPadObj.checkFunctionUsedInGD32PinPad(Function2) && GD32PinPadObj.getPinUsedType() >= 1;
    }

    private boolean functionIsAssignedInPin(String Function2, GD32PinPad GD32PinPadObj) {
        if (GD32PinPadObj.getGPIOModel() == 1) {
            if (GD32PinPadObj.checkFunctionUsedInGD32PinPad(Function2)) {
                return true;
            }
        } else {
            if (GD32PinPadObj.getPinUsedFunctionStr().equals(Function2)) {
                return true;
            }
            if (GlobalVariables.MultipleFunctionPinList.containsKey(GD32PinPadObj.getPinName())) {
                List<String> testModePins = GlobalVariables.MultipleFunctionPinList.get(GD32PinPadObj.getPinName());
                if (GD32PinPadObj.getPinUsedType() != 0) {
                    if (testModePins.contains(Function2) && GD32PinPadObj.getPinUsedFunctionStr().contains(Function2)) {
                        return true;
                    }
                    if (testModePins.contains(Function2) && testModePins.contains(GD32PinPadObj.getPinUsedFunctionStr())) {
                        return true;
                    }
                } else if (testModePins.contains(Function2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public List<GD32PinPad> getResetPinInEqualRemapGroup(String PeriName, String Function2, int PinIndex) {
        if (!this.isRemap) {
            return null;
        }
        ArrayList<GD32PinPad> pinpadList = new ArrayList<GD32PinPad>();
        Map<String, List<PinNamesStruct>> PinNamesMap = this.AFIORemapMap.get(this.getPeriName(PeriName));
        if (PinNamesMap == null) {
            return null;
        }
        List<PinNamesStruct> PinNamesStructList = PinNamesMap.get(PeriName);
        if (PinNamesStructList == null) {
            return null;
        }
        if (!this.FunctionIsInRemap(Function2, PinNamesStructList.get(0))) {
            return null;
        }
        String PinName = this.GD32PinPads.get(PinIndex).getPinName();
        int usedPinInEqualRemapMin = 99;
        int selectedGroupIndex = 0;
        int i = 0;
        while (i < PinNamesStructList.size()) {
            PinNamesStruct pinNamesStruct = PinNamesStructList.get(i);
            int count = 0;
            List<PinStruct> PinStructList = pinNamesStruct.getPinStructList();
            int j = 0;
            while (j < PinStructList.size()) {
                String pinFunctionStr = PinStructList.get(j).getPinUsedFunction();
                String pinNameStr = PinStructList.get(j).getPinName();
                if (pinFunctionStr.equals(Function2)) {
                    if (!pinNameStr.equals(PinName)) {
                        count = 999;
                        break;
                    }
                } else {
                    int pinIndex;
                    GD32PinPad GD32PinPadObj = this.GD32PinPads.get(this.GetPinIndexByPinName(pinNameStr));
                    if (GD32PinPadObj.getPinUsedType() != 0 && !GD32PinPadObj.getPinUsedFunctionStr().equals(pinFunctionStr) && (pinIndex = this.GetPinIndexByUsedFunc(pinNameStr)) >= 0) {
                        ++count;
                    }
                }
                ++j;
            }
            if (count < usedPinInEqualRemapMin) {
                usedPinInEqualRemapMin = count;
                selectedGroupIndex = i;
                if (count == 0) break;
            }
            ++i;
        }
        PinNamesStruct pinNamesStruct = PinNamesStructList.get(selectedGroupIndex);
        List<PinStruct> PinStructList = pinNamesStruct.getPinStructList();
        int j = 0;
        while (j < PinStructList.size()) {
            String pinFunctionStr = PinStructList.get(j).getPinUsedFunction();
            String pinNameStr = PinStructList.get(j).getPinName();
            if (!pinFunctionStr.equals(Function2) || !pinNameStr.equals(PinName)) {
                GD32PinPad GD32PinPadObj = this.GD32PinPads.get(this.GetPinIndexByPinName(pinNameStr));
                int pinIndex = this.GetPinIndexByUsedFunc(pinFunctionStr);
                if (pinIndex >= 0 && pinIndex != GD32PinPadObj.getPinIndex()) {
                    GD32PinPad GD32PinPadCopyObj = new GD32PinPad();
                    GD32PinPadCopyObj.putPinIndex(this.GetPinIndexByPinName(pinNameStr));
                    GD32PinPadCopyObj.putPinName(pinNameStr);
                    GD32PinPadCopyObj.putPinUsedFunctionStr(pinFunctionStr);
                    System.out.println(String.valueOf(pinNameStr) + "   " + pinFunctionStr);
                    GD32PinPadCopyObj.putPinUsedPeri(this.GD32PinPads.get(pinIndex).getPinUsedPeri());
                    GD32PinPadCopyObj.putPinUsedType(this.GD32PinPads.get(pinIndex).getPinUsedType());
                    GD32PinPadCopyObj.putRemapAF_Value(pinNamesStruct.getRemapAFValue());
                    pinpadList.add(GD32PinPadCopyObj);
                }
            }
            ++j;
        }
        System.out.println("END");
        return pinpadList;
    }
}

